/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.useralerts;

import freenet.keys.FreenetURI;
import freenet.l10n.NodeL10n;
import freenet.node.DarknetPeerNode;
import freenet.node.PeerNode;
import freenet.node.fcp.FCPMessage;
import freenet.node.fcp.URIFeedMessage;
import freenet.node.useralerts.AbstractUserAlert;
import freenet.support.HTMLNode;
import java.lang.ref.WeakReference;

public class DownloadFeedUserAlert
extends AbstractUserAlert {
    private final WeakReference<PeerNode> peerRef;
    private final FreenetURI uri;
    private final int fileNumber;
    private final String description;
    private final long composed;
    private final long sent;
    private final long received;
    private String sourceNodeName;

    public DownloadFeedUserAlert(DarknetPeerNode sourcePeerNode, String description, int fileNumber, FreenetURI uri, long composed, long sent, long received) {
        super(true, null, null, null, null, (short)3, true, null, true, null);
        this.description = description;
        this.uri = uri;
        this.fileNumber = fileNumber;
        this.composed = composed;
        this.sent = sent;
        this.received = received;
        this.peerRef = sourcePeerNode.getWeakRef();
        this.sourceNodeName = sourcePeerNode.getName();
    }

    @Override
    public String getTitle() {
        return this.l10n("title", "from", this.sourceNodeName);
    }

    @Override
    public String getText() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.l10n("fileURI")).append(" ").append(this.uri).append("\n");
        if (this.description != null && this.description.length() != 0) {
            sb.append(this.l10n("fileDescription")).append(" ").append(this.description);
        }
        return sb.toString();
    }

    @Override
    public String getShortText() {
        return this.getTitle();
    }

    @Override
    public HTMLNode getHTMLText() {
        HTMLNode alertNode = new HTMLNode("div");
        alertNode.addChild("a", "href", "/" + this.uri).addChild("#", this.uri.toShortString());
        if (this.description != null && this.description.length() != 0) {
            String[] lines = this.description.split("\n");
            alertNode.addChild("br");
            alertNode.addChild("br");
            alertNode.addChild("#", this.l10n("fileDescription"));
            alertNode.addChild("br");
            for (int i = 0; i < lines.length; ++i) {
                alertNode.addChild("#", lines[i]);
                if (i == lines.length - 1) continue;
                alertNode.addChild("br");
            }
        }
        return alertNode;
    }

    @Override
    public String dismissButtonText() {
        return this.l10n("delete");
    }

    private String l10n(String key) {
        return NodeL10n.getBase().getString("DownloadFeedUserAlert." + key);
    }

    private String l10n(String key, String pattern, String value) {
        return NodeL10n.getBase().getString("DownloadFeedUserAlert." + key, pattern, value);
    }

    @Override
    public void onDismiss() {
        DarknetPeerNode pn = (DarknetPeerNode)this.peerRef.get();
        if (pn != null) {
            pn.deleteExtraPeerDataFile(this.fileNumber);
        }
    }

    @Override
    public FCPMessage getFCPMessage() {
        return new URIFeedMessage(this.getTitle(), this.getShortText(), this.getText(), this.getPriorityClass(), this.getUpdatedTime(), this.sourceNodeName, this.composed, this.sent, this.received, this.uri, this.description);
    }

    @Override
    public boolean isValid() {
        DarknetPeerNode pn = (DarknetPeerNode)this.peerRef.get();
        if (pn != null) {
            this.sourceNodeName = pn.getName();
        }
        return true;
    }
}

