/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.useralerts;

import freenet.l10n.NodeL10n;
import freenet.node.DarknetPeerNode;
import freenet.node.PeerNode;
import freenet.node.fcp.FCPMessage;
import freenet.node.fcp.TextFeedMessage;
import freenet.node.useralerts.AbstractUserAlert;
import freenet.support.HTMLNode;
import java.lang.ref.WeakReference;
import java.text.DateFormat;
import java.util.Date;

public class N2NTMUserAlert
extends AbstractUserAlert {
    private final WeakReference<PeerNode> peerRef;
    private final String messageText;
    private final int fileNumber;
    private final long composedTime;
    private final long sentTime;
    private final long receivedTime;
    private String sourceNodeName;
    private String sourcePeer;

    public N2NTMUserAlert(DarknetPeerNode sourcePeerNode, String message, int fileNumber, long composedTime, long sentTime, long receivedTime) {
        super(true, null, null, null, null, (short)3, true, null, true, null);
        this.messageText = message;
        this.fileNumber = fileNumber;
        this.composedTime = composedTime;
        this.sentTime = sentTime;
        this.receivedTime = receivedTime;
        this.peerRef = sourcePeerNode.getWeakRef();
        this.sourceNodeName = sourcePeerNode.getName();
        this.sourcePeer = sourcePeerNode.getPeer().toString();
    }

    @Override
    public String getTitle() {
        return this.l10n("title", new String[]{"number", "peername", "peer"}, new String[]{Integer.toString(this.fileNumber), this.sourceNodeName, this.sourcePeer});
    }

    @Override
    public String getText() {
        return this.l10n("header", new String[]{"from", "composed", "sent", "received"}, new String[]{this.sourceNodeName, DateFormat.getInstance().format(new Date(this.composedTime)), DateFormat.getInstance().format(new Date(this.sentTime)), DateFormat.getInstance().format(new Date(this.receivedTime))}) + ": " + this.messageText;
    }

    @Override
    public String getShortText() {
        return this.l10n("headerShort", "from", this.sourceNodeName);
    }

    @Override
    public HTMLNode getHTMLText() {
        HTMLNode alertNode = new HTMLNode("div");
        alertNode.addChild("p", this.l10n("header", new String[]{"from", "composed", "sent", "received"}, new String[]{this.sourceNodeName, DateFormat.getInstance().format(new Date(this.composedTime)), DateFormat.getInstance().format(new Date(this.sentTime)), DateFormat.getInstance().format(new Date(this.receivedTime))}));
        String[] lines = this.messageText.split("\n");
        int c = lines.length;
        for (int i = 0; i < c; ++i) {
            alertNode.addChild("#", lines[i]);
            if (i == lines.length - 1) continue;
            alertNode.addChild("br");
        }
        DarknetPeerNode pn = (DarknetPeerNode)this.peerRef.get();
        if (pn != null) {
            alertNode.addChild("p").addChild("a", "href", "/send_n2ntm/?peernode_hashcode=" + pn.hashCode(), this.l10n("reply"));
        }
        return alertNode;
    }

    @Override
    public String dismissButtonText() {
        return this.l10n("delete");
    }

    private String l10n(String key) {
        return NodeL10n.getBase().getString("N2NTMUserAlert." + key);
    }

    private String l10n(String key, String[] patterns, String[] values) {
        return NodeL10n.getBase().getString("N2NTMUserAlert." + key, patterns, values);
    }

    private String l10n(String key, String pattern, String value) {
        return NodeL10n.getBase().getString("N2NTMUserAlert." + key, pattern, value);
    }

    @Override
    public void onDismiss() {
        DarknetPeerNode pn = (DarknetPeerNode)this.peerRef.get();
        if (pn != null) {
            pn.deleteExtraPeerDataFile(this.fileNumber);
        }
    }

    @Override
    public FCPMessage getFCPMessage() {
        return new TextFeedMessage(this.getTitle(), this.getShortText(), this.getText(), this.getPriorityClass(), this.getUpdatedTime(), this.sourceNodeName, this.composedTime, this.sentTime, this.receivedTime, this.messageText);
    }

    @Override
    public boolean isValid() {
        DarknetPeerNode pn = (DarknetPeerNode)this.peerRef.get();
        if (pn != null) {
            this.sourceNodeName = pn.getName();
            this.sourcePeer = pn.getPeer().toString();
        }
        return true;
    }
}

