/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.useralerts;

import freenet.node.fcp.FCPMessage;
import freenet.node.fcp.FeedMessage;
import freenet.node.useralerts.AbstractUserEvent;
import freenet.node.useralerts.UserEvent;
import freenet.support.HTMLNode;
import java.util.Iterator;
import java.util.Map;

public abstract class StoringUserEvent<T extends StoringUserEvent<T>>
extends AbstractUserEvent {
    protected final Map<String, T> events;

    protected StoringUserEvent(Map<String, T> events) {
        this.events = events;
    }

    protected StoringUserEvent(UserEvent.Type eventType, boolean userCanDismiss, String title, String text, String shortText, HTMLNode htmlText, short priorityClass, boolean valid, String dismissButtonText, boolean shouldUnregisterOnDismiss, Object userIdentifier, Map<String, T> events) {
        super(eventType, userCanDismiss, title, text, shortText, htmlText, priorityClass, valid, dismissButtonText, shouldUnregisterOnDismiss, userIdentifier);
        this.events = events;
    }

    public abstract String getEventText();

    public abstract HTMLNode getEventHTMLText();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HTMLNode getHTMLText() {
        HTMLNode text = new HTMLNode("div");
        Map<String, T> map = this.events;
        synchronized (map) {
            for (StoringUserEvent event : this.events.values()) {
                text.addChild(event.getEventHTMLText());
            }
        }
        return text;
    }

    @Override
    public FCPMessage getFCPMessage() {
        return new FeedMessage(this.getEventText(), this.getEventText(), this.getEventText(), this.getPriorityClass(), this.getUpdatedTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDismiss() {
        Map<String, T> map = this.events;
        synchronized (map) {
            Iterator<T> iter = this.events.values().iterator();
            while (iter.hasNext()) {
                StoringUserEvent event = (StoringUserEvent)iter.next();
                event.onEventDismiss();
                iter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid() {
        boolean valid;
        Map<String, T> map = this.events;
        synchronized (map) {
            valid = !this.events.isEmpty();
        }
        return valid;
    }

    public abstract void onEventDismiss();
}

