/*
 * Decompiled with CFR 0.152.
 */
package freenet.pluginmanager;

import com.db4o.Db4o;
import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.config.Configuration;
import com.db4o.io.IoAdapter;
import com.db4o.io.MemoryIoAdapter;
import freenet.node.FSParseException;
import freenet.pluginmanager.PluginStoreContainer;
import freenet.support.Base64;
import freenet.support.IllegalBase64Exception;
import freenet.support.SimpleFieldSet;
import java.util.HashMap;
import java.util.Map;

public class PluginStore {
    public final HashMap<String, PluginStore> subStores = new HashMap();
    public final HashMap<String, Long> longs = new HashMap();
    public final HashMap<String, long[]> longsArrays = new HashMap();
    public final HashMap<String, Integer> integers = new HashMap();
    public final HashMap<String, int[]> integersArrays = new HashMap();
    public final HashMap<String, Short> shorts = new HashMap();
    public final HashMap<String, short[]> shortsArrays = new HashMap();
    public final HashMap<String, Boolean> booleans = new HashMap();
    public final HashMap<String, boolean[]> booleansArrays = new HashMap();
    public final HashMap<String, Byte> bytes = new HashMap();
    public final HashMap<String, byte[]> bytesArrays = new HashMap();
    public final HashMap<String, String> strings = new HashMap();
    public final HashMap<String, String[]> stringsArrays = new HashMap();

    public PluginStore() {
    }

    public byte[] exportStore() {
        Configuration conf = Db4o.newConfiguration();
        MemoryIoAdapter mia = new MemoryIoAdapter();
        conf.io((IoAdapter)mia);
        ObjectContainer o = Db4o.openFile((Configuration)conf, (String)"Export");
        PluginStoreContainer psc = new PluginStoreContainer();
        psc.pluginStore = this;
        o.ext().store((Object)psc, Integer.MAX_VALUE);
        o.commit();
        o.close();
        return mia.get("Export");
    }

    public static PluginStore importStore(byte[] exportedStore) {
        Configuration conf = Db4o.newConfiguration();
        MemoryIoAdapter mia = new MemoryIoAdapter();
        conf.io((IoAdapter)mia);
        mia.put("Import", exportedStore);
        ObjectContainer o = Db4o.openFile((Configuration)conf, (String)"Import");
        ObjectSet query = o.query(PluginStoreContainer.class);
        if (query.size() > 0) {
            o.activate(query.get(0), Integer.MAX_VALUE);
            PluginStore ret = ((PluginStoreContainer)query.get((int)0)).pluginStore;
            o.close();
            return ret;
        }
        o.close();
        return null;
    }

    public SimpleFieldSet exportStoreAsSFS() {
        SimpleFieldSet fs = new SimpleFieldSet(true, true);
        for (Map.Entry<String, PluginStore> entry : this.subStores.entrySet()) {
            fs.put("substore." + PluginStore.encode(entry.getKey()), entry.getValue().exportStoreAsSFS());
        }
        for (Map.Entry<String, Object> entry : this.longs.entrySet()) {
            fs.put("long." + PluginStore.encode(entry.getKey()), (Long)entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.longsArrays.entrySet()) {
            fs.put("longs." + PluginStore.encode(entry.getKey()), (long[])entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.integers.entrySet()) {
            fs.put("integer." + PluginStore.encode(entry.getKey()), (Integer)entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.integersArrays.entrySet()) {
            fs.put("integers." + PluginStore.encode(entry.getKey()), (int[])entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.shorts.entrySet()) {
            fs.put("short." + PluginStore.encode(entry.getKey()), (Short)entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.shortsArrays.entrySet()) {
            fs.put("shorts." + PluginStore.encode(entry.getKey()), (short[])entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.bytes.entrySet()) {
            fs.put("byte." + PluginStore.encode(entry.getKey()), ((Byte)entry.getValue()).byteValue());
        }
        for (Map.Entry<String, Object> entry : this.bytesArrays.entrySet()) {
            fs.put("bytes." + PluginStore.encode(entry.getKey()), (byte[])entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.booleans.entrySet()) {
            fs.put("boolean." + PluginStore.encode(entry.getKey()), (Boolean)entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.booleansArrays.entrySet()) {
            fs.put("booleans." + PluginStore.encode(entry.getKey()), (boolean[])entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.strings.entrySet()) {
            fs.putSingle("string." + PluginStore.encode(entry.getKey()), (String)entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.stringsArrays.entrySet()) {
            fs.putEncoded("strings." + PluginStore.encode(entry.getKey()), (String[])entry.getValue());
        }
        return fs;
    }

    public PluginStore(SimpleFieldSet sfs) throws IllegalBase64Exception, FSParseException {
        SimpleFieldSet group = sfs.subset("substore");
        if (group != null) {
            for (Map.Entry<String, SimpleFieldSet> entry : group.directSubsets().entrySet()) {
                this.subStores.put(PluginStore.decode(entry.getKey()), new PluginStore(entry.getValue()));
            }
        }
        if ((group = sfs.subset("long")) != null) {
            for (String s : group.directKeys()) {
                this.longs.put(PluginStore.decode(s), group.getLong(s));
            }
        }
        if ((group = sfs.subset("longs")) != null) {
            for (String s : group.directKeys()) {
                this.longsArrays.put(PluginStore.decode(s), group.getLongArray(s));
            }
        }
        if ((group = sfs.subset("integer")) != null) {
            for (String s : group.directKeys()) {
                this.integers.put(PluginStore.decode(s), group.getInt(s));
            }
        }
        if ((group = sfs.subset("integers")) != null) {
            for (String s : group.directKeys()) {
                this.integersArrays.put(PluginStore.decode(s), group.getIntArray(s));
            }
        }
        if ((group = sfs.subset("short")) != null) {
            for (String s : group.directKeys()) {
                this.shorts.put(PluginStore.decode(s), group.getShort(s));
            }
        }
        if ((group = sfs.subset("shorts")) != null) {
            for (String s : group.directKeys()) {
                this.shortsArrays.put(PluginStore.decode(s), group.getShortArray(s));
            }
        }
        if ((group = sfs.subset("boolean")) != null) {
            for (String s : group.directKeys()) {
                this.booleans.put(PluginStore.decode(s), group.getBoolean(s));
            }
        }
        if ((group = sfs.subset("booleans")) != null) {
            for (String s : group.directKeys()) {
                this.booleansArrays.put(PluginStore.decode(s), group.getBooleanArray(s));
            }
        }
        if ((group = sfs.subset("byte")) != null) {
            for (String s : group.directKeys()) {
                this.bytes.put(PluginStore.decode(s), group.getByte(s));
            }
        }
        if ((group = sfs.subset("bytes")) != null) {
            for (String s : group.directKeys()) {
                this.bytesArrays.put(PluginStore.decode(s), group.getByteArray(s));
            }
        }
        if ((group = sfs.subset("string")) != null) {
            for (String s : group.directKeys()) {
                this.strings.put(PluginStore.decode(s), group.get(s));
            }
        }
        if ((group = sfs.subset("strings")) != null) {
            for (String s : group.directKeys()) {
                this.stringsArrays.put(PluginStore.decode(s), group.getAllEncoded(s));
            }
        }
    }

    private static final String encode(String s) {
        return Base64.encodeUTF8(s);
    }

    private static final String decode(String s) throws IllegalBase64Exception {
        return Base64.decodeUTF8(s);
    }

    public void removeFrom(ObjectContainer container) {
        for (PluginStore s : this.subStores.values()) {
            s.removeFrom(container);
        }
        this.subStores.clear();
        container.delete(this.subStores);
        container.delete(this.longs);
        container.delete(this.longsArrays);
        container.delete(this.integers);
        container.delete(this.integersArrays);
        container.delete(this.shorts);
        container.delete(this.shortsArrays);
        container.delete(this.booleans);
        container.delete(this.booleansArrays);
        container.delete(this.bytes);
        container.delete(this.bytesArrays);
        container.delete(this.strings);
        container.delete(this.stringsArrays);
        container.delete((Object)this);
    }
}

