/*
 * Decompiled with CFR 0.152.
 */
package freenet.pluginmanager;

import freenet.node.Node;
import freenet.node.fcp.FCPConnectionHandler;
import freenet.pluginmanager.FredPluginFCP;
import freenet.pluginmanager.FredPluginTalker;
import freenet.pluginmanager.PluginNotFoundException;
import freenet.pluginmanager.PluginReplySender;
import freenet.pluginmanager.PluginReplySenderDirect;
import freenet.pluginmanager.PluginReplySenderFCP;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import freenet.support.api.Bucket;
import java.lang.ref.WeakReference;
import java.util.UUID;

public class PluginTalker {
    protected Node node;
    protected PluginReplySender replysender;
    protected int access;
    protected WeakReference<FredPluginFCP> pluginRef;
    protected String pluginName;

    public PluginTalker(FredPluginTalker fpt, Node node2, String pluginname2, String clientSideIdentifier) throws PluginNotFoundException {
        this.node = node2;
        this.pluginName = pluginname2;
        this.pluginRef = this.findPlugin(pluginname2);
        this.access = 0;
        String clientIdentifier = UUID.randomUUID().toString();
        this.replysender = new PluginReplySenderDirect(node2, fpt, pluginname2, clientIdentifier, clientSideIdentifier);
    }

    public PluginTalker(Node node2, FCPConnectionHandler handler, String pluginname2, String clientSideIdentifier, boolean access2) throws PluginNotFoundException {
        this.node = node2;
        this.pluginName = pluginname2;
        this.pluginRef = this.findPlugin(pluginname2);
        this.access = access2 ? 2 : 1;
        String clientIdentifier = handler.connectionIdentifier;
        this.replysender = new PluginReplySenderFCP(handler, pluginname2, clientIdentifier, clientSideIdentifier);
    }

    protected WeakReference<FredPluginFCP> findPlugin(String pluginname2) throws PluginNotFoundException {
        Logger.normal(this, "Searching fcp plugin: " + pluginname2);
        FredPluginFCP plug = this.node.pluginManager.getFCPPlugin(pluginname2);
        if (plug == null) {
            Logger.error(this, "Could not find fcp plugin: " + pluginname2);
            throw new PluginNotFoundException();
        }
        Logger.normal(this, "Found fcp plugin: " + pluginname2);
        return new WeakReference<FredPluginFCP>(plug);
    }

    public void send(final SimpleFieldSet plugparams, final Bucket data2) {
        this.node.executor.execute(new Runnable(){

            @Override
            public void run() {
                PluginTalker.this.sendSyncInternalOnly(plugparams, data2);
            }
        }, "FCPPlugin talk runner for " + this.pluginName);
    }

    public void sendSyncInternalOnly(SimpleFieldSet plugparams, Bucket data2) {
        try {
            FredPluginFCP plug = (FredPluginFCP)this.pluginRef.get();
            if (plug == null) {
                Logger.error(this, "Connection to plugin '" + this.pluginName + "' lost.", (Throwable)new Exception("FIXME"));
                return;
            }
            plug.handle(this.replysender, plugparams, data2, this.access);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (VirtualMachineError vme) {
            throw vme;
        }
        catch (Throwable t) {
            Logger.error(this, "Cought error while execute fcp plugin handler for '" + this.pluginName + "', report it to the plugin author: " + t.getMessage(), t);
        }
    }
}

