/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import com.db4o.ObjectContainer;
import freenet.client.async.ClientContext;
import freenet.client.async.HasCooldownCacheItem;
import freenet.support.Logger;
import freenet.support.RandomGrabArrayItem;
import freenet.support.RandomGrabArrayItemExclusionList;
import freenet.support.RandomGrabArrayWithClient;
import freenet.support.RemoveRandom;
import freenet.support.RemoveRandomParent;
import freenet.support.RemoveRandomWithObject;
import java.util.Arrays;

public class SectoredRandomGrabArray
implements RemoveRandom,
RemoveRandomParent,
HasCooldownCacheItem {
    private static volatile boolean logMINOR;
    private RemoveRandomWithObject[] grabArrays;
    private Object[] grabClients;
    protected final boolean persistent;
    private RemoveRandomParent parent;

    public SectoredRandomGrabArray(boolean persistent, ObjectContainer container, RemoveRandomParent parent) {
        this.persistent = persistent;
        this.grabClients = new Object[0];
        this.grabArrays = new RemoveRandomWithObject[0];
        this.parent = parent;
    }

    public synchronized void add(Object client, RandomGrabArrayItem item, ObjectContainer container, ClientContext context) {
        RandomGrabArrayWithClient rga;
        if (item.persistent() != this.persistent) {
            throw new IllegalArgumentException("item.persistent()=" + item.persistent() + " but array.persistent=" + this.persistent + " item=" + item + " array=" + this);
        }
        int clientIndex = this.haveClient(client);
        if (clientIndex == -1) {
            if (logMINOR) {
                Logger.minor(this, "Adding new RGAWithClient for " + client + " on " + this + " for " + item);
            }
            rga = new RandomGrabArrayWithClient(client, this.persistent, container, this);
            this.addElement(client, rga);
            if (this.persistent) {
                container.store((Object)rga);
                container.store((Object)this);
            }
        } else {
            rga = (RandomGrabArrayWithClient)this.grabArrays[clientIndex];
            if (this.persistent) {
                container.activate((Object)rga, 1);
            }
        }
        if (logMINOR) {
            Logger.minor(this, "Adding " + item + " to RGA " + rga + " for " + client);
        }
        rga.add(item, container, context);
        if (this.persistent) {
            container.deactivate((Object)rga, 1);
        }
        if (context != null) {
            context.cooldownTracker.clearCachedWakeup(this, this.persistent, container);
            if (this.parent != null) {
                context.cooldownTracker.clearCachedWakeup(this.parent, this.persistent, container);
            }
        }
        if (logMINOR) {
            Logger.minor(this, "Size now " + this.grabArrays.length + " on " + this);
        }
    }

    private synchronized void addElement(Object client, RemoveRandomWithObject rga) {
        int len = this.grabArrays.length;
        this.grabArrays = Arrays.copyOf(this.grabArrays, len + 1);
        this.grabArrays[len] = rga;
        this.grabClients = Arrays.copyOf(this.grabClients, len + 1);
        this.grabClients[len] = client;
    }

    private synchronized int haveClient(Object client) {
        for (int i = 0; i < this.grabClients.length; ++i) {
            if (this.grabClients[i] != client) continue;
            return i;
        }
        return -1;
    }

    public synchronized RemoveRandomWithObject getGrabber(Object client) {
        int idx = this.haveClient(client);
        if (idx == -1) {
            return null;
        }
        return this.grabArrays[idx];
    }

    public synchronized Object getClient(int x) {
        return this.grabClients[x];
    }

    public synchronized void addGrabber(Object client, RemoveRandomWithObject requestGrabber, ObjectContainer container, ClientContext context) {
        if (requestGrabber.getObject() != client) {
            throw new IllegalArgumentException("Client not equal to RemoveRandomWithObject's client: client=" + client + " rr=" + requestGrabber + " his object=" + requestGrabber.getObject());
        }
        this.addElement(client, requestGrabber);
        if (this.persistent) {
            container.store((Object)this);
        }
        if (context != null) {
            context.cooldownTracker.clearCachedWakeup(this, this.persistent, container);
            if (this.parent != null) {
                context.cooldownTracker.clearCachedWakeup(this.parent, this.persistent, container);
            }
        }
    }

    @Override
    public synchronized RemoveRandom.RemoveRandomReturn removeRandom(RandomGrabArrayItemExclusionList excluding, ObjectContainer container, ClientContext context, long now) {
        block4: {
            RemoveRandom.RemoveRandomReturn ret;
            do {
                if (this.grabArrays.length == 0) {
                    return null;
                }
                if (this.grabArrays.length == 1) {
                    return this.removeRandomOneOnly(excluding, container, context, now);
                }
                if (this.grabArrays.length != 2) break block4;
            } while ((ret = this.removeRandomTwoOnly(excluding, container, context, now)) == null);
            return ret;
        }
        RandomGrabArrayItem item = this.removeRandomLimited(excluding, container, context, now);
        if (item != null) {
            return new RemoveRandom.RemoveRandomReturn(item);
        }
        return this.removeRandomExhaustive(excluding, container, context, now);
    }

    private synchronized RemoveRandom.RemoveRandomReturn removeRandomExhaustive(RandomGrabArrayItemExclusionList excluding, ObjectContainer container, ClientContext context, long now) {
        long wakeupTime = Long.MAX_VALUE;
        if (this.grabArrays.length == 0) {
            return null;
        }
        int x = context.fastWeakRandom.nextInt(this.grabArrays.length);
        for (int i = 0; i < this.grabArrays.length; ++i) {
            RemoveRandomWithObject rga;
            long excludeTime;
            if (++x >= this.grabArrays.length) {
                x = 0;
            }
            if ((excludeTime = excluding.excludeSummarily(rga = this.grabArrays[x], this, container, this.persistent, now)) > 0L) {
                if (wakeupTime <= excludeTime) continue;
                wakeupTime = excludeTime;
                continue;
            }
            if (this.persistent) {
                container.activate((Object)rga, 1);
            }
            if (logMINOR) {
                Logger.minor(this, "Picked " + x + " of " + this.grabArrays.length + " : " + rga + " on " + this);
            }
            RandomGrabArrayItem item = null;
            RemoveRandom.RemoveRandomReturn val = rga.removeRandom(excluding, container, context, now);
            if (val != null) {
                if (val.item != null) {
                    item = val.item;
                } else if (wakeupTime > val.wakeupTime) {
                    wakeupTime = val.wakeupTime;
                }
            }
            if (logMINOR) {
                Logger.minor(this, "RGA has picked " + x + "/" + this.grabArrays.length + ": " + item + " rga.isEmpty=" + rga.isEmpty(container));
            }
            if (item != null) {
                if (this.persistent) {
                    container.deactivate((Object)rga, 1);
                }
                return new RemoveRandom.RemoveRandomReturn(item);
            }
            if (!rga.isEmpty(container)) continue;
            if (logMINOR) {
                Logger.minor(this, "Removing grab array " + x + " : " + rga + " (is empty)");
            }
            this.removeElement(x);
            if (this.persistent) {
                container.store((Object)this);
                rga.removeFrom(container);
            }
            if (!this.persistent) continue;
            container.deactivate((Object)rga, 1);
        }
        context.cooldownTracker.setCachedWakeup(wakeupTime, this, this.parent, this.persistent, container, context);
        return new RemoveRandom.RemoveRandomReturn(wakeupTime);
    }

    private synchronized RandomGrabArrayItem removeRandomLimited(RandomGrabArrayItemExclusionList excluding, ObjectContainer container, ClientContext context, long now) {
        int MAX_EXCLUDED = 10;
        int excluded = 0;
        while (this.grabArrays.length != 0) {
            int x = context.fastWeakRandom.nextInt(this.grabArrays.length);
            RemoveRandomWithObject rga = this.grabArrays[x];
            if (rga == null) {
                Logger.error(this, "Slot " + x + " is null for client " + this.grabClients[x]);
                if (++excluded <= 10) continue;
                Logger.normal(this, "Too many sub-arrays are entirely excluded on " + this + " length = " + this.grabArrays.length, (Throwable)new Exception("error"));
                return null;
            }
            long excludeTime = excluding.excludeSummarily(rga, this, container, this.persistent, now);
            if (excludeTime > 0L) {
                if (++excluded <= 10) continue;
                Logger.normal(this, "Too many sub-arrays are entirely excluded on " + this + " length = " + this.grabArrays.length, (Throwable)new Exception("error"));
                return null;
            }
            if (this.persistent) {
                container.activate((Object)rga, 1);
            }
            if (logMINOR) {
                Logger.minor(this, "Picked " + x + " of " + this.grabArrays.length + " : " + rga + " on " + this);
            }
            RandomGrabArrayItem item = null;
            RemoveRandom.RemoveRandomReturn val = rga.removeRandom(excluding, container, context, now);
            if (val != null && val.item != null) {
                item = val.item;
            }
            if (logMINOR) {
                Logger.minor(this, "RGA has picked " + x + "/" + this.grabArrays.length + ": " + item + " rga.isEmpty=" + rga.isEmpty(container));
            }
            if (item != null) {
                if (this.persistent) {
                    container.deactivate((Object)rga, 1);
                }
                return item;
            }
            if (rga.isEmpty(container)) {
                if (logMINOR) {
                    Logger.minor(this, "Removing grab array " + x + " : " + rga + " (is empty)");
                }
                this.removeElement(x);
                if (this.persistent) {
                    container.store((Object)this);
                    rga.removeFrom(container);
                }
            } else if (++excluded > 10) {
                Logger.normal(this, "Too many sub-arrays are entirely excluded on " + this + " length = " + this.grabArrays.length, (Throwable)new Exception("error"));
                if (this.persistent) {
                    container.deactivate((Object)rga, 1);
                }
                return null;
            }
            if (!this.persistent) continue;
            container.deactivate((Object)rga, 1);
        }
        return null;
    }

    private synchronized RemoveRandom.RemoveRandomReturn removeRandomTwoOnly(RandomGrabArrayItemExclusionList excluding, ObjectContainer container, ClientContext context, long now) {
        long excludeTime;
        RemoveRandomWithObject rga;
        long wakeupTime = Long.MAX_VALUE;
        int x = context.fastWeakRandom.nextBoolean() ? 1 : 0;
        RemoveRandomWithObject firstRGA = rga = this.grabArrays[x];
        if (rga == null) {
            Logger.error(this, "rga = null on " + this);
            if (this.grabArrays[1 - x] == null) {
                Logger.error(this, "other rga is also null on " + this);
                this.grabArrays = new RemoveRandomWithObject[0];
                this.grabClients = new Object[0];
                if (this.persistent) {
                    container.store((Object)this);
                }
                return null;
            }
            Logger.error(this, "grabArrays[" + (1 - x) + "] is valid but [" + x + "] is null, correcting...");
            this.grabArrays = new RemoveRandomWithObject[]{this.grabArrays[1 - x]};
            this.grabClients = new Object[]{this.grabClients[1 - x]};
            if (this.persistent) {
                container.store((Object)this);
            }
            return null;
        }
        RandomGrabArrayItem item = null;
        RemoveRandom.RemoveRandomReturn val = null;
        if (logMINOR) {
            Logger.minor(this, "Only 2, trying " + rga);
        }
        if ((excludeTime = excluding.excludeSummarily(rga, this, container, this.persistent, now)) > 0L) {
            wakeupTime = excludeTime;
            rga = null;
            firstRGA = null;
        } else {
            if (this.persistent) {
                container.activate((Object)rga, 1);
            }
            if ((val = rga.removeRandom(excluding, container, context, now)) != null) {
                if (val.item != null) {
                    item = val.item;
                } else if (wakeupTime > val.wakeupTime) {
                    wakeupTime = val.wakeupTime;
                }
            }
        }
        if (item != null) {
            if (this.persistent) {
                container.deactivate((Object)rga, 1);
            }
            if (logMINOR) {
                Logger.minor(this, "Returning (two items only) " + item + " for " + rga);
            }
            return new RemoveRandom.RemoveRandomReturn(item);
        }
        rga = this.grabArrays[x = 1 - x];
        if (rga == null) {
            Logger.error(this, "Other RGA is null later on on " + this);
            this.grabArrays = new RemoveRandomWithObject[]{this.grabArrays[1 - x]};
            this.grabClients = new Object[]{this.grabClients[1 - x]};
            if (this.persistent) {
                container.store((Object)this);
            }
            context.cooldownTracker.setCachedWakeup(wakeupTime, this, this.parent, this.persistent, container, context);
            return new RemoveRandom.RemoveRandomReturn(wakeupTime);
        }
        excludeTime = excluding.excludeSummarily(rga, this, container, this.persistent, now);
        if (excludeTime > 0L) {
            if (wakeupTime > excludeTime) {
                wakeupTime = excludeTime;
            }
            rga = null;
        } else {
            if (this.persistent) {
                container.activate((Object)rga, 1);
            }
            if ((val = rga.removeRandom(excluding, container, context, now)) != null) {
                if (val.item != null) {
                    item = val.item;
                } else if (wakeupTime > val.wakeupTime) {
                    wakeupTime = val.wakeupTime;
                }
            }
        }
        if (firstRGA != null && firstRGA.isEmpty(container) && rga != null && rga.isEmpty(container)) {
            if (logMINOR) {
                Logger.minor(this, "Removing both on " + this + " : " + firstRGA + " and " + rga + " are empty");
            }
            this.grabArrays = new RemoveRandomWithObject[0];
            this.grabClients = new Object[0];
            if (this.persistent) {
                container.store((Object)this);
                firstRGA.removeFrom(container);
                rga.removeFrom(container);
            }
        } else if (firstRGA != null && firstRGA.isEmpty(container)) {
            if (logMINOR) {
                Logger.minor(this, "Removing first: " + firstRGA + " is empty on " + this);
            }
            this.grabArrays = new RemoveRandomWithObject[]{this.grabArrays[x]};
            this.grabClients = new Object[]{this.grabClients[x]};
            if (this.persistent) {
                container.store((Object)this);
                firstRGA.removeFrom(container);
            }
        }
        if (this.persistent) {
            if (rga != null) {
                container.deactivate((Object)rga, 1);
            }
            if (firstRGA != null) {
                container.deactivate((Object)firstRGA, 1);
            }
        }
        if (logMINOR) {
            Logger.minor(this, "Returning (two items only) " + item + " for " + rga);
        }
        if (item == null) {
            if (this.grabArrays.length == 0) {
                return null;
            }
            context.cooldownTracker.setCachedWakeup(wakeupTime, this, this.parent, this.persistent, container, context);
            return new RemoveRandom.RemoveRandomReturn(wakeupTime);
        }
        return new RemoveRandom.RemoveRandomReturn(item);
    }

    private synchronized RemoveRandom.RemoveRandomReturn removeRandomOneOnly(RandomGrabArrayItemExclusionList excluding, ObjectContainer container, ClientContext context, long now) {
        long excludeTime;
        long wakeupTime = Long.MAX_VALUE;
        RemoveRandomWithObject rga = this.grabArrays[0];
        if (logMINOR) {
            Logger.minor(this, "Only one RGA: " + rga);
        }
        if ((excludeTime = excluding.excludeSummarily(rga, this, container, this.persistent, now)) > 0L) {
            return new RemoveRandom.RemoveRandomReturn(excludeTime);
        }
        if (rga == null) {
            Logger.error(this, "Only one entry and that is null; persistent=" + this.persistent);
            if (container == null) {
                this.grabArrays = new RemoveRandomWithObject[0];
                this.grabClients = new Object[0];
            }
            return null;
        }
        if (this.persistent) {
            container.activate((Object)rga, 1);
        }
        RemoveRandom.RemoveRandomReturn val = rga.removeRandom(excluding, container, context, now);
        RandomGrabArrayItem item = null;
        if (val != null) {
            if (val.item != null) {
                item = val.item;
            } else {
                wakeupTime = val.wakeupTime;
            }
        }
        if (rga.isEmpty(container)) {
            if (logMINOR) {
                Logger.minor(this, "Removing only grab array (0) : " + rga);
            }
            this.grabArrays = new RemoveRandomWithObject[0];
            this.grabClients = new Object[0];
            if (this.persistent) {
                container.store((Object)this);
                rga.removeFrom(container);
            }
        }
        if (logMINOR) {
            Logger.minor(this, "Returning (one item only) " + item + " for " + rga);
        }
        if (item == null) {
            if (this.grabArrays.length == 0) {
                if (logMINOR) {
                    Logger.minor(this, "Arrays are empty on " + this);
                }
                return null;
            }
            context.cooldownTracker.setCachedWakeup(wakeupTime, this, this.parent, this.persistent, container, context);
            return new RemoveRandom.RemoveRandomReturn(wakeupTime);
        }
        return new RemoveRandom.RemoveRandomReturn(item);
    }

    private synchronized void removeElement(int x) {
        int grabArraysLength = this.grabArrays.length;
        int newLen = grabArraysLength > 1 ? grabArraysLength - 1 : 0;
        RemoveRandomWithObject[] newArray = new RemoveRandomWithObject[newLen];
        if (x > 0) {
            System.arraycopy(this.grabArrays, 0, newArray, 0, x);
        }
        if (x < grabArraysLength - 1) {
            System.arraycopy(this.grabArrays, x + 1, newArray, x, grabArraysLength - (x + 1));
        }
        this.grabArrays = newArray;
        Object[] newClients = new Object[newLen];
        if (x > 0) {
            System.arraycopy(this.grabClients, 0, newClients, 0, x);
        }
        if (x < grabArraysLength - 1) {
            System.arraycopy(this.grabClients, x + 1, newClients, x, grabArraysLength - (x + 1));
        }
        this.grabClients = newClients;
    }

    public synchronized boolean isEmpty(ObjectContainer container) {
        if (container != null && !this.persistent) {
            boolean stored = container.ext().isStored((Object)this);
            boolean active = container.ext().isActive((Object)this);
            if (stored && !active) {
                Logger.error(this, "Not empty because not active on " + this);
                return false;
            }
            if (!stored) {
                Logger.error(this, "Not stored yet passed in container on " + this, (Throwable)new Exception("debug"));
            } else if (stored) {
                throw new IllegalStateException("Stored but not persistent on " + this);
            }
        }
        return this.grabArrays.length == 0;
    }

    @Override
    public boolean persistent() {
        return this.persistent;
    }

    public synchronized int size() {
        return this.grabArrays.length;
    }

    @Override
    public void removeFrom(ObjectContainer container) {
        if (this.grabArrays != null && this.grabArrays.length != 0) {
            for (RemoveRandomWithObject rr : this.grabArrays) {
                if (rr == null) continue;
                Logger.error(this, "NOT EMPTY REMOVING " + this + " : " + rr);
                return;
            }
        }
        container.delete((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void maybeRemove(RemoveRandom r, ObjectContainer container, ClientContext context) {
        int finalSize;
        int count = 0;
        SectoredRandomGrabArray sectoredRandomGrabArray = this;
        synchronized (sectoredRandomGrabArray) {
            while (true) {
                int found = -1;
                for (int i = 0; i < this.grabArrays.length; ++i) {
                    if (this.grabArrays[i] != r) continue;
                    found = i;
                    break;
                }
                if (found == -1) break;
                if (++count > 1) {
                    Logger.error(this, "Found " + r + " many times in " + this, (Throwable)new Exception("error"));
                }
                this.removeElement(found);
            }
            finalSize = this.grabArrays.length;
        }
        if (count == 0) {
            if (logMINOR) {
                Logger.minor(this, "Not in parent: " + r + " for " + this, (Throwable)new Exception("error"));
            }
            context.cooldownTracker.removeCachedWakeup(r, this.persistent, container);
        } else if (this.persistent) {
            container.store((Object)this);
            r.removeFrom(container);
        }
        if (finalSize == 0 && this.parent != null) {
            boolean active = true;
            if (this.persistent) {
                active = container.ext().isActive((Object)this.parent);
            }
            if (!active) {
                container.activate((Object)this.parent, 1);
            }
            context.cooldownTracker.removeCachedWakeup(this, this.persistent, container);
            this.parent.maybeRemove(this, container, context);
            if (!active) {
                container.deactivate((Object)this.parent, 1);
            }
        }
    }

    public void moveElementsTo(SectoredRandomGrabArray newTopLevel, ObjectContainer container, boolean canCommit) {
        for (int i = 0; i < this.grabArrays.length; ++i) {
            RemoveRandomWithObject grabber = this.grabArrays[i];
            Object client = this.grabClients[i];
            if (grabber == null && client == null) continue;
            if (grabber == null && client != null) {
                System.err.println("Grabber is null but client is not null? client is " + client);
                continue;
            }
            if (grabber != null && client == null) {
                System.err.println("Client is null but grabber is not? grabber is " + grabber);
            }
            RemoveRandomWithObject existingGrabber = newTopLevel.getGrabber(client);
            if (this.persistent()) {
                container.activate(client, 1);
            }
            if (existingGrabber != null) {
                System.out.println("Merging with existing grabber for client " + client);
            }
            if (this.persistent()) {
                container.deactivate(client, 1);
            }
            if (existingGrabber != null) {
                if (this.persistent) {
                    container.activate((Object)grabber, 1);
                    container.activate((Object)existingGrabber, 1);
                }
                grabber.moveElementsTo(existingGrabber, container, canCommit);
                grabber.removeFrom(container);
                if (this.persistent) {
                    container.deactivate((Object)grabber, 1);
                    container.deactivate((Object)existingGrabber, 1);
                }
            } else {
                if (this.persistent) {
                    container.activate((Object)grabber, 1);
                }
                grabber.setParent(newTopLevel, container);
                if (grabber.getObject() == null && client != null) {
                    Logger.error(this, "Minor corruption on migration: client is " + client + " but grabber reports null, correcting");
                    grabber.setObject(client, container);
                }
                newTopLevel.addGrabber(client, grabber, container, null);
                if (this.persistent) {
                    container.deactivate((Object)grabber, 1);
                }
            }
            this.grabArrays[i] = null;
            this.grabClients[i] = null;
            if (!this.persistent) continue;
            container.store((Object)this);
            if (!canCommit) continue;
            container.commit();
        }
        this.grabArrays = new RemoveRandomWithObject[0];
        this.grabClients = new Object[0];
        if (this.persistent) {
            container.store((Object)this);
            if (canCommit) {
                container.commit();
            }
        }
    }

    @Override
    public void moveElementsTo(RemoveRandom existingGrabber, ObjectContainer container, boolean canCommit) {
        if (!(existingGrabber instanceof SectoredRandomGrabArray)) {
            throw new IllegalArgumentException();
        }
        this.moveElementsTo((SectoredRandomGrabArray)existingGrabber, container, canCommit);
    }

    @Override
    public void setParent(RemoveRandomParent newParent, ObjectContainer container) {
        this.parent = newParent;
        if (this.persistent()) {
            container.store((Object)this);
        }
    }

    static {
        Logger.registerClass(SectoredRandomGrabArray.class);
    }
}

