/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import java.util.LinkedHashMap;
import java.util.Map;

public class SentTimeCache {
    private BoundedSentTimeMap cache;

    public SentTimeCache(int maxSize) {
        this.cache = new BoundedSentTimeMap(maxSize);
    }

    public synchronized void report(int seqnum, long time) {
        this.cache.put(seqnum, time);
    }

    public synchronized void sent(int seqnum) {
        long time = System.currentTimeMillis();
        this.report(seqnum, time);
    }

    public synchronized long queryAndRemove(int seqnum) {
        Long ret = (Long)this.cache.remove(seqnum);
        if (ret == null) {
            return -1L;
        }
        return ret;
    }

    int size() {
        return this.cache.size();
    }

    private class BoundedSentTimeMap
    extends LinkedHashMap<Integer, Long> {
        private static final long serialVersionUID = 0L;
        private final int maxSize;

        BoundedSentTimeMap(int maxSize) {
            super(maxSize);
            if (maxSize <= 0) {
                throw new IllegalArgumentException("Negative or zero maxSize");
            }
            this.maxSize = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<Integer, Long> eldest) {
            return this.size() > this.maxSize;
        }
    }
}

