/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import com.db4o.ObjectContainer;
import freenet.client.FetchException;
import freenet.client.FetchResult;
import freenet.client.HighLevelSimpleClient;
import freenet.client.InsertException;
import freenet.client.async.BaseClientPutter;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientGetCallback;
import freenet.client.async.ClientGetter;
import freenet.client.async.ClientPutCallback;
import freenet.keys.FreenetURI;
import freenet.node.Node;
import freenet.node.PrioRunnable;
import freenet.support.Logger;
import freenet.support.TrivialTicker;
import freenet.support.io.TempBucketFactory;
import java.util.Collection;
import java.util.concurrent.TimeUnit;

public abstract class TransferThread
implements PrioRunnable,
ClientGetCallback,
ClientPutCallback {
    private final String mName;
    protected final Node mNode;
    protected final HighLevelSimpleClient mClient;
    protected final ClientContext mClientContext;
    protected final TempBucketFactory mTBF;
    private TrivialTicker mTicker;
    private final Collection<ClientGetter> mFetches = this.createFetchStorage();
    private final Collection<BaseClientPutter> mInserts = this.createInsertStorage();

    public TransferThread(Node myNode, HighLevelSimpleClient myClient, String myName) {
        this.mNode = myNode;
        this.mClient = myClient;
        this.mClientContext = this.mNode.clientCore.clientContext;
        this.mTBF = this.mNode.clientCore.tempBucketFactory;
        this.mName = myName;
        this.mTicker = new TrivialTicker(this.mNode.executor);
    }

    public void start() {
        Logger.debug(this, "Starting...");
        this.mTicker.queueTimedJob(this, this.mName, this.getStartupDelay(), false, true);
    }

    @Override
    public abstract int getPriority();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long sleepTime = TimeUnit.SECONDS.toMillis(1L);
        try {
            Logger.debug(this, "Loop running...");
            this.iterate();
            sleepTime = this.getSleepTime();
        }
        catch (Exception e) {
            Logger.error(this, "Error in iterate() or getSleepTime() probably", (Throwable)e);
        }
        finally {
            Logger.debug(this, "Loop finished. Sleeping for " + TimeUnit.MINUTES.convert(sleepTime, TimeUnit.MILLISECONDS) + " minutes.");
            this.mTicker.queueTimedJob(this, this.mName, sleepTime, false, true);
        }
    }

    public void nextIteration() {
        this.mTicker.rescheduleTimedJob(this, this.mName, 0L);
    }

    protected void abortAllTransfers() {
        Logger.debug(this, "Trying to stop all fetches & inserts...");
        this.abortFetches();
        this.abortInserts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void abortFetches() {
        Logger.debug(this, "Trying to stop all fetches...");
        if (this.mFetches != null) {
            Collection<ClientGetter> collection = this.mFetches;
            synchronized (collection) {
                ClientGetter[] fetches = this.mFetches.toArray(new ClientGetter[this.mFetches.size()]);
                int fcounter = 0;
                for (ClientGetter fetch : fetches) {
                    fetch.cancel(null, this.mNode.clientCore.clientContext);
                    ++fcounter;
                }
                Logger.debug(this, "Stopped " + fcounter + " current fetches.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void abortInserts() {
        Logger.debug(this, "Trying to stop all inserts...");
        if (this.mInserts != null) {
            Collection<BaseClientPutter> collection = this.mInserts;
            synchronized (collection) {
                BaseClientPutter[] inserts = this.mInserts.toArray(new BaseClientPutter[this.mInserts.size()]);
                int icounter = 0;
                for (BaseClientPutter insert : inserts) {
                    insert.cancel(null, this.mNode.clientCore.clientContext);
                    ++icounter;
                }
                Logger.debug(this, "Stopped " + icounter + " current inserts.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addFetch(ClientGetter g) {
        Collection<ClientGetter> collection = this.mFetches;
        synchronized (collection) {
            this.mFetches.add(g);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFetch(ClientGetter g) {
        Collection<ClientGetter> collection = this.mFetches;
        synchronized (collection) {
            this.mFetches.remove(g);
        }
        Logger.debug(this, "Removed request for " + g.getURI());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addInsert(BaseClientPutter p) {
        Collection<BaseClientPutter> collection = this.mInserts;
        synchronized (collection) {
            this.mInserts.add(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeInsert(BaseClientPutter p) {
        Collection<BaseClientPutter> collection = this.mInserts;
        synchronized (collection) {
            this.mInserts.remove(p);
        }
        Logger.debug(this, "Removed insert for " + p.getURI());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int fetchCount() {
        Collection<ClientGetter> collection = this.mFetches;
        synchronized (collection) {
            return this.mFetches.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int insertCount() {
        Collection<BaseClientPutter> collection = this.mInserts;
        synchronized (collection) {
            return this.mInserts.size();
        }
    }

    public void terminate() {
        Logger.debug(this, "Terminating...");
        this.mTicker.shutdown();
        try {
            this.abortAllTransfers();
        }
        catch (RuntimeException e) {
            Logger.error(this, "Aborting all transfers failed", (Throwable)e);
        }
        Logger.debug(this, "Terminated.");
    }

    protected abstract Collection<ClientGetter> createFetchStorage();

    protected abstract Collection<BaseClientPutter> createInsertStorage();

    protected abstract long getStartupDelay();

    protected abstract long getSleepTime();

    protected abstract void iterate();

    @Override
    public abstract void onSuccess(FetchResult var1, ClientGetter var2, ObjectContainer var3);

    @Override
    public abstract void onFailure(FetchException var1, ClientGetter var2, ObjectContainer var3);

    @Override
    public abstract void onSuccess(BaseClientPutter var1, ObjectContainer var2);

    @Override
    public abstract void onFailure(InsertException var1, BaseClientPutter var2, ObjectContainer var3);

    @Override
    public abstract void onFetchable(BaseClientPutter var1, ObjectContainer var2);

    @Override
    public abstract void onGeneratedURI(FreenetURI var1, BaseClientPutter var2, ObjectContainer var3);

    @Override
    public abstract void onMajorProgress(ObjectContainer var1);

    public boolean objectCanNew(ObjectContainer container) {
        Logger.error(this, "Not storing TransferThread in database", (Throwable)new Exception("error"));
        return false;
    }
}

