/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.compress;

import SevenZip.Compression.LZMA.Decoder;
import SevenZip.Compression.LZMA.Encoder;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.api.BucketFactory;
import freenet.support.compress.CompressionOutputSizeException;
import freenet.support.compress.Compressor;
import freenet.support.compress.InvalidCompressedDataException;
import freenet.support.compress.TooBigDictionaryException;
import freenet.support.io.Closer;
import freenet.support.io.CountedInputStream;
import freenet.support.io.CountedOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class NewLZMACompressor
implements Compressor {
    static final int MAX_DICTIONARY_SIZE = 0x100000;
    private static volatile boolean logMINOR;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bucket compress(Bucket data, BucketFactory bf, long maxReadLength, long maxWriteLength) throws IOException, CompressionOutputSizeException {
        Bucket output;
        InputStream is = null;
        OutputStream os = null;
        try {
            output = bf.makeBucket(maxWriteLength);
            is = data.getInputStream();
            os = output.getOutputStream();
            if (logMINOR) {
                Logger.minor(this, "Compressing " + data + " size " + data.size() + " to new bucket " + output);
            }
            this.compress(is, os, maxReadLength, maxWriteLength);
            is.close();
            is = null;
            os.close();
            os = null;
        }
        catch (Throwable throwable) {
            Closer.close(is);
            Closer.close(os);
            throw throwable;
        }
        Closer.close(is);
        Closer.close(os);
        return output;
    }

    @Override
    public long compress(InputStream is, OutputStream os, long maxReadLength, long maxWriteLength) throws IOException, CompressionOutputSizeException {
        int dictionarySize;
        CountedInputStream cis = null;
        CountedOutputStream cos = null;
        cis = new CountedInputStream(new BufferedInputStream(is, 32768));
        cos = new CountedOutputStream(new BufferedOutputStream(os, 32768));
        Encoder encoder = new Encoder();
        encoder.SetEndMarkerMode(true);
        if (maxReadLength == Long.MAX_VALUE || maxReadLength < 0L) {
            dictionarySize = 0x100000;
            Logger.error(this, "No indication of size, having to use maximum dictionary size", (Throwable)new Exception("debug"));
        } else {
            for (dictionarySize = 1; (long)dictionarySize < maxReadLength && dictionarySize < 0x100000; dictionarySize <<= 1) {
            }
        }
        encoder.SetDictionarySize(dictionarySize);
        encoder.WriteCoderProperties(os);
        encoder.Code((InputStream)cis, (OutputStream)cos, maxReadLength, maxWriteLength, null);
        if (cos.written() > maxWriteLength) {
            throw new CompressionOutputSizeException(cos.written());
        }
        cos.flush();
        if (logMINOR) {
            Logger.minor(this, "Read " + cis.count() + " written " + cos.written());
        }
        return cos.written();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bucket decompress(Bucket data, BucketFactory bf, long maxLength, long maxCheckSizeLength, Bucket preferred) throws IOException, CompressionOutputSizeException {
        Bucket output = preferred != null ? preferred : bf.makeBucket(maxLength);
        if (logMINOR) {
            Logger.minor(this, "Decompressing " + data + " size " + data.size() + " to new bucket " + output);
        }
        CountedInputStream is = null;
        BufferedOutputStream os = null;
        try {
            is = new CountedInputStream(new BufferedInputStream(data.getInputStream(), 32768));
            os = new BufferedOutputStream(output.getOutputStream(), 32768);
            this.decompress(is, os, maxLength, maxCheckSizeLength);
            if (logMINOR) {
                Logger.minor(this, "Output: " + output + " size " + output.size() + " read " + is.count());
            }
            is.close();
            is = null;
            os.close();
            os = null;
        }
        catch (Throwable throwable) {
            Closer.close(os);
            Closer.close(is);
            throw throwable;
        }
        Closer.close(os);
        Closer.close(is);
        return output;
    }

    @Override
    public long decompress(InputStream is, OutputStream os, long maxLength, long maxCheckSizeBytes) throws IOException, CompressionOutputSizeException {
        byte[] props = new byte[5];
        DataInputStream dis = new DataInputStream(is);
        dis.readFully(props);
        CountedOutputStream cos = new CountedOutputStream(os);
        int dictionarySize = 0;
        for (int i = 0; i < 4; ++i) {
            dictionarySize += (props[1 + i] & 0xFF) << i * 8;
        }
        if (dictionarySize < 0) {
            throw new InvalidCompressedDataException("Invalid dictionary size");
        }
        if (dictionarySize > 0x100000) {
            throw new TooBigDictionaryException();
        }
        Decoder decoder = new Decoder();
        if (!decoder.SetDecoderProperties(props)) {
            throw new InvalidCompressedDataException("Invalid properties");
        }
        decoder.Code(is, (OutputStream)cos, maxLength);
        return cos.written();
    }

    @Override
    public int decompress(byte[] dbuf, int i, int j, byte[] output) throws CompressionOutputSizeException {
        ByteArrayInputStream bais = new ByteArrayInputStream(dbuf, i, j);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(output.length);
        int bytes = 0;
        try {
            this.decompress(bais, baos, (long)output.length, -1L);
            bytes = baos.size();
        }
        catch (IOException e) {
            throw new Error("Got IOException: " + e.getMessage(), e);
        }
        byte[] buf = baos.toByteArray();
        System.arraycopy(buf, 0, output, 0, bytes);
        return bytes;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

