/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.compress;

import com.db4o.ObjectContainer;
import freenet.client.InsertException;
import freenet.client.async.ClientContext;
import freenet.node.PrioRunnable;
import freenet.support.Executor;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.compress.CompressJob;
import freenet.support.io.NativeThread;
import java.util.LinkedList;
import java.util.concurrent.Semaphore;

public class RealCompressor
implements PrioRunnable {
    private final Executor exec;
    private ClientContext context;
    private static final LinkedList<CompressJob> _awaitingJobs = new LinkedList();
    public static final Semaphore compressorSemaphore = new Semaphore(RealCompressor.getMaxRunningCompressionThreads());
    private static volatile boolean logMINOR;

    public RealCompressor(Executor e) {
        this.exec = e;
    }

    public void setClientContext(ClientContext context) {
        this.context = context;
    }

    @Override
    public int getPriority() {
        return NativeThread.HIGH_PRIORITY;
    }

    public synchronized void enqueueNewJob(CompressJob j) {
        _awaitingJobs.add(j);
        if (logMINOR) {
            Logger.minor(this, "Enqueueing compression job: " + j);
        }
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Logger.normal(this, "Starting RealCompressor");
        while (true) {
            CompressJob currentJob = null;
            try {
                RealCompressor realCompressor = this;
                synchronized (realCompressor) {
                    currentJob = _awaitingJobs.poll();
                    if (currentJob == null) {
                        this.wait();
                        continue;
                    }
                }
                compressorSemaphore.acquire();
            }
            catch (InterruptedException e) {
                Logger.error(this, "caught: " + e.getMessage(), (Throwable)e);
                continue;
            }
            final CompressJob finalJob = currentJob;
            this.exec.execute(new PrioRunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Logger.OSThread.logPID(this);
                    try {
                        try {
                            finalJob.tryCompress(RealCompressor.this.context);
                        }
                        catch (InsertException e) {
                            finalJob.onFailure(e, null, RealCompressor.this.context);
                        }
                        catch (Throwable t) {
                            Logger.error(this, "Caught in OffThreadCompressor: " + t, t);
                            System.err.println("Caught in OffThreadCompressor: " + t);
                            t.printStackTrace();
                            finalJob.onFailure(new InsertException(3, t, null), null, RealCompressor.this.context);
                        }
                    }
                    catch (Throwable t) {
                        Logger.error(this, "Caught " + t + " in " + this, t);
                    }
                    finally {
                        compressorSemaphore.release();
                    }
                }

                @Override
                public int getPriority() {
                    return NativeThread.MIN_PRIORITY;
                }
            }, "Compressor thread for " + currentJob);
        }
    }

    public boolean objectCanNew(ObjectContainer container) {
        Logger.error(this, "Not storing RealCompressor in database", (Throwable)new Exception("error"));
        return false;
    }

    private static int getMaxRunningCompressionThreads() {
        int maxRunningThreads = 1;
        String osName = System.getProperty("os.name");
        if (osName.indexOf("Windows") == -1 && osName.toLowerCase().indexOf("mac os x") > 0 || !NativeThread.usingNativeCode()) {
            maxRunningThreads = 1;
        } else {
            Runtime r = Runtime.getRuntime();
            int max = r.availableProcessors();
            long maxMemory = r.maxMemory();
            max = maxMemory < 0x8000000L ? 1 : Math.min(max, (int)Math.min(Integer.MAX_VALUE, maxMemory / 0x8000000L));
            maxRunningThreads = max;
        }
        Logger.minor(RealCompressor.class, "Maximum Compressor threads: " + maxRunningThreads);
        return maxRunningThreads;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

