/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import com.db4o.ObjectContainer;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.io.BaseFileBucket;
import java.io.File;

public class FileBucket
extends BaseFileBucket
implements Bucket {
    protected final File file;
    protected boolean readOnly;
    protected boolean deleteOnFinalize;
    protected boolean deleteOnFree;
    protected final boolean deleteOnExit;
    protected final boolean createFileOnly;
    private static volatile boolean logMINOR;

    public FileBucket(File file, boolean readOnly, boolean createFileOnly, boolean deleteOnFinalize, boolean deleteOnExit, boolean deleteOnFree) {
        super(file, deleteOnExit);
        if (file == null) {
            throw new NullPointerException();
        }
        File origFile = file;
        if (origFile == (file = file.getAbsoluteFile())) {
            file = new File(file.getPath());
        }
        this.readOnly = readOnly;
        this.createFileOnly = createFileOnly;
        this.file = file;
        this.deleteOnFinalize = deleteOnFinalize;
        this.deleteOnFree = deleteOnFree;
        this.deleteOnExit = deleteOnExit;
        this.fileRestartCounter = 0L;
    }

    @Override
    public synchronized File getFile() {
        return this.file;
    }

    @Override
    public synchronized boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public synchronized void setReadOnly() {
        this.readOnly = true;
    }

    public synchronized void dontDeleteOnFinalize() {
        this.deleteOnFinalize = false;
    }

    @Override
    protected boolean createFileOnly() {
        return this.createFileOnly;
    }

    @Override
    protected boolean deleteOnExit() {
        return this.deleteOnExit;
    }

    @Override
    protected boolean deleteOnFinalize() {
        return this.deleteOnFinalize;
    }

    @Override
    protected boolean deleteOnFree() {
        return this.deleteOnFree;
    }

    @Override
    public void storeTo(ObjectContainer container) {
        container.store((Object)this);
    }

    @Override
    public void removeFrom(ObjectContainer container) {
        container.activate((Object)this.file, 5);
        if (logMINOR) {
            Logger.minor(this, "Removing " + this);
        }
        container.delete((Object)this.file);
        container.delete((Object)this);
    }

    public void objectOnActivate(ObjectContainer container) {
        container.activate((Object)this.file, 5);
    }

    @Override
    public Bucket createShadow() {
        String fnam = this.file.getPath();
        File newFile = new File(fnam);
        return new FileBucket(newFile, true, false, false, false, false);
    }

    static {
        Logger.registerClass(FileBucket.class);
    }
}

