/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import com.db4o.ObjectContainer;
import freenet.crypt.PCFBMode;
import freenet.crypt.RandomSource;
import freenet.crypt.UnsupportedCipherException;
import freenet.crypt.ciphers.Rijndael;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.math.MersenneTwister;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Random;

public class PaddedEphemerallyEncryptedBucket
implements Bucket {
    private final Bucket bucket;
    private final int minPaddedSize;
    private final byte[] key;
    private final byte[] iv;
    private final byte[] randomSeed;
    private long dataLength;
    private boolean readOnly;
    private int lastOutputStream;
    private static volatile boolean logMINOR;

    public PaddedEphemerallyEncryptedBucket(Bucket bucket, int minSize, RandomSource strongPRNG, Random weakPRNG) {
        this.bucket = bucket;
        if (bucket.size() != 0L) {
            throw new IllegalArgumentException("Bucket must be empty");
        }
        byte[] tempKey = new byte[32];
        this.randomSeed = new byte[32];
        weakPRNG.nextBytes(this.randomSeed);
        strongPRNG.nextBytes(tempKey);
        this.key = tempKey;
        this.iv = new byte[32];
        strongPRNG.nextBytes(this.iv);
        this.minPaddedSize = minSize;
        this.readOnly = false;
        this.lastOutputStream = 0;
        this.dataLength = 0L;
    }

    public PaddedEphemerallyEncryptedBucket(PaddedEphemerallyEncryptedBucket orig, Bucket newBucket) {
        this.dataLength = orig.dataLength;
        this.key = (byte[])orig.key.clone();
        this.randomSeed = null;
        this.setReadOnly();
        this.bucket = newBucket;
        this.minPaddedSize = orig.minPaddedSize;
        this.iv = (byte[])(orig.iv != null ? Arrays.copyOf(orig.iv, 32) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.readOnly) {
            throw new IOException("Read only");
        }
        OutputStream os = this.bucket.getOutputStream();
        PaddedEphemerallyEncryptedBucket paddedEphemerallyEncryptedBucket = this;
        synchronized (paddedEphemerallyEncryptedBucket) {
            this.dataLength = 0L;
        }
        return new PaddedEphemerallyEncryptedOutputStream(os, ++this.lastOutputStream);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new PaddedEphemerallyEncryptedInputStream(this.bucket.getInputStream());
    }

    public synchronized long paddedLength() {
        long size = this.dataLength;
        if (size < (long)this.minPaddedSize) {
            size = this.minPaddedSize;
        }
        if (size == (long)this.minPaddedSize) {
            return size;
        }
        long min = this.minPaddedSize;
        long max = (long)this.minPaddedSize << 1;
        while (true) {
            if (max < 0L) {
                throw new Error("Impossible size: " + size + " - min=" + min + ", max=" + max);
            }
            if (size < min) {
                throw new IllegalStateException("???");
            }
            if (size >= min && size <= max) {
                if (logMINOR) {
                    Logger.minor(this, "Padded: " + max + " was: " + this.dataLength + " for " + this.getName());
                }
                return max;
            }
            min = max;
            max <<= 1;
        }
    }

    private synchronized Rijndael getRijndael() {
        Rijndael aes;
        try {
            aes = new Rijndael(256, 256);
        }
        catch (UnsupportedCipherException e) {
            throw new Error(e);
        }
        aes.initialize(this.key);
        return aes;
    }

    public PCFBMode getPCFB() {
        Rijndael aes = this.getRijndael();
        if (this.iv != null) {
            return PCFBMode.create(aes, this.iv);
        }
        return PCFBMode.create(aes);
    }

    @Override
    public String getName() {
        return "Encrypted:" + this.bucket.getName();
    }

    public String toString() {
        return super.toString() + ':' + this.bucket;
    }

    @Override
    public synchronized long size() {
        return this.dataLength;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void setReadOnly() {
        this.readOnly = true;
    }

    public Bucket getUnderlying() {
        return this.bucket;
    }

    @Override
    public void free() {
        this.bucket.free();
    }

    public byte[] getKey() {
        return this.key;
    }

    @Override
    public void storeTo(ObjectContainer container) {
        this.bucket.storeTo(container);
        container.store((Object)this);
    }

    @Override
    public void removeFrom(ObjectContainer container) {
        if (logMINOR) {
            Logger.minor(this, "Removing from database: " + this);
        }
        this.bucket.removeFrom(container);
        container.delete((Object)this);
    }

    public void objectOnActivate(ObjectContainer container) {
        Logger.minor(this, "Activating " + super.toString() + " bucket == null = " + (this.bucket == null));
        container.activate((Object)this.bucket, 1);
    }

    @Override
    public Bucket createShadow() {
        Bucket newUnderlying = this.bucket.createShadow();
        if (newUnderlying == null) {
            return null;
        }
        return new PaddedEphemerallyEncryptedBucket(this, newUnderlying);
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }

    private class PaddedEphemerallyEncryptedInputStream
    extends InputStream {
        final InputStream in;
        final PCFBMode pcfb;
        long ptr;

        public PaddedEphemerallyEncryptedInputStream(InputStream in) {
            this.in = in;
            this.pcfb = PaddedEphemerallyEncryptedBucket.this.getPCFB();
            this.ptr = 0L;
        }

        @Override
        public int read() throws IOException {
            if (this.ptr >= PaddedEphemerallyEncryptedBucket.this.dataLength) {
                return -1;
            }
            int x = this.in.read();
            if (x == -1) {
                return x;
            }
            ++this.ptr;
            return this.pcfb.decipher(x);
        }

        @Override
        public final int available() {
            int x = (int)Math.min(PaddedEphemerallyEncryptedBucket.this.dataLength - this.ptr, Integer.MAX_VALUE);
            return x < 0 ? 0 : x;
        }

        @Override
        public int read(byte[] buf, int offset, int length) throws IOException {
            if (length + offset > buf.length || offset < 0 || length < 0) {
                throw new ArrayIndexOutOfBoundsException("a=" + offset + ", b=" + length + ", length " + buf.length);
            }
            int x = this.available();
            if (x <= 0) {
                return -1;
            }
            int readBytes = this.in.read(buf, offset, length = Math.min(length, x));
            if (readBytes <= 0) {
                return readBytes;
            }
            this.ptr += (long)readBytes;
            this.pcfb.blockDecipher(buf, offset, readBytes);
            return readBytes;
        }

        @Override
        public int read(byte[] buf) throws IOException {
            return this.read(buf, 0, buf.length);
        }

        @Override
        public long skip(long bytes) throws IOException {
            long skipped;
            int x;
            byte[] buf = new byte[(int)Math.min(4096L, bytes)];
            for (skipped = 0L; skipped < bytes; skipped += (long)x) {
                x = this.read(buf, 0, (int)Math.min(bytes - skipped, (long)buf.length));
                if (x > 0) continue;
                return skipped;
            }
            return skipped;
        }

        @Override
        public void close() throws IOException {
            this.in.close();
        }
    }

    private class PaddedEphemerallyEncryptedOutputStream
    extends OutputStream {
        final PCFBMode pcfb;
        final OutputStream out;
        final int streamNumber;
        private boolean closed;

        public PaddedEphemerallyEncryptedOutputStream(OutputStream out, int streamNumber) {
            this.out = out;
            PaddedEphemerallyEncryptedBucket.this.dataLength = 0L;
            this.streamNumber = streamNumber;
            this.pcfb = PaddedEphemerallyEncryptedBucket.this.getPCFB();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(int b) throws IOException {
            if (this.closed) {
                throw new IOException("Already closed!");
            }
            if (this.streamNumber != PaddedEphemerallyEncryptedBucket.this.lastOutputStream) {
                throw new IllegalStateException("Writing to old stream in " + PaddedEphemerallyEncryptedBucket.this.getName());
            }
            int toWrite = this.pcfb.encipher(b);
            PaddedEphemerallyEncryptedBucket paddedEphemerallyEncryptedBucket = PaddedEphemerallyEncryptedBucket.this;
            synchronized (paddedEphemerallyEncryptedBucket) {
                this.out.write(toWrite);
                PaddedEphemerallyEncryptedBucket.this.dataLength++;
            }
        }

        @Override
        public void write(byte[] buf) throws IOException {
            if (this.closed) {
                throw new IOException("Already closed!");
            }
            if (this.streamNumber != PaddedEphemerallyEncryptedBucket.this.lastOutputStream) {
                throw new IllegalStateException("Writing to old stream in " + PaddedEphemerallyEncryptedBucket.this.getName());
            }
            this.write(buf, 0, buf.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] buf, int offset, int length) throws IOException {
            if (this.closed) {
                throw new IOException("Already closed!");
            }
            if (this.streamNumber != PaddedEphemerallyEncryptedBucket.this.lastOutputStream) {
                throw new IllegalStateException("Writing to old stream in " + PaddedEphemerallyEncryptedBucket.this.getName());
            }
            if (length == 0) {
                return;
            }
            byte[] enc = Arrays.copyOfRange(buf, offset, offset + length);
            this.pcfb.blockEncipher(enc, 0, enc.length);
            PaddedEphemerallyEncryptedBucket paddedEphemerallyEncryptedBucket = PaddedEphemerallyEncryptedBucket.this;
            synchronized (paddedEphemerallyEncryptedBucket) {
                this.out.write(enc, 0, enc.length);
                PaddedEphemerallyEncryptedBucket.this.dataLength += enc.length;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            try {
                if (this.streamNumber != PaddedEphemerallyEncryptedBucket.this.lastOutputStream) {
                    Logger.normal(this, "Not padding out to length because have been superceded: " + PaddedEphemerallyEncryptedBucket.this.getName());
                    return;
                }
                MersenneTwister random = new MersenneTwister(PaddedEphemerallyEncryptedBucket.this.randomSeed);
                PaddedEphemerallyEncryptedBucket paddedEphemerallyEncryptedBucket = PaddedEphemerallyEncryptedBucket.this;
                synchronized (paddedEphemerallyEncryptedBucket) {
                    int left;
                    long finalLength = PaddedEphemerallyEncryptedBucket.this.paddedLength();
                    long padding = finalLength - PaddedEphemerallyEncryptedBucket.this.dataLength;
                    int sz = 65536;
                    if (padding < (long)sz) {
                        sz = (int)padding;
                    }
                    byte[] buf = new byte[sz];
                    for (long writtenPadding = 0L; writtenPadding < padding; writtenPadding += (long)left) {
                        left = (int)Math.min(padding - writtenPadding, (long)buf.length);
                        ((Random)((Object)random)).nextBytes(buf);
                        this.out.write(buf, 0, left);
                    }
                }
            }
            finally {
                this.closed = true;
                this.out.flush();
                this.out.close();
            }
        }
    }
}

