/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.query.Query;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.io.PersistentBlobTempBucketFactory;
import freenet.support.io.PersistentBlobTempBucketTag;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class PersistentBlobTempBucket
implements Bucket {
    public final long blockSize;
    long size;
    public final PersistentBlobTempBucketFactory factory;
    private volatile long index;
    private boolean freed;
    private boolean readOnly;
    private boolean persisted;
    private final int hashCode;
    private PersistentBlobTempBucketTag tag;
    private boolean shadow;
    private int inputStreams;

    public int hashCode() {
        return this.hashCode;
    }

    public PersistentBlobTempBucket(PersistentBlobTempBucketFactory factory2, long blockSize2, long slot, PersistentBlobTempBucketTag tag, boolean shadow) {
        this.factory = factory2;
        this.blockSize = blockSize2;
        this.index = slot;
        this.hashCode = super.hashCode();
        if (tag == null && !shadow) {
            throw new NullPointerException();
        }
        if (shadow) {
            tag = null;
        }
        this.tag = tag;
        this.shadow = shadow;
        this.readOnly = shadow;
    }

    @Override
    public Bucket createShadow() {
        return this.factory.createShadow(this);
    }

    @Override
    public void free() {
        if (this.shadow) {
            this.factory.freeShadow(this.index, this);
        } else {
            this.factory.freeBucket(this.index, this);
        }
    }

    public boolean freed() {
        return this.freed;
    }

    synchronized void onFree() {
        this.freed = true;
    }

    boolean persisted() {
        return this.persisted;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.freed) {
            throw new IOException("Already freed");
        }
        final FileChannel channel = this.factory.channel;
        return new InputStream(){
            private int offset;
            private boolean closed;
            {
                PersistentBlobTempBucket persistentBlobTempBucket2 = PersistentBlobTempBucket.this;
                synchronized (persistentBlobTempBucket2) {
                    PersistentBlobTempBucket.this.inputStreams++;
                }
            }

            @Override
            public int read() throws IOException {
                if (this.closed) {
                    throw new IOException("closed");
                }
                byte[] buf = new byte[1];
                int res = this.read(buf);
                if (res == -1) {
                    return -1;
                }
                return buf[0];
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int read(byte[] buffer, int bufOffset, int length) throws IOException {
                int read;
                long max;
                if (this.closed) {
                    throw new IOException("closed");
                }
                PersistentBlobTempBucket persistentBlobTempBucket = PersistentBlobTempBucket.this;
                synchronized (persistentBlobTempBucket) {
                    if (PersistentBlobTempBucket.this.freed) {
                        throw new IOException("Bucket freed during read");
                    }
                    max = Math.min(PersistentBlobTempBucket.this.blockSize, PersistentBlobTempBucket.this.size);
                }
                if (length == 0) {
                    return 0;
                }
                if (bufOffset < 0) {
                    return -1;
                }
                if ((long)(this.offset + length) >= max) {
                    length = (int)Math.min(max - (long)this.offset, Integer.MAX_VALUE);
                }
                if (length == 0) {
                    return -1;
                }
                if (length < 0) {
                    throw new IllegalStateException("offset=" + bufOffset + " length=" + length + " buf len = " + buffer.length + " my offset is " + this.offset + " my size is " + max + " for " + this + " for " + PersistentBlobTempBucket.this);
                }
                ByteBuffer buf = ByteBuffer.wrap(buffer, bufOffset, length);
                PersistentBlobTempBucket persistentBlobTempBucket2 = PersistentBlobTempBucket.this;
                synchronized (persistentBlobTempBucket2) {
                    read = channel.read(buf, PersistentBlobTempBucket.this.blockSize * PersistentBlobTempBucket.this.index + (long)this.offset);
                }
                if (read > 0) {
                    this.offset += read;
                }
                return read;
            }

            @Override
            public int read(byte[] buffer) throws IOException {
                if (this.closed) {
                    throw new IOException("closed");
                }
                return this.read(buffer, 0, buffer.length);
            }

            @Override
            public int available() {
                return (int)Math.min(PersistentBlobTempBucket.this.blockSize - (long)this.offset, Integer.MAX_VALUE);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                PersistentBlobTempBucket persistentBlobTempBucket = PersistentBlobTempBucket.this;
                synchronized (persistentBlobTempBucket) {
                    PersistentBlobTempBucket.this.inputStreams--;
                }
            }
        };
    }

    @Override
    public String getName() {
        return this.factory.getName() + ":" + this.index;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.freed) {
            throw new IOException("Already freed");
        }
        if (this.shadow) {
            throw new IOException("Shadow");
        }
        if (this.readOnly) {
            throw new IOException("Read-only");
        }
        final FileChannel channel = this.factory.channel;
        return new OutputStream(){
            private int offset;

            @Override
            public void write(int arg) throws IOException {
                byte[] buf = new byte[]{(byte)arg};
                this.write(buf, 0, 1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void write(byte[] buffer, int bufOffset, int length) throws IOException {
                int w;
                PersistentBlobTempBucket persistentBlobTempBucket = PersistentBlobTempBucket.this;
                synchronized (persistentBlobTempBucket) {
                    if (PersistentBlobTempBucket.this.freed) {
                        throw new IOException("Bucket freed during write");
                    }
                    if (PersistentBlobTempBucket.this.readOnly) {
                        throw new IOException("Bucket made read only during write");
                    }
                }
                long remaining = PersistentBlobTempBucket.this.blockSize - (long)this.offset;
                if (remaining <= 0L) {
                    throw new IOException("Too big");
                }
                if ((long)length > remaining) {
                    throw new IOException("Writing too many bytes: written " + this.offset + " of " + PersistentBlobTempBucket.this.blockSize + " and now want to write " + length);
                }
                ByteBuffer buf = ByteBuffer.wrap(buffer, bufOffset, length);
                for (int written = 0; written < length; written += w) {
                    PersistentBlobTempBucket persistentBlobTempBucket2 = PersistentBlobTempBucket.this;
                    synchronized (persistentBlobTempBucket2) {
                        w = channel.write(buf, PersistentBlobTempBucket.this.blockSize * PersistentBlobTempBucket.this.index + (long)this.offset);
                        this.offset += w;
                        PersistentBlobTempBucket.this.size += (long)w;
                        continue;
                    }
                }
            }

            @Override
            public void write(byte[] buffer) throws IOException {
                this.write(buffer, 0, buffer.length);
            }
        };
    }

    @Override
    public synchronized boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public synchronized void setReadOnly() {
        this.readOnly = true;
    }

    @Override
    public synchronized long size() {
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeTo(ObjectContainer container) {
        boolean p;
        if (this.shadow) {
            throw new UnsupportedOperationException("Can't store a shadow");
        }
        PersistentBlobTempBucket persistentBlobTempBucket = this;
        synchronized (persistentBlobTempBucket) {
            if (this.freed) {
                Logger.error(this, "Storing freed bucket " + this + " formerly for slot " + this.index, (Throwable)new Exception("error"));
                if (this.tag != null) {
                    container.activate((Object)this.tag, 1);
                    if (this.tag.bucket == this) {
                        Logger.error(this, "Clearing tag");
                        this.tag.bucket = null;
                        this.tag.isFree = true;
                        container.store((Object)this.tag);
                    }
                    this.tag = null;
                }
                container.store((Object)this);
                return;
            }
            if (this.tag == null && !container.ext().isActive((Object)this)) {
                Logger.error(this, "NOT ACTIVE IN storeTo()!!", (Throwable)new Exception("error"));
                container.activate((Object)this, 1);
            }
            if (this.tag == null) {
                Query q = container.query();
                q.constrain(PersistentBlobTempBucketTag.class);
                q.descend("index").constrain((Object)this.index);
                ObjectSet results = q.execute();
                if (results.isEmpty()) {
                    Logger.error(this, "Tag not found");
                } else {
                    PersistentBlobTempBucketTag tag = (PersistentBlobTempBucketTag)results.next();
                    if (tag.bucket == null) {
                        Logger.error(this, "Found tag but is empty");
                        throw new NullPointerException("Active but tag null! (Other tag is also null) shadow=" + this.shadow + " freed=" + this.freed + " persisted=" + this.persisted + " stored=" + container.ext().isStored((Object)this) + " index=" + this.index + " for " + this);
                    }
                    if (tag.bucket == this) {
                        this.tag = tag;
                        container.store((Object)this);
                        Logger.error(this, "Found tag, was pointing to us, fixed");
                    } else {
                        throw new NullPointerException("Active but tag null, and other tag points to other bucket!: " + tag.bucket + " not " + this + " details: shadow=" + this.shadow + " freed=" + this.freed + " persisted=" + this.persisted + " stored=" + container.ext().isStored((Object)this) + " index=" + this.index);
                    }
                }
            }
            p = this.persisted;
            this.persisted = true;
        }
        if (!p) {
            this.factory.store(this, container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean objectCanNew(ObjectContainer container) {
        if (this.shadow) {
            throw new UnsupportedOperationException("Can't store a shadow");
        }
        PersistentBlobTempBucket persistentBlobTempBucket = this;
        synchronized (persistentBlobTempBucket) {
            if (this.persisted) {
                return true;
            }
        }
        Logger.error(this, "objectOnNew() called but we haven't been stored yet! for " + this + " for " + this.factory + " index " + this.index, (Throwable)new Exception("error"));
        return true;
    }

    public boolean objectCanDeactivate(ObjectContainer container) {
        if (this.inputStreams > 0) {
            Logger.error(this, "Deactivating when have active input streams!", (Throwable)new Exception("error"));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFrom(ObjectContainer container) {
        boolean p;
        if (this.shadow) {
            throw new UnsupportedOperationException("Can't store a shadow");
        }
        PersistentBlobTempBucket persistentBlobTempBucket = this;
        synchronized (persistentBlobTempBucket) {
            p = this.persisted;
        }
        if (p) {
            this.factory.remove(this, container);
        }
        container.delete((Object)this);
    }

    synchronized void onRemove() {
        this.persisted = false;
    }

    public synchronized long getIndex() {
        return this.index;
    }

    synchronized void setIndex(long index2) {
        this.index = index2;
    }

    synchronized void setTag(PersistentBlobTempBucketTag newTag) {
        this.tag = newTag;
    }

    public synchronized PersistentBlobTempBucketTag getTag() {
        return this.tag;
    }
}

