/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.query.Query;
import freenet.client.async.ClientContext;
import freenet.client.async.DBJob;
import freenet.client.async.DBJobRunner;
import freenet.client.async.DatabaseDisabledException;
import freenet.support.BitArray;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.Ticker;
import freenet.support.api.Bucket;
import freenet.support.io.FileUtil;
import freenet.support.io.NativeThread;
import freenet.support.io.PersistentBlobTempBucket;
import freenet.support.io.PersistentBlobTempBucketTag;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.SyncFailedException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.tanukisoftware.wrapper.WrapperManager;

public class PersistentBlobTempBucketFactory {
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;
    public final long blockSize;
    private File storageFile;
    private transient RandomAccessFile raf;
    private transient HashSet<DBJob> freeJobs;
    transient FileChannel channel;
    private transient BitArray freeBlocksCache;
    private transient TreeMap<Long, PersistentBlobTempBucket> notCommittedBlobs;
    private transient TreeMap<Long, PersistentBlobTempBucketTag> freeSlots;
    private transient TreeMap<Long, PersistentBlobTempBucketTag> almostFreeSlots;
    private transient long lastMovedFrom = Long.MAX_VALUE;
    private transient TreeMap<Long, PersistentBlobTempBucket> shadows;
    private transient DBJobRunner jobRunner;
    private transient Random weakRandomSource;
    private transient Ticker ticker;
    static final int MAX_FREE = 2048;
    private transient DBJob slotFinder;
    private long lastCheckedEnd = -1L;
    static boolean DISABLE_SANITY_CHECKS_DEFRAG;
    private transient long cachedSize;

    public PersistentBlobTempBucketFactory(long blockSize2, long nodeDBHandle2, File storageFile2) {
        this.blockSize = blockSize2;
        this.storageFile = storageFile2;
    }

    void onInit(ObjectContainer container, DBJobRunner jobRunner2, Random fastWeakRandom, File storageFile2, long blockSize2, Ticker ticker) throws IOException {
        container.activate((Object)this.storageFile, 100);
        this.initSlotFinder();
        File oldFile = FileUtil.getCanonicalFile(new File(this.storageFile.getPath()));
        File newFile = FileUtil.getCanonicalFile(new File(storageFile2.getPath()));
        if (this.blockSize != blockSize2) {
            throw new IllegalStateException("My block size is " + blockSize2 + " but stored block size is " + this.blockSize + " for same file " + this.storageFile);
        }
        if (!oldFile.equals(newFile) && !(File.separatorChar != '\\' ? oldFile.getPath().equals(newFile.getPath()) : oldFile.getPath().toLowerCase().equals(newFile.getPath().toLowerCase()))) {
            if (this.storageFile.exists() && !FileUtil.moveTo(this.storageFile, storageFile2, false)) {
                throw new IOException("Unable to move temp blob file from " + this.storageFile + " to " + storageFile2);
            }
            this.storageFile = storageFile2;
            container.store((Object)this);
        }
        this.raf = new RandomAccessFile(this.storageFile, "rw");
        this.channel = this.raf.getChannel();
        this.notCommittedBlobs = new TreeMap();
        this.freeSlots = new TreeMap();
        this.almostFreeSlots = new TreeMap();
        this.shadows = new TreeMap();
        this.jobRunner = jobRunner2;
        this.weakRandomSource = fastWeakRandom;
        this.freeJobs = new HashSet();
        this.ticker = ticker;
        this.freeBlocksCache = this.createFreeBlocksCache(container);
        this.maybeShrink(container);
        if (logDEBUG) {
            this.initRangeDump(container);
        }
    }

    private BitArray createFreeBlocksCache(ObjectContainer container) throws IOException {
        long size;
        System.err.println("Creating free blocks cache...");
        try {
            size = this.channel.size();
        }
        catch (IOException e1) {
            Logger.error(this, "Unable to find size of temp blob storage file: " + e1, (Throwable)e1);
            throw e1;
        }
        size -= size % this.blockSize;
        long blocks = size / this.blockSize;
        WrapperManager.signalStarting((int)((int)Math.max(blocks * 100L, TimeUnit.HOURS.toMillis(24L))));
        if (blocks > Integer.MAX_VALUE) {
            Logger.error(this, "Unable to create free blocks cache!");
            throw new IOException("Blob file already too big!");
        }
        BitArray freeBlocksCache = new BitArray((int)blocks);
        Query query = container.query();
        query.constrain(PersistentBlobTempBucketTag.class);
        ObjectSet tags = query.execute();
        int counter = 0;
        int buckets = 0;
        while (tags.hasNext()) {
            if (counter % 1024 == 0) {
                System.out.println("Creating free blocks cache: " + counter + " / " + blocks);
            }
            PersistentBlobTempBucketTag tag = (PersistentBlobTempBucketTag)tags.next();
            ++counter;
            if (tag.factory != this) continue;
            if (tag.isFree) {
                if (tag.bucket == null) continue;
                container.activate((Object)tag.bucket, 1);
                if (tag.bucket.freed()) continue;
                Logger.error(this, "Bucket " + tag.bucket + " for index " + tag.index + " is not free even though tag is!");
                continue;
            }
            if (tag.bucket == null) {
                Logger.error(this, "Tag for index " + tag.index + " has no bucket yet is not free?!");
                tag.isFree = true;
                container.store((Object)tag);
            }
            ++buckets;
            if (tag.index > Integer.MAX_VALUE) {
                Logger.error(this, "Tag for index " + tag.index + " is over MAXINT yet the file length is not?!");
                continue;
            }
            if (tag.index >= (long)freeBlocksCache.getSize()) {
                if (tag.isFree) {
                    if (tag.bucket != null) {
                        Logger.error(this, "Block is marked free, is beyond the end of the file, yet has a bucket!! Freeing anyway...");
                        container.activate((Object)tag.bucket, 1);
                        tag.bucket.onFree();
                        container.delete((Object)tag.bucket);
                    }
                    container.delete((Object)tag);
                    continue;
                }
                if (tag.bucket == null) {
                    Logger.error(this, "Block beyond the end of the file marked as in use but has no bucket!");
                    container.delete((Object)tag);
                    continue;
                }
                Logger.error(this, "Block is occupied *AND IN USE* yet beyond the length of the file: " + tag.index);
                Logger.error(this, "Freeing the block, expect internal errors and similar problems!");
                System.err.println("Your downloads database is corrupt. A persistent temp bucket is in use yet is beyond the length of the persistent-blob.tmp file.");
                System.err.println("We will free the bucket, but this may cause internal errors and similar problems later on. This was probably caused by a bug at some point but that bug may have already been fixed. Sorry...");
                container.activate((Object)tag.bucket, 1);
                tag.bucket.onFree();
                container.delete((Object)tag.bucket);
                container.delete((Object)tag);
                continue;
            }
            freeBlocksCache.setBit((int)tag.index, true);
        }
        System.out.println("Created free blocks cache: " + buckets + " used of " + counter);
        return freeBlocksCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initRangeDump(ObjectContainer container) {
        long size;
        try {
            size = this.channel.size();
        }
        catch (IOException e1) {
            Logger.error(this, "Unable to find size of temp blob storage file: " + e1, (Throwable)e1);
            return;
        }
        size -= size % this.blockSize;
        long blocks = size / this.blockSize;
        long ptr = blocks - 1L;
        long used = 0L;
        long rangeStart = Long.MIN_VALUE;
        PersistentBlobTempBucketTag firstInRange = null;
        for (long l = 0L; l < ptr; ++l) {
            PersistentBlobTempBucketTag tag;
            PersistentBlobTempBucketFactory persistentBlobTempBucketFactory = this;
            synchronized (persistentBlobTempBucketFactory) {
                if (this.freeSlots.containsKey(l)) {
                    continue;
                }
                if (this.notCommittedBlobs.containsKey(l)) {
                    continue;
                }
                if (this.almostFreeSlots.containsKey(l)) {
                    continue;
                }
            }
            Query query = container.query();
            query.constrain(PersistentBlobTempBucketTag.class);
            query.descend("index").constrain((Object)l);
            ObjectSet tags = query.execute();
            if (tags.hasNext()) {
                tag = (PersistentBlobTempBucketTag)tags.next();
                if (!tag.isFree) {
                    ++used;
                }
                if (tag.bucket == null && !tag.isFree) {
                    Logger.error(this, "No bucket but flagged as not free: index " + l + " " + tag.bucket);
                }
                if (tag.bucket != null && tag.isFree) {
                    Logger.error(this, "Has bucket but flagged as free: index " + l + " " + tag.bucket);
                }
                if (!tag.isFree) {
                    if (rangeStart != Long.MIN_VALUE) continue;
                    rangeStart = l;
                    firstInRange = tag;
                    continue;
                }
                if (rangeStart == Long.MIN_VALUE) continue;
                System.out.println("Range: " + rangeStart + " to " + (l - 1L) + " first is " + firstInRange);
                rangeStart = Long.MIN_VALUE;
                firstInRange = null;
                continue;
            }
            Logger.error(this, "FOUND EMPTY SLOT: " + l + " when scanning the blob file because tags in database < length of file");
            tag = new PersistentBlobTempBucketTag(this, l);
            container.store((Object)tag);
        }
        if (rangeStart != Long.MIN_VALUE) {
            System.out.println("Range: " + rangeStart + " to " + (ptr - 1L));
        }
        System.err.println("Persistent blobs: Blocks: " + blocks + " used " + used);
    }

    public String getName() {
        return this.storageFile.getPath();
    }

    private void initSlotFinder() {
        this.slotFinder = new DBJob(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean run(ObjectContainer container, ClientContext context) {
                PersistentBlobTempBucketFactory persistentBlobTempBucketFactory;
                Query query;
                boolean changedTags;
                long ptr;
                long blocks;
                boolean logMINOR = logMINOR;
                int added = 0;
                while (true) {
                    Object tag;
                    ObjectSet tags;
                    block75: {
                        PersistentBlobTempBucketFactory persistentBlobTempBucketFactory2 = PersistentBlobTempBucketFactory.this;
                        synchronized (persistentBlobTempBucketFactory2) {
                            if (PersistentBlobTempBucketFactory.this.freeSlots.size() > 2048) {
                                return false;
                            }
                        }
                        blocks = PersistentBlobTempBucketFactory.this.getSize();
                        if (blocks == Long.MAX_VALUE) {
                            return false;
                        }
                        ptr = blocks - 1L;
                        changedTags = false;
                        int first = -1;
                        block36: while (true) {
                            PersistentBlobTempBucketFactory persistentBlobTempBucketFactory3;
                            PersistentBlobTempBucketTag tag2;
                            if (logMINOR) {
                                Logger.minor(this, "Maybe found free slot from bitmap " + first);
                            }
                            PersistentBlobTempBucketFactory persistentBlobTempBucketFactory4 = PersistentBlobTempBucketFactory.this;
                            synchronized (persistentBlobTempBucketFactory4) {
                                first = PersistentBlobTempBucketFactory.this.freeBlocksCache.firstZero(first + 1);
                                if (first == -1) {
                                    break block75;
                                }
                                if ((long)first > ptr) {
                                    break block75;
                                }
                                if (PersistentBlobTempBucketFactory.this.freeSlots.containsKey(first)) {
                                    continue;
                                }
                                if (PersistentBlobTempBucketFactory.this.almostFreeSlots.containsKey(first)) {
                                    continue;
                                }
                                if (PersistentBlobTempBucketFactory.this.notCommittedBlobs.containsKey(first)) {
                                    continue;
                                }
                            }
                            query = container.query();
                            query.constrain(PersistentBlobTempBucketTag.class);
                            query.descend("index").constrain((Object)first);
                            tags = query.execute();
                            while (tags.hasNext()) {
                                tag2 = (PersistentBlobTempBucketTag)tags.next();
                                if (tag2.factory != PersistentBlobTempBucketFactory.this) continue;
                                if (!tag2.isFree) continue block36;
                                if (tag2.bucket != null) {
                                    Logger.error(this, "Index " + first + " has bucket despite free?!");
                                    container.activate((Object)tag2.bucket, 2);
                                    if (tag2.bucket.freed()) continue block36;
                                    Logger.error(this, "And the bucket is not free either!");
                                    continue block36;
                                }
                                persistentBlobTempBucketFactory3 = PersistentBlobTempBucketFactory.this;
                                synchronized (persistentBlobTempBucketFactory3) {
                                    PersistentBlobTempBucketFactory.this.freeSlots.put(Long.valueOf(first), tag2);
                                }
                                ++added;
                                changedTags = true;
                                if (logMINOR) {
                                    Logger.minor(this, "Found free slot from bitmap " + first);
                                }
                                if (added <= 2048) continue block36;
                                return true;
                            }
                            Logger.error(PersistentBlobTempBucketFactory.this, "No tag for index " + first);
                            tag2 = new PersistentBlobTempBucketTag(PersistentBlobTempBucketFactory.this, first);
                            container.store((Object)tag2);
                            persistentBlobTempBucketFactory3 = PersistentBlobTempBucketFactory.this;
                            synchronized (persistentBlobTempBucketFactory3) {
                                PersistentBlobTempBucketFactory.this.freeSlots.put(ptr, tag2);
                            }
                            Logger.normal(this, "Found free slot (missing) from bitmap " + first);
                            changedTags = true;
                            if (++added > 2048) break;
                        }
                        return true;
                    }
                    for (long l = 0L; l < PersistentBlobTempBucketFactory.this.blockSize + 16383L; l += 16384L) {
                        Query query2 = container.query();
                        query2.constrain(PersistentBlobTempBucketTag.class);
                        query2.descend("isFree").constrain((Object)true).and(query2.descend("index").constrain((Object)l).smaller());
                        ObjectSet tags2 = query2.execute();
                        PersistentBlobTempBucketFactory persistentBlobTempBucketFactory5 = PersistentBlobTempBucketFactory.this;
                        synchronized (persistentBlobTempBucketFactory5) {
                            while (tags2.hasNext()) {
                                tag = (PersistentBlobTempBucketTag)tags2.next();
                                if (!((PersistentBlobTempBucketTag)tag).isFree) {
                                    Logger.error(this, "Tag not free! " + ((PersistentBlobTempBucketTag)tag).index);
                                    if (((PersistentBlobTempBucketTag)tag).bucket != null) continue;
                                    Logger.error(this, "Tag flagged non-free yet has no bucket for index " + ((PersistentBlobTempBucketTag)tag).index);
                                    ((PersistentBlobTempBucketTag)tag).isFree = true;
                                    container.store(tag);
                                    changedTags = true;
                                }
                                if (((PersistentBlobTempBucketTag)tag).bucket != null) {
                                    Logger.error(this, "Query returned tag with valid bucket!");
                                    continue;
                                }
                                if (((PersistentBlobTempBucketTag)tag).factory != PersistentBlobTempBucketFactory.this || PersistentBlobTempBucketFactory.this.notCommittedBlobs.containsKey(((PersistentBlobTempBucketTag)tag).index) || PersistentBlobTempBucketFactory.this.almostFreeSlots.containsKey(((PersistentBlobTempBucketTag)tag).index) || PersistentBlobTempBucketFactory.this.freeSlots.containsKey(((PersistentBlobTempBucketTag)tag).index)) continue;
                                if (((PersistentBlobTempBucketTag)tag).bucket != null) {
                                    Logger.error(this, "Bucket is occupied but not in notCommittedBlobs?!: " + tag + " : " + ((PersistentBlobTempBucketTag)tag).bucket);
                                    continue;
                                }
                                if (((PersistentBlobTempBucketTag)tag).index > ptr) {
                                    if (logMINOR) {
                                        Logger.minor(this, "Not adding slot " + ((PersistentBlobTempBucketTag)tag).index + " to freeSlots because it is past the end of the file (but it is free)");
                                    }
                                    container.delete(tag);
                                    continue;
                                }
                                if (logMINOR) {
                                    Logger.minor(this, "Adding slot " + ((PersistentBlobTempBucketTag)tag).index + " to freeSlots (has a free tag and no taken tag)");
                                }
                                PersistentBlobTempBucketFactory.this.freeSlots.put(((PersistentBlobTempBucketTag)tag).index, tag);
                                if (++added <= 2048) continue;
                                return changedTags;
                            }
                            continue;
                        }
                    }
                    if (logMINOR) {
                        Logger.minor(this, "Checking number of tags against file size...");
                    }
                    query = container.query();
                    query.constrain(PersistentBlobTempBucketTag.class);
                    tags = query.execute();
                    long inDB = tags.size();
                    if (logMINOR) {
                        Logger.minor(this, "Checked size.");
                    }
                    tags = null;
                    if (inDB < ptr) {
                        Logger.error(this, "Tags in database: " + inDB + " but size of file allows: " + ptr);
                        for (long l = ptr - 1L; l >= 0L; --l) {
                            PersistentBlobTempBucketFactory persistentBlobTempBucketFactory6 = PersistentBlobTempBucketFactory.this;
                            synchronized (persistentBlobTempBucketFactory6) {
                                if (PersistentBlobTempBucketFactory.this.freeSlots.containsKey(l)) {
                                    continue;
                                }
                                if (PersistentBlobTempBucketFactory.this.notCommittedBlobs.containsKey(l)) {
                                    continue;
                                }
                                if (PersistentBlobTempBucketFactory.this.almostFreeSlots.containsKey(l)) {
                                    continue;
                                }
                            }
                            query = container.query();
                            query.constrain(PersistentBlobTempBucketTag.class);
                            query.descend("index").constrain((Object)l);
                            tags = query.execute();
                            if (tags.hasNext()) continue;
                            Logger.error(this, "FOUND EMPTY SLOT: " + l + " when scanning the blob file because tags in database < length of file");
                            PersistentBlobTempBucketTag tag3 = new PersistentBlobTempBucketTag(PersistentBlobTempBucketFactory.this, l);
                            container.store((Object)tag3);
                            persistentBlobTempBucketFactory = PersistentBlobTempBucketFactory.this;
                            synchronized (persistentBlobTempBucketFactory) {
                                PersistentBlobTempBucketFactory.this.freeSlots.put(ptr, tag3);
                            }
                            changedTags = true;
                            if (++added > 2048) {
                                return true;
                            }
                            if (l + (long)added == ptr) break;
                        }
                    }
                    DBJob freeJob = null;
                    tag = PersistentBlobTempBucketFactory.this;
                    synchronized (tag) {
                        if (!PersistentBlobTempBucketFactory.this.freeJobs.isEmpty()) {
                            freeJob = (DBJob)PersistentBlobTempBucketFactory.this.freeJobs.iterator().next();
                            PersistentBlobTempBucketFactory.this.freeJobs.remove(freeJob);
                        }
                    }
                    if (freeJob == null) break;
                    container.activate((Object)freeJob, 1);
                    System.err.println("Freeing some space by running " + freeJob);
                    if (logMINOR) {
                        Logger.minor(this, "Freeing some space by running " + freeJob);
                    }
                    freeJob.run(container, context);
                }
                long addBlocks = Math.min(8192L, blocks / 10L + 32L);
                if (blocks + addBlocks > Integer.MAX_VALUE && (addBlocks = blocks + addBlocks - Integer.MAX_VALUE) <= 0L) {
                    return changedTags;
                }
                persistentBlobTempBucketFactory = PersistentBlobTempBucketFactory.this;
                synchronized (persistentBlobTempBucketFactory) {
                    PersistentBlobTempBucketFactory.this.freeBlocksCache.setSize((int)Math.min(Integer.MAX_VALUE, blocks + addBlocks));
                }
                long extendBy = addBlocks * PersistentBlobTempBucketFactory.this.blockSize;
                byte[] buf = new byte[65536];
                ByteBuffer buffer = ByteBuffer.wrap(buf);
                for (long written = 0L; written < extendBy; written += (long)PersistentBlobTempBucketFactory.this.channel.write(buffer, blocks * PersistentBlobTempBucketFactory.this.blockSize + written)) {
                    PersistentBlobTempBucketFactory.this.weakRandomSource.nextBytes(buf);
                    int bytesLeft = (int)Math.min(extendBy - written, Integer.MAX_VALUE);
                    if (bytesLeft < buf.length) {
                        buffer.limit(bytesLeft);
                    }
                    try {
                        buffer.clear();
                        continue;
                    }
                    catch (IOException e) {
                        break;
                    }
                }
                PersistentBlobTempBucketFactory bytesLeft = PersistentBlobTempBucketFactory.this;
                synchronized (bytesLeft) {
                    PersistentBlobTempBucketFactory.this.cachedSize = blocks + addBlocks;
                }
                query = container.query();
                query.constrain(PersistentBlobTempBucketTag.class);
                query.descend("index").constrain((Object)(blocks - 1L)).greater().and(query.descend("factory").constrain((Object)PersistentBlobTempBucketFactory.this));
                HashSet<Long> taken = null;
                ObjectSet results = query.execute();
                while (results.hasNext()) {
                    PersistentBlobTempBucketTag tag = (PersistentBlobTempBucketTag)results.next();
                    if (!tag.isFree) {
                        Logger.error(this, "Block already exists beyond the end of the file (" + blocks + "), yet is occupied: block " + tag.index);
                    }
                    if (taken == null) {
                        taken = new HashSet<Long>();
                    }
                    taken.add(tag.index);
                }
                int i = 0;
                while ((long)i < addBlocks) {
                    ptr = blocks + (long)i;
                    if (taken == null || !taken.contains(ptr)) {
                        PersistentBlobTempBucketTag tag = new PersistentBlobTempBucketTag(PersistentBlobTempBucketFactory.this, ptr);
                        container.store((Object)tag);
                        changedTags = true;
                        PersistentBlobTempBucketFactory persistentBlobTempBucketFactory7 = PersistentBlobTempBucketFactory.this;
                        synchronized (persistentBlobTempBucketFactory7) {
                            if (logMINOR) {
                                Logger.minor(this, "Adding slot " + ptr + " to freeSlots while extending storage file");
                            }
                            PersistentBlobTempBucketFactory.this.freeSlots.put(ptr, tag);
                        }
                    }
                    ++i;
                }
                return changedTags;
            }

            public String toString() {
                return "PersistentBlobTempBucketFactory.SlotFinder";
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersistentBlobTempBucket makeBucket() throws DatabaseDisabledException {
        PersistentBlobTempBucketFactory persistentBlobTempBucketFactory = this;
        synchronized (persistentBlobTempBucketFactory) {
            if (!this.freeSlots.isEmpty()) {
                Long slot = this.freeSlots.firstKey();
                if (logMINOR) {
                    try {
                        if (slot * this.blockSize > this.channel.size()) {
                            Logger.error(this, "Free slot " + slot + " but file length is " + this.channel.size() + " = " + this.channel.size() / this.blockSize + " blocks");
                            this.freeSlots.remove(slot);
                            return null;
                        }
                    }
                    catch (IOException e) {
                        return null;
                    }
                }
                PersistentBlobTempBucketTag tag = this.freeSlots.remove(slot);
                if (this.notCommittedBlobs.get(slot) != null || this.almostFreeSlots.get(slot) != null) {
                    Logger.error(this, "Slot " + slot + " already occupied by a not committed blob despite being in freeSlots!!");
                    this.freeSlots.remove(slot);
                    return null;
                }
                PersistentBlobTempBucket bucket = new PersistentBlobTempBucket(this, this.blockSize, slot, tag, false);
                this.notCommittedBlobs.put(slot, bucket);
                if (logMINOR) {
                    Logger.minor(this, "Using slot " + slot + " for " + bucket);
                }
                return bucket;
            }
        }
        this.jobRunner.runBlocking(this.slotFinder, NativeThread.HIGH_PRIORITY);
        persistentBlobTempBucketFactory = this;
        synchronized (persistentBlobTempBucketFactory) {
            if (!this.freeSlots.isEmpty()) {
                Long slot = this.freeSlots.firstKey();
                if (logMINOR) {
                    try {
                        if (slot * this.blockSize > this.channel.size()) {
                            Logger.error(this, "Free slot " + slot + " but file length is " + this.channel.size() + " = " + this.channel.size() / this.blockSize + " blocks");
                            this.freeSlots.remove(slot);
                            return null;
                        }
                    }
                    catch (IOException e) {
                        return null;
                    }
                }
                PersistentBlobTempBucketTag tag = this.freeSlots.remove(slot);
                if (this.notCommittedBlobs.get(slot) != null || this.almostFreeSlots.get(slot) != null) {
                    Logger.error(this, "Slot " + slot + " already occupied by a not committed blob despite being in freeSlots!!");
                    this.freeSlots.remove(slot);
                    return null;
                }
                PersistentBlobTempBucket bucket = new PersistentBlobTempBucket(this, this.blockSize, slot, tag, false);
                this.notCommittedBlobs.put(slot, bucket);
                if (logMINOR) {
                    Logger.minor(this, "Using slot " + slot + " for " + bucket + " (after waiting)");
                }
                return bucket;
            }
        }
        Logger.error(this, "Returning null, unable to create a bucket for some reason, node will fallback to file-based buckets");
        return null;
    }

    public synchronized void freeBucket(long index, PersistentBlobTempBucket bucket) {
        PersistentBlobTempBucket shadow;
        if (logMINOR) {
            Logger.minor(this, "Freeing index " + index + " for " + bucket, (Throwable)new Exception("debug"));
        }
        this.notCommittedBlobs.remove(index);
        bucket.onFree();
        if (!bucket.persisted()) {
            if (bucket.getTag() == null) {
                Logger.error(this, "freeBucket but tag is null for " + bucket + " - not activated???", (Throwable)new Exception("error"));
            } else {
                this.freeSlots.put(index, bucket.getTag());
            }
        }
        if ((shadow = this.shadows.get(index)) != null) {
            shadow.freed();
        }
        this.freeBlocksCache.setBit((int)index, false);
    }

    public synchronized void remove(PersistentBlobTempBucket bucket, ObjectContainer container) {
        if (logMINOR) {
            Logger.minor(this, "Removing bucket " + bucket + " for slot " + bucket.getIndex() + " from database", (Throwable)new Exception("debug"));
        }
        long index = bucket.getIndex();
        PersistentBlobTempBucketTag tag = bucket.getTag();
        if (tag == null) {
            if (!container.ext().isActive((Object)bucket)) {
                Logger.error(this, "BUCKET NOT ACTIVE IN REMOVE: " + bucket, (Throwable)new Exception("error"));
                container.activate((Object)bucket, 1);
                tag = bucket.getTag();
                index = bucket.getIndex();
            } else {
                Logger.error(this, "NO TAG ON BUCKET REMOVING: " + bucket + " index " + index, (Throwable)new Exception("error"));
                Query query = container.query();
                query.constrain(PersistentBlobTempBucketTag.class);
                query.descend("index").constrain((Object)index);
                ObjectSet results = query.execute();
                if (!results.hasNext()) {
                    Logger.error(this, "TAG DOES NOT EXIST FOR INDEX " + index);
                } else {
                    tag = (PersistentBlobTempBucketTag)results.next();
                    if (tag.index != index) {
                        Logger.error(this, "INVALID INDEX: should be " + index + " but is " + tag.index);
                    }
                    if (tag.isFree) {
                        Logger.error(this, "FOUND TAG BUT IS FREE: " + tag);
                    }
                    if (tag.bucket == null) {
                        Logger.error(this, "FOUND TAG BUT NO BUCKET: " + tag);
                    } else if (tag.bucket == bucket) {
                        Logger.error(this, "TAG LINKS TO BUCKET BUT BUCKET DOESN'T LINK TO TAG");
                    } else {
                        Logger.error(this, "SERIOUS ERROR: TAG BELONGS TO A DIFFERENT BUCKET!!!");
                    }
                }
            }
        }
        if (tag != null) {
            container.activate((Object)tag, 1);
            if (!bucket.freed()) {
                Logger.error(this, "Removing bucket " + bucket + " for slot " + index + " but not freed!", (Throwable)new Exception("debug"));
                this.notCommittedBlobs.put(index, bucket);
            } else {
                this.almostFreeSlots.put(index, tag);
                this.notCommittedBlobs.remove(index);
            }
            tag.bucket = null;
            tag.isFree = true;
            container.store((Object)tag);
        } else {
            Logger.error(this, "Tag still null for " + bucket, (Throwable)new Exception("error"));
            if (!bucket.freed()) {
                Logger.error(this, "Removing bucket " + bucket + " for slot " + index + " but not freed!", (Throwable)new Exception("debug"));
                this.notCommittedBlobs.put(index, bucket);
            }
        }
        container.delete((Object)bucket);
        bucket.onRemove();
        this.maybeShrink(container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean maybeShrink(ObjectContainer container) {
        long newBlocks;
        final boolean logMINOR = PersistentBlobTempBucketFactory.logMINOR;
        if (logMINOR) {
            Logger.minor(this, "maybeShrink()");
        }
        long now = System.currentTimeMillis();
        PersistentBlobTempBucketFactory persistentBlobTempBucketFactory = this;
        synchronized (persistentBlobTempBucketFactory) {
            int blocksMoved = 0;
            if (now - this.lastCheckedEnd > TimeUnit.SECONDS.toMillis(60L) || DISABLE_SANITY_CHECKS_DEFRAG) {
                long lastBlock;
                long lastCommitted;
                long lastNotCommitted;
                long blocks;
                block68: {
                    double full;
                    long lastAlmostFreed;
                    if (logMINOR) {
                        Logger.minor(this, "maybeShrink() inner");
                    }
                    if ((blocks = this.getSize()) == Long.MAX_VALUE) {
                        Logger.error(this, "Not shrinking, unable to determine size");
                        return false;
                    }
                    if (blocks <= 32L && !DISABLE_SANITY_CHECKS_DEFRAG) {
                        if (logMINOR) {
                            Logger.minor(this, "Not shrinking, blob file not larger than a megabyte");
                        }
                        this.lastCheckedEnd = now;
                        this.queueMaybeShrink();
                        return false;
                    }
                    lastNotCommitted = this.notCommittedBlobs.isEmpty() ? 0L : this.notCommittedBlobs.lastKey();
                    long l = lastAlmostFreed = this.almostFreeSlots.isEmpty() ? 0L : this.almostFreeSlots.lastKey();
                    if (lastNotCommitted < lastAlmostFreed) {
                        if (logMINOR) {
                            Logger.minor(this, "Last almost freed: " + lastAlmostFreed + " replacing last not committed: " + lastNotCommitted);
                        }
                        lastNotCommitted = lastAlmostFreed;
                    }
                    if ((full = (double)lastNotCommitted / (double)blocks) > 0.8 && !DISABLE_SANITY_CHECKS_DEFRAG || lastNotCommitted == blocks) {
                        if (logMINOR) {
                            Logger.minor(this, "Not shrinking, last not committed block is at " + full * 100.0 + "% (" + lastNotCommitted + " of " + blocks + ")");
                        }
                        this.lastCheckedEnd = now;
                        this.queueMaybeShrink();
                        return false;
                    }
                    lastCommitted = -1L;
                    PersistentBlobTempBucketTag lastTag = null;
                    PersistentBlobTempBucket lastBucket = null;
                    ObjectSet tags = null;
                    Query query = null;
                    int MOVE_BLOCKS_PER_MINUTE = this.freeBlocksCache != null && blocks < Integer.MAX_VALUE ? 20 : 10;
                    while (true) {
                        boolean deactivateLastBucket;
                        int last = (int)blocks;
                        block28: while (true) {
                            PersistentBlobTempBucketFactory persistentBlobTempBucketFactory2 = this;
                            synchronized (persistentBlobTempBucketFactory2) {
                                last = this.freeBlocksCache.lastOne(last - 1);
                                if (last == -1) {
                                    break;
                                }
                                if (this.notCommittedBlobs.containsKey(last)) {
                                    continue;
                                }
                            }
                            query = container.query();
                            query.constrain(PersistentBlobTempBucketTag.class);
                            query.descend("index").constrain((Object)last);
                            tags = query.execute();
                            while (tags.hasNext()) {
                                lastTag = (PersistentBlobTempBucketTag)tags.next();
                                if (lastTag.factory != this) continue;
                                if (lastTag.isFree) continue block28;
                                if (lastTag.bucket == null) {
                                    Logger.error(this, "Last tag has no bucket! index " + last);
                                    lastTag.isFree = true;
                                    container.store((Object)lastTag);
                                    continue block28;
                                }
                                lastCommitted = last;
                                lastBucket = lastTag.bucket;
                                break block28;
                            }
                            Logger.error(this, "Last slot has no tag! index " + last);
                            PersistentBlobTempBucketTag tag = new PersistentBlobTempBucketTag(this, last);
                            container.store((Object)tag);
                            PersistentBlobTempBucketFactory persistentBlobTempBucketFactory3 = this;
                            synchronized (persistentBlobTempBucketFactory3) {
                                this.freeBlocksCache.setBit(last, false);
                            }
                        }
                        if (lastCommitted == -1L) {
                            Logger.normal(this, "No used slots in persistent temp file (but last not committed = " + lastNotCommitted + ")");
                            lastCommitted = 0L;
                            query = null;
                        }
                        if (!((full = (double)lastCommitted / (double)blocks) > 0.8) && !DISABLE_SANITY_CHECKS_DEFRAG) break block68;
                        if (full > 0.8) {
                            if (logMINOR) {
                                Logger.minor(this, "Not shrinking, last committed block is at " + full * 100.0 + "%");
                            }
                            this.lastCheckedEnd = now;
                            this.queueMaybeShrink();
                        }
                        boolean bl = deactivateLastBucket = !container.ext().isActive(lastBucket);
                        if (deactivateLastBucket) {
                            container.activate(lastBucket, 1);
                        }
                        if (this.freeSlots.isEmpty()) {
                            try {
                                this.jobRunner.queue(this.slotFinder, NativeThread.LOW_PRIORITY, false);
                            }
                            catch (DatabaseDisabledException e) {
                                // empty catch block
                            }
                            this.queueMaybeShrink();
                            return false;
                        }
                        Long lFirstSlot = this.freeSlots.firstKey();
                        long firstSlot = lFirstSlot;
                        if (firstSlot < lastCommitted) {
                            ++blocksMoved;
                            PersistentBlobTempBucketTag newTag = this.freeSlots.remove(lFirstSlot);
                            if (newTag == null) {
                                throw new NullPointerException();
                            }
                            PersistentBlobTempBucket shadow = this.shadows.remove(lastCommitted);
                            if (shadow != null) {
                                this.shadows.put(newTag.index, shadow);
                            }
                            PersistentBlobTempBucket persistentBlobTempBucket = lastBucket;
                            synchronized (persistentBlobTempBucket) {
                                if (shadow != null) {
                                    PersistentBlobTempBucket persistentBlobTempBucket2 = shadow;
                                    synchronized (persistentBlobTempBucket2) {
                                        if (!this.innerDefrag(lastBucket, shadow, lastTag, newTag, container)) {
                                            return false;
                                        }
                                    }
                                } else if (!this.innerDefrag(lastBucket, shadow, lastTag, newTag, container)) {
                                    return false;
                                }
                            }
                        } else {
                            if (!logMINOR) break;
                            Logger.minor(this, "First available slot " + firstSlot + " is after slot to move " + lastCommitted);
                            break;
                        }
                        if (deactivateLastBucket) {
                            container.deactivate((Object)lastBucket, 1);
                        }
                        if (blocksMoved >= MOVE_BLOCKS_PER_MINUTE) break;
                        lastTag = null;
                    }
                    if (blocksMoved > 0) {
                        try {
                            this.raf.getFD().sync();
                            Logger.normal(this, "Moved " + blocksMoved + " in defrag and synced to disk");
                        }
                        catch (SyncFailedException e) {
                            System.err.println("Failed to sync to disk after defragging: " + e);
                            e.printStackTrace();
                        }
                        catch (IOException e) {
                            System.err.println("Failed to sync to disk after defragging: " + e);
                            e.printStackTrace();
                        }
                        this.jobRunner.setCommitThisTransaction();
                    }
                    query = null;
                }
                newBlocks = lastBlock = Math.max(lastCommitted, lastNotCommitted);
                if (!DISABLE_SANITY_CHECKS_DEFRAG) {
                    newBlocks = (long)((double)(newBlocks + 32L) * 1.1);
                    newBlocks = Math.max(newBlocks, 32L);
                } else {
                    ++newBlocks;
                }
                if (newBlocks >= blocks) {
                    if (logMINOR) {
                        Logger.minor(this, "Not shrinking, would shrink from " + blocks + " to " + newBlocks);
                    }
                    this.lastCheckedEnd = now;
                    this.queueMaybeShrink();
                    return false;
                }
                Logger.normal(this, "Shrinking blob file from " + blocks + " to " + newBlocks);
                for (long l = newBlocks; l <= blocks; ++l) {
                    this.freeSlots.remove(l);
                }
                for (Long l : this.freeSlots.keySet()) {
                    if (l <= newBlocks) continue;
                    Logger.error(this, "Removing free slot " + l + " over the current block limit");
                }
            } else {
                return false;
            }
            this.freeSlots.tailMap(newBlocks + 1L).clear();
            this.lastCheckedEnd = now;
            this.queueMaybeShrink();
            this.cachedSize = newBlocks;
        }
        persistentBlobTempBucketFactory = this;
        synchronized (persistentBlobTempBucketFactory) {
            this.freeBlocksCache.setSize((int)Math.min(Integer.MAX_VALUE, newBlocks));
        }
        try {
            this.channel.truncate(newBlocks * this.blockSize);
        }
        catch (IOException e) {
            System.err.println("Shrinking blob file failed!");
            System.err.println(e);
            e.printStackTrace();
            Logger.error(this, "Shrinking blob file failed!: " + e, (Throwable)e);
        }
        Query query = container.query();
        query.constrain(PersistentBlobTempBucketTag.class);
        query.descend("index").constrain((Object)newBlocks).greater();
        ObjectSet tags = query.execute();
        long deleted = 0L;
        while (tags.hasNext()) {
            PersistentBlobTempBucketTag tag = (PersistentBlobTempBucketTag)tags.next();
            if (logMINOR) {
                Logger.minor(this, "Deleting tag " + tag + " for index " + tag.index);
            }
            container.delete((Object)tag);
            if (++deleted <= 1024L) continue;
            break;
        }
        if (deleted > 1024L) {
            try {
                this.jobRunner.queue(new DBJob(){

                    @Override
                    public boolean run(ObjectContainer container, ClientContext context) {
                        long size;
                        try {
                            size = PersistentBlobTempBucketFactory.this.channel.size();
                        }
                        catch (IOException e1) {
                            Logger.error(this, "Unable to find size of temp blob storage file: " + e1, (Throwable)e1);
                            return false;
                        }
                        size -= size % PersistentBlobTempBucketFactory.this.blockSize;
                        long blocks = size / PersistentBlobTempBucketFactory.this.blockSize;
                        Query query = container.query();
                        query.constrain(PersistentBlobTempBucketTag.class);
                        query.descend("index").constrain((Object)blocks).greater();
                        ObjectSet tags = query.execute();
                        long deleted = 0L;
                        while (tags.hasNext()) {
                            PersistentBlobTempBucketTag tag = (PersistentBlobTempBucketTag)tags.next();
                            if (tag.bucket != null) {
                                Logger.error(this, "Tag with bucket beyond end of file! index=" + tag.index + " bucket=" + tag.bucket);
                                continue;
                            }
                            if (logMINOR) {
                                Logger.minor(this, "Deleting tag " + tag + " for index " + tag.index);
                            }
                            container.delete((Object)tag);
                            if (++deleted <= 1024L) continue;
                            break;
                        }
                        if (deleted > 1024L) {
                            try {
                                PersistentBlobTempBucketFactory.this.jobRunner.queue(this, NativeThread.LOW_PRIORITY, true);
                            }
                            catch (DatabaseDisabledException e) {
                                // empty catch block
                            }
                        }
                        return true;
                    }

                    public String toString() {
                        return "PersistentBlobTempBucketFactory.PostShrinkCheck";
                    }
                }, NativeThread.LOW_PRIORITY, true);
            }
            catch (DatabaseDisabledException e) {
                // empty catch block
            }
        }
        this.queueMaybeShrink();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean innerDefrag(PersistentBlobTempBucket lastBucket, PersistentBlobTempBucket shadow, PersistentBlobTempBucketTag lastTag, PersistentBlobTempBucketTag newTag, ObjectContainer container) {
        Logger.minor(this, "Attempting to defragment: moving " + lastTag.index + " to " + newTag.index);
        try {
            byte[] blob = this.readSlot(lastTag.index);
            this.writeSlot(newTag.index, blob);
        }
        catch (IOException e) {
            System.err.println("Failed to move bucket in defrag: " + e);
            e.printStackTrace();
            Logger.error(this, "Failed to move bucket in defrag: " + e, (Throwable)e);
            this.queueMaybeShrink();
            return false;
        }
        lastBucket.setIndex(newTag.index);
        lastBucket.setTag(newTag);
        newTag.bucket = lastBucket;
        newTag.isFree = false;
        lastTag.bucket = null;
        lastTag.isFree = true;
        if (shadow != null) {
            shadow.setIndex(newTag.index);
        }
        container.store((Object)newTag);
        container.store((Object)lastTag);
        container.store((Object)lastBucket);
        PersistentBlobTempBucketFactory persistentBlobTempBucketFactory = this;
        synchronized (persistentBlobTempBucketFactory) {
            this.lastMovedFrom = Math.min(this.lastMovedFrom, lastTag.index);
            this.almostFreeSlots.put(lastTag.index, lastTag);
            this.freeBlocksCache.setBit((int)newTag.index, true);
            this.freeBlocksCache.setBit((int)lastTag.index, false);
        }
        return true;
    }

    private void queueMaybeShrink() {
        this.ticker.queueTimedJob(new Runnable(){

            @Override
            public void run() {
                try {
                    PersistentBlobTempBucketFactory.this.jobRunner.queue(new DBJob(){

                        @Override
                        public boolean run(ObjectContainer container, ClientContext context) {
                            return PersistentBlobTempBucketFactory.this.maybeShrink(container);
                        }

                        public String toString() {
                            return "PersistentBlobTempBucketFactory.MaybeShrink";
                        }
                    }, NativeThread.NORM_PRIORITY - 1, true);
                }
                catch (DatabaseDisabledException databaseDisabledException) {
                    // empty catch block
                }
            }
        }, TimeUnit.SECONDS.toMillis(61L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(PersistentBlobTempBucket bucket, ObjectContainer container) {
        if (logMINOR) {
            Logger.minor(this, "Storing bucket " + bucket + " for slot " + bucket.getIndex() + " to database");
        }
        long index = bucket.getIndex();
        PersistentBlobTempBucketTag tag = bucket.getTag();
        container.activate((Object)tag, 1);
        if (tag.bucket != null && tag.bucket != bucket) {
            Logger.error(this, "Slot " + index + " already occupied!: " + tag.bucket + " for " + tag.index);
            throw new IllegalStateException("Slot " + index + " already occupied!");
        }
        tag.bucket = bucket;
        tag.isFree = false;
        container.store((Object)tag);
        container.store((Object)bucket);
        PersistentBlobTempBucketFactory persistentBlobTempBucketFactory = this;
        synchronized (persistentBlobTempBucketFactory) {
            this.notCommittedBlobs.remove(index);
            this.freeBlocksCache.setBit((int)index, true);
        }
    }

    public synchronized void postCommit() {
        int freeNow = this.freeSlots.size();
        int sz = freeNow + this.almostFreeSlots.size();
        if (sz == 0) {
            return;
        }
        long blocks = this.getSize();
        Iterator<Map.Entry<Long, PersistentBlobTempBucketTag>> it = this.almostFreeSlots.entrySet().iterator();
        while (freeNow < 2048 && it.hasNext()) {
            Map.Entry<Long, PersistentBlobTempBucketTag> entry = it.next();
            Long slot = entry.getKey();
            if (slot >= blocks || slot >= this.lastMovedFrom) continue;
            if (entry.getValue() != null) {
                this.freeSlots.put(entry.getKey(), entry.getValue());
            }
            ++freeNow;
        }
        this.lastMovedFrom = Long.MAX_VALUE;
        this.almostFreeSlots.clear();
    }

    private synchronized long getSize() {
        long size;
        if (this.cachedSize != Long.MAX_VALUE && this.cachedSize != 0L) {
            return this.cachedSize;
        }
        try {
            size = this.channel.size();
        }
        catch (IOException e1) {
            Logger.error(this, "Unable to find size of temp blob storage file: " + e1, (Throwable)e1);
            return Long.MAX_VALUE;
        }
        size -= size % this.blockSize;
        this.cachedSize = size / this.blockSize;
        return this.cachedSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bucket createShadow(PersistentBlobTempBucket bucket) {
        long index = bucket.getIndex();
        Long i = index;
        PersistentBlobTempBucketFactory persistentBlobTempBucketFactory = this;
        synchronized (persistentBlobTempBucketFactory) {
            if (this.shadows.containsKey(i)) {
                return null;
            }
            PersistentBlobTempBucket shadow = new PersistentBlobTempBucket(this, this.blockSize, index, null, true);
            shadow.size = bucket.size;
            this.shadows.put(i, shadow);
            return shadow;
        }
    }

    public synchronized void freeShadow(long index, PersistentBlobTempBucket bucket) {
        PersistentBlobTempBucket temp = this.shadows.remove(index);
        if (temp != bucket) {
            Logger.error(this, "Freed wrong shadow: " + temp + " should be " + bucket);
            this.shadows.put(index, temp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBlobFreeCallback(DBJob job) {
        PersistentBlobTempBucketFactory persistentBlobTempBucketFactory = this;
        synchronized (persistentBlobTempBucketFactory) {
            this.freeJobs.add(job);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBlobFreeCallback(DBJob job) {
        PersistentBlobTempBucketFactory persistentBlobTempBucketFactory = this;
        synchronized (persistentBlobTempBucketFactory) {
            this.freeJobs.remove(job);
        }
    }

    private byte[] readSlot(long index) throws IOException {
        if (this.blockSize > Integer.MAX_VALUE) {
            throw new IOException("Block size over Integer.MAX_VALUE, unable to defragment!");
        }
        byte[] data = new byte[(int)this.blockSize];
        ByteBuffer buf = ByteBuffer.wrap(data);
        int offset = 0;
        while ((long)offset < this.blockSize) {
            int read = this.channel.read(buf, this.blockSize * index + (long)offset);
            if (read < 0) {
                throw new EOFException();
            }
            if (read <= 0) continue;
            offset += read;
        }
        return data;
    }

    private void writeSlot(long index, byte[] blob) throws IOException {
        ByteBuffer buf = ByteBuffer.wrap(blob);
        int written = 0;
        while ((long)written < this.blockSize) {
            int w = this.channel.write(buf, this.blockSize * index + (long)written);
            written += w;
        }
    }

    synchronized int lastOccupiedBlock() {
        return this.freeBlocksCache.lastOne(Integer.MAX_VALUE);
    }

    synchronized String occupiedBlocksString() {
        return this.freeBlocksCache.toString();
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
                logDEBUG = Logger.shouldLog(Logger.LogLevel.DEBUG, (Object)this);
            }
        });
        DISABLE_SANITY_CHECKS_DEFRAG = false;
    }
}

