/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import com.db4o.ObjectContainer;
import freenet.crypt.AEADCryptBucket;
import freenet.crypt.RandomSource;
import freenet.node.NodeStarter;
import freenet.support.Executor;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.SizeUtil;
import freenet.support.TimeUtil;
import freenet.support.api.Bucket;
import freenet.support.api.BucketFactory;
import freenet.support.io.ArrayBucket;
import freenet.support.io.BucketTools;
import freenet.support.io.Closer;
import freenet.support.io.FilenameGenerator;
import freenet.support.io.TempFileBucket;
import freenet.support.io.TrivialPaddedBucket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Queue;
import java.util.Random;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class TempBucketFactory
implements BucketFactory {
    public static final long defaultIncrement = 4096L;
    public static final float DEFAULT_FACTOR = 1.25f;
    private final FilenameGenerator filenameGenerator;
    private long bytesInUse = 0L;
    private final RandomSource strongPRNG;
    private final Random weakPRNG;
    private final Executor executor;
    private volatile boolean reallyEncrypt;
    private long maxRAMBucketSize;
    private long maxRamUsed;
    private static final long RAMBUCKET_MAX_AGE = TimeUnit.MINUTES.toMillis(5L);
    static final int RAMBUCKET_CONVERSION_FACTOR = 4;
    static final boolean TRACE_BUCKET_LEAKS = false;
    private static volatile boolean logMINOR;
    static final double MAX_USAGE_LOW = 0.8;
    static final double MAX_USAGE_HIGH = 0.9;
    boolean runningCleaner = false;
    private final Runnable cleaner = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            try {
                now = System.currentTimeMillis();
                TempBucketFactory.access$1300(TempBucketFactory.this, now, false);
                do {
                    var3_2 = TempBucketFactory.this;
                    synchronized (var3_2) {
                        block18: {
                            if (!((double)TempBucketFactory.access$800(TempBucketFactory.this) <= (double)TempBucketFactory.access$900(TempBucketFactory.this) * 0.8)) break block18;
                            return;
                        }
                        ** try [egrp 4[TRYBLOCK] [3 : 78->83)] { 
                        {
                        }
                    }
lbl16:
                    // 1 sources

                } while (TempBucketFactory.access$1300(TempBucketFactory.this, System.currentTimeMillis(), true));
                return;
            }
            finally {
                var4_3 = TempBucketFactory.this;
                synchronized (var4_3) {
                    TempBucketFactory.this.runningCleaner = false;
                }
            }
        }
    };
    private final Queue<WeakReference<TempBucket>> ramBucketQueue = new LinkedBlockingQueue<WeakReference<TempBucket>>();

    public TempBucketFactory(Executor executor, FilenameGenerator filenameGenerator, long maxBucketSizeKeptInRam, long maxRamUsed, RandomSource strongPRNG, Random weakPRNG, boolean reallyEncrypt) {
        this.filenameGenerator = filenameGenerator;
        this.maxRamUsed = maxRamUsed;
        this.maxRAMBucketSize = maxBucketSizeKeptInRam;
        this.strongPRNG = strongPRNG;
        this.weakPRNG = weakPRNG;
        this.reallyEncrypt = reallyEncrypt;
        this.executor = executor;
    }

    @Override
    public Bucket makeBucket(long size) throws IOException {
        return this.makeBucket(size, 1.25f, 4096L);
    }

    public Bucket makeBucket(long size, float factor) throws IOException {
        return this.makeBucket(size, factor, 4096L);
    }

    private synchronized void _hasTaken(long size) {
        this.bytesInUse += size;
    }

    private synchronized void _hasFreed(long size) {
        this.bytesInUse -= size;
    }

    public synchronized long getRamUsed() {
        return this.bytesInUse;
    }

    public synchronized void setMaxRamUsed(long size) {
        this.maxRamUsed = size;
    }

    public synchronized long getMaxRamUsed() {
        return this.maxRamUsed;
    }

    public synchronized void setMaxRAMBucketSize(long size) {
        this.maxRAMBucketSize = size;
    }

    public synchronized long getMaxRAMBucketSize() {
        return this.maxRAMBucketSize;
    }

    public void setEncryption(boolean value) {
        this.reallyEncrypt = value;
    }

    public boolean isEncrypting() {
        return this.reallyEncrypt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TempBucket makeBucket(long size, float factor, long increment) throws IOException {
        Bucket realBucket = null;
        boolean useRAMBucket = false;
        long now = System.currentTimeMillis();
        TempBucketFactory tempBucketFactory = this;
        synchronized (tempBucketFactory) {
            if (size > 0L && size <= this.maxRAMBucketSize && this.bytesInUse < this.maxRamUsed && this.bytesInUse + size <= this.maxRamUsed) {
                useRAMBucket = true;
            }
            if ((double)this.bytesInUse >= (double)this.maxRamUsed * 0.9 && !this.runningCleaner) {
                this.runningCleaner = true;
                this.executor.execute(this.cleaner);
            }
        }
        realBucket = useRAMBucket ? new ArrayBucket() : this._makeFileBucket();
        TempBucket toReturn = new TempBucket(now, realBucket);
        if (useRAMBucket) {
            Queue<WeakReference<TempBucket>> queue = this.ramBucketQueue;
            synchronized (queue) {
                this.ramBucketQueue.add(toReturn.getReference());
            }
        }
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean cleanBucketQueue(long now, boolean force) {
        boolean shouldContinue = true;
        LinkedList<TempBucket> toMigrate = null;
        if (logMINOR) {
            Logger.minor(this, "Starting cleanBucketQueue");
        }
        do {
            Queue<WeakReference<TempBucket>> queue = this.ramBucketQueue;
            synchronized (queue) {
                WeakReference<TempBucket> tmpBucketRef = this.ramBucketQueue.peek();
                if (tmpBucketRef == null) {
                    shouldContinue = false;
                } else {
                    TempBucket tmpBucket = (TempBucket)tmpBucketRef.get();
                    if (tmpBucket == null) {
                        this.ramBucketQueue.remove(tmpBucketRef);
                        continue;
                    }
                    if (tmpBucket.creationTime + RAMBUCKET_MAX_AGE > now && !force) {
                        shouldContinue = false;
                    } else {
                        if (logMINOR) {
                            Logger.minor(this, "The bucket " + tmpBucket + " is " + TimeUtil.formatTime(now - tmpBucket.creationTime) + " old: we will force-migrate it to disk.");
                        }
                        this.ramBucketQueue.remove(tmpBucketRef);
                        if (toMigrate == null) {
                            toMigrate = new LinkedList<TempBucket>();
                        }
                        toMigrate.add(tmpBucket);
                        force = false;
                    }
                }
            }
        } while (shouldContinue);
        if (toMigrate == null) {
            return false;
        }
        if (toMigrate.size() > 0) {
            if (logMINOR) {
                Logger.minor(this, "We are going to migrate " + toMigrate.size() + " RAMBuckets");
            }
            for (TempBucket tmpBucket : toMigrate) {
                try {
                    tmpBucket.migrateToFileBucket();
                }
                catch (IOException e) {
                    Logger.error(tmpBucket, "An IOE occured while migrating long-lived buckets:" + e.getMessage(), (Throwable)e);
                }
            }
            return true;
        }
        return false;
    }

    private Bucket _makeFileBucket() {
        Bucket fileBucket = new TempFileBucket(this.filenameGenerator.makeRandomFilename(), this.filenameGenerator, true);
        if (this.reallyEncrypt) {
            fileBucket = new TrivialPaddedBucket(fileBucket);
            byte[] key = new byte[16];
            SecureRandom srng = NodeStarter.getGlobalSecureRandom();
            srng.nextBytes(key);
            fileBucket = new AEADCryptBucket(fileBucket, key);
        }
        return fileBucket;
    }

    static /* synthetic */ boolean access$1300(TempBucketFactory x0, long x1, boolean x2) {
        return x0.cleanBucketQueue(x1, x2);
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }

    public class TempBucket
    implements Bucket {
        private Bucket currentBucket;
        private long currentSize;
        private boolean hasWritten;
        private OutputStream os = null;
        private final ArrayList<TempBucketInputStream> tbis;
        private short osIndex;
        public final long creationTime;
        private boolean hasBeenFreed = false;
        private final Throwable tracer;
        private WeakReference<TempBucket> weakRef = new WeakReference<TempBucket>(this);

        public TempBucket(long now, Bucket cur) {
            if (cur == null) {
                throw new NullPointerException();
            }
            this.tracer = null;
            this.currentBucket = cur;
            this.creationTime = now;
            this.osIndex = 0;
            this.tbis = new ArrayList(1);
            if (logMINOR) {
                Logger.minor(TempBucket.class, "Created " + this, (Throwable)new Exception("debug"));
            }
        }

        private synchronized void closeInputStreams(boolean forFree) {
            ListIterator<TempBucketInputStream> i = this.tbis.listIterator();
            while (i.hasNext()) {
                TempBucketInputStream is = i.next();
                if (forFree) {
                    i.remove();
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        Logger.error(this, "Caught " + e + " closing " + is);
                    }
                    continue;
                }
                try {
                    is._maybeResetInputStream();
                }
                catch (IOException e) {
                    i.remove();
                    Closer.close(is);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void migrateToFileBucket() throws IOException {
            long size;
            Bucket toMigrate = null;
            Object object = this;
            synchronized (object) {
                if (!this.isRAMBucket() || this.hasBeenFreed) {
                    return;
                }
                toMigrate = this.currentBucket;
                Bucket tempFB = TempBucketFactory.this._makeFileBucket();
                size = this.currentSize;
                if (this.os != null) {
                    this.os.flush();
                    this.os.close();
                    this.os = tempFB.getOutputStream();
                    if (size > 0L) {
                        BucketTools.copyTo(toMigrate, this.os, size);
                    }
                } else if (size > 0L) {
                    OutputStream temp = tempFB.getOutputStream();
                    try {
                        BucketTools.copyTo(toMigrate, temp, size);
                    }
                    finally {
                        temp.close();
                    }
                }
                if (toMigrate.isReadOnly()) {
                    tempFB.setReadOnly();
                }
                this.closeInputStreams(false);
                this.currentBucket = tempFB;
            }
            if (logMINOR) {
                Logger.minor(this, "We have migrated " + toMigrate.hashCode());
            }
            object = TempBucketFactory.this.ramBucketQueue;
            synchronized (object) {
                TempBucketFactory.this.ramBucketQueue.remove(this.getReference());
            }
            toMigrate.free();
            TempBucketFactory.this._hasFreed(size);
        }

        public final synchronized boolean isRAMBucket() {
            return this.currentBucket instanceof ArrayBucket;
        }

        @Override
        public synchronized OutputStream getOutputStream() throws IOException {
            if (this.osIndex > 0) {
                throw new IOException("Only one OutputStream per bucket on " + this + " !");
            }
            this.hasWritten = true;
            this.osIndex = (short)(this.osIndex + 1);
            TempBucketOutputStream tos = new TempBucketOutputStream(this.osIndex);
            if (logMINOR) {
                Logger.minor(this, "Got " + tos + " for " + this, (Throwable)new Exception());
            }
            return tos;
        }

        @Override
        public synchronized InputStream getInputStream() throws IOException {
            if (!this.hasWritten) {
                throw new IOException("No OutputStream has been openned! Why would you want an InputStream then?");
            }
            TempBucketInputStream is = new TempBucketInputStream(this.osIndex);
            this.tbis.add(is);
            if (logMINOR) {
                Logger.minor(this, "Got " + is + " for " + this, (Throwable)new Exception());
            }
            return is;
        }

        @Override
        public synchronized String getName() {
            return this.currentBucket.getName();
        }

        @Override
        public synchronized long size() {
            return this.currentSize;
        }

        @Override
        public synchronized boolean isReadOnly() {
            return this.currentBucket.isReadOnly();
        }

        @Override
        public synchronized void setReadOnly() {
            this.currentBucket.setReadOnly();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void free() {
            if (this.hasBeenFreed) {
                return;
            }
            this.hasBeenFreed = true;
            Closer.close(this.os);
            this.closeInputStreams(true);
            this.currentBucket.free();
            if (this.isRAMBucket()) {
                TempBucketFactory.this._hasFreed(this.currentSize);
                Queue queue = TempBucketFactory.this.ramBucketQueue;
                synchronized (queue) {
                    TempBucketFactory.this.ramBucketQueue.remove(this.getReference());
                }
            }
        }

        @Override
        public Bucket createShadow() {
            return this.currentBucket.createShadow();
        }

        @Override
        public void removeFrom(ObjectContainer container) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void storeTo(ObjectContainer container) {
            throw new UnsupportedOperationException();
        }

        public boolean objectCanNew(ObjectContainer container) {
            Logger.error(this, "Not storing TempBucket in database", (Throwable)new Exception("error"));
            throw new IllegalStateException();
        }

        public boolean objectCanUpdate(ObjectContainer container) {
            Logger.error(this, "Trying to store a TempBucket!", (Throwable)new Exception("error"));
            throw new IllegalStateException();
        }

        public boolean objectCanActivate(ObjectContainer container) {
            Logger.error(this, "Trying to store a TempBucket!", (Throwable)new Exception("error"));
            return false;
        }

        public boolean objectCanDeactivate(ObjectContainer container) {
            Logger.error(this, "Trying to store a TempBucket!", (Throwable)new Exception("error"));
            return false;
        }

        public WeakReference<TempBucket> getReference() {
            return this.weakRef;
        }

        protected void finalize() throws Throwable {
            if (!this.hasBeenFreed) {
                Logger.error(this, "TempBucket not freed, size=" + this.size() + ", isRAMBucket=" + this.isRAMBucket() + " : " + this);
                this.free();
            }
            super.finalize();
        }

        private class TempBucketInputStream
        extends InputStream {
            private InputStream currentIS;
            private long index = 0L;
            private final short idx;

            TempBucketInputStream(short idx) throws IOException {
                this.idx = idx;
                this.currentIS = TempBucket.this.currentBucket.getInputStream();
            }

            public void _maybeResetInputStream() throws IOException {
                if (this.idx != TempBucket.this.osIndex) {
                    this.close();
                } else {
                    Closer.close(this.currentIS);
                    this.currentIS = TempBucket.this.currentBucket.getInputStream();
                    for (long toSkip = this.index; toSkip > 0L; toSkip -= this.currentIS.skip(toSkip)) {
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public final int read() throws IOException {
                TempBucket tempBucket = TempBucket.this;
                synchronized (tempBucket) {
                    int toReturn = this.currentIS.read();
                    if (toReturn != -1) {
                        ++this.index;
                    }
                    return toReturn;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int read(byte[] b) throws IOException {
                TempBucket tempBucket = TempBucket.this;
                synchronized (tempBucket) {
                    return this.read(b, 0, b.length);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                TempBucket tempBucket = TempBucket.this;
                synchronized (tempBucket) {
                    int toReturn = this.currentIS.read(b, off, len);
                    if (toReturn > 0) {
                        this.index += (long)toReturn;
                    }
                    return toReturn;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long skip(long n) throws IOException {
                TempBucket tempBucket = TempBucket.this;
                synchronized (tempBucket) {
                    long skipped = this.currentIS.skip(n);
                    this.index += skipped;
                    return skipped;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int available() throws IOException {
                TempBucket tempBucket = TempBucket.this;
                synchronized (tempBucket) {
                    return this.currentIS.available();
                }
            }

            @Override
            public boolean markSupported() {
                return false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public final void close() throws IOException {
                TempBucket tempBucket = TempBucket.this;
                synchronized (tempBucket) {
                    Closer.close(this.currentIS);
                    TempBucket.this.tbis.remove(this);
                }
            }
        }

        private class TempBucketOutputStream
        extends OutputStream {
            boolean closed = false;

            TempBucketOutputStream(short idx) throws IOException {
                if (TempBucket.this.os == null) {
                    TempBucket.this.os = TempBucket.this.currentBucket.getOutputStream();
                }
            }

            private void _maybeMigrateRamBucket(long futureSize) throws IOException {
                if (this.closed) {
                    return;
                }
                if (TempBucket.this.isRAMBucket()) {
                    boolean shouldMigrate = false;
                    boolean isOversized = false;
                    if (futureSize >= Math.min(Integer.MAX_VALUE, TempBucketFactory.this.maxRAMBucketSize * 4L)) {
                        isOversized = true;
                        shouldMigrate = true;
                    } else if (futureSize - TempBucket.this.currentSize + TempBucketFactory.this.bytesInUse >= TempBucketFactory.this.maxRamUsed) {
                        shouldMigrate = true;
                    }
                    if (shouldMigrate) {
                        if (logMINOR) {
                            if (isOversized) {
                                Logger.minor(this, "The bucket " + TempBucket.this + " is over " + SizeUtil.formatSize(TempBucketFactory.this.maxRAMBucketSize * 4L) + ": we will force-migrate it to disk.");
                            } else {
                                Logger.minor(this, "The bucketpool is full: force-migrate before we go over the limit");
                            }
                        }
                        TempBucket.this.migrateToFileBucket();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public final void write(int b) throws IOException {
                TempBucket tempBucket = TempBucket.this;
                synchronized (tempBucket) {
                    long futureSize = TempBucket.this.currentSize + 1L;
                    this._maybeMigrateRamBucket(futureSize);
                    TempBucket.this.os.write(b);
                    TempBucket.this.currentSize = futureSize;
                    if (TempBucket.this.isRAMBucket()) {
                        TempBucketFactory.this._hasTaken(1L);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public final void write(byte[] b, int off, int len) throws IOException {
                TempBucket tempBucket = TempBucket.this;
                synchronized (tempBucket) {
                    long futureSize = TempBucket.this.currentSize + (long)len;
                    this._maybeMigrateRamBucket(futureSize);
                    TempBucket.this.os.write(b, off, len);
                    TempBucket.this.currentSize = futureSize;
                    if (TempBucket.this.isRAMBucket()) {
                        TempBucketFactory.this._hasTaken(len);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public final void flush() throws IOException {
                TempBucket tempBucket = TempBucket.this;
                synchronized (tempBucket) {
                    this._maybeMigrateRamBucket(TempBucket.this.currentSize);
                    if (!this.closed) {
                        TempBucket.this.os.flush();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public final void close() throws IOException {
                TempBucket tempBucket = TempBucket.this;
                synchronized (tempBucket) {
                    if (this.closed) {
                        return;
                    }
                    this._maybeMigrateRamBucket(TempBucket.this.currentSize);
                    TempBucket.this.os.flush();
                    TempBucket.this.os.close();
                    TempBucket.this.os = null;
                    this.closed = true;
                }
            }
        }
    }
}

