/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import freenet.client.InsertException;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientPutState;
import freenet.client.async.PersistenceDisabledException;
import freenet.client.async.PersistentJob;
import freenet.client.async.SingleFileInserter;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.api.BucketFactory;
import freenet.support.api.RandomAccessBucket;
import freenet.support.compress.CompressJob;
import freenet.support.io.NativeThread;

public class InsertCompressor
implements CompressJob {
    public final SingleFileInserter inserter;
    final RandomAccessBucket origData;
    public final int minSize;
    public final BucketFactory bucketFactory;
    public final boolean persistent;
    public final String compressorDescriptor;
    private transient boolean scheduled;
    private static volatile boolean logMINOR;
    private final long generateHashes;
    private final boolean pre1254;

    public InsertCompressor(SingleFileInserter inserter2, RandomAccessBucket origData2, int minSize2, BucketFactory bf, boolean persistent, long generateHashes, boolean pre1254) {
        this.inserter = inserter2;
        this.origData = origData2;
        this.minSize = minSize2;
        this.bucketFactory = bf;
        this.persistent = persistent;
        this.compressorDescriptor = this.inserter.ctx.compressorDescriptor;
        this.generateHashes = generateHashes;
        this.pre1254 = pre1254;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(ClientContext ctx) {
        InsertCompressor insertCompressor = this;
        synchronized (insertCompressor) {
            if (this.scheduled) {
                Logger.error(this, "Already scheduled compression, not rescheduling");
                return;
            }
            this.scheduled = true;
        }
        if (logMINOR) {
            Logger.minor(this, "Compressing " + this + " : origData.size=" + this.origData.size() + " for " + this.inserter + " origData=" + this.origData + " hashes=" + this.generateHashes);
        }
        ctx.rc.enqueueNewJob(this);
    }

    /*
     * Exception decompiling
     */
    @Override
    public void tryCompress(ClientContext context) throws InsertException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void fail(final InsertException ie, ClientContext context, Bucket bestCompressedData) {
        if (this.persistent) {
            try {
                context.jobRunner.queue(new PersistentJob(){

                    @Override
                    public boolean run(ClientContext context) {
                        InsertCompressor.this.inserter.cb.onFailure(ie, InsertCompressor.this.inserter, context);
                        return true;
                    }
                }, NativeThread.NORM_PRIORITY + 1);
            }
            catch (PersistenceDisabledException e1) {
                Logger.error(this, "Database disabled compressing data", (Throwable)new Exception("error"));
                if (bestCompressedData != null && bestCompressedData != this.origData) {
                    bestCompressedData.free();
                }
            }
        } else {
            this.inserter.cb.onFailure(ie, this.inserter, context);
        }
    }

    public static InsertCompressor start(ClientContext ctx, SingleFileInserter inserter, RandomAccessBucket origData, int minSize, BucketFactory bf, boolean persistent, long generateHashes, boolean pre1254) {
        InsertCompressor compressor = new InsertCompressor(inserter, origData, minSize, bf, persistent, generateHashes, pre1254);
        compressor.init(ctx);
        return compressor;
    }

    @Override
    public void onFailure(final InsertException e, ClientPutState c, ClientContext context) {
        if (this.persistent) {
            try {
                context.jobRunner.queue(new PersistentJob(){

                    @Override
                    public boolean run(ClientContext context) {
                        InsertCompressor.this.inserter.cb.onFailure(e, InsertCompressor.this.inserter, context);
                        return true;
                    }
                }, NativeThread.NORM_PRIORITY + 1);
            }
            catch (PersistenceDisabledException e1) {}
        } else {
            this.inserter.cb.onFailure(e, this.inserter, context);
        }
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

