/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import freenet.client.FetchException;
import freenet.client.Metadata;
import freenet.client.async.ClientContext;
import freenet.client.async.PersistenceDisabledException;
import freenet.client.async.PersistentJob;
import freenet.client.async.PersistentJobRunner;
import freenet.client.async.SplitFileFetcherCrossSegmentStorage;
import freenet.client.async.SplitFileFetcherSegmentBlockChooser;
import freenet.client.async.SplitFileFetcherStorage;
import freenet.client.async.SplitFileSegmentKeys;
import freenet.crypt.ChecksumFailedException;
import freenet.keys.CHKBlock;
import freenet.keys.CHKDecodeException;
import freenet.keys.CHKEncodeException;
import freenet.keys.CHKVerifyException;
import freenet.keys.ClientCHK;
import freenet.keys.ClientCHKBlock;
import freenet.keys.Key;
import freenet.keys.NodeCHK;
import freenet.node.KeysFetchingLocally;
import freenet.support.Logger;
import freenet.support.MemoryLimitedChunk;
import freenet.support.MemoryLimitedJob;
import freenet.support.api.LockableRandomAccessBuffer;
import freenet.support.io.NativeThread;
import freenet.support.io.StorageFormatException;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class SplitFileFetcherSegmentStorage {
    private static final boolean FORCE_CHECK_FEC_KEYS = true;
    final int segNo;
    final long segmentBlockDataOffset;
    final long segmentCrossCheckBlockDataOffset;
    final long segmentStatusOffset;
    final int segmentStatusPaddedLength;
    final long segmentKeyListOffset;
    final int segmentKeyListLength;
    final SplitFileFetcherStorage parent;
    public final int dataBlocks;
    public final int crossSegmentCheckBlocks;
    public final int checkBlocks;
    private final SplitFileFetcherSegmentBlockChooser blockChooser;
    private final int[] blocksFetched;
    private boolean succeeded;
    private boolean finished;
    private boolean failed;
    private boolean failedRetries;
    private boolean metadataDirty;
    private boolean corruptMetadata;
    private final SplitFileFetcherCrossSegmentStorage[] crossSegmentsByBlock;
    private SoftReference<SplitFileSegmentKeys> keysCache;
    private boolean tryDecode;
    private int crossDataBlocksAllocated;
    private int crossCheckBlocksAllocated;
    private int failedBlocks;
    private static volatile boolean logMINOR;

    public SplitFileFetcherSegmentStorage(SplitFileFetcherStorage parent, int segNumber, Metadata.SplitfileAlgorithm splitfileType, int dataBlocks, int checkBlocks, int crossCheckBlocks, long segmentDataOffset, long segmentCrossCheckDataOffset, long segmentKeysOffset, long segmentStatusOffset, boolean writeRetries, SplitFileSegmentKeys keys, KeysFetchingLocally keysFetching) {
        this.parent = parent;
        this.segNo = segNumber;
        this.dataBlocks = dataBlocks;
        this.checkBlocks = checkBlocks;
        this.crossSegmentCheckBlocks = crossCheckBlocks;
        int total = dataBlocks + checkBlocks + this.crossSegmentCheckBlocks;
        boolean ignoreLastBlock = this.segNo == parent.segments.length - 1 && parent.lastBlockMightNotBePadded();
        this.blockChooser = new SplitFileFetcherSegmentBlockChooser(total, parent.random, parent.maxRetries, parent.cooldownTries, parent.cooldownLength, this, keysFetching, ignoreLastBlock ? dataBlocks - 1 : -1);
        int minFetched = this.blocksForDecode();
        this.crossSegmentsByBlock = crossCheckBlocks != 0 ? new SplitFileFetcherCrossSegmentStorage[minFetched] : null;
        this.blocksFetched = new int[minFetched];
        for (int i = 0; i < this.blocksFetched.length; ++i) {
            this.blocksFetched[i] = -1;
        }
        this.segmentStatusPaddedLength = SplitFileFetcherSegmentStorage.paddedStoredSegmentStatusLength(dataBlocks, checkBlocks, crossCheckBlocks, writeRetries, parent.checksumLength, parent.persistent);
        this.segmentKeyListLength = SplitFileFetcherSegmentStorage.storedKeysLength(this.blocksForDecode(), checkBlocks, parent.splitfileSingleCryptoKey != null, parent.checksumLength);
        this.segmentBlockDataOffset = segmentDataOffset;
        if (segmentCrossCheckDataOffset == -1L) {
            segmentCrossCheckDataOffset = this.segmentBlockDataOffset + (long)(dataBlocks * 32768);
        }
        this.segmentCrossCheckBlockDataOffset = segmentCrossCheckDataOffset;
        this.segmentKeyListOffset = segmentKeysOffset;
        this.segmentStatusOffset = segmentStatusOffset;
        this.keysCache = new SoftReference<SplitFileSegmentKeys>(keys);
    }

    public SplitFileFetcherSegmentStorage(SplitFileFetcherStorage parent, DataInputStream dis, int segNo, boolean writeRetries, long segmentDataOffset, long segmentCrossCheckDataOffset, long segmentKeysOffset, long segmentStatusOffset, KeysFetchingLocally keysFetching) throws IOException, StorageFormatException {
        this.segNo = segNo;
        this.parent = parent;
        this.dataBlocks = dis.readInt();
        if (this.dataBlocks < 1 || this.dataBlocks > 256) {
            throw new StorageFormatException("Bad data block count");
        }
        this.crossSegmentCheckBlocks = dis.readInt();
        if (this.crossSegmentCheckBlocks < 0 || this.crossSegmentCheckBlocks > 256) {
            throw new StorageFormatException("Bad cross-segment check block count");
        }
        this.checkBlocks = dis.readInt();
        if (this.checkBlocks < 0 || this.checkBlocks > 256) {
            throw new StorageFormatException("Bad check block count");
        }
        int total = this.dataBlocks + this.checkBlocks + this.crossSegmentCheckBlocks;
        if (total > 256) {
            throw new StorageFormatException("Too many blocks in segment");
        }
        boolean ignoreLastBlock = segNo == parent.segments.length - 1 && parent.lastBlockMightNotBePadded();
        this.blockChooser = new SplitFileFetcherSegmentBlockChooser(total, parent.random, parent.maxRetries, parent.cooldownTries, parent.cooldownLength, this, keysFetching, ignoreLastBlock ? this.dataBlocks - 1 : -1);
        int minFetched = this.blocksForDecode();
        this.crossSegmentsByBlock = this.crossSegmentCheckBlocks != 0 ? new SplitFileFetcherCrossSegmentStorage[minFetched] : null;
        this.blocksFetched = new int[minFetched];
        for (int i = 0; i < this.blocksFetched.length; ++i) {
            this.blocksFetched[i] = -1;
        }
        this.segmentStatusPaddedLength = SplitFileFetcherSegmentStorage.paddedStoredSegmentStatusLength(this.dataBlocks, this.checkBlocks, this.crossSegmentCheckBlocks, writeRetries, parent.checksumLength, true);
        this.segmentKeyListLength = SplitFileFetcherSegmentStorage.storedKeysLength(this.blocksForDecode(), this.checkBlocks, parent.splitfileSingleCryptoKey != null, parent.checksumLength);
        this.keysCache = null;
        this.segmentBlockDataOffset = segmentDataOffset;
        if (segmentCrossCheckDataOffset == -1L) {
            segmentCrossCheckDataOffset = this.segmentBlockDataOffset + (long)(this.dataBlocks * 32768);
        }
        this.segmentCrossCheckBlockDataOffset = segmentCrossCheckDataOffset;
        this.segmentKeyListOffset = segmentKeysOffset;
        this.segmentStatusOffset = segmentStatusOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SplitFileSegmentKeys getSegmentKeys() throws IOException {
        SplitFileFetcherSegmentStorage splitFileFetcherSegmentStorage = this;
        synchronized (splitFileFetcherSegmentStorage) {
            SplitFileSegmentKeys keys;
            SplitFileSegmentKeys cached;
            if (this.keysCache != null && (cached = this.keysCache.get()) != null) {
                return cached;
            }
            try {
                keys = this.readSegmentKeys();
            }
            catch (ChecksumFailedException e) {
                Logger.error(this, "Keys corrupted on " + this + " !");
                throw new IOException(e);
            }
            if (keys == null) {
                return keys;
            }
            this.keysCache = new SoftReference<SplitFileSegmentKeys>(keys);
            return keys;
        }
    }

    SplitFileSegmentKeys readSegmentKeys() throws IOException, ChecksumFailedException {
        SplitFileSegmentKeys keys = new SplitFileSegmentKeys(this.blocksForDecode(), this.checkBlocks, this.parent.splitfileSingleCryptoKey, this.parent.splitfileSingleCryptoAlgorithm);
        byte[] buf = new byte[SplitFileSegmentKeys.storedKeysLength(this.blocksForDecode(), this.checkBlocks, this.parent.splitfileSingleCryptoKey != null)];
        this.parent.preadChecksummed(this.segmentKeyListOffset, buf, 0, buf.length);
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(buf));
        keys.readKeys(dis, false);
        keys.readKeys(dis, true);
        return keys;
    }

    public void writeMetadata() throws IOException {
        this.writeMetadata(true);
    }

    public void writeMetadata(boolean force) throws IOException {
        this.innerWriteMetadata(force);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryStartDecode() {
        SplitFileFetcherSegmentStorage splitFileFetcherSegmentStorage = this;
        synchronized (splitFileFetcherSegmentStorage) {
            if (this.succeeded || this.failed || this.finished) {
                return false;
            }
            if (!this.corruptMetadata && this.blockChooser.successCount() < this.blocksForDecode()) {
                return false;
            }
            if (this.tryDecode) {
                return true;
            }
            this.tryDecode = true;
        }
        long limit = (long)(this.totalBlocks() * 32768) + Math.max(this.parent.fecCodec.maxMemoryOverheadDecode(this.blocksForDecode(), this.checkBlocks), this.parent.fecCodec.maxMemoryOverheadEncode(this.blocksForDecode(), this.checkBlocks));
        final int prio = NativeThread.LOW_PRIORITY;
        this.parent.memoryLimitedJobRunner.queueJob(new MemoryLimitedJob(limit){

            @Override
            public int getPriority() {
                return prio;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean start(MemoryLimitedChunk chunk) {
                boolean shutdown = false;
                PersistentJobRunner.CheckpointLock lock = null;
                try {
                    lock = SplitFileFetcherSegmentStorage.this.parent.jobRunner.lock();
                    SplitFileFetcherSegmentStorage.this.innerDecode(chunk);
                }
                catch (IOException e) {
                    Logger.error(this, "Failed to decode " + this + " because of disk error: " + e, (Throwable)e);
                    SplitFileFetcherSegmentStorage.this.parent.failOnDiskError(e);
                }
                catch (PersistenceDisabledException e) {
                    shutdown = true;
                }
                catch (Throwable e) {
                    Logger.error(this, "Failed to decode " + this + " because of internal error: " + e, e);
                    SplitFileFetcherSegmentStorage.this.parent.fail(new FetchException(FetchException.FetchExceptionMode.INTERNAL_ERROR, e));
                }
                finally {
                    chunk.release();
                    SplitFileFetcherSegmentStorage e = SplitFileFetcherSegmentStorage.this;
                    synchronized (e) {
                        SplitFileFetcherSegmentStorage.this.tryDecode = false;
                    }
                    try {
                        if (!shutdown) {
                            SplitFileFetcherSegmentStorage.this.parent.finishedEncoding(SplitFileFetcherSegmentStorage.this);
                        }
                    }
                    finally {
                        if (lock != null) {
                            lock.unlock(false, prio);
                        }
                    }
                }
                return true;
            }
        });
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerDecode(MemoryLimitedChunk chunk) throws IOException {
        SplitFileFetcherSegmentStorage splitFileFetcherSegmentStorage;
        int i;
        Object used;
        boolean fail;
        if (logMINOR) {
            Logger.minor(this, "Trying to decode " + this + " for " + this.parent);
        }
        SplitFileFetcherSegmentStorage splitFileFetcherSegmentStorage2 = this;
        synchronized (splitFileFetcherSegmentStorage2) {
            if (this.finished) {
                return;
            }
            boolean bl = fail = this.succeeded || this.failed;
            if (fail) {
                this.finished = true;
            }
        }
        if (fail) {
            return;
        }
        int totalBlocks = this.totalBlocks();
        byte[][] allBlocks = this.readAllBlocks();
        SplitFileSegmentKeys keys = this.getSegmentKeys();
        if (allBlocks == null || keys == null) {
            return;
        }
        class MyBlock {
            final byte[] buf;
            final int blockNumber;
            final int slot;

            MyBlock(byte[] buf, int blockNumber, int slot) {
                this.buf = buf;
                this.blockNumber = blockNumber;
                this.slot = slot;
            }
        }
        ArrayList<MyBlock> maybeBlocks = new ArrayList<MyBlock>();
        int fetchedCount = 0;
        SplitFileFetcherSegmentStorage splitFileFetcherSegmentStorage3 = this;
        synchronized (splitFileFetcherSegmentStorage3) {
            used = new boolean[totalBlocks];
            for (int i2 = 0; i2 < this.blocksFetched.length; i2 = (int)((short)(i2 + 1))) {
                if (this.blocksFetched[i2] < 0 || this.blocksFetched[i2] > totalBlocks) {
                    Logger.warning(this, "Inconsistency decoding splitfile: slot " + i2 + " has bogus block number " + this.blocksFetched[i2]);
                    if (this.blocksFetched[i2] != -1) {
                        this.blocksFetched[i2] = -1;
                    }
                    maybeBlocks.add(new MyBlock(allBlocks[i2], -1, i2));
                    continue;
                }
                if (used[this.blocksFetched[i2]]) {
                    Logger.warning(this, "Inconsistency decoding splitfile: slot " + i2 + " has duplicate block number " + this.blocksFetched[i2]);
                    this.blocksFetched[i2] = -1;
                    continue;
                }
                if (logMINOR) {
                    Logger.minor(this, "Found block " + this.blocksFetched[i2] + " in slot " + i2);
                }
                maybeBlocks.add(new MyBlock(allBlocks[i2], this.blocksFetched[i2], i2));
                used[this.blocksFetched[i2]] = true;
                ++fetchedCount;
            }
            if (fetchedCount < this.blocksForDecode()) {
                int oldBlocksFetchedCount = this.blockChooser.successCount();
                this.blockChooser.replaceSuccesses((boolean[])used);
                if (this.blockChooser.successCount() != oldBlocksFetchedCount) {
                    Logger.warning(this, "Corrected block count to " + this.blockChooser.successCount() + " from " + oldBlocksFetchedCount);
                }
            }
        }
        if (fetchedCount < this.blocksForDecode()) {
            this.writeMetadata();
            SplitFileFetcherSegmentStorage splitFileFetcherSegmentStorage4 = this;
            used = splitFileFetcherSegmentStorage4;
            synchronized (splitFileFetcherSegmentStorage4) {
                boolean wasCorrupt = this.corruptMetadata;
                this.corruptMetadata = false;
                // ** MonitorExit[used /* !! */ ] (shouldn't be in output)
                this.parent.restartedAfterDataCorruption(wasCorrupt);
                return;
            }
        }
        int validBlocks = 0;
        int validDataBlocks = 0;
        Object dataBlocks = new byte[this.blocksForDecode()][];
        Object checkBlocks = new byte[this.checkBlocks][];
        for (MyBlock myBlock : maybeBlocks) {
            byte[] buf;
            int blockNumber;
            boolean failed;
            block56: {
                failed = false;
                blockNumber = myBlock.blockNumber;
                buf = myBlock.buf;
                ClientCHK decodeKey = blockNumber == -1 ? null : keys.getKey(blockNumber, null, false);
                try {
                    SplitFileFetcherSegmentStorage splitFileFetcherSegmentStorage5;
                    ClientCHKBlock block = ClientCHKBlock.encodeSplitfileBlock(buf, decodeKey.getCryptoKey(), decodeKey.getCryptoAlgorithm());
                    ClientCHK actualKey = block.getClientKey();
                    if (decodeKey != null && decodeKey.equals(actualKey)) break block56;
                    blockNumber = (short)keys.getBlockNumber(actualKey, null);
                    if (blockNumber == -1) {
                        Logger.error(this, "Block which should be block #" + myBlock.blockNumber + " in slot " + myBlock.slot + " for segment " + this + " is not valid for key " + decodeKey);
                        failed = true;
                        splitFileFetcherSegmentStorage5 = this;
                        synchronized (splitFileFetcherSegmentStorage5) {
                            this.blockChooser.onUnSuccess(blockNumber);
                            if (this.blocksFetched[myBlock.slot] == myBlock.blockNumber) {
                                this.blocksFetched[myBlock.slot] = -1;
                            }
                            break block56;
                        }
                    }
                    splitFileFetcherSegmentStorage5 = this;
                    synchronized (splitFileFetcherSegmentStorage5) {
                        this.blockChooser.onUnSuccess(blockNumber);
                        this.blocksFetched[myBlock.slot] = blockNumber;
                        this.blockChooser.onSuccess(blockNumber);
                    }
                }
                catch (CHKEncodeException e) {
                    Logger.error(this, "Block which should be " + blockNumber + " for segment " + this + " cannot be encoded for key " + decodeKey);
                    failed = true;
                }
            }
            if (failed) continue;
            ++validBlocks;
            if (blockNumber < this.blocksForDecode()) {
                ++validDataBlocks;
            }
            if (blockNumber < ((byte[][])dataBlocks).length) {
                dataBlocks[blockNumber] = buf;
                continue;
            }
            checkBlocks[blockNumber - ((byte[][])dataBlocks).length] = buf;
        }
        allBlocks = null;
        maybeBlocks.clear();
        maybeBlocks = null;
        if (validBlocks < this.blocksForDecode()) {
            boolean wasCorrupt;
            this.writeMetadata();
            SplitFileFetcherSegmentStorage splitFileFetcherSegmentStorage6 = this;
            synchronized (splitFileFetcherSegmentStorage6) {
                wasCorrupt = this.corruptMetadata;
                this.corruptMetadata = false;
            }
            this.parent.restartedAfterDataCorruption(wasCorrupt);
            return;
        }
        boolean[] dataBlocksPresent = new boolean[((byte[][])dataBlocks).length];
        boolean[] blArray = new boolean[((byte[][])checkBlocks).length];
        for (i = 0; i < ((byte[][])dataBlocks).length; ++i) {
            if (dataBlocks[i] == null) {
                dataBlocks[i] = new byte[32768];
                continue;
            }
            dataBlocksPresent[i] = true;
        }
        for (i = 0; i < ((byte[][])checkBlocks).length; ++i) {
            if (checkBlocks[i] == null) {
                checkBlocks[i] = new byte[32768];
                continue;
            }
            blArray[i] = true;
        }
        if (validDataBlocks < this.blocksForDecode()) {
            if (logMINOR) {
                Logger.minor(this, "Decoding in memory for " + this);
            }
            this.parent.fecCodec.decode((byte[][])dataBlocks, (byte[][])checkBlocks, dataBlocksPresent, blArray, 32768);
        }
        boolean capturingBinaryBlob = this.parent.fetcher.wantBinaryBlob();
        boolean checkDecodedKeys = true;
        if (checkDecodedKeys) {
            this.checkDecodedDataBlocks((byte[][])dataBlocks, dataBlocksPresent, keys, capturingBinaryBlob);
        }
        this.writeAllDataBlocks((byte[][])dataBlocks);
        if (!checkDecodedKeys) {
            this.parent.finishedSuccess(this);
        }
        this.triggerAllCrossSegmentCallbacks();
        this.parent.fecCodec.encode((byte[][])dataBlocks, (byte[][])checkBlocks, blArray, 32768);
        if (checkDecodedKeys) {
            if (!this.checkEncodedDataBlocks((byte[][])checkBlocks, blArray, keys, capturingBinaryBlob)) {
                splitFileFetcherSegmentStorage = this;
                synchronized (splitFileFetcherSegmentStorage) {
                    this.finished = true;
                }
                this.parent.fail(new FetchException(FetchException.FetchExceptionMode.SPLITFILE_DECODE_ERROR, "Encoded blocks do not match metadata"));
                return;
            }
            this.parent.finishedSuccess(this);
        }
        this.queueHeal((byte[][])dataBlocks, (byte[][])checkBlocks, dataBlocksPresent, blArray);
        dataBlocks = null;
        checkBlocks = null;
        this.writeMetadata();
        splitFileFetcherSegmentStorage = this;
        synchronized (splitFileFetcherSegmentStorage) {
            this.corruptMetadata = false;
            this.finished = true;
        }
        if (logMINOR) {
            Logger.minor(this, "Finished decoding " + this + " for " + this.parent);
        }
    }

    private void checkDecodedDataBlocks(byte[][] dataBlocks, boolean[] dataBlocksPresent, SplitFileSegmentKeys keys, boolean capturingBinaryBlob) {
        for (int i = 0; i < dataBlocks.length; ++i) {
            if (dataBlocksPresent[i]) continue;
            ClientCHK decodeKey = keys.getKey(i, null, false);
            try {
                ClientCHKBlock block = ClientCHKBlock.encodeSplitfileBlock(dataBlocks[i], decodeKey.getCryptoKey(), decodeKey.getCryptoAlgorithm());
                ClientCHK actualKey = block.getClientKey();
                if (!actualKey.equals(decodeKey)) {
                    if (i == dataBlocks.length - 1 && this.segNo == this.parent.segments.length - 1 && this.parent.lastBlockMightNotBePadded()) {
                        return;
                    }
                    this.parent.fail(new FetchException(FetchException.FetchExceptionMode.SPLITFILE_DECODE_ERROR, "Decoded block does not match expected key"));
                    return;
                }
                if (!capturingBinaryBlob) continue;
                this.parent.fetcher.maybeAddToBinaryBlob(block);
                continue;
            }
            catch (CHKEncodeException e) {
                this.parent.fail(new FetchException(FetchException.FetchExceptionMode.INTERNAL_ERROR, "Decoded block could not be encoded"));
                Logger.error(this, "Impossible: Decoded block could not be encoded");
                return;
            }
        }
    }

    private boolean checkEncodedDataBlocks(byte[][] checkBlocks, boolean[] checkBlocksPresent, SplitFileSegmentKeys keys, boolean capturingBinaryBlob) {
        for (int i = 0; i < checkBlocks.length; ++i) {
            if (checkBlocksPresent[i]) continue;
            ClientCHK decodeKey = keys.getKey(i + this.blocksForDecode(), null, false);
            try {
                ClientCHKBlock block = ClientCHKBlock.encodeSplitfileBlock(checkBlocks[i], decodeKey.getCryptoKey(), decodeKey.getCryptoAlgorithm());
                ClientCHK actualKey = block.getClientKey();
                if (!actualKey.equals(decodeKey)) {
                    Logger.error(this, "Splitfile check block " + i + " does not encode to expected key for " + this + " for " + this.parent);
                    return false;
                }
                if (!capturingBinaryBlob) continue;
                this.parent.fetcher.maybeAddToBinaryBlob(block);
                continue;
            }
            catch (CHKEncodeException e) {
                this.parent.fail(new FetchException(FetchException.FetchExceptionMode.INTERNAL_ERROR, "Decoded block could not be encoded"));
                Logger.error(this, "Impossible: Decoded block could not be encoded");
                return false;
            }
        }
        return true;
    }

    private void queueHeal(byte[][] dataBlocks, byte[][] checkBlocks, boolean[] dataBlocksPresent, boolean[] checkBlocksPresent) throws IOException {
        int i;
        for (i = 0; i < dataBlocks.length; ++i) {
            if (dataBlocksPresent[i] || this.blockChooser.getRetries(i) == 0) continue;
            this.queueHeal(i, dataBlocks[i]);
        }
        for (i = 0; i < checkBlocks.length; ++i) {
            if (checkBlocksPresent[i] || this.blockChooser.getRetries(i + dataBlocks.length) == 0) continue;
            this.queueHeal(i + dataBlocks.length, checkBlocks[i]);
        }
    }

    private void queueHeal(int blockNumber, byte[] data) throws IOException {
        byte cryptoAlgorithm;
        byte[] cryptoKey;
        if (this.parent.splitfileSingleCryptoKey != null) {
            cryptoKey = this.parent.splitfileSingleCryptoKey;
            cryptoAlgorithm = this.parent.splitfileSingleCryptoAlgorithm;
        } else {
            ClientCHK key = this.getSegmentKeys().getKey(blockNumber, null, false);
            cryptoKey = key.getCryptoKey();
            cryptoAlgorithm = key.getCryptoAlgorithm();
        }
        this.parent.fetcher.queueHeal(data, cryptoKey, cryptoAlgorithm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized byte[][] readAllBlocks() throws IOException {
        LockableRandomAccessBuffer.RAFLock lock = this.parent.lockRAFOpen();
        try {
            byte[][] ret = new byte[this.blocksForDecode()][];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = this.readBlock(i);
            }
            byte[][] byArrayArray = ret;
            return byArrayArray;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void triggerAllCrossSegmentCallbacks() {
        SplitFileFetcherCrossSegmentStorage[] crossSegmentsByBlockCopy;
        SplitFileFetcherSegmentStorage splitFileFetcherSegmentStorage = this;
        synchronized (splitFileFetcherSegmentStorage) {
            if (this.crossSegmentsByBlock == null) {
                return;
            }
            crossSegmentsByBlockCopy = Arrays.copyOf(this.crossSegmentsByBlock, this.crossSegmentsByBlock.length);
        }
        for (int i = 0; i < crossSegmentsByBlockCopy.length; ++i) {
            SplitFileFetcherCrossSegmentStorage s = crossSegmentsByBlockCopy[i];
            if (s == null) continue;
            s.onFetchedRelevantBlock(this, i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeAllDataBlocks(byte[][] dataBlocks) throws IOException {
        LockableRandomAccessBuffer.RAFLock lock = this.parent.lockRAFOpen();
        try {
            SplitFileFetcherSegmentStorage splitFileFetcherSegmentStorage = this;
            synchronized (splitFileFetcherSegmentStorage) {
                assert (dataBlocks.length == this.blocksForDecode());
                for (int i = 0; i < dataBlocks.length; ++i) {
                    this.writeDownloadedBlock(i, dataBlocks[i]);
                    this.blockChooser.onSuccess(i);
                    this.blocksFetched[i] = (short)i;
                }
                this.succeeded = true;
            }
        }
        finally {
            lock.unlock();
        }
    }

    final int totalBlocks() {
        return this.dataBlocks + this.crossSegmentCheckBlocks + this.checkBlocks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onGotKey(NodeCHK key, CHKBlock block) throws IOException {
        byte[] decodedData;
        ClientCHKBlock decodedBlock;
        ClientCHK decodeKey;
        int blockNumber;
        SplitFileSegmentKeys keys = this.getSegmentKeys();
        if (keys == null) {
            return false;
        }
        SplitFileFetcherSegmentStorage splitFileFetcherSegmentStorage = this;
        synchronized (splitFileFetcherSegmentStorage) {
            if (this.succeeded || this.failed || this.finished) {
                return false;
            }
            blockNumber = this.blockChooser.getBlockNumber(keys, key);
            if (blockNumber == -1) {
                if (logMINOR) {
                    Logger.minor(this, "Block not found " + key);
                }
                return false;
            }
            if (this.blockChooser.hasSucceeded(blockNumber)) {
                return false;
            }
            if (this.tryDecode) {
                return false;
            }
            decodeKey = keys.getKey(blockNumber, null, false);
        }
        try {
            decodedBlock = new ClientCHKBlock(block, decodeKey);
            decodedData = decodedBlock.memoryDecode();
        }
        catch (CHKVerifyException e) {
            Logger.error(this, "Verify failed on block for " + decodeKey);
            return false;
        }
        catch (CHKDecodeException e) {
            Logger.error(this, "Decode failed on block for " + decodeKey);
            return false;
        }
        return this.innerOnGotKey(key, decodedBlock, keys, blockNumber, decodedData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean innerOnGotKey(NodeCHK key, ClientCHKBlock block, SplitFileSegmentKeys keys, int blockNumber, byte[] decodedData) throws IOException {
        if (decodedData.length != 32768) {
            if (blockNumber == this.dataBlocks - 1 && this.segNo == this.parent.segments.length - 1 && this.parent.lastBlockMightNotBePadded()) {
                Logger.warning(this, "Ignoring last block");
                return false;
            }
            this.parent.fail(new FetchException(FetchException.FetchExceptionMode.SPLITFILE_ERROR, "Splitfile block is too short"));
            return false;
        }
        SplitFileFetcherCrossSegmentStorage callback = null;
        boolean saved = false;
        do {
            short nextBlockNumber;
            int slotNumber;
            SplitFileFetcherSegmentStorage splitFileFetcherSegmentStorage = this;
            synchronized (splitFileFetcherSegmentStorage) {
                if (this.succeeded || this.failed || this.finished) {
                    if (logMINOR) {
                        Logger.minor(this, "Already succeeded/finished/failed");
                    }
                    return saved;
                }
                if (this.blockChooser.hasSucceeded(blockNumber)) {
                    if (logMINOR) {
                        Logger.minor(this, "Already have block " + blockNumber);
                    }
                    blockNumber = this.blockChooser.getBlockNumber(keys, key);
                    if (logMINOR) {
                        Logger.minor(this, "Trying block " + blockNumber);
                    }
                    continue;
                }
                if (this.blockChooser.successCount() >= this.blocksForDecode()) {
                    if (logMINOR) {
                        Logger.minor(this, "Already decoding");
                    }
                    return saved;
                }
                slotNumber = this.findFreeSlot();
                assert (slotNumber != -1);
                this.blocksFetched[slotNumber] = blockNumber;
                this.blockChooser.onSuccess(blockNumber);
                LockableRandomAccessBuffer.RAFLock lock = this.parent.lockRAFOpen();
                try {
                    this.writeDownloadedBlock(slotNumber, decodedData);
                    saved = true;
                }
                catch (IOException e) {
                    this.blocksFetched[slotNumber] = -1;
                    this.blockChooser.onUnSuccess(blockNumber);
                    Logger.error(this, "Unable to write downloaded block to disk: " + e, (Throwable)e);
                    throw e;
                }
                finally {
                    lock.unlock();
                }
                if (this.crossSegmentsByBlock != null && blockNumber < this.crossSegmentsByBlock.length) {
                    callback = this.crossSegmentsByBlock[blockNumber];
                }
                nextBlockNumber = (short)this.blockChooser.getBlockNumber(keys, key);
                this.metadataDirty = true;
            }
            if (callback != null) {
                callback.onFetchedRelevantBlock(this, blockNumber);
            }
            this.lazyWriteMetadata();
            if (logMINOR) {
                Logger.minor(this, "Got block " + blockNumber + " (" + key + ") for " + this + " for " + this.parent + " written to " + slotNumber);
            }
            this.parent.jobRunner.queueNormalOrDrop(new PersistentJob(){

                @Override
                public boolean run(ClientContext context) {
                    SplitFileFetcherSegmentStorage.this.parent.fetcher.onFetchedBlock();
                    return false;
                }
            });
            this.tryStartDecode();
            this.parent.fetcher.maybeAddToBinaryBlob(block);
            blockNumber = nextBlockNumber;
        } while (blockNumber != -1);
        return saved;
    }

    private synchronized int findFreeSlot() {
        for (int i = 0; i < this.blocksFetched.length; ++i) {
            if (this.blocksFetched[i] != -1) continue;
            return i;
        }
        return -1;
    }

    private synchronized void writeDownloadedBlock(int slotNumber, byte[] data) throws IOException {
        if (data.length != 32768) {
            throw new IllegalArgumentException();
        }
        if (slotNumber >= this.blocksForDecode()) {
            throw new IllegalArgumentException();
        }
        this.parent.writeBlock(this, slotNumber, data);
    }

    long blockOffset(int slotNumber) {
        if (slotNumber < this.dataBlocks) {
            return this.segmentBlockDataOffset + (long)(slotNumber * 32768);
        }
        if (slotNumber >= this.dataBlocks + this.crossSegmentCheckBlocks) {
            return this.segmentBlockDataOffset + (long)((slotNumber -= this.crossSegmentCheckBlocks) * 32768);
        }
        return this.segmentCrossCheckBlockDataOffset + (long)((slotNumber -= this.dataBlocks) * 32768);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerWriteMetadata(boolean force) throws IOException {
        if (!this.parent.persistent) {
            return;
        }
        SplitFileFetcherSegmentStorage splitFileFetcherSegmentStorage = this;
        synchronized (splitFileFetcherSegmentStorage) {
            if (!force && !this.metadataDirty) {
                return;
            }
            if (logMINOR) {
                Logger.debug(this, "Writing metadata for " + this.segNo + " for " + this.parent, (Throwable)new Exception("debug"));
            }
            OutputStream cos = this.parent.writeChecksummedTo(this.segmentStatusOffset, this.segmentStatusPaddedLength);
            try {
                DataOutputStream dos = new DataOutputStream(cos);
                for (int s : this.blocksFetched) {
                    dos.writeInt(s);
                }
                this.blockChooser.writeRetries(dos);
                dos.close();
            }
            catch (IOException e) {
                throw new Error(e);
            }
            this.metadataDirty = false;
        }
    }

    void readMetadata() throws IOException, StorageFormatException, ChecksumFailedException {
        byte[] buf = new byte[this.segmentStatusPaddedLength];
        try {
            this.parent.preadChecksummed(this.segmentStatusOffset, buf, 0, this.segmentStatusPaddedLength - this.parent.checksumLength);
        }
        catch (ChecksumFailedException e) {
            this.corruptMetadata = true;
            throw e;
        }
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(buf));
        for (int i = 0; i < this.blocksFetched.length; ++i) {
            int s = dis.readInt();
            if (s < -1 || s >= this.totalBlocks()) {
                throw new StorageFormatException("Bogus block number in blocksFetched[" + i + "]: " + s);
            }
            this.blocksFetched[i] = s;
            if (s < 0) continue;
            if (!this.blockChooser.hasSucceeded(s)) {
                this.blockChooser.onSuccess(s);
                continue;
            }
            throw new StorageFormatException("Duplicated block number in blocksFetched in " + this);
        }
        this.blockChooser.readRetries(dis);
        this.failedBlocks = this.blockChooser.countFailedBlocks();
        if (this.failedBlocks >= this.checkBlocks) {
            this.failedRetries = true;
        }
        dis.close();
    }

    public static int storedSegmentStatusLength(int dataBlocks, int checkBlocks, int crossCheckBlocks, boolean trackRetries) {
        int fetchedBlocks = dataBlocks + crossCheckBlocks;
        int totalBlocks = dataBlocks + checkBlocks + crossCheckBlocks;
        return fetchedBlocks * 4 + (trackRetries ? totalBlocks * 4 : 0);
    }

    public static int paddedStoredSegmentStatusLength(int dataBlocks, int checkBlocks, int crossCheckBlocks, boolean trackRetries, int checksumLength, boolean persistent) {
        if (!persistent) {
            return 0;
        }
        return SplitFileFetcherSegmentStorage.storedSegmentStatusLength(dataBlocks, checkBlocks, crossCheckBlocks, trackRetries) + checksumLength;
    }

    private final int blocksForDecode() {
        return this.dataBlocks + this.crossSegmentCheckBlocks;
    }

    public synchronized boolean isFinished() {
        return this.finished || this.failed || this.failedRetries;
    }

    public synchronized boolean isDecodingOrFinished() {
        return this.finished || this.failed || this.succeeded || this.tryDecode;
    }

    public synchronized boolean hasSucceeded() {
        return this.succeeded;
    }

    void writeToInner(OutputStream os) throws IOException {
        for (int i = 0; i < this.dataBlocks; ++i) {
            byte[] buf = this.readBlock(i);
            if (i == this.dataBlocks - 1 && this.segNo == this.parent.segments.length - 1) {
                int length = (int)(this.parent.finalLength % 32768L);
                if (length == 0) {
                    length = 32768;
                }
                os.write(buf, 0, length);
                continue;
            }
            os.write(buf);
        }
    }

    private synchronized byte[] readBlock(int slotNumber) throws IOException {
        if (slotNumber >= this.blocksForDecode()) {
            throw new IllegalArgumentException();
        }
        return this.parent.readBlock(this, slotNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNonFatalFailure(int blockNumber) {
        boolean givenUp = false;
        boolean kill = false;
        boolean wake = false;
        boolean write = false;
        if (logMINOR) {
            Logger.minor(this, "Non-fatal failure on block " + blockNumber + " for " + this + " for " + this.parent);
        }
        SplitFileFetcherSegmentStorage splitFileFetcherSegmentStorage = this;
        synchronized (splitFileFetcherSegmentStorage) {
            long cooldown = this.blockChooser.overallCooldownTime();
            if (this.blockChooser.onNonFatalFailure(blockNumber)) {
                if (logMINOR) {
                    Logger.minor(this, "Giving up on block " + blockNumber + " on " + this);
                }
                givenUp = true;
                ++this.failedBlocks;
                int target = this.checkBlocks;
                if (!this.parent.lastBlockMightNotBePadded()) {
                    ++target;
                }
                if (this.failedBlocks >= target) {
                    kill = true;
                    this.failedRetries = true;
                    if (this.crossSegmentsByBlock == null) {
                        this.finished = true;
                        this.failed = true;
                    }
                } else {
                    write = true;
                }
            } else {
                if (logMINOR) {
                    Logger.minor(this, "Block " + blockNumber + " on " + this + " : " + this.blockChooser.getRetries(blockNumber) + "/" + this.blockChooser.maxRetries);
                }
                if (this.blockChooser.overallCooldownTime() < cooldown) {
                    wake = true;
                }
                write = true;
            }
            if (write) {
                this.metadataDirty = true;
            }
        }
        if (write) {
            this.lazyWriteMetadata();
        }
        if (givenUp) {
            this.parent.failedBlock();
        }
        if (kill) {
            if (this.crossSegmentsByBlock == null) {
                this.parent.failOnSegment(this);
            } else {
                this.parent.finishedEncoding(this);
            }
        }
        if (wake) {
            this.parent.maybeClearCooldown();
        }
    }

    private void lazyWriteMetadata() {
        this.parent.lazyWriteMetadata();
    }

    public int allocateCrossDataBlock(SplitFileFetcherCrossSegmentStorage seg, Random random) {
        int i;
        int size = this.dataBlocks;
        if (this.crossDataBlocksAllocated == size) {
            return -1;
        }
        int x = 0;
        for (i = 0; i < 10; ++i) {
            x = random.nextInt(size);
            if (this.crossSegmentsByBlock[x] != null) continue;
            this.crossSegmentsByBlock[x] = seg;
            ++this.crossDataBlocksAllocated;
            return x;
        }
        for (i = 0; i < size; ++i) {
            if (++x == size) {
                x = 0;
            }
            if (this.crossSegmentsByBlock[x] != null) continue;
            this.crossSegmentsByBlock[x] = seg;
            ++this.crossDataBlocksAllocated;
            return x;
        }
        throw new IllegalStateException("Unable to allocate cross data block even though have not used all slots up???");
    }

    public int allocateCrossCheckBlock(SplitFileFetcherCrossSegmentStorage seg, Random random) {
        if (this.crossCheckBlocksAllocated == this.crossSegmentCheckBlocks) {
            return -1;
        }
        int x = this.dataBlocks + this.crossSegmentCheckBlocks - (1 + random.nextInt(this.crossSegmentCheckBlocks));
        for (int i = 0; i < this.crossSegmentCheckBlocks; ++i) {
            if (++x == this.dataBlocks + this.crossSegmentCheckBlocks) {
                x = this.dataBlocks;
            }
            if (this.crossSegmentsByBlock[x] != null) continue;
            this.crossSegmentsByBlock[x] = seg;
            ++this.crossCheckBlocksAllocated;
            return x;
        }
        throw new IllegalStateException("Unable to allocate cross check block even though have not used all slots up???");
    }

    static int storedKeysLength(int dataBlocks, int checkBlocks, boolean commonDecryptKey, int checksumLength) {
        return SplitFileSegmentKeys.storedKeysLength(dataBlocks, checkBlocks, commonDecryptKey) + checksumLength;
    }

    void writeKeysWithChecksum(SplitFileSegmentKeys keys) throws IOException {
        assert (this.keysCache.get() == keys);
        assert (this.dataBlocks + this.crossSegmentCheckBlocks == keys.dataBlocks);
        assert (this.checkBlocks == keys.checkBlocks);
        OutputStream cos = this.parent.writeChecksummedTo(this.segmentKeyListOffset, this.segmentKeyListLength);
        DataOutputStream dos = new DataOutputStream(cos);
        try {
            keys.writeKeys(dos, false);
            keys.writeKeys(dos, true);
        }
        catch (IOException e) {
            throw new Error(e);
        }
        dos.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean definitelyWantKey(NodeCHK key) {
        SplitFileSegmentKeys keys;
        SplitFileFetcherSegmentStorage splitFileFetcherSegmentStorage = this;
        synchronized (splitFileFetcherSegmentStorage) {
            if (this.succeeded || this.failed || this.finished) {
                return false;
            }
        }
        try {
            keys = this.getSegmentKeys();
        }
        catch (IOException e) {
            this.parent.failOnDiskError(e);
            return false;
        }
        SplitFileFetcherSegmentStorage splitFileFetcherSegmentStorage2 = this;
        synchronized (splitFileFetcherSegmentStorage2) {
            return this.blockChooser.getBlockNumber(keys, key) >= 0;
        }
    }

    public void writeFixedMetadata(DataOutputStream dos) throws IOException {
        dos.writeInt(this.dataBlocks);
        dos.writeInt(this.crossSegmentCheckBlocks);
        dos.writeInt(this.checkBlocks);
    }

    synchronized boolean hasStartedDecode() {
        return this.succeeded || this.failed || this.finished || this.tryDecode;
    }

    synchronized boolean hasFailed() {
        return this.failed || this.failedRetries;
    }

    synchronized boolean[] copyDownloadedBlocks() {
        return this.blockChooser.copyDownloadedBlocks();
    }

    public synchronized long countUnfetchedKeys() {
        if (this.finished || this.tryDecode) {
            return 0L;
        }
        return this.totalBlocks() - this.blockChooser.successCount();
    }

    public synchronized long countSendableKeys(long now, int maxRetries) {
        if (this.finished || this.tryDecode) {
            return 0L;
        }
        return this.blockChooser.countFetchable();
    }

    public synchronized void getUnfetchedKeys(List<Key> keys) throws IOException {
        if (this.finished || this.tryDecode) {
            return;
        }
        SplitFileSegmentKeys keyList = this.getSegmentKeys();
        for (int i = 0; i < this.totalBlocks(); ++i) {
            if (this.blockChooser.hasSucceeded(i)) continue;
            keys.add(keyList.getNodeKey(i, null, false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int chooseRandomKey() {
        int chosen;
        SplitFileFetcherSegmentStorage splitFileFetcherSegmentStorage = this;
        synchronized (splitFileFetcherSegmentStorage) {
            if (this.finished) {
                return -1;
            }
            if (this.failedRetries) {
                return -1;
            }
            if (this.tryDecode) {
                if (logMINOR) {
                    Logger.minor(this, "Segment decoding so not choosing a key on " + this);
                }
                return -1;
            }
            if (this.corruptMetadata) {
                return -1;
            }
            chosen = this.blockChooser.chooseKey();
            if (chosen != -1) {
                if (logMINOR) {
                    Logger.minor(this, "Chosen key " + chosen + "/" + this.totalBlocks() + " for " + this + " (retries " + this.blockChooser.getRetries(chosen) + "/" + this.blockChooser.maxRetries + ")");
                }
            } else if (logMINOR) {
                Logger.minor(this, "No keys chosen for " + this);
            }
        }
        if (chosen == -1) {
            long cooldownTime = this.blockChooser.overallCooldownTime();
            if (cooldownTime > System.currentTimeMillis()) {
                this.parent.increaseCooldown(this, cooldownTime);
            }
            return -1;
        }
        return chosen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        boolean decoding;
        SplitFileFetcherSegmentStorage splitFileFetcherSegmentStorage = this;
        synchronized (splitFileFetcherSegmentStorage) {
            if (this.finished) {
                return;
            }
            this.finished = true;
            decoding = this.tryDecode;
        }
        if (!decoding) {
            this.parent.finishedEncoding(this);
        }
    }

    public synchronized long getOverallCooldownTime() {
        if (this.finished || this.succeeded || this.failed || this.failedRetries) {
            return 0L;
        }
        return this.blockChooser.overallCooldownTime();
    }

    synchronized long getCooldownTime(int blockNumber) {
        if (this.finished || this.succeeded || this.failed || this.failedRetries) {
            return 0L;
        }
        return this.blockChooser.getCooldownTime(blockNumber);
    }

    synchronized boolean corruptMetadata() {
        return this.corruptMetadata;
    }

    public synchronized boolean needsDecode() {
        if (this.finished || this.succeeded || this.failed) {
            return false;
        }
        if (this.tryDecode) {
            return false;
        }
        return this.blockChooser.successCount() == this.blocksForDecode();
    }

    public synchronized int foundBlocks() {
        return this.blockChooser.successCount();
    }

    public synchronized int failedBlocks() {
        return this.failedBlocks;
    }

    public synchronized ClientCHK getKey(int blockNum) {
        SplitFileSegmentKeys keys;
        try {
            keys = this.getSegmentKeys();
        }
        catch (IOException e) {
            return null;
        }
        if (keys == null) {
            return null;
        }
        return keys.getKey(blockNum, null, false);
    }

    public synchronized byte[] checkAndGetBlockData(int blockNum) throws IOException {
        if (!this.blockChooser.hasSucceeded(blockNum)) {
            return null;
        }
        ClientCHK key = this.getKey(blockNum);
        if (key == null) {
            return null;
        }
        for (int i = 0; i < this.blocksFetched.length; ++i) {
            if (this.blocksFetched[i] != blockNum) continue;
            byte[] buf = this.readBlock(i);
            try {
                ClientCHKBlock block = ClientCHKBlock.encodeSplitfileBlock(buf, key.getCryptoKey(), key.getCryptoAlgorithm());
                if (block.getClientKey().equals(key)) {
                    return buf;
                }
                Logger.error(this, "Block " + blockNum + " in blocksFound[" + i + "] is not valid!");
                this.blockChooser.onUnSuccess(blockNum);
                this.succeeded = false;
                this.finished = false;
                continue;
            }
            catch (CHKEncodeException e) {
                Logger.error(this, "Impossible: " + e);
                return null;
            }
        }
        Logger.error(this, "Block " + blockNum + " in blocksFound but not in blocksFetched on " + this);
        return null;
    }

    synchronized void resumeCallback(int blockNo, SplitFileFetcherCrossSegmentStorage crossSegment) {
        this.crossSegmentsByBlock[blockNo] = crossSegment;
    }

    public synchronized boolean hasBlock(int blockNo) {
        return this.blockChooser.hasSucceeded(blockNo);
    }

    public synchronized boolean isDecoding() {
        return this.tryDecode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFinishedCheckingDatastoreNoFetch(ClientContext context) {
        SplitFileFetcherSegmentStorage splitFileFetcherSegmentStorage = this;
        synchronized (splitFileFetcherSegmentStorage) {
            if (this.tryDecode) {
                return;
            }
            if (this.succeeded) {
                return;
            }
            if (this.finished) {
                return;
            }
            if (this.failed) {
                return;
            }
            this.failed = true;
            this.finished = true;
        }
        this.parent.finishedEncoding(this);
    }

    static {
        Logger.registerClass(SplitFileFetcherSegmentStorage.class);
    }
}

