/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.crypt.DHGroup;
import freenet.crypt.DiffieHellmanLightContext;
import freenet.crypt.Global;
import freenet.support.Logger;
import freenet.support.io.NativeThread;
import java.math.BigInteger;
import java.util.Random;
import java.util.Stack;
import net.i2p.util.NativeBigInteger;

public class DiffieHellman {
    private static final int PRECALC_RESUME = 20;
    private static final int PRECALC_MAX = 40;
    private static final int PRECALC_TIMEOUT = 193000;
    private static Random r;
    private static DHGroup group;
    private static Stack<NativeBigInteger[]> precalcBuffer;
    private static Object precalcerWaitObj;
    private static NativeThread precalcThread;
    public static final BigInteger MIN_EXPONENTIAL_VALUE;
    public static final BigInteger MAX_EXPONENTIAL_VALUE;

    public static void init(Random random) {
        r = random;
        precalcThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void askRefill() {
        if (precalcBuffer.size() < 20) {
            Object object = precalcerWaitObj;
            synchronized (object) {
                precalcerWaitObj.notify();
            }
        }
    }

    public static DiffieHellmanLightContext generateLightContext(DHGroup group) {
        long time1 = System.currentTimeMillis();
        NativeBigInteger[] params = DiffieHellman.getParams();
        long time2 = System.currentTimeMillis();
        if (time2 - time1 > 300L) {
            Logger.error(null, "DiffieHellman.generateLightContext(): time2 is more than 300ms after time1 (" + (time2 - time1) + ')');
        }
        return new DiffieHellmanLightContext(group, params[0], params[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NativeBigInteger[] getParams() {
        Stack<NativeBigInteger[]> stack = precalcBuffer;
        synchronized (stack) {
            DiffieHellman.askRefill();
            if (!precalcBuffer.isEmpty()) {
                return precalcBuffer.pop();
            }
        }
        Logger.normal(DiffieHellman.class, "DiffieHellman had to generate a parameter on thread! (report if that happens often)");
        return DiffieHellman.genParams();
    }

    private static NativeBigInteger[] genParams() {
        NativeBigInteger[] params;
        params = new NativeBigInteger[]{new NativeBigInteger(256, r), (NativeBigInteger)group.getG().modPow(params[0], group.getP())};
        while (!DiffieHellman.checkDHExponentialValidity(DiffieHellman.class, params[1])) {
        }
        return params;
    }

    public static boolean checkDHExponentialValidity(Class<?> caller, BigInteger exponential) {
        int onesCount = 0;
        int zerosCount = 0;
        for (int i = 0; i < exponential.bitLength(); ++i) {
            if (exponential.testBit(i)) {
                ++onesCount;
                continue;
            }
            ++zerosCount;
        }
        if (onesCount < 16 || zerosCount < 16) {
            Logger.error(caller, "The provided exponential contains " + zerosCount + " zeros and " + onesCount + " ones wich is unacceptable!");
            return false;
        }
        if (MIN_EXPONENTIAL_VALUE.compareTo(exponential) > -1) {
            Logger.error(caller, "The provided exponential is smaller than 2^24 which is unacceptable!");
            return false;
        }
        if (MAX_EXPONENTIAL_VALUE.compareTo(exponential) < 1) {
            Logger.error(DiffieHellman.class, "The provided exponential is bigger than (p - 2^24) which is unacceptable!");
            return false;
        }
        return true;
    }

    public static DHGroup getGroup() {
        return group;
    }

    public static int modulusLengthInBytes() {
        DHGroup g = DiffieHellman.getGroup();
        if (g == Global.DHgroupA) {
            return 128;
        }
        int bitLength = g.getP().bitLength();
        return (bitLength + 7) / 8;
    }

    static {
        group = Global.DHgroupA;
        precalcBuffer = new Stack();
        precalcerWaitObj = new Object();
        MIN_EXPONENTIAL_VALUE = new BigInteger("2").pow(24);
        MAX_EXPONENTIAL_VALUE = group.getP().subtract(MIN_EXPONENTIAL_VALUE);
        precalcThread = new PrecalcBufferFill();
    }

    private static class PrecalcBufferFill
    extends NativeThread {
        public PrecalcBufferFill() {
            super("Diffie-Hellman-Precalc", NativeThread.MIN_PRIORITY, false);
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void realRun() {
            while (true) {
                Object object;
                if (precalcBuffer.size() < 40) {
                    precalcBuffer.push(DiffieHellman.genParams());
                    object = precalcBuffer;
                    synchronized (object) {
                        precalcBuffer.notify();
                    }
                }
                object = precalcerWaitObj;
                synchronized (object) {
                    try {
                        precalcerWaitObj.wait(193000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

