/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.crypt.DHGroup;
import freenet.crypt.DiffieHellman;
import freenet.crypt.KeyAgreementSchemeContext;
import freenet.support.HexUtil;
import freenet.support.Logger;
import java.math.BigInteger;
import net.i2p.util.NativeBigInteger;

public class DiffieHellmanLightContext
extends KeyAgreementSchemeContext {
    private static volatile boolean logMINOR;
    public final NativeBigInteger myExponent;
    public final NativeBigInteger myExponential;
    public final DHGroup group;

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(": myExponent=");
        sb.append(HexUtil.toHexString(this.myExponent));
        sb.append(", myExponential=");
        sb.append(HexUtil.toHexString(this.myExponential));
        return sb.toString();
    }

    public DiffieHellmanLightContext(DHGroup group, NativeBigInteger myExponent, NativeBigInteger myExponential) {
        this.myExponent = myExponent;
        this.myExponential = myExponential;
        this.group = group;
        this.lastUsedTime = System.currentTimeMillis();
    }

    public byte[] getHMACKey(NativeBigInteger peerExponential) {
        this.lastUsedTime = System.currentTimeMillis();
        BigInteger P = this.group.getP();
        NativeBigInteger sharedSecret = (NativeBigInteger)peerExponential.modPow(this.myExponent, P);
        if (logMINOR) {
            Logger.minor(this, "P: " + HexUtil.biToHex(P));
            Logger.minor(this, "My exponent: " + HexUtil.toHexString(this.myExponent));
            Logger.minor(this, "My exponential: " + HexUtil.toHexString(this.myExponential));
            Logger.minor(this, "Peer's exponential: " + HexUtil.toHexString(peerExponential));
            Logger.minor(this, "g^ir mod p = " + HexUtil.toHexString(sharedSecret));
        }
        return sharedSecret.toByteArray();
    }

    @Override
    public byte[] getPublicKeyNetworkFormat() {
        return this.stripBigIntegerToNetworkFormat(this.myExponential);
    }

    private byte[] stripBigIntegerToNetworkFormat(BigInteger exponential) {
        byte[] data = exponential.toByteArray();
        int targetLength = DiffieHellman.modulusLengthInBytes();
        assert (exponential.signum() == 1);
        if (data.length != targetLength) {
            byte[] newData = new byte[targetLength];
            if (data.length == targetLength + 1 && data[0] == 0) {
                System.arraycopy(data, 1, newData, 0, targetLength);
            } else if (data.length < targetLength) {
                System.arraycopy(data, 0, newData, targetLength - data.length, data.length);
            } else {
                throw new IllegalStateException("Too long!");
            }
            data = newData;
        }
        return data;
    }

    static {
        Logger.registerClass(DiffieHellmanLightContext.class);
    }
}

