/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.crypt.Ed2MessageDigest;
import freenet.crypt.SHA256;
import freenet.crypt.Util;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.bitpedia.util.TigerTree;

public enum HashType {
    SHA1(1, 20),
    MD5(2, 16),
    SHA256(4, "SHA-256", 32),
    SHA384(8, "SHA-384", 48),
    SHA512(16, "SHA-512", 64),
    ED2K(32, null, 16),
    TTH(64, null, 24);

    public final int bitmask;
    public final String javaName;
    public final int hashLength;

    private HashType(int bitmask, int hashLength) {
        this.bitmask = bitmask;
        this.javaName = super.name();
        this.hashLength = hashLength;
    }

    private HashType(int bitmask, String name, int hashLength) {
        this.bitmask = bitmask;
        this.javaName = name;
        this.hashLength = hashLength;
    }

    public MessageDigest get() throws NoSuchAlgorithmException {
        if (this.javaName == null) {
            if (this.name().equals("ED2K")) {
                return new Ed2MessageDigest();
            }
            if (this.name().equals("TTH")) {
                return new TigerTree();
            }
        }
        if (this.name().equals("SHA256")) {
            return freenet.crypt.SHA256.getMessageDigest();
        }
        return MessageDigest.getInstance(this.javaName, Util.mdProviders.get(this.javaName));
    }

    public void recycle(MessageDigest md) {
        if (this.equals((Object)SHA256)) {
            freenet.crypt.SHA256.returnMessageDigest(md);
        }
    }
}

