/*
 * Decompiled with CFR 0.152.
 */
package freenet.store;

import freenet.keys.KeyVerifyException;
import freenet.node.stats.StoreAccessStats;
import freenet.node.useralerts.UserAlertManager;
import freenet.store.BlockMetadata;
import freenet.store.FreenetStore;
import freenet.store.KeyCollisionException;
import freenet.store.StorableBlock;
import freenet.store.StoreCallback;
import freenet.support.ByteArrayWrapper;
import freenet.support.LRUMap;
import freenet.support.Logger;
import freenet.support.Ticker;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;

public class RAMFreenetStore<T extends StorableBlock>
implements FreenetStore<T> {
    private final LRUMap<ByteArrayWrapper, Block> blocksByRoutingKey;
    private final StoreCallback<T> callback;
    private int maxKeys;
    private long hits;
    private long misses;
    private long writes;

    public RAMFreenetStore(StoreCallback<T> callback, int maxKeys) {
        this.callback = callback;
        this.blocksByRoutingKey = LRUMap.createSafeMap(ByteArrayWrapper.FAST_COMPARATOR);
        this.maxKeys = maxKeys;
        callback.setStore(this);
    }

    @Override
    public synchronized T fetch(byte[] routingKey, byte[] fullKey, boolean dontPromote, boolean canReadClientCache, boolean canReadSlashdotCache, boolean ignoreOldBlocks, BlockMetadata meta) throws IOException {
        ByteArrayWrapper key = new ByteArrayWrapper(routingKey);
        Block block = this.blocksByRoutingKey.get(key);
        if (block == null) {
            ++this.misses;
            return null;
        }
        if (ignoreOldBlocks && block.oldBlock) {
            Logger.normal(this, "Ignoring old block");
            return null;
        }
        try {
            T ret = this.callback.construct(block.data, block.header, routingKey, block.fullKey, canReadClientCache, canReadSlashdotCache, meta, null);
            ++this.hits;
            if (!dontPromote) {
                this.blocksByRoutingKey.push(key, block);
            }
            if (meta != null && block.oldBlock) {
                meta.setOldBlock();
            }
            return ret;
        }
        catch (KeyVerifyException e) {
            this.blocksByRoutingKey.removeKey(key);
            ++this.misses;
            return null;
        }
    }

    @Override
    public synchronized long getMaxKeys() {
        return this.maxKeys;
    }

    @Override
    public synchronized long hits() {
        return this.hits;
    }

    @Override
    public synchronized long keyCount() {
        return this.blocksByRoutingKey.size();
    }

    @Override
    public synchronized long misses() {
        return this.misses;
    }

    @Override
    public synchronized void put(T block, byte[] data, byte[] header, boolean overwrite, boolean isOldBlock) throws KeyCollisionException {
        byte[] routingkey = block.getRoutingKey();
        byte[] fullKey = block.getFullKey();
        ++this.writes;
        ByteArrayWrapper key = new ByteArrayWrapper(routingkey);
        Block oldBlock = this.blocksByRoutingKey.get(key);
        boolean storeFullKeys = this.callback.storeFullKeys();
        if (oldBlock != null) {
            if (this.callback.collisionPossible()) {
                boolean equals;
                boolean bl = equals = Arrays.equals(oldBlock.data, data) && Arrays.equals(oldBlock.header, header) && (!storeFullKeys || Arrays.equals(oldBlock.fullKey, fullKey));
                if (equals) {
                    if (!isOldBlock) {
                        oldBlock.oldBlock = false;
                    }
                    return;
                }
                if (overwrite) {
                    oldBlock.data = data;
                    oldBlock.header = header;
                    if (storeFullKeys) {
                        oldBlock.fullKey = fullKey;
                    }
                } else {
                    throw new KeyCollisionException();
                }
                oldBlock.oldBlock = isOldBlock;
                return;
            }
            if (!isOldBlock) {
                oldBlock.oldBlock = false;
            }
            return;
        }
        Block storeBlock = new Block();
        storeBlock.data = data;
        storeBlock.header = header;
        if (storeFullKeys) {
            storeBlock.fullKey = fullKey;
        }
        storeBlock.oldBlock = isOldBlock;
        this.blocksByRoutingKey.push(key, storeBlock);
        while (this.blocksByRoutingKey.size() > this.maxKeys) {
            this.blocksByRoutingKey.popKey();
        }
    }

    @Override
    public synchronized void setMaxKeys(long maxStoreKeys, boolean shrinkNow) throws IOException {
        this.maxKeys = (int)Math.min(Integer.MAX_VALUE, maxStoreKeys);
        while (this.blocksByRoutingKey.size() > this.maxKeys) {
            this.blocksByRoutingKey.popKey();
        }
    }

    @Override
    public long writes() {
        return this.writes;
    }

    @Override
    public long getBloomFalsePositive() {
        return -1L;
    }

    @Override
    public boolean probablyInStore(byte[] routingKey) {
        ByteArrayWrapper key = new ByteArrayWrapper(routingKey);
        return this.blocksByRoutingKey.get(key) != null;
    }

    public void clear() {
        this.blocksByRoutingKey.clear();
    }

    public void migrateTo(StoreCallback<T> target, boolean canReadClientCache) throws IOException {
        Enumeration<ByteArrayWrapper> keys = this.blocksByRoutingKey.keys();
        while (keys.hasMoreElements()) {
            T ret;
            ByteArrayWrapper routingKeyWrapped = keys.nextElement();
            byte[] routingKey = routingKeyWrapped.get();
            Block block = this.blocksByRoutingKey.get(routingKeyWrapped);
            try {
                ret = this.callback.construct(block.data, block.header, routingKey, block.fullKey, canReadClientCache, false, null, null);
            }
            catch (KeyVerifyException e) {
                Logger.error(this, "Caught while migrating: " + e, (Throwable)e);
                continue;
            }
            try {
                target.getStore().put(ret, block.data, block.header, false, block.oldBlock);
            }
            catch (KeyCollisionException e) {}
        }
    }

    @Override
    public StoreAccessStats getSessionAccessStats() {
        return new StoreAccessStats(){

            @Override
            public long hits() {
                return RAMFreenetStore.this.hits;
            }

            @Override
            public long misses() {
                return RAMFreenetStore.this.misses;
            }

            @Override
            public long falsePos() {
                return 0L;
            }

            @Override
            public long writes() {
                return RAMFreenetStore.this.writes;
            }
        };
    }

    @Override
    public StoreAccessStats getTotalAccessStats() {
        return null;
    }

    @Override
    public boolean start(Ticker ticker, boolean longStart) throws IOException {
        return false;
    }

    @Override
    public void setUserAlertManager(UserAlertManager userAlertManager) {
    }

    @Override
    public FreenetStore<T> getUnderlyingStore() {
        return this;
    }

    @Override
    public void close() {
    }

    private static final class Block {
        byte[] header;
        byte[] data;
        byte[] fullKey;
        boolean oldBlock;

        private Block() {
        }
    }
}

