/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import freenet.client.ClientMetadata;
import freenet.client.FetchContext;
import freenet.client.FetchException;
import freenet.client.FetchResult;
import freenet.client.async.BaseSingleFileFetcher;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientGetState;
import freenet.client.async.ClientGetter;
import freenet.client.async.ClientRequester;
import freenet.client.async.GetCompletionCallback;
import freenet.client.async.KeyListenerConstructionException;
import freenet.client.async.SingleFileStreamGenerator;
import freenet.keys.ClientKey;
import freenet.keys.ClientKeyBlock;
import freenet.keys.KeyDecodeException;
import freenet.keys.TooBigException;
import freenet.node.LowLevelGetException;
import freenet.node.SendableRequestItem;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.api.Bucket;
import freenet.support.io.InsufficientDiskSpaceException;
import java.io.IOException;
import java.io.Serializable;

public class SimpleSingleFileFetcher
extends BaseSingleFileFetcher
implements ClientGetState,
Serializable {
    private static final long serialVersionUID = 1L;
    final GetCompletionCallback rcb;
    final long token;
    private static volatile boolean logMINOR;

    SimpleSingleFileFetcher(ClientKey key, int maxRetries, FetchContext ctx, ClientRequester parent, GetCompletionCallback rcb, boolean isEssential, boolean dontAdd, long l, ClientContext context, boolean deleteFetchContext, boolean realTimeFlag) {
        super(key, maxRetries, ctx, parent, deleteFetchContext, realTimeFlag);
        this.rcb = rcb;
        this.token = l;
        if (!dontAdd) {
            if (isEssential) {
                parent.addMustSucceedBlocks(1);
            } else {
                parent.addBlock();
            }
            parent.notifyClients(context);
        }
    }

    @Override
    public void onFailure(LowLevelGetException e, SendableRequestItem reqTokenIgnored, ClientContext context) {
        this.onFailure(SimpleSingleFileFetcher.translateException(e), false, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onFailure(FetchException e, boolean forceFatal, ClientContext context) {
        if (logMINOR) {
            Logger.minor(this, "onFailure( " + e + " , " + forceFatal + ")", (Throwable)e);
        }
        if (this.parent.isCancelled() || this.cancelled) {
            if (logMINOR) {
                Logger.minor(this, "Failing: cancelled");
            }
            e = new FetchException(FetchException.FetchExceptionMode.CANCELLED);
            forceFatal = true;
        }
        if (!e.isFatal() && !forceFatal && this.retry(context)) {
            if (logMINOR) {
                Logger.minor(this, "Retrying");
            }
            return;
        }
        this.unregisterAll(context);
        SimpleSingleFileFetcher simpleSingleFileFetcher = this;
        synchronized (simpleSingleFileFetcher) {
            this.finished = true;
        }
        if (e.isFatal() || forceFatal) {
            this.parent.fatallyFailedBlock(context);
        } else {
            this.parent.failedBlock(context);
        }
        this.rcb.onFailure(e, this, context);
    }

    protected void onSuccess(FetchResult data, ClientContext context) {
        if (this.parent.isCancelled()) {
            data.asBucket().free();
            this.onFailure(new FetchException(FetchException.FetchExceptionMode.CANCELLED), false, context);
            return;
        }
        this.rcb.onSuccess(new SingleFileStreamGenerator(data.asBucket(), this.persistent), data.getMetadata(), null, this, context);
    }

    @Override
    public void onSuccess(ClientKeyBlock block, boolean fromStore, Object reqTokenIgnored, ClientContext context) {
        Bucket data;
        if (this.parent instanceof ClientGetter) {
            ((ClientGetter)this.parent).addKeyToBinaryBlob(block, context);
        }
        if ((data = this.extract(block, context)) == null) {
            return;
        }
        context.uskManager.checkUSK(this.key.getURI(), fromStore, block.isMetadata());
        if (!block.isMetadata()) {
            this.onSuccess(new FetchResult(new ClientMetadata(null), data), context);
        } else {
            this.onFailure(new FetchException(FetchException.FetchExceptionMode.INVALID_METADATA, "Metadata where expected data"), false, context);
        }
    }

    protected Bucket extract(ClientKeyBlock block, ClientContext context) {
        Bucket data;
        try {
            data = block.decode(context.getBucketFactory(this.parent.persistent()), (int)Math.min(this.ctx.maxOutputLength, Integer.MAX_VALUE), false);
        }
        catch (KeyDecodeException e1) {
            if (logMINOR) {
                Logger.minor(this, "Decode failure: " + e1, (Throwable)e1);
            }
            this.onFailure(new FetchException(FetchException.FetchExceptionMode.BLOCK_DECODE_ERROR, e1.getMessage()), false, context);
            return null;
        }
        catch (TooBigException e) {
            this.onFailure(new FetchException(FetchException.FetchExceptionMode.TOO_BIG, (Throwable)e), false, context);
            return null;
        }
        catch (InsufficientDiskSpaceException e) {
            this.onFailure(new FetchException(FetchException.FetchExceptionMode.NOT_ENOUGH_DISK_SPACE), false, context);
            return null;
        }
        catch (IOException e) {
            Logger.error(this, "Could not capture data - disk full?: " + e, (Throwable)e);
            this.onFailure(new FetchException(FetchException.FetchExceptionMode.BUCKET_ERROR, (Throwable)e), false, context);
            return null;
        }
        return data;
    }

    @Override
    public long getToken() {
        return this.token;
    }

    @Override
    public void onFailed(KeyListenerConstructionException e, ClientContext context) {
        this.onFailure(e.getFetchException(), false, context);
    }

    @Override
    public void cancel(ClientContext context) {
        super.cancel(context);
        this.rcb.onFailure(new FetchException(FetchException.FetchExceptionMode.CANCELLED), this, context);
    }

    @Override
    protected void notFoundInStore(ClientContext context) {
        this.onFailure(new FetchException(FetchException.FetchExceptionMode.DATA_NOT_FOUND), true, context);
    }

    @Override
    protected void onBlockDecodeError(SendableRequestItem token, ClientContext context) {
        this.onFailure(new FetchException(FetchException.FetchExceptionMode.BLOCK_DECODE_ERROR, "Could not decode block with the URI given, probably invalid as inserted, possible the URI is wrong"), true, context);
    }

    @Override
    public void onShutdown(ClientContext context) {
    }

    @Override
    protected ClientGetState getClientGetState() {
        return this;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

