/*
 * Decompiled with CFR 0.152.
 */
package freenet.keys;

import freenet.keys.ClientKey;
import freenet.keys.FreenetURI;
import freenet.keys.Key;
import freenet.keys.NodeCHK;
import freenet.support.Base64;
import freenet.support.ByteArrayWrapper;
import freenet.support.Fields;
import freenet.support.compress.Compressor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Random;

public class ClientCHK
extends ClientKey
implements Serializable {
    private static final long serialVersionUID = 1L;
    transient NodeCHK nodeKey;
    final byte[] routingKey;
    final byte[] cryptoKey;
    final boolean controlDocument;
    final byte cryptoAlgorithm;
    final short compressionAlgorithm;
    final int hashCode;
    public static final short EXTRA_LENGTH = 5;
    public static final short CRYPTO_KEY_LENGTH = 32;
    public static final ClientCHK TEST_KEY;
    static byte[] lastExtra;
    static HashSet<ByteArrayWrapper> standardExtras;

    private ClientCHK(ClientCHK key) {
        this.routingKey = (byte[])key.routingKey.clone();
        this.nodeKey = null;
        this.cryptoKey = (byte[])key.cryptoKey.clone();
        this.controlDocument = key.controlDocument;
        this.cryptoAlgorithm = key.cryptoAlgorithm;
        this.compressionAlgorithm = key.compressionAlgorithm;
        if (this.routingKey == null) {
            throw new NullPointerException();
        }
        this.hashCode = Fields.hashCode(this.routingKey) ^ Fields.hashCode(this.routingKey) ^ this.compressionAlgorithm;
    }

    public ClientCHK(byte[] routingKey, byte[] encKey, boolean isControlDocument, byte algo, short compressionAlgorithm) {
        this.routingKey = routingKey;
        this.cryptoKey = encKey;
        this.controlDocument = isControlDocument;
        this.cryptoAlgorithm = algo;
        this.compressionAlgorithm = compressionAlgorithm;
        if (routingKey == null) {
            throw new NullPointerException();
        }
        this.hashCode = Fields.hashCode(routingKey) ^ Fields.hashCode(encKey) ^ compressionAlgorithm;
    }

    public ClientCHK(byte[] routingKey, byte[] encKey, byte[] extra) throws MalformedURLException {
        this.routingKey = routingKey;
        this.cryptoKey = encKey;
        if (extra == null || extra.length < 5) {
            throw new MalformedURLException("No extra bytes in CHK - maybe a 0.5 key?");
        }
        this.cryptoAlgorithm = extra[1];
        if (this.cryptoAlgorithm != 2 && this.cryptoAlgorithm != 3) {
            throw new MalformedURLException("Invalid crypto algorithm");
        }
        this.controlDocument = (extra[2] & 2) != 0;
        this.compressionAlgorithm = (short)(((extra[3] & 0xFF) << 8) + (extra[4] & 0xFF));
        this.hashCode = Fields.hashCode(routingKey) ^ Fields.hashCode(this.cryptoKey) ^ this.compressionAlgorithm;
    }

    public ClientCHK(FreenetURI uri) throws MalformedURLException {
        if (!uri.getKeyType().equals("CHK")) {
            throw new MalformedURLException("Not CHK");
        }
        this.routingKey = uri.getRoutingKey();
        this.cryptoKey = uri.getCryptoKey();
        byte[] extra = uri.getExtra();
        if (extra == null || extra.length < 5) {
            throw new MalformedURLException("No extra bytes in CHK - maybe a 0.5 key?");
        }
        this.cryptoAlgorithm = extra[1];
        if (this.cryptoAlgorithm != 2 && this.cryptoAlgorithm != 3) {
            throw new MalformedURLException("Invalid crypto algorithm");
        }
        this.controlDocument = (extra[2] & 2) != 0;
        this.compressionAlgorithm = (short)(((extra[3] & 0xFF) << 8) + (extra[4] & 0xFF));
        this.hashCode = Fields.hashCode(this.routingKey) ^ Fields.hashCode(this.cryptoKey) ^ this.compressionAlgorithm;
    }

    public ClientCHK(DataInputStream dis) throws IOException {
        byte[] extra = new byte[5];
        dis.readFully(extra);
        this.cryptoAlgorithm = extra[1];
        if (this.cryptoAlgorithm != 2 && this.cryptoAlgorithm != 3) {
            throw new MalformedURLException("Invalid crypto algorithm");
        }
        this.compressionAlgorithm = (short)(((extra[3] & 0xFF) << 8) + (extra[4] & 0xFF));
        this.controlDocument = (extra[2] & 2) != 0;
        this.routingKey = new byte[32];
        dis.readFully(this.routingKey);
        this.cryptoKey = new byte[32];
        dis.readFully(this.cryptoKey);
        this.hashCode = Fields.hashCode(this.routingKey) ^ Fields.hashCode(this.cryptoKey) ^ this.compressionAlgorithm;
    }

    protected ClientCHK() {
        this.routingKey = null;
        this.cryptoKey = null;
        this.controlDocument = false;
        this.cryptoAlgorithm = 0;
        this.compressionAlgorithm = 0;
        this.hashCode = 0;
    }

    public void writeRawBinaryKey(DataOutputStream dos) throws IOException {
        dos.write(this.getExtra());
        dos.write(this.routingKey);
        dos.write(this.cryptoKey);
    }

    public byte[] getExtra() {
        return ClientCHK.getExtra(this.cryptoAlgorithm, this.compressionAlgorithm, this.controlDocument);
    }

    public static byte[] getExtra(byte cryptoAlgorithm, short compressionAlgorithm, boolean controlDocument) {
        byte[] extra = new byte[]{(byte)(cryptoAlgorithm >> 8), cryptoAlgorithm, (byte)(controlDocument ? 2 : 0), (byte)(compressionAlgorithm >> 8), (byte)compressionAlgorithm};
        byte[] last = lastExtra;
        if (Arrays.equals(last, extra)) {
            return last;
        }
        assert (extra.length == 5);
        lastExtra = extra;
        return extra;
    }

    public static byte getCryptoAlgorithmFromExtra(byte[] extra) {
        return extra[1];
    }

    public static byte[] internExtra(byte[] extra) {
        for (ByteArrayWrapper baw : standardExtras) {
            if (!Arrays.equals(baw.get(), extra)) continue;
            return baw.get();
        }
        return extra;
    }

    public String toString() {
        return super.toString() + ':' + Base64.encode(this.routingKey) + ',' + Base64.encode(this.cryptoKey) + ',' + this.compressionAlgorithm + ',' + this.controlDocument + ',' + this.cryptoAlgorithm;
    }

    @Override
    public Key getNodeKey(boolean cloneKey) {
        return cloneKey ? this.getNodeCHK().cloneKey() : this.getNodeCHK();
    }

    public synchronized NodeCHK getNodeCHK() {
        if (this.nodeKey == null) {
            this.nodeKey = new NodeCHK(this.routingKey, this.cryptoAlgorithm);
        }
        return this.nodeKey;
    }

    @Override
    public FreenetURI getURI() {
        byte[] extra = this.getExtra();
        return new FreenetURI("CHK", null, this.routingKey, this.cryptoKey, extra);
    }

    public static ClientCHK readRawBinaryKey(DataInputStream dis) throws IOException {
        return new ClientCHK(dis);
    }

    public boolean isMetadata() {
        return this.controlDocument;
    }

    public boolean isCompressed() {
        return this.compressionAlgorithm >= 0;
    }

    @Override
    public ClientCHK cloneKey() {
        return new ClientCHK(this);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ClientCHK)) {
            return false;
        }
        ClientCHK key = (ClientCHK)o;
        if (this.controlDocument != key.controlDocument) {
            return false;
        }
        if (this.cryptoAlgorithm != key.cryptoAlgorithm) {
            return false;
        }
        if (this.compressionAlgorithm != key.compressionAlgorithm) {
            return false;
        }
        if (!Arrays.equals(this.routingKey, key.routingKey)) {
            return false;
        }
        return Arrays.equals(this.cryptoKey, key.cryptoKey);
    }

    public byte[] getRoutingKey() {
        return this.routingKey;
    }

    public byte[] getCryptoKey() {
        return this.cryptoKey;
    }

    public byte getCryptoAlgorithm() {
        return this.cryptoAlgorithm;
    }

    static {
        try {
            TEST_KEY = new ClientCHK(FreenetURI.generateRandomCHK(new Random()));
        }
        catch (MalformedURLException e) {
            throw new Error(e);
        }
        standardExtras = new HashSet();
        for (byte cryptoAlgorithm = 2; cryptoAlgorithm <= 3; cryptoAlgorithm = (byte)((byte)(cryptoAlgorithm + 1))) {
            for (short compressionAlgorithm = -1; compressionAlgorithm <= (short)Compressor.COMPRESSOR_TYPE.countCompressors(); compressionAlgorithm = (short)(compressionAlgorithm + 1)) {
                standardExtras.add(new ByteArrayWrapper(ClientCHK.getExtra(cryptoAlgorithm, compressionAlgorithm, true)));
                standardExtras.add(new ByteArrayWrapper(ClientCHK.getExtra(cryptoAlgorithm, compressionAlgorithm, false)));
            }
        }
    }
}

