/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.updater;

import freenet.io.comm.AsyncMessageCallback;
import freenet.io.comm.DMT;
import freenet.io.comm.DisconnectedException;
import freenet.io.comm.Message;
import freenet.io.comm.NotConnectedException;
import freenet.io.xfer.BulkTransmitter;
import freenet.io.xfer.PartiallyReceivedBulk;
import freenet.node.PeerNode;
import freenet.node.RequestClient;
import freenet.node.updater.NodeUpdateManager;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.io.FileRandomAccessBuffer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class LegacyUpdateOverMandatoryManager
implements RequestClient {
    private static volatile boolean logMINOR;
    final NodeUpdateManager updateManager;

    public LegacyUpdateOverMandatoryManager(NodeUpdateManager manager) {
        this.updateManager = manager;
    }

    public void handleRequestJar(Message m, final PeerNode source, final boolean isExt) {
        Message msg;
        BulkTransmitter bt;
        FileRandomAccessBuffer raf;
        File data;
        String name;
        String string = name = isExt ? "ext" : "main";
        if (source.isOpennet() && this.updateManager.dontAllowUOM()) {
            Logger.normal(this, "Peer " + source + " asked us for the blob file for " + name + "; We are a seenode, so we ignore it!");
            return;
        }
        int version = isExt ? 29 : 1421;
        File file = data = isExt ? this.updateManager.getTransitionExtBlob() : this.updateManager.getTransitionMainBlob();
        if (data == null) {
            Logger.normal(this, "Peer " + source + " asked us for the blob file for the " + name + " jar but we don't have it!");
            return;
        }
        final long uid = m.getLong("uid");
        if (!source.sendingUOMJar(isExt)) {
            Logger.error(this, "Peer " + source + " asked for UOM " + (isExt ? "ext" : "main") + " jar twice");
            return;
        }
        try {
            try {
                raf = new FileRandomAccessBuffer(data, true);
            }
            catch (FileNotFoundException e) {
                Logger.error(this, "Peer " + source + " asked us for the blob file for the " + name + " jar, we have downloaded it but don't have the file even though we did have it when we checked!: " + e, (Throwable)e);
                return;
            }
            catch (IOException e) {
                Logger.error(this, "Peer " + source + " asked us for the blob file for the " + name + " jar, we have downloaded it but can't read the file on disk!: " + e, (Throwable)e);
                return;
            }
            long length = raf.size();
            PartiallyReceivedBulk prb = new PartiallyReceivedBulk(this.updateManager.node.getUSM(), length, 1024, raf, true);
            try {
                bt = new BulkTransmitter(prb, source, uid, false, this.updateManager.ctr, true);
            }
            catch (DisconnectedException e) {
                Logger.error(this, "Peer " + source + " asked us for the blob file for the " + name + " jar, then disconnected: " + e, (Throwable)e);
                raf.close();
                return;
            }
            msg = isExt ? DMT.createUOMSendingExtra(uid, length, NodeUpdateManager.transitionExtJarURIAsUSK.toString(), version) : DMT.createUOMSendingMain(uid, length, NodeUpdateManager.transitionMainJarURIAsUSK.toString(), version);
        }
        catch (RuntimeException e) {
            source.finishedSendingUOMJar(isExt);
            throw e;
        }
        catch (Error e) {
            source.finishedSendingUOMJar(isExt);
            throw e;
        }
        final Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    if (!bt.send()) {
                        Logger.error(this, "Failed to send " + name + " jar blob to " + source.userToString() + " : " + bt.getCancelReason());
                    } else {
                        Logger.normal(this, "Sent " + name + " jar blob to " + source.userToString());
                    }
                    raf.close();
                }
                catch (DisconnectedException disconnectedException) {
                }
                finally {
                    source.finishedSendingUOMJar(isExt);
                    raf.close();
                }
            }
        };
        try {
            source.sendAsync(msg, new AsyncMessageCallback(){

                @Override
                public void acknowledged() {
                    if (logMINOR) {
                        Logger.minor(this, "Sending data...");
                    }
                    LegacyUpdateOverMandatoryManager.this.updateManager.node.executor.execute(r, name + " jar send for " + uid + " to " + source.userToString());
                }

                @Override
                public void disconnected() {
                    Logger.error(this, "Peer " + source + " asked us for the blob file for the " + name + " jar, then disconnected when we tried to send the UOMSendingMain");
                    source.finishedSendingUOMJar(isExt);
                }

                @Override
                public void fatalError() {
                    Logger.error(this, "Peer " + source + " asked us for the blob file for the " + name + " jar, then got a fatal error when we tried to send the UOMSendingMain");
                    source.finishedSendingUOMJar(isExt);
                }

                @Override
                public void sent() {
                    if (logMINOR) {
                        Logger.minor(this, "Message sent, data soon");
                    }
                }

                public String toString() {
                    return super.toString() + "(" + uid + ":" + source.getPeer() + ")";
                }
            }, this.updateManager.ctr);
        }
        catch (NotConnectedException e) {
            Logger.error(this, "Peer " + source + " asked us for the blob file for the " + name + " jar, then disconnected when we tried to send the UOMSendingExt: " + e, (Throwable)e);
            return;
        }
        catch (RuntimeException e) {
            source.finishedSendingUOMJar(isExt);
            throw e;
        }
        catch (Error e) {
            source.finishedSendingUOMJar(isExt);
            throw e;
        }
    }

    @Override
    public boolean persistent() {
        return false;
    }

    @Override
    public boolean realTimeFlag() {
        return false;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

