/*
 * Decompiled with CFR 0.152.
 */
package freenet.pluginmanager;

import freenet.keys.FreenetURI;
import freenet.pluginmanager.PluginManager;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class OfficialPlugins {
    private final Map<String, OfficialPluginDescription> officialPlugins = new HashMap<String, OfficialPluginDescription>();

    public OfficialPlugins() {
        try {
            this.addPlugin("Freemail").inGroup("communication").minimumVersion(15).usesXml().loadedFrom("CHK@6dfMgGf7YEfJhF0W~K0HUv0fnbuRwYH6iMqrLIbTI7k,huYBf8oBevwW6lRQnz-0jDP1dl5ej7FKeyVZ3CnH0Ec,AAMC--8/Freemail.jar").deprecated();
            this.addPlugin("Freemail_wot").inGroup("communication").minimumVersion(26).loadedFrom("CHK@~N5XxfOXgprXtRlZTIE-BcZT2UaZKFFbStEZM9LCILQ,oUOM~YlFSZgYGBZZSf898OITzOosi6UOJTxtU0Ruag0,AAMC--8/Freemail-v0.2.7.1.jar");
            this.addPlugin("HelloWorld").inGroup("example").loadedFrom("CHK@ZdTXnWV-ikkt25-y8jmhlHjCY-nikDMQwcYlWHww5eg,Usq3uRHpHuIRmMRRlNQE7BNveO1NwNI7oNKdb7cowFM,AAIC--8/HelloWorld.jar").advanced();
            this.addPlugin("HelloFCP").inGroup("example").loadedFrom("CHK@0gtXJpw1QUJCmFOhoPRNqhsNbMtVw1CGVe46FUv7-e0,X8QqhtPkHoaFCUd89bgNaKxX1AV0WNBVf3sRgSF51-g,AAIC--8/HelloFCP.jar").advanced();
            this.addPlugin("JSTUN").inGroup("connectivity").essential().minimumVersion(2).loadedFrom("CHK@Zgib8xrGxcEuix7AVB4eajton1FpNHbIJeQZgEbHMNU,BQekU261VLSDUBQPOHSMKUF5qxY1v0zjXa33RyoEbYk,AAMC--8/JSTUN.jar");
            this.addPlugin("KeyUtils").inGroup("technical").minimumVersion(5024).loadedFrom("CHK@rsRNrCbYJvuCcQa3OC0c9uQh23KtqczNfZSUQfLpiAM,68yt6H-UiG00PWNQWF5uNrhuT5bcWu5CYwP~acTnzEM,AAMC--8/KeyUtils-v5024.jar").advanced();
            this.addPlugin("MDNSDiscovery").inGroup("connectivity").minimumVersion(2).loadedFrom("CHK@wPyhY61bsDM3OW6arFlxYX8~mBKjo~XtOTIAbT0dk88,Vr3MTAzkW5J28SJs2dTxkj6D4GVNm3u8GFsxJgzTL1M,AAIC--8/MDNSDiscovery.jar");
            this.addPlugin("SNMP").inGroup("connectivity").loadedFrom("CHK@EykJIv83UE291zONVzfXqyJYX5t66uCQJHkzQrB61MI,-npuolPZj1fcAWane2~qzRNEjKDERx52aQ5bC6NBQgw,AAIC--8/SNMP.jar").advanced();
            this.addPlugin("TestGallery").inGroup("example").minimumVersion(1).loadedFrom("CHK@LfJVh1EkCr4ry0yDW74vwxkX-3nkr~ztW2z0SUZHfC0,-mz7l39dC6n0RTUiSokjC~pUDO7PWZ89miYesKH0-WA,AAIC--8/TestGallery.jar").experimental();
            this.addPlugin("ThawIndexBrowser").inGroup("file-transfer").minimumVersion(6).usesXml().loadedFrom("CHK@9bjNQtl7ndPKh~gi4woH0Xvb7uRunJ81deIlXwGE6qg,clwp0Bhx2LZxt2XCWeARqv24tBNmjlhXDZtwAJpzlIc,AAMC--8/ThawIndexBrowser-v6.jar");
            this.addPlugin("UPnP").inGroup("connectivity").essential().minimumVersion(10003).loadedFrom("CHK@ICSu1tgnNxJ0bApWkL-fQFswbfi9KPnmWI3Is4eq0iw,Sj1N3zdDHBbL3Uc3~eY4elqWwSP7IR1uHrKVR2-nA0s,AAMC--8/UPnP-10006.jar");
            this.addPlugin("XMLLibrarian").inGroup("index").minimumVersion(26).usesXml().loadedFrom("CHK@TvjyCaG1dx0xIBSJkXSKA1ZT4I~NkRKeQqwC0a0bhFM,JiQe4CRjF1RwhQRFFQzP-ih9t2i0peV0tBCfJAeFCdk,AAIC--8/XMLLibrarian.jar").unsupported();
            this.addPlugin("XMLSpider").inGroup("index").minimumVersion(48).usesXml().loadedFrom("CHK@ne-aaLuzVZLcHj0YmrclaCXJqxsSb7q-J0eYEiL9V9o,v0EdgDGBhTE9k6GsB44UrQ4ADUq5LCUVknLaE4iSEBk,AAMC--8/XMLSpider.jar").unsupported();
            this.addPlugin("Freereader").inGroup("index").minimumVersion(4).usesXml().loadedFrom("CHK@4PuSjXk4Z0Hdu04JLhdPHLyOVLljj8qVbjRn3rHVzvg,bDGYnuYj67Q4uzroPBEWAYWRk26bPzf-iQ4~Uo3S7mg,AAIC--8/Freereader.jar");
            this.addPlugin("Library").inGroup("index").minimumVersion(36).usesXml().loadedFrom("CHK@DB~oyn9M5B3Yx1B80qJbp-qp~434cxDERtgnxyhSfZ8,WRc11UVdhU4phf688oledQIV8BrNn3nvR9bVCVB-pM0,AAMC--8/Library-v36.jar");
            this.addPlugin("Spider").inGroup("index").minimumVersion(52).loadedFrom("CHK@94gCPJEkEXq6Zti4wxDrqr9e~geQS4B3kdIwl4TXzV8,NUlmfjeqja28Lim6m3kTuxGHRSNtQHsbRoIAilxdkJY,AAMC--8/Spider-v52.jar").advanced();
            this.addPlugin("WebOfTrust").inGroup("communication").minimumVersion(15).usesXml().loadedFrom("CHK@1FWUqydeyTbxC3fut51QT8VGnokQFYHMoLsqzP4RU60,BM3ibZYejeo2-sC7WklJ9I8ZJysMpO9~l9MZ8NUzP2c,AAMC--8/WebOfTrust-build0015.jar");
            this.addPlugin("FlogHelper").inGroup("communication").minimumVersion(34).usesXml().loadedFrom("CHK@yuiC-Dv0UYNgqRcLq4heCL-y0nHctr2LBcOsBN0ORyM,8M2bv~d7Su~O0MJHz4Tq1g3n4nrAgw-C7dn6mMFQSA4,AAMC--8/FlogHelper-v34.jar");
        }
        catch (MalformedURLException mue1) {
            throw new RuntimeException("Could not create FreenetURI.", mue1);
        }
    }

    private OfficialPluginBuilder addPlugin(String name) {
        return new OfficialPluginBuilder(name);
    }

    public OfficialPluginDescription get(String name) {
        return this.officialPlugins.get(name);
    }

    public Collection<OfficialPluginDescription> getAll() {
        return Collections.unmodifiableCollection(this.officialPlugins.values());
    }

    public static class OfficialPluginDescription {
        public final String name;
        public final String group;
        public final boolean essential;
        public final long minimumVersion;
        public final long recommendedVersion;
        public final boolean usesXML;
        public final FreenetURI uri;
        public final boolean deprecated;
        public final boolean experimental;
        public final boolean advanced;
        public final boolean unsupported;

        OfficialPluginDescription(String name, String group, boolean essential, long minVer, long recVer, boolean usesXML, FreenetURI uri, boolean deprecated, boolean experimental, boolean advanced, boolean unsupported) {
            this.name = name;
            this.group = group;
            this.essential = essential;
            this.minimumVersion = minVer;
            this.recommendedVersion = recVer;
            this.usesXML = usesXML;
            this.uri = uri;
            this.deprecated = deprecated;
            this.experimental = experimental;
            this.advanced = advanced;
            this.unsupported = unsupported;
        }

        public String getLocalisedPluginName() {
            return PluginManager.getOfficialPluginLocalisedName(this.name);
        }

        public String getLocalisedPluginDescription() {
            return PluginManager.l10n("pluginDesc." + this.name);
        }
    }

    private class OfficialPluginBuilder {
        private final String name;
        private String group;
        private boolean essential;
        private long minimumVersion = -1L;
        private long recommendedVersion = -1L;
        private boolean usesXml;
        private FreenetURI uri;
        private boolean deprecated;
        private boolean experimental;
        private boolean advanced;
        private boolean unsupported;

        private OfficialPluginBuilder(String name) {
            this.name = name;
            this.addCurrentPluginDescription();
        }

        public OfficialPluginBuilder inGroup(String group) {
            this.group = group;
            this.addCurrentPluginDescription();
            return this;
        }

        public OfficialPluginBuilder essential() {
            this.essential = true;
            this.addCurrentPluginDescription();
            return this;
        }

        public OfficialPluginBuilder minimumVersion(int minimumVersion) {
            this.minimumVersion = minimumVersion;
            this.addCurrentPluginDescription();
            return this;
        }

        public OfficialPluginBuilder recommendedVersion(int recommendedVersion) {
            this.recommendedVersion = recommendedVersion;
            this.addCurrentPluginDescription();
            return this;
        }

        public OfficialPluginBuilder usesXml() {
            this.usesXml = true;
            this.addCurrentPluginDescription();
            return this;
        }

        public OfficialPluginBuilder loadedFrom(String uri) throws MalformedURLException {
            this.uri = new FreenetURI(uri);
            this.addCurrentPluginDescription();
            return this;
        }

        public OfficialPluginBuilder deprecated() {
            this.deprecated = true;
            this.addCurrentPluginDescription();
            return this;
        }

        public OfficialPluginBuilder experimental() {
            this.experimental = true;
            this.addCurrentPluginDescription();
            return this;
        }

        public OfficialPluginBuilder advanced() {
            this.advanced = true;
            this.addCurrentPluginDescription();
            return this;
        }

        public OfficialPluginBuilder unsupported() {
            this.unsupported = true;
            this.addCurrentPluginDescription();
            return this;
        }

        private void addCurrentPluginDescription() {
            OfficialPlugins.this.officialPlugins.put(this.name, this.createOfficialPluginDescription());
        }

        private OfficialPluginDescription createOfficialPluginDescription() {
            return new OfficialPluginDescription(this.name, this.group, this.essential, this.minimumVersion, this.recommendedVersion, this.usesXml, this.uri, this.deprecated, this.experimental, this.advanced, this.unsupported);
        }
    }
}

