/*
 * Decompiled with CFR 0.152.
 */
package freenet.pluginmanager;

import freenet.pluginmanager.PluginDownLoader;
import freenet.pluginmanager.PluginManager;
import freenet.pluginmanager.PluginNotFoundException;
import freenet.support.Logger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

public class PluginDownLoaderURL
extends PluginDownLoader<URL> {
    @Override
    public URL checkSource(String source) throws PluginNotFoundException {
        try {
            return new URL(source);
        }
        catch (MalformedURLException e) {
            File[] roots;
            for (File f : roots = File.listRoots()) {
                if (!source.startsWith(f.getName()) || new File(source).exists()) continue;
                throw new PluginNotFoundException("File not found: " + source);
            }
            Logger.error(this, "could not build plugin url for " + source, (Throwable)e);
            throw new PluginNotFoundException("could not build plugin url for " + source, e);
        }
    }

    @Override
    InputStream getInputStream(PluginManager.PluginProgress progress) throws IOException {
        URLConnection urlConnection = ((URL)this.getSource()).openConnection();
        urlConnection.setUseCaches(false);
        urlConnection.setAllowUserInteraction(false);
        return PluginDownLoaderURL.openConnectionCheckRedirects(urlConnection);
    }

    @Override
    String getPluginName(String source) throws PluginNotFoundException {
        String name = source.substring(source.lastIndexOf(47) + 1);
        if (name.endsWith(".url")) {
            name = name.substring(0, name.length() - 4);
        }
        return name;
    }

    @Override
    String getSHA1sum() throws PluginNotFoundException {
        return null;
    }

    @Override
    String getSHA256sum() throws PluginNotFoundException {
        return null;
    }

    static InputStream openConnectionCheckRedirects(URLConnection c) throws IOException {
        boolean redir;
        int redirects = 0;
        InputStream in = null;
        do {
            HttpURLConnection http;
            int stat;
            if (c instanceof HttpURLConnection) {
                ((HttpURLConnection)c).setInstanceFollowRedirects(false);
            }
            in = c.getInputStream();
            redir = false;
            if (!(c instanceof HttpURLConnection) || (stat = (http = (HttpURLConnection)c).getResponseCode()) < 300 || stat > 307 || stat == 306 || stat == 304) continue;
            URL base = http.getURL();
            String loc = http.getHeaderField("Location");
            URL target = null;
            if (loc != null) {
                target = new URL(base, loc);
            }
            http.disconnect();
            if (target == null || !target.getProtocol().equals("http") && !target.getProtocol().equals("https") && !target.getProtocol().equals("ftp") || redirects >= 5) {
                throw new SecurityException("illegal URL redirect");
            }
            redir = true;
            c = target.openConnection();
            ++redirects;
            in.close();
        } while (redir);
        return in;
    }

    @Override
    void tryCancel() {
    }
}

