/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.support.Logger;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class Timer {
    private final long startTime;
    private final boolean isSubTimer;
    private final List<Timer> subTimers = new LinkedList<Timer>();
    private String logMessage;
    private boolean logAtWarning = false;

    private Timer(boolean isSubTimer) {
        this.startTime = System.nanoTime();
        this.isSubTimer = isSubTimer;
    }

    public static Timer start() {
        return new Timer(false);
    }

    public long getTime() {
        long cur = System.nanoTime();
        return Math.abs(cur - this.startTime);
    }

    public void log(Class<?> c, String message) {
        long time = this.getTime();
        this.logMessage = message + ": " + time + "ns";
        if (!this.isSubTimer) {
            this.log(c);
        }
    }

    public void log(Object o, String message) {
        long time = this.getTime();
        this.logMessage = message + ": " + time + "ns";
        if (!this.isSubTimer) {
            this.log(o);
        }
    }

    public void log(Class<?> c, long warningThreshold, TimeUnit unit, String message) {
        long time = this.getTime();
        this.logMessage = message + ": " + time + "ns";
        if (time >= unit.toNanos(warningThreshold)) {
            this.logAtWarning = true;
        }
        if (!this.isSubTimer) {
            this.log(c);
        }
    }

    public void log(Object o, long warningThreshold, TimeUnit unit, String message) {
        long time = this.getTime();
        this.logMessage = message + ": " + time + "ns";
        if (time >= unit.toNanos(warningThreshold)) {
            this.logAtWarning = true;
        }
        if (!this.isSubTimer) {
            this.log(o);
        }
    }

    public Timer startSubTimer() {
        Timer t = new Timer(true);
        this.subTimers.add(t);
        return t;
    }

    private void log(Class<?> c) {
        for (Timer t : this.subTimers) {
            if (this.logAtWarning) {
                t.logAtWarning = true;
            }
            t.log(c);
        }
        if (this.logAtWarning) {
            Logger.warning(c, this.logMessage);
        } else {
            Logger.minor(c, this.logMessage);
        }
    }

    private void log(Object o) {
        for (Timer t : this.subTimers) {
            if (this.logAtWarning) {
                t.logAtWarning = true;
            }
            t.log(o);
        }
        if (this.logAtWarning) {
            Logger.warning(o, this.logMessage);
        } else {
            Logger.minor(o, this.logMessage);
        }
    }
}

