/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import freenet.client.DefaultMIMETypes;
import freenet.node.NodeStarter;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.StringValidityChecker;
import freenet.support.io.BucketTools;
import freenet.support.io.Closer;
import freenet.support.io.FileBucket;
import freenet.support.io.LineReadingInputStream;
import freenet.support.io.RandomAccessFileOutputStream;
import freenet.support.io.ZeroInputStream;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Random;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.AESFastEngine;
import org.bouncycastle.crypto.io.CipherInputStream;
import org.bouncycastle.crypto.modes.SICBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

public final class FileUtil {
    public static final int BUFFER_SIZE = 32768;
    public static final OperatingSystem detectedOS = FileUtil.detectOperatingSystem();
    public static final CPUArchitecture detectedArch = FileUtil.detectCPUArchitecture();
    private static final Charset fileNameCharset = FileUtil.getFileEncodingCharset();
    private static volatile boolean logMINOR;
    private static CipherInputStream cis;
    private static ZeroInputStream zis;
    private static long cisCounter;

    public static LineReadingInputStream getLogTailReader(File logfile, long byteLimit) throws IOException {
        long length = logfile.length();
        long skip = 0L;
        if (length > byteLimit) {
            skip = length - byteLimit;
        }
        FileInputStream fis = null;
        LineReadingInputStream lis = null;
        try {
            fis = new FileInputStream(logfile);
            lis = new LineReadingInputStream(fis);
            if (skip > 0L) {
                lis.skip(skip);
                lis.readLine(100000, 200, true);
            }
        }
        catch (IOException e) {
            Closer.close(lis);
            Closer.close(fis);
            throw e;
        }
        return lis;
    }

    private static OperatingSystem detectOperatingSystem() {
        try {
            String name = System.getProperty("os.name").toLowerCase();
            if (name.indexOf("win") >= 0) {
                return OperatingSystem.Windows;
            }
            if (name.indexOf("mac") >= 0) {
                return OperatingSystem.MacOS;
            }
            if (name.indexOf("linux") >= 0) {
                return OperatingSystem.Linux;
            }
            if (name.indexOf("freebsd") >= 0) {
                return OperatingSystem.FreeBSD;
            }
            if (name.indexOf("unix") >= 0) {
                return OperatingSystem.GenericUnix;
            }
            if (File.separatorChar == '/') {
                return OperatingSystem.GenericUnix;
            }
            if (File.separatorChar == '\\') {
                return OperatingSystem.Windows;
            }
            Logger.error(FileUtil.class, "Unknown operating system:" + name);
        }
        catch (Throwable t) {
            Logger.error(FileUtil.class, "Operating system detection failed", t);
        }
        return OperatingSystem.Unknown;
    }

    private static CPUArchitecture detectCPUArchitecture() {
        try {
            String name = System.getProperty("os.arch").toLowerCase();
            if (name.equals("x86") || name.equals("i386") || name.matches("i[3-9]86")) {
                return CPUArchitecture.X86;
            }
            if (name.equals("amd64") || name.equals("x86-64") || name.equals("x86_64") || name.equals("x86") || name.equals("em64t") || name.equals("x8664") || name.equals("8664")) {
                return CPUArchitecture.X86_64;
            }
            if (name.startsWith("arm")) {
                return CPUArchitecture.ARM;
            }
            if (name.equals("ppc") || name.equals("powerpc")) {
                return CPUArchitecture.PPC_32;
            }
            if (name.equals("ppc64")) {
                return CPUArchitecture.PPC_64;
            }
            if (name.startsWith("ia64")) {
                return CPUArchitecture.IA64;
            }
        }
        catch (Throwable t) {
            Logger.error(FileUtil.class, "CPU architecture detection failed", t);
        }
        return CPUArchitecture.Unknown;
    }

    public static Charset getFileEncodingCharset() {
        try {
            return Charset.forName(System.getProperty("file.encoding"));
        }
        catch (Throwable t) {
            return Charset.defaultCharset();
        }
    }

    private static long roundup_2n(long val, int blocksize) {
        int mask = blocksize - 1;
        return val + (long)mask & (long)(~mask);
    }

    public static long estimateUsage(File file, long flen) {
        int nameLength;
        long blockUsage = FileUtil.roundup_2n(flen, 4096);
        String filename = file.getName();
        try {
            nameLength = Math.max(filename.getBytes("UTF-16").length, filename.getBytes("UTF-8").length) + 100;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-16 or UTF-8 charset not supported?!");
        }
        long filenameUsage = FileUtil.roundup_2n(nameLength, 512);
        long extra = FileUtil.roundup_2n(flen, 1024) / 1024L * 50L;
        return blockUsage + filenameUsage + extra;
    }

    public static boolean isParent(File poss, File filename) {
        File canon = FileUtil.getCanonicalFile(poss);
        File canonFile = FileUtil.getCanonicalFile(filename);
        if (FileUtil.isParentInner(poss, filename)) {
            return true;
        }
        if (FileUtil.isParentInner(poss, canonFile)) {
            return true;
        }
        if (FileUtil.isParentInner(canon, filename)) {
            return true;
        }
        return FileUtil.isParentInner(canon, canonFile);
    }

    private static boolean isParentInner(File possParent, File filename) {
        do {
            if (!filename.equals(possParent)) continue;
            return true;
        } while ((filename = filename.getParentFile()) != null);
        return false;
    }

    public static File getCanonicalFile(File file) {
        File result;
        String name = file.getPath();
        if (File.pathSeparatorChar == '\\') {
            name = name.toLowerCase();
        }
        file = new File(name);
        try {
            result = file.getAbsoluteFile().getCanonicalFile();
        }
        catch (IOException e) {
            result = file.getAbsoluteFile();
        }
        return result;
    }

    public static StringBuilder readUTF(File file) throws FileNotFoundException, IOException {
        return FileUtil.readUTF(file, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuilder readUTF(File file, long offset) throws FileNotFoundException, IOException {
        StringBuilder result = new StringBuilder();
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        InputStreamReader isr = null;
        try {
            fis = new FileInputStream(file);
            FileUtil.skipFully(fis, offset);
            bis = new BufferedInputStream(fis);
            isr = new InputStreamReader((InputStream)bis, "UTF-8");
            char[] buf = new char[4096];
            int length = 0;
            while ((length = isr.read(buf)) > 0) {
                result.append(buf, 0, length);
            }
        }
        catch (Throwable throwable) {
            Closer.close(isr);
            Closer.close(bis);
            Closer.close(fis);
            throw throwable;
        }
        Closer.close(isr);
        Closer.close(bis);
        Closer.close(fis);
        return result;
    }

    public static StringBuilder readUTF(InputStream stream) throws IOException {
        return FileUtil.readUTF(stream, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuilder readUTF(InputStream stream, long offset) throws IOException {
        StringBuilder result = new StringBuilder();
        FileUtil.skipFully(stream, offset);
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(stream, "UTF-8");
            char[] buf = new char[4096];
            int length = 0;
            while ((length = reader.read(buf)) > 0) {
                result.append(buf, 0, length);
            }
        }
        catch (Throwable throwable) {
            Closer.close(reader);
            throw throwable;
        }
        Closer.close(reader);
        return result;
    }

    public static void skipFully(InputStream is, long skip) throws IOException {
        long x;
        for (long skipped = 0L; skipped < skip; skipped += x) {
            x = is.skip(skip - skipped);
            if (x > 0L) continue;
            throw new IOException("Unable to skip " + (skip - skipped) + " bytes");
        }
    }

    public static boolean writeTo(InputStream input, File target) throws FileNotFoundException, IOException {
        DataInputStream dis = null;
        FileOutputStream fos = null;
        File file = File.createTempFile("temp", ".tmp", target.getParentFile());
        if (logMINOR) {
            Logger.minor(FileUtil.class, "Writing to " + file + " to be renamed to " + target);
        }
        try {
            dis = new DataInputStream(input);
            fos = new FileOutputStream(file);
            int len = 0;
            byte[] buffer = new byte[4096];
            while ((len = dis.read(buffer)) > 0) {
                fos.write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (dis != null) {
                dis.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
        if (FileUtil.renameTo(file, target)) {
            return true;
        }
        file.delete();
        return false;
    }

    public static boolean renameTo(File orig, File dest) {
        if (orig.equals(dest)) {
            throw new IllegalArgumentException("Huh? the two file descriptors are the same!");
        }
        if (!orig.exists()) {
            throw new IllegalArgumentException("Original doesn't exist!");
        }
        if (!orig.renameTo(dest)) {
            if (!dest.delete() && dest.exists()) {
                Logger.error("FileUtil", "Could not delete " + dest + " - check permissions");
                System.err.println("Could not delete " + dest + " - check permissions");
            }
            if (!orig.renameTo(dest)) {
                String err = "Could not rename " + orig + " to " + dest + (dest.exists() ? " (target exists)" : "") + (orig.exists() ? " (source exists)" : "") + " - check permissions";
                Logger.error(FileUtil.class, err);
                System.err.println(err);
                return false;
            }
        }
        return true;
    }

    public static boolean moveTo(File orig, File dest, boolean overwrite) {
        if (orig.equals(dest)) {
            throw new IllegalArgumentException("Huh? the two file descriptors are the same!");
        }
        if (!orig.exists()) {
            throw new IllegalArgumentException("Original doesn't exist!");
        }
        if (dest.exists()) {
            if (overwrite) {
                dest.delete();
            } else {
                System.err.println("Not overwriting " + dest + " - already exists moving " + orig);
                return false;
            }
        }
        if (!orig.renameTo(dest)) {
            return FileUtil.copyFile(orig, dest);
        }
        return true;
    }

    public static String sanitizeFileName(String fileName, OperatingSystem targetOS, String extraChars) {
        CharBuffer buffer = fileNameCharset.decode(fileNameCharset.encode(fileName));
        StringBuilder sb = new StringBuilder(fileName.length() + 1);
        switch (targetOS) {
            case Unknown: {
                break;
            }
            case MacOS: {
                break;
            }
            case Linux: {
                break;
            }
            case FreeBSD: {
                break;
            }
            case GenericUnix: {
                break;
            }
            case Windows: {
                break;
            }
            default: {
                Logger.error(FileUtil.class, "Unsupported operating system: " + (Object)((Object)targetOS));
                targetOS = OperatingSystem.Unknown;
            }
        }
        char def = ' ';
        if (extraChars.indexOf(32) != -1 && extraChars.indexOf(def = '_') != -1 && extraChars.indexOf(def = '-') != -1) {
            throw new IllegalArgumentException("What do you want me to use instead of spaces???");
        }
        for (char c : buffer.array()) {
            if (extraChars.indexOf(c) != -1) {
                sb.append(def);
                continue;
            }
            if (Character.getType(c) == 15 || Character.isWhitespace(c)) {
                sb.append(def);
                continue;
            }
            if ((targetOS == OperatingSystem.Unknown || targetOS.isWindows) && StringValidityChecker.isWindowsReservedPrintableFilenameCharacter(Character.valueOf(c))) {
                sb.append(def);
                continue;
            }
            if ((targetOS == OperatingSystem.Unknown || targetOS.isMac) && StringValidityChecker.isMacOSReservedPrintableFilenameCharacter(Character.valueOf(c))) {
                sb.append(def);
                continue;
            }
            if ((targetOS == OperatingSystem.Unknown || targetOS.isUnix) && StringValidityChecker.isUnixReservedPrintableFilenameCharacter(c)) {
                sb.append(def);
                continue;
            }
            sb.append(c);
        }
        if (targetOS == OperatingSystem.Unknown || targetOS.isWindows) {
            char lastChar;
            int lastCharIndex = sb.length() - 1;
            while (lastCharIndex >= 0 && ((lastChar = sb.charAt(lastCharIndex)) == ' ' || lastChar == '.')) {
                sb.deleteCharAt(lastCharIndex--);
            }
        }
        if ((targetOS == OperatingSystem.Unknown || targetOS.isWindows) && StringValidityChecker.isWindowsReservedFilename(sb.toString())) {
            sb.insert(0, '_');
        }
        if (sb.length() == 0) {
            sb.append("Invalid filename");
        }
        return sb.toString().trim();
    }

    public static String sanitize(String fileName) {
        return FileUtil.sanitizeFileName(fileName, detectedOS, "");
    }

    public static String sanitizeFileNameWithExtras(String fileName, String extraChars) {
        return FileUtil.sanitizeFileName(fileName, detectedOS, extraChars);
    }

    public static String sanitize(String filename, String mimeType) {
        filename = FileUtil.sanitize(filename);
        if (mimeType == null) {
            return filename;
        }
        return DefaultMIMETypes.forceExtension(filename, mimeType);
    }

    public static long findLength(InputStream source) throws IOException {
        long length = 0L;
        byte[] buffer = new byte[32768];
        int read = 0;
        while (read > -1) {
            read = source.read(buffer);
            if (read == -1) continue;
            length += (long)read;
        }
        return length;
    }

    public static void copy(InputStream source, OutputStream destination, long length) throws IOException {
        long remaining = length;
        byte[] buffer = new byte[32768];
        int read = 0;
        while (remaining == -1L || remaining > 0L) {
            read = source.read(buffer, 0, remaining > 32768L || remaining == -1L ? 32768 : (int)remaining);
            if (read == -1) {
                if (length == -1L) {
                    return;
                }
                throw new EOFException("stream reached eof");
            }
            destination.write(buffer, 0, read);
            if (remaining <= 0L) continue;
            remaining -= (long)read;
        }
    }

    public static boolean secureDeleteAll(File wd) throws IOException {
        if (!wd.isDirectory()) {
            System.err.println("DELETING FILE " + wd);
            try {
                FileUtil.secureDelete(wd);
            }
            catch (IOException e) {
                Logger.error(FileUtil.class, "Could not delete file: " + wd, (Throwable)e);
                return false;
            }
        } else {
            for (File subfile : wd.listFiles()) {
                if (FileUtil.removeAll(subfile)) continue;
                return false;
            }
            if (!wd.delete()) {
                Logger.error(FileUtil.class, "Could not delete directory: " + wd);
            }
        }
        return true;
    }

    public static boolean removeAll(File wd) {
        if (!wd.isDirectory()) {
            System.err.println("DELETING FILE " + wd);
            if (!wd.delete() && wd.exists()) {
                Logger.error(FileUtil.class, "Could not delete file: " + wd);
                return false;
            }
        } else {
            for (File subfile : wd.listFiles()) {
                if (FileUtil.removeAll(subfile)) continue;
                return false;
            }
            if (!wd.delete()) {
                Logger.error(FileUtil.class, "Could not delete directory: " + wd);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void secureDelete(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        long size = file.length();
        if (size > 0L) {
            RandomAccessFile raf = null;
            try {
                System.out.println("Securely deleting " + file + " which is of length " + size + " bytes...");
                raf = new RandomAccessFile(file, "rw");
                raf.seek(0L);
                FileUtil.fill(new RandomAccessFileOutputStream(raf), size);
                raf.getFD().sync();
                raf.close();
                raf = null;
            }
            catch (Throwable throwable) {
                Closer.close(raf);
                throw throwable;
            }
            Closer.close(raf);
        }
        if (!file.delete() && file.exists()) {
            throw new IOException("Unable to delete file " + file);
        }
    }

    @Deprecated
    public static void secureDelete(File file, Random random) throws IOException {
        FileUtil.secureDelete(file);
    }

    public static boolean setOwnerRW(File f) {
        return FileUtil.setOwnerPerm(f, true, true, false);
    }

    public static boolean setOwnerRWX(File f) {
        return FileUtil.setOwnerPerm(f, true, true, true);
    }

    public static boolean setOwnerPerm(File f, boolean r, boolean w, boolean x) {
        boolean success = true;
        try {
            String[] methods = new String[]{"setReadable", "setWritable", "setExecutable"};
            boolean[] perms = new boolean[]{r, w, x};
            for (int i = 0; i < methods.length; ++i) {
                Method m = File.class.getDeclaredMethod(methods[i], Boolean.TYPE, Boolean.TYPE);
                if (m == null) continue;
                success &= ((Boolean)m.invoke((Object)f, false, false)).booleanValue();
                success &= ((Boolean)m.invoke((Object)f, perms[i], true)).booleanValue();
            }
        }
        catch (NoSuchMethodException e) {
            success = false;
        }
        catch (InvocationTargetException e) {
            success = false;
        }
        catch (IllegalAccessException e) {
            success = false;
        }
        catch (ExceptionInInitializerError e) {
            success = false;
        }
        catch (RuntimeException e) {
            success = false;
        }
        return success;
    }

    public static boolean equals(File a, File b) {
        if (a == b) {
            return true;
        }
        if (a.equals(b)) {
            return true;
        }
        a = FileUtil.getCanonicalFile(a);
        b = FileUtil.getCanonicalFile(b);
        return a.equals(b);
    }

    public static File createTempFile(String prefix, String suffix, File directory) throws IOException {
        if (directory == null) {
            directory = new File(".");
        }
        return File.createTempFile(prefix, suffix, directory);
    }

    public static boolean copyFile(File copyFrom, File copyTo) {
        copyTo.delete();
        boolean executable = copyFrom.canExecute();
        FileBucket outBucket = new FileBucket(copyTo, false, true, false, false);
        FileBucket inBucket = new FileBucket(copyFrom, true, false, false, false);
        try {
            BucketTools.copy(inBucket, outBucket);
            if (executable && !copyTo.setExecutable(true) && !copyTo.canExecute()) {
                System.err.println("Unable to preserve executable bit when copying " + copyFrom + " to " + copyTo + " - you may need to make it executable!");
            }
            return true;
        }
        catch (IOException e) {
            System.err.println("Unable to copy from " + copyFrom + " to " + copyTo);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void fill(OutputStream os, long length) throws IOException {
        long remaining = length;
        byte[] buffer = new byte[32768];
        int read = 0;
        while (true) {
            if (remaining != -1L) {
                if (remaining <= 0L) return;
            }
            Class<FileUtil> clazz = FileUtil.class;
            // MONITORENTER : freenet.support.io.FileUtil.class
            if (cis == null || cisCounter > 0x3FFFFFFFFFFFFFFFL) {
                byte[] key = new byte[16];
                byte[] iv = new byte[16];
                SecureRandom rng = NodeStarter.getGlobalSecureRandom();
                rng.nextBytes(key);
                rng.nextBytes(iv);
                AESFastEngine e = new AESFastEngine();
                SICBlockCipher ctr = new SICBlockCipher((BlockCipher)e);
                ctr.init(true, (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(key), iv));
                cis = new CipherInputStream((InputStream)zis, new BufferedBlockCipher((BlockCipher)ctr));
                cisCounter = 0L;
            }
            read = cis.read(buffer, 0, remaining > 32768L || remaining == -1L ? 32768 : (int)remaining);
            cisCounter += (long)read;
            // MONITOREXIT : clazz
            if (read == -1) {
                if (length != -1L) throw new EOFException("stream reached eof");
                return;
            }
            os.write(buffer, 0, read);
            if (remaining <= 0L) continue;
            remaining -= (long)read;
        }
    }

    public static void fill(OutputStream os, Random random, long length) throws IOException {
        int toRead;
        byte[] buf = new byte[32768];
        for (long moved = 0L; moved < length; moved += (long)toRead) {
            toRead = (int)Math.min(32768L, length - moved);
            random.nextBytes(buf);
            os.write(buf, 0, toRead);
        }
    }

    public static boolean equalStreams(InputStream a, InputStream b, long size) throws IOException {
        int toRead;
        byte[] aBuffer = new byte[32768];
        byte[] bBuffer = new byte[32768];
        DataInputStream aIn = new DataInputStream(a);
        DataInputStream bIn = new DataInputStream(b);
        for (long checked = 0L; checked < size; checked += (long)toRead) {
            toRead = (int)Math.min(32768L, size - checked);
            aIn.readFully(aBuffer, 0, toRead);
            bIn.readFully(bBuffer, 0, toRead);
            if (MessageDigest.isEqual(aBuffer, bBuffer)) continue;
            return false;
        }
        return true;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
        zis = new ZeroInputStream();
    }

    public static enum CPUArchitecture {
        Unknown,
        X86,
        X86_64,
        PPC_32,
        PPC_64,
        ARM,
        SPARC,
        IA64;

    }

    public static enum OperatingSystem {
        Unknown(false, false, false),
        MacOS(false, true, true),
        Linux(false, false, true),
        FreeBSD(false, false, true),
        GenericUnix(false, false, true),
        Windows(true, false, false);

        public final boolean isWindows;
        public final boolean isMac;
        public final boolean isUnix;

        private OperatingSystem(boolean win, boolean mac, boolean unix) {
            this.isWindows = win;
            this.isMac = mac;
            this.isUnix = unix;
        }
    }
}

