/*
 * Decompiled with CFR 0.152.
 */
package freenet.client;

import freenet.client.ArchiveManager;
import freenet.client.ArchiveStoreItem;
import freenet.keys.FreenetURI;
import freenet.support.DoublyLinkedListImpl;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;

class ArchiveStoreContext {
    private FreenetURI key;
    private final ArchiveManager.ARCHIVE_TYPE archiveType;
    private long lastSize = -1L;
    private byte[] lastHash;
    private final DoublyLinkedListImpl<ArchiveStoreItem> myItems;
    private static volatile boolean logMINOR;

    ArchiveStoreContext(FreenetURI key, ArchiveManager.ARCHIVE_TYPE archiveType) {
        this.key = key;
        this.archiveType = archiveType;
        this.myItems = new DoublyLinkedListImpl();
    }

    long getLastSize() {
        return this.lastSize;
    }

    void setLastSize(long size) {
        this.lastSize = size;
    }

    byte[] getLastHash() {
        return this.lastHash;
    }

    void setLastHash(byte[] realHash) {
        this.lastHash = realHash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAllCachedItems(ArchiveManager manager) {
        ArchiveStoreItem item = null;
        while (true) {
            DoublyLinkedListImpl<ArchiveStoreItem> doublyLinkedListImpl = this.myItems;
            synchronized (doublyLinkedListImpl) {
                item = this.myItems.head();
            }
            if (item == null) break;
            manager.removeCachedItem(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addItem(ArchiveStoreItem item) {
        DoublyLinkedListImpl<ArchiveStoreItem> doublyLinkedListImpl = this.myItems;
        synchronized (doublyLinkedListImpl) {
            this.myItems.push(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeItem(ArchiveStoreItem item) {
        DoublyLinkedListImpl<ArchiveStoreItem> doublyLinkedListImpl = this.myItems;
        synchronized (doublyLinkedListImpl) {
            if (this.myItems.remove(item) == null) {
                if (logMINOR) {
                    Logger.minor(this, "Not removing: " + item + " for " + this + " - already removed");
                }
                return;
            }
        }
        item.innerClose();
    }

    public short getArchiveType() {
        return this.archiveType.metadataID;
    }

    public FreenetURI getKey() {
        return this.key;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

