/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.fcp;

import freenet.clients.fcp.FCPConnectionHandler;
import freenet.clients.fcp.FCPMessage;
import freenet.clients.fcp.MessageInvalidException;
import freenet.clients.fcp.PluginInfoMessage;
import freenet.clients.fcp.ProtocolErrorMessage;
import freenet.keys.FreenetURI;
import freenet.node.Node;
import freenet.pluginmanager.PluginInfoWrapper;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import java.io.File;
import java.net.MalformedURLException;

public class LoadPlugin
extends FCPMessage {
    static final String NAME = "LoadPlugin";
    static final String TYPENAME_FILE = "file";
    static final String TYPENAME_FREENET = "freenet";
    static final String TYPENAME_OFFICIAL = "official";
    static final String TYPENAME_URL = "url";
    private final String identifier;
    private final String pluginURL;
    private final String urlType;
    private final boolean store;
    private final boolean force;
    private final boolean forceHTTPS;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public LoadPlugin(SimpleFieldSet fs) throws MessageInvalidException {
        this.identifier = fs.get("Identifier");
        if (this.identifier == null) {
            throw new MessageInvalidException(5, "Must contain an Identifier field", null, false);
        }
        this.pluginURL = fs.get("PluginURL");
        if (this.pluginURL == null) {
            throw new MessageInvalidException(5, "Must contain a PluginURL field", this.identifier, false);
        }
        String type = fs.get("URLType");
        this.urlType = type != null && type.trim().length() > 0 ? type.trim() : null;
        if (!(this.urlType == null || TYPENAME_FILE.equalsIgnoreCase(this.urlType) || TYPENAME_FREENET.equalsIgnoreCase(this.urlType) || TYPENAME_OFFICIAL.equalsIgnoreCase(this.urlType) || TYPENAME_URL.equalsIgnoreCase(this.urlType))) {
            throw new MessageInvalidException(8, "Unknown URL type: '" + this.urlType + "'", this.identifier, false);
        }
        String officialSource = fs.get("OfficialSource");
        if (officialSource != null) {
            if (officialSource.equalsIgnoreCase("https")) {
                this.force = true;
                this.forceHTTPS = true;
            } else {
                if (!officialSource.equalsIgnoreCase(TYPENAME_FREENET)) throw new MessageInvalidException(8, "Unknown OfficialSource '" + officialSource + "'", this.identifier, false);
                this.force = true;
                this.forceHTTPS = false;
            }
        } else {
            this.force = false;
            this.forceHTTPS = false;
        }
        this.store = fs.getBoolean("Store", false);
    }

    @Override
    public SimpleFieldSet getFieldSet() {
        return new SimpleFieldSet(true);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void run(final FCPConnectionHandler handler, final Node node) throws MessageInvalidException {
        if (!handler.hasFullAccess()) {
            throw new MessageInvalidException(24, "LoadPlugin requires full access", this.identifier, false);
        }
        node.executor.execute(new Runnable(){

            @Override
            public void run() {
                PluginInfoWrapper pi;
                String type = null;
                if (LoadPlugin.this.urlType == null) {
                    if (node.pluginManager.isOfficialPlugin(LoadPlugin.this.pluginURL) != null) {
                        type = LoadPlugin.TYPENAME_OFFICIAL;
                    } else if (new File(LoadPlugin.this.pluginURL).exists()) {
                        type = LoadPlugin.TYPENAME_FILE;
                    } else {
                        try {
                            new FreenetURI(LoadPlugin.this.pluginURL);
                            type = LoadPlugin.TYPENAME_FREENET;
                        }
                        catch (MalformedURLException e) {
                            // empty catch block
                        }
                    }
                    if (type == null) {
                        handler.outputHandler.queue(new ProtocolErrorMessage(8, false, "Was not able to guess the URL type from URL, check the URL or add a 'URLType' field", LoadPlugin.this.identifier, false));
                        return;
                    }
                } else {
                    type = LoadPlugin.this.urlType.toLowerCase();
                }
                if (LoadPlugin.TYPENAME_OFFICIAL.equals(type)) {
                    pi = node.pluginManager.startPluginOfficial(LoadPlugin.this.pluginURL, LoadPlugin.this.store, LoadPlugin.this.force, LoadPlugin.this.forceHTTPS);
                } else if (LoadPlugin.TYPENAME_FILE.equals(type)) {
                    pi = node.pluginManager.startPluginFile(LoadPlugin.this.pluginURL, LoadPlugin.this.store);
                } else if (LoadPlugin.TYPENAME_FREENET.equals(type)) {
                    pi = node.pluginManager.startPluginFreenet(LoadPlugin.this.pluginURL, LoadPlugin.this.store);
                } else if (LoadPlugin.TYPENAME_URL.equals(type)) {
                    pi = node.pluginManager.startPluginURL(LoadPlugin.this.pluginURL, LoadPlugin.this.store);
                } else {
                    Logger.error(this, "This should really not happen!", (Throwable)new Exception("FIXME"));
                    handler.outputHandler.queue(new ProtocolErrorMessage(17, false, "This should really not happen! See logs for details.", LoadPlugin.this.identifier, false));
                    return;
                }
                if (pi == null) {
                    handler.outputHandler.queue(new ProtocolErrorMessage(32, false, "Plugin '" + LoadPlugin.this.pluginURL + "' does not exist or is not a FCP plugin", LoadPlugin.this.identifier, false));
                } else {
                    handler.outputHandler.queue(new PluginInfoMessage(pi, LoadPlugin.this.identifier, true));
                }
            }
        }, "Load Plugin");
    }
}

