/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.crypt.DSAGroup;
import freenet.crypt.DSAPrivateKey;
import freenet.crypt.DSAPublicKey;
import freenet.crypt.DSASignature;
import freenet.crypt.DummyRandomSource;
import freenet.crypt.Global;
import freenet.crypt.RandomSource;
import freenet.crypt.Util;
import freenet.crypt.Yarrow;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import java.io.File;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Random;
import net.i2p.util.NativeBigInteger;

public class DSA {
    private static volatile boolean logMINOR;
    static final BigInteger SIGNATURE_MASK;

    static DSASignature sign(DSAGroup g, DSAPrivateKey x, BigInteger k, BigInteger m, RandomSource random) {
        if (k.signum() == -1) {
            throw new IllegalArgumentException();
        }
        if (m.signum() == -1) {
            throw new IllegalArgumentException();
        }
        if (g.getQ().bitLength() == 256) {
            m = m.and(SIGNATURE_MASK);
        }
        if (m.compareTo(g.getQ()) != -1) {
            throw new IllegalArgumentException();
        }
        BigInteger r = g.getG().modPow(k, g.getP()).mod(g.getQ());
        BigInteger kInv = k.modInverse(g.getQ());
        return DSA.sign(g, x, r, kInv, m, random);
    }

    public static DSASignature sign(DSAGroup g, DSAPrivateKey x, BigInteger m, RandomSource r) {
        BigInteger k = DSA.generateK(g, r);
        return DSA.sign(g, x, k, m, r);
    }

    static DSASignature sign(DSAGroup g, DSAPrivateKey x, BigInteger r, BigInteger kInv, BigInteger m, RandomSource random) {
        BigInteger s1 = m.add(x.getX().multiply(r)).mod(g.getQ());
        BigInteger s = kInv.multiply(s1).mod(g.getQ());
        if (r.compareTo(BigInteger.ZERO) == 0 || s.compareTo(BigInteger.ZERO) == 0) {
            Logger.warning(DSA.class, "R or S equals 0 : Weird behaviour detected, please report if seen too often.");
            return DSA.sign(g, x, DSA.generateK(g, random), m, random);
        }
        return new DSASignature(r, s);
    }

    private static BigInteger generateK(DSAGroup g, Random r) {
        NativeBigInteger k;
        if (g.getQ().bitLength() < 256) {
            throw new IllegalArgumentException("Q is too short! (" + g.getQ().bitLength() + '<' + 256 + ')');
        }
        do {
            k = new NativeBigInteger(256, r);
        } while (g.getQ().compareTo(k) < 1 || k.compareTo(BigInteger.ZERO) < 1);
        return k;
    }

    public static boolean verify(DSAPublicKey kp, DSASignature sig, BigInteger m, boolean forceMod) {
        if (m.signum() == -1) {
            throw new IllegalArgumentException();
        }
        if (kp.getGroup().getQ().bitLength() == 256 && !forceMod) {
            m = m.and(SIGNATURE_MASK);
        }
        try {
            if (sig.getR().compareTo(BigInteger.ZERO) < 1 || kp.getQ().compareTo(sig.getR()) < 1) {
                if (logMINOR) {
                    Logger.minor(DSA.class, "r < 0 || r > q: r=" + sig.getR() + " q=" + kp.getQ());
                }
                return false;
            }
            if (sig.getS().compareTo(BigInteger.ZERO) < 1 || kp.getQ().compareTo(sig.getS()) < 1) {
                if (logMINOR) {
                    Logger.minor(DSA.class, "s < 0 || s > q: s=" + sig.getS() + " q=" + kp.getQ());
                }
                return false;
            }
            BigInteger w = sig.getS().modInverse(kp.getQ());
            BigInteger u1 = m.multiply(w).mod(kp.getQ());
            BigInteger u2 = sig.getR().multiply(w).mod(kp.getQ());
            BigInteger v1 = kp.getG().modPow(u1, kp.getP());
            BigInteger v2 = kp.getY().modPow(u2, kp.getP());
            BigInteger v = v1.multiply(v2).mod(kp.getP()).mod(kp.getQ());
            return v.equals(sig.getR());
        }
        catch (ArithmeticException e) {
            if (logMINOR) {
                Logger.minor(DSA.class, "Verify failed: " + e, (Throwable)e);
            }
            return false;
        }
    }

    public static void main(String[] args) throws Exception {
        SimpleFieldSet fs = args.length >= 1 && args[0].length() != 0 ? SimpleFieldSet.readFrom(new File(args[0]), false, false) : null;
        DSAGroup g = Global.DSAgroupBigA;
        if (fs != null) {
            g = DSAGroup.create(fs.subset("dsaGroup"));
        }
        RandomSource y = new DummyRandomSource();
        if (args.length >= 2 && args[1].equals("yarrow")) {
            y = new Yarrow();
        }
        DSAPrivateKey pk = new DSAPrivateKey(g, y);
        DSAPublicKey pub = new DSAPublicKey(g, pk);
        if (fs != null) {
            pub = DSAPublicKey.create(fs.subset("dsaPubKey"), g);
            pk = DSAPrivateKey.create(fs.subset("dsaPrivKey"), g);
        }
        DSASignature sig = DSA.sign(g, pk, BigInteger.ZERO, y);
        System.err.println(DSA.verify(pub, sig, BigInteger.ZERO, false));
        while (true) {
            long totalTimeSigning = 0L;
            long totalTimeVerifying = 0L;
            long totalRSize = 0L;
            long totalSSize = 0L;
            long totalPubKeySize = 0L;
            long totalPrivKeySize = 0L;
            int maxPrivKeySize = 0;
            int maxPubKeySize = 0;
            int maxRSize = 0;
            int maxSSize = 0;
            int totalRUnsignedBitSize = 0;
            int maxRUnsignedBitSize = 0;
            Random r = new Random(y.nextLong());
            byte[] msg = new byte[32];
            long[] timeSigning = new long[1000];
            long[] timeVerifying = new long[timeSigning.length];
            for (int i = 0; i < timeSigning.length; ++i) {
                r.nextBytes(msg);
                BigInteger m = new BigInteger(1, msg);
                pk = new DSAPrivateKey(g, r);
                int privKeySize = pk.asBytes().length;
                totalPrivKeySize += (long)privKeySize;
                if (privKeySize > maxPrivKeySize) {
                    maxPrivKeySize = privKeySize;
                }
                pub = new DSAPublicKey(g, pk);
                int pubKeySize = pub.asBytes().length;
                totalPubKeySize += (long)pubKeySize;
                if (pubKeySize > maxPubKeySize) {
                    maxPubKeySize = pubKeySize;
                }
                long t1 = System.nanoTime();
                sig = DSA.sign(g, pk, m, y);
                long t2 = System.nanoTime();
                if (!DSA.verify(pub, sig, m, false)) {
                    System.err.println("Failed to verify!");
                }
                long t3 = System.nanoTime();
                totalTimeSigning += t2 - t1;
                timeSigning[i] = t2 - t1;
                totalTimeVerifying += t3 - t2;
                timeVerifying[i] = t3 - t2;
                int rSize = sig.getR().bitLength();
                rSize = (rSize + 7) / 8;
                totalRSize += (long)rSize;
                if (rSize > maxRSize) {
                    maxRSize = rSize;
                }
                int rUnsignedBitSize = sig.getR().bitLength();
                totalRUnsignedBitSize += rUnsignedBitSize;
                maxRUnsignedBitSize = Math.max(maxRUnsignedBitSize, rUnsignedBitSize);
                int sSize = sig.getS().bitLength();
                sSize = (sSize + 7) / 8;
                totalSSize += (long)sSize;
                if (sSize <= maxSSize) continue;
                maxSSize = sSize;
            }
            System.out.println("Total time signing: " + totalTimeSigning);
            Arrays.sort(timeSigning);
            System.out.println("\tavg=" + (double)totalTimeSigning / (double)timeSigning.length + "\tmed=" + timeSigning[timeSigning.length / 2] + "\tmin=" + timeSigning[0] + "\tmax=" + timeSigning[timeSigning.length - 1]);
            System.out.println("Total time verifying: " + totalTimeVerifying);
            Arrays.sort(timeVerifying);
            System.out.println("\tavg=" + (double)totalTimeVerifying / (double)timeVerifying.length + "\tmed=" + timeVerifying[timeVerifying.length / 2] + "\tmin=" + timeVerifying[0] + "\tmax=" + timeVerifying[timeVerifying.length - 1]);
            System.out.println("Total R size: " + totalRSize + " (max " + maxRSize + ')');
            System.out.println("Total S size: " + totalSSize + " (max " + maxSSize + ')');
            System.out.println("Total R unsigned bitsize: " + totalRUnsignedBitSize);
            System.out.println("Total pub key size: " + totalPubKeySize + " (max " + maxPubKeySize + ')');
            System.out.println("Total priv key size: " + totalPrivKeySize + " (max " + maxPrivKeySize + ')');
        }
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
        SIGNATURE_MASK = Util.TWO.pow(255).subtract(BigInteger.ONE);
    }
}

