/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.crypt.Util;
import freenet.node.BasePeerNode;
import freenet.node.MessageFragment;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.SortedSet;
import java.util.TreeSet;

class NPFPacket {
    private static volatile boolean logDEBUG;
    private int sequenceNumber;
    private final SortedSet<Integer> acks = new TreeSet<Integer>();
    private final List<MessageFragment> fragments = new ArrayList<MessageFragment>();
    private final List<byte[]> lossyMessages = new LinkedList<byte[]>();
    private boolean error;
    private int length = 5;
    private int ackRangeCount = 0;
    private int ackBlockByteSize = 0;
    private boolean useCumulativeAcks = true;
    private int oldMsgIDLength;

    NPFPacket() {
    }

    public void setAcknowledgeType(boolean useCumulativeAcks) {
        this.useCumulativeAcks = useCumulativeAcks;
    }

    public static NPFPacket create(byte[] plaintext, BasePeerNode pn) {
        NPFPacket packet = new NPFPacket();
        if (pn == null) {
            throw new IllegalArgumentException("Can't estimate an ack type of received packet");
        }
        boolean useCumAcks = pn.isUseCumulativeAcksSet();
        packet.setAcknowledgeType(useCumAcks);
        int offset = 0;
        if (plaintext.length < offset + 5) {
            packet.error = true;
            return packet;
        }
        packet.sequenceNumber = (plaintext[offset] & 0xFF) << 24 | (plaintext[offset + 1] & 0xFF) << 16 | (plaintext[offset + 2] & 0xFF) << 8 | plaintext[offset + 3] & 0xFF;
        offset += 4;
        if (useCumAcks) {
            int numAckRanges;
            if ((numAckRanges = plaintext[offset++] & 0xFF) > 0) {
                try {
                    int prevAck = 0;
                    for (int i = 0; i < numAckRanges; ++i) {
                        int distanceFromPrevious;
                        int ack;
                        if (i == 0) {
                            ack = (plaintext[offset] & 0xFF) << 24 | (plaintext[offset + 1] & 0xFF) << 16 | (plaintext[offset + 2] & 0xFF) << 8 | plaintext[offset + 3] & 0xFF;
                            offset += 4;
                        } else if ((distanceFromPrevious = plaintext[offset++] & 0xFF) != 0) {
                            ack = prevAck + distanceFromPrevious;
                        } else {
                            ack = (plaintext[offset] & 0xFF) << 24 | (plaintext[offset + 1] & 0xFF) << 16 | (plaintext[offset + 2] & 0xFF) << 8 | plaintext[offset + 3] & 0xFF;
                            offset += 4;
                        }
                        int rangeSize = plaintext[offset++] & 0xFF;
                        for (int j = 1; j <= rangeSize; ++j) {
                            packet.acks.add(ack++);
                        }
                        prevAck = ack - 1;
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    packet.error = true;
                    return packet;
                }
            }
        } else {
            int numAcks;
            if (plaintext.length < offset + (numAcks = plaintext[offset++] & 0xFF) + (numAcks > 0 ? 3 : 0)) {
                packet.error = true;
                return packet;
            }
            int prevAck = 0;
            for (int i = 0; i < numAcks; ++i) {
                int ack = 0;
                if (i == 0) {
                    ack = (plaintext[offset] & 0xFF) << 24 | (plaintext[offset + 1] & 0xFF) << 16 | (plaintext[offset + 2] & 0xFF) << 8 | plaintext[offset + 3] & 0xFF;
                    offset += 4;
                } else {
                    ack = prevAck + (plaintext[offset++] & 0xFF);
                }
                packet.acks.add(ack);
                prevAck = ack;
            }
        }
        int prevFragmentID = -1;
        while (offset < plaintext.length) {
            int fragmentLength;
            boolean firstFragment;
            boolean shortMessage = (plaintext[offset] & 0x80) != 0;
            boolean isFragmented = (plaintext[offset] & 0x40) != 0;
            boolean bl = firstFragment = (plaintext[offset] & 0x20) != 0;
            if (!isFragmented && !firstFragment) {
                offset = NPFPacket.tryParseLossyMessages(packet, plaintext, offset);
                break;
            }
            int messageID = -1;
            if ((plaintext[offset] & 0x10) != 0) {
                if (plaintext.length < offset + 4) {
                    packet.error = true;
                    return packet;
                }
                messageID = (plaintext[offset] & 0xF) << 24 | (plaintext[offset + 1] & 0xFF) << 16 | (plaintext[offset + 2] & 0xFF) << 8 | plaintext[offset + 3] & 0xFF;
                offset += 4;
            } else {
                if (plaintext.length < offset + 2) {
                    packet.error = true;
                    return packet;
                }
                if (prevFragmentID == -1) {
                    Logger.warning(NPFPacket.class, "First fragment doesn't have full message id");
                    packet.error = true;
                    return packet;
                }
                messageID = prevFragmentID + ((plaintext[offset] & 0xF) << 8 | plaintext[offset + 1] & 0xFF);
                offset += 2;
            }
            prevFragmentID = messageID;
            int requiredLength = offset + (shortMessage ? 1 : 2) + (isFragmented ? (shortMessage ? 1 : 3) : 0);
            if (plaintext.length < requiredLength) {
                packet.error = true;
                return packet;
            }
            if (shortMessage) {
                fragmentLength = plaintext[offset++] & 0xFF;
            } else {
                fragmentLength = (plaintext[offset] & 0xFF) << 8 | plaintext[offset + 1] & 0xFF;
                offset += 2;
            }
            int messageLength = -1;
            int fragmentOffset = 0;
            if (isFragmented) {
                int value;
                if (shortMessage) {
                    value = plaintext[offset++] & 0xFF;
                } else {
                    value = (plaintext[offset] & 0xFF) << 8 | plaintext[offset + 1] & 0xFF;
                    offset += 2;
                }
                if (firstFragment) {
                    messageLength = value;
                    if (messageLength == fragmentLength) {
                        Logger.warning(NPFPacket.class, "Received fragmented message, but fragment contains the entire message");
                    }
                } else {
                    fragmentOffset = value;
                }
            } else {
                messageLength = fragmentLength;
            }
            if (offset + fragmentLength > plaintext.length) {
                Logger.error(NPFPacket.class, "Fragment doesn't fit in the received packet: offset is " + offset + " fragment length is " + fragmentLength + " plaintext length is " + plaintext.length + " message length " + messageLength + " message ID " + messageID + (pn == null ? "" : " from " + pn.shortToString()));
                packet.error = true;
                break;
            }
            byte[] fragmentData = Arrays.copyOfRange(plaintext, offset, offset + fragmentLength);
            offset += fragmentLength;
            packet.fragments.add(new MessageFragment(shortMessage, isFragmented, firstFragment, messageID, fragmentLength, messageLength, fragmentOffset, fragmentData, null));
        }
        packet.length = offset;
        return packet;
    }

    private static int tryParseLossyMessages(NPFPacket packet, byte[] plaintext, int offset) {
        int len;
        int origOffset = offset;
        do {
            if (plaintext[offset] != 31) {
                return offset;
            }
            if (++offset >= plaintext.length) {
                packet.lossyMessages.clear();
                return origOffset;
            }
            len = plaintext[offset] & 0xFF;
            if (len > plaintext.length - ++offset) {
                packet.lossyMessages.clear();
                return origOffset;
            }
            byte[] fragment = Arrays.copyOfRange(plaintext, offset, offset + len);
            packet.lossyMessages.add(fragment);
        } while ((offset += len) != plaintext.length);
        return offset;
    }

    public int toBytes(byte[] buf, int offset, Random paddingGen) {
        int origOffset;
        block31: {
            block30: {
                origOffset = offset;
                buf[offset] = (byte)(this.sequenceNumber >>> 24);
                buf[offset + 1] = (byte)(this.sequenceNumber >>> 16);
                buf[offset + 2] = (byte)(this.sequenceNumber >>> 8);
                buf[offset + 3] = (byte)this.sequenceNumber;
                offset += 4;
                if (!this.useCumulativeAcks) break block30;
                buf[offset++] = (byte)this.ackRangeCount;
                Iterator acksIterator = this.acks.iterator();
                if (!acksIterator.hasNext()) break block31;
                int startRange = 0;
                int endRange = -1;
                int nextAck = (Integer)acksIterator.next();
                int i = 0;
                while (acksIterator.hasNext()) {
                    assert (nextAck - endRange >= 0);
                    if (i == 0 || nextAck - endRange >= 254) {
                        if (i != 0) {
                            buf[offset++] = 0;
                        }
                        buf[offset] = (byte)(nextAck >>> 24);
                        buf[offset + 1] = (byte)(nextAck >>> 16);
                        buf[offset + 2] = (byte)(nextAck >>> 8);
                        buf[offset + 3] = (byte)nextAck;
                        offset += 4;
                    } else {
                        assert (nextAck - endRange < 254);
                        buf[offset++] = (byte)(nextAck - endRange);
                    }
                    endRange = startRange = nextAck;
                    while (acksIterator.hasNext() && (nextAck = ((Integer)acksIterator.next()).intValue()) - endRange == 1 && endRange - startRange < 254) {
                        ++endRange;
                    }
                    byte rangeSize = (byte)(endRange - startRange + 1);
                    buf[offset++] = rangeSize;
                    ++i;
                }
                if (nextAck == endRange) break block31;
                assert (nextAck - endRange >= 0);
                if (nextAck - endRange >= 254 && endRange != -1) {
                    buf[offset++] = 0;
                }
                if (this.ackRangeCount == 1 || nextAck - endRange >= 254) {
                    buf[offset] = (byte)(nextAck >>> 24);
                    buf[offset + 1] = (byte)(nextAck >>> 16);
                    buf[offset + 2] = (byte)(nextAck >>> 8);
                    buf[offset + 3] = (byte)nextAck;
                    offset += 4;
                    buf[offset++] = 1;
                } else {
                    buf[offset++] = (byte)(nextAck - endRange);
                    buf[offset++] = 1;
                }
                break block31;
            }
            buf[offset++] = (byte)this.acks.size();
            Iterator acksIterator = this.acks.iterator();
            if (acksIterator.hasNext()) {
                int prevAck = (Integer)acksIterator.next();
                buf[offset] = (byte)(prevAck >>> 24);
                buf[offset + 1] = (byte)(prevAck >>> 16);
                buf[offset + 2] = (byte)(prevAck >>> 8);
                buf[offset + 3] = (byte)prevAck;
                offset += 4;
                while (acksIterator.hasNext()) {
                    int ack = (Integer)acksIterator.next();
                    buf[offset++] = (byte)(ack - prevAck);
                    prevAck = ack;
                }
            }
        }
        int prevFragmentID = -1;
        for (MessageFragment fragment : this.fragments) {
            if (fragment.shortMessage) {
                buf[offset] = (byte)(buf[offset] & 0xFF | 0x80);
            }
            if (fragment.isFragmented) {
                buf[offset] = (byte)(buf[offset] & 0xFF | 0x40);
            }
            if (fragment.firstFragment) {
                buf[offset] = (byte)(buf[offset] & 0xFF | 0x20);
            }
            if (prevFragmentID == -1 || fragment.messageID - prevFragmentID >= 4096) {
                buf[offset] = (byte)(buf[offset] & 0xFF | 0x10);
                buf[offset] = (byte)(buf[offset] & 0xFF | fragment.messageID >>> 24 & 0xF);
                buf[offset + 1] = (byte)(fragment.messageID >>> 16);
                buf[offset + 2] = (byte)(fragment.messageID >>> 8);
                buf[offset + 3] = (byte)fragment.messageID;
                offset += 4;
            } else {
                int compressedMsgID = fragment.messageID - prevFragmentID;
                buf[offset] = (byte)(buf[offset] & 0xFF | compressedMsgID >>> 8 & 0xF);
                buf[offset + 1] = (byte)compressedMsgID;
                offset += 2;
            }
            prevFragmentID = fragment.messageID;
            if (fragment.shortMessage) {
                buf[offset++] = (byte)fragment.fragmentLength;
            } else {
                buf[offset] = (byte)(fragment.fragmentLength >>> 8);
                buf[offset + 1] = (byte)fragment.fragmentLength;
                offset += 2;
            }
            if (fragment.isFragmented) {
                int value;
                int n = value = fragment.firstFragment ? fragment.messageLength : fragment.fragmentOffset;
                if (fragment.shortMessage) {
                    buf[offset++] = (byte)value;
                } else {
                    buf[offset] = (byte)(value >>> 8);
                    buf[offset + 1] = (byte)value;
                    offset += 2;
                }
            }
            System.arraycopy(fragment.fragmentData, 0, buf, offset, fragment.fragmentLength);
            offset += fragment.fragmentLength;
        }
        if (!this.lossyMessages.isEmpty()) {
            for (byte[] msg : this.lossyMessages) {
                buf[offset++] = 31;
                assert (msg.length <= 255);
                buf[offset++] = (byte)msg.length;
                System.arraycopy(msg, 0, buf, offset, msg.length);
                offset += msg.length;
            }
        }
        assert (offset - origOffset == this.length);
        if (offset < buf.length) {
            Util.randomBytes(paddingGen, buf, offset, buf.length - offset);
            int b = buf[offset] & 0x9F;
            if (b == 31) {
                b = -97;
            }
            buf[offset] = b;
        }
        return offset;
    }

    public boolean addAck(int ack, int maxPacketSize) {
        if (ack < 0) {
            throw new IllegalArgumentException("Got negative ack: " + ack);
        }
        if (this.acks.contains(ack)) {
            return true;
        }
        if (this.useCumulativeAcks) {
            this.acks.add(ack);
            int nearRangeCount = 0;
            int farRangeCount = 0;
            Iterator acksIterator = this.acks.iterator();
            int startRange = 0;
            int endRange = -1;
            int nextAck = (Integer)acksIterator.next();
            while (acksIterator.hasNext()) {
                if (nextAck - endRange > 254 && endRange != -1) {
                    ++farRangeCount;
                } else {
                    ++nearRangeCount;
                }
                endRange = startRange = nextAck;
                while (acksIterator.hasNext() && (nextAck = ((Integer)acksIterator.next()).intValue()) - endRange == 1 && endRange - startRange < 254) {
                    ++endRange;
                }
            }
            if (nextAck != endRange) {
                if (nextAck - endRange < 254 || endRange == -1) {
                    ++nearRangeCount;
                } else {
                    ++farRangeCount;
                }
            }
            if (nearRangeCount + farRangeCount > 254) {
                this.acks.remove(ack);
                return false;
            }
            int blockSize = 5 + (nearRangeCount - 1) * 2 + farRangeCount * 6;
            int finalLength = this.length + blockSize - this.ackBlockByteSize;
            if (finalLength > maxPacketSize) {
                this.acks.remove(ack);
                return false;
            }
            this.length = finalLength;
            this.ackBlockByteSize = blockSize;
            this.ackRangeCount = farRangeCount + nearRangeCount;
        } else {
            if (this.acks.size() >= 255) {
                return false;
            }
            if (this.acks.size() == 0) {
                this.length += 3;
            } else if (ack < this.acks.first() ? this.acks.first() - ack > 255 : ack > this.acks.last() && ack - this.acks.last() > 255) {
                return false;
            }
            this.acks.add(ack);
            ++this.length;
        }
        return true;
    }

    public int addMessageFragment(MessageFragment frag) {
        this.length += frag.length();
        this.fragments.add(frag);
        Collections.sort(this.fragments, new MessageFragmentComparator());
        int msgIDLength = 0;
        int prevMessageID = -1;
        for (MessageFragment fragment : this.fragments) {
            if (prevMessageID == -1 || fragment.messageID - prevMessageID >= 4096) {
                msgIDLength += 2;
            }
            prevMessageID = fragment.messageID;
        }
        this.length += msgIDLength - this.oldMsgIDLength;
        this.oldMsgIDLength = msgIDLength;
        return this.length;
    }

    public int addLossyMessage(byte[] buf) {
        if (buf.length > 255) {
            throw new IllegalArgumentException();
        }
        this.lossyMessages.add(buf);
        this.length += buf.length + 2;
        return this.length;
    }

    public boolean addLossyMessage(byte[] buf, int maxPacketSize) {
        if (this.length + buf.length + 2 > maxPacketSize) {
            return false;
        }
        if (buf.length > 255) {
            throw new IllegalArgumentException();
        }
        this.lossyMessages.add(buf);
        this.length += buf.length + 2;
        return true;
    }

    public void removeLossyMessage(byte[] buf) {
        if (this.lossyMessages.remove(buf)) {
            this.length -= buf.length + 2;
        }
    }

    public List<byte[]> getLossyMessages() {
        return this.lossyMessages;
    }

    public boolean getError() {
        return this.error;
    }

    public List<MessageFragment> getFragments() {
        return this.fragments;
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(int sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public SortedSet<Integer> getAcks() {
        return this.acks;
    }

    public int getLength() {
        return this.length;
    }

    public String toString() {
        return "Packet " + this.sequenceNumber + ": " + this.length + " bytes, " + this.acks.size() + " acks, " + this.fragments.size() + " fragments";
    }

    public void onSent(int totalPacketLength, BasePeerNode pn) {
        int totalMessageData = 0;
        int size = this.fragments.size();
        int biggest = 0;
        for (MessageFragment frag : this.fragments) {
            totalMessageData += frag.fragmentLength;
            ++size;
            if (biggest >= frag.messageLength) continue;
            biggest = frag.messageLength;
        }
        int overhead = totalPacketLength - totalMessageData;
        if (logDEBUG) {
            Logger.debug(this, "Total packet overhead: " + overhead + " for " + size + " messages total message length " + totalMessageData + " total packet length " + totalPacketLength + " biggest message " + biggest);
        }
        for (MessageFragment frag : this.fragments) {
            frag.wrapper.onSent(frag.fragmentOffset, frag.fragmentOffset + frag.fragmentLength - 1, overhead / size, pn);
        }
    }

    String fragmentsAsString() {
        return Arrays.toString(this.fragments.toArray());
    }

    public int countAcks() {
        return this.acks.size();
    }

    public boolean noFragments() {
        return this.fragments.isEmpty();
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logDEBUG = Logger.shouldLog(Logger.LogLevel.DEBUG, (Object)this);
            }
        });
    }

    private static class MessageFragmentComparator
    implements Comparator<MessageFragment> {
        private MessageFragmentComparator() {
        }

        @Override
        public int compare(MessageFragment frag1, MessageFragment frag2) {
            if (frag1.messageID < frag2.messageID) {
                return -1;
            }
            if (frag1.messageID == frag2.messageID) {
                return 0;
            }
            return 1;
        }
    }
}

