/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.io.comm.FreenetInetAddress;
import freenet.io.comm.Peer;
import freenet.io.comm.PeerParseException;
import freenet.io.comm.ReferenceSignatureVerificationException;
import freenet.node.FSParseException;
import freenet.node.Node;
import freenet.node.NodeCrypto;
import freenet.node.OpennetManager;
import freenet.node.PeerNode;
import freenet.node.PeerNodeStatus;
import freenet.node.PeerTooOldException;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;

public class SeedServerPeerNode
extends PeerNode {
    public SeedServerPeerNode(SimpleFieldSet fs, Node node2, NodeCrypto crypto, boolean fromLocal) throws FSParseException, PeerParseException, ReferenceSignatureVerificationException, PeerTooOldException {
        super(fs, node2, crypto, fromLocal);
    }

    @Override
    public PeerNodeStatus getStatus(boolean noHeavy) {
        return new PeerNodeStatus(this, noHeavy);
    }

    @Override
    public boolean isDarknet() {
        return false;
    }

    @Override
    public boolean isOpennet() {
        return false;
    }

    @Override
    public boolean isSeed() {
        return true;
    }

    @Override
    public boolean isRealConnection() {
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SeedServerPeerNode) {
            return super.equals(o);
        }
        return false;
    }

    @Override
    public void onSuccess(boolean insert, boolean ssk) {
    }

    @Override
    public boolean isRoutingCompatible() {
        return false;
    }

    @Override
    public boolean recordStatus() {
        return false;
    }

    @Override
    protected void sendInitialMessages() {
        super.sendInitialMessages();
        final OpennetManager om = this.node.getOpennet();
        if (om == null) {
            Logger.normal(this, "Opennet turned off while connecting to seednodes");
            this.node.peers.disconnectAndRemove(this, true, true, true);
        } else {
            this.node.getTicker().queueTimedJob(new Runnable(){

                @Override
                public void run() {
                    try {
                        om.announcer.maybeSendAnnouncement();
                    }
                    catch (Throwable t) {
                        Logger.error(this, "Caught " + t, t);
                    }
                }
            }, TimeUnit.SECONDS.toMillis(5L));
        }
    }

    public InetAddress[] getInetAddresses() {
        ArrayList<InetAddress> v = new ArrayList<InetAddress>();
        for (Peer peer : this.getHandshakeIPs()) {
            InetAddress ia;
            FreenetInetAddress fa = peer.getFreenetAddress().dropHostname();
            if (fa == null || v.contains(ia = fa.getAddress())) continue;
            v.add(ia);
        }
        if (v.isEmpty()) {
            Logger.error(this, "No valid addresses for seed node " + this);
        }
        return v.toArray(new InetAddress[v.size()]);
    }

    @Override
    public boolean handshakeUnknownInitiator() {
        return true;
    }

    @Override
    public int handshakeSetupType() {
        return 1;
    }

    @Override
    public boolean disconnected(boolean dumpMessageQueue, boolean dumpTrackers) {
        boolean ret = super.disconnected(dumpMessageQueue, dumpTrackers);
        this.node.peers.disconnectAndRemove(this, false, false, false);
        return ret;
    }

    @Override
    public boolean shouldDisconnectAndRemoveNow() {
        OpennetManager om = this.node.getOpennet();
        if (om == null) {
            return true;
        }
        if (!om.announcer.enoughPeers()) {
            return false;
        }
        return System.currentTimeMillis() - om.announcer.timeGotEnoughPeers() > TimeUnit.MINUTES.toMillis(5L);
    }

    @Override
    protected void maybeClearPeerAddedTimeOnConnect() {
    }

    @Override
    protected boolean shouldExportPeerAddedTime() {
        return true;
    }

    @Override
    protected void maybeClearPeerAddedTimeOnRestart(long now) {
    }

    @Override
    public void fatalTimeout() {
        this.forceDisconnect();
    }

    @Override
    public boolean shallWeRouteAccordingToOurPeersLocation() {
        return false;
    }

    @Override
    boolean dontKeepFullFieldSet() {
        return false;
    }

    @Override
    public boolean isOpennetForNoderef() {
        return true;
    }

    @Override
    public boolean canAcceptAnnouncements() {
        return false;
    }

    @Override
    protected void writePeers() {
    }
}

