/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.client.MetadataUnresolvedException;
import freenet.client.async.TooManyFilesInsertException;
import freenet.clients.fcp.IdentifierCollisionException;
import freenet.clients.fcp.NotAllowedException;
import freenet.clients.fcp.PersistentRequestClient;
import freenet.keys.FreenetURI;
import freenet.node.NodeClientCore;
import freenet.node.RequestClient;
import freenet.node.fcp.FCPClient;
import freenet.support.io.ResumeFailedException;
import java.io.IOException;

public abstract class ClientRequest {
    protected FreenetURI uri;
    protected final String identifier;
    protected final int verbosity;
    protected final FCPClient client;
    protected short priorityClass;
    protected final String charset;
    protected boolean finished;
    protected String clientToken;
    protected final boolean global;
    protected final long startupTime;
    protected long completionTime;
    protected long lastActivity;
    protected final RequestClient lowLevelClient;
    public static final short PERSIST_CONNECTION = 0;
    public static final short PERSIST_REBOOT = 1;
    public static final short PERSIST_FOREVER = 2;
    protected boolean started;

    protected ClientRequest() {
        throw new UnsupportedOperationException();
    }

    public static String persistenceTypeString(short type) {
        switch (type) {
            case 0: {
                return "connection";
            }
            case 1: {
                return "reboot";
            }
            case 2: {
                return "forever";
            }
        }
        return Short.toString(type);
    }

    public static short parsePersistence(String string) {
        if (string == null || string.equalsIgnoreCase("connection")) {
            return 0;
        }
        if (string.equalsIgnoreCase("reboot")) {
            return 1;
        }
        if (string.equalsIgnoreCase("forever")) {
            return 2;
        }
        return Short.parseShort(string);
    }

    public boolean hasFinished() {
        return this.finished;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public short getPriority() {
        return this.priorityClass;
    }

    public boolean isStarted() {
        return this.started;
    }

    public long getLastActivity() {
        return this.lastActivity;
    }

    protected boolean isGlobalQueue() {
        if (this.client == null) {
            return false;
        }
        return this.client.isGlobalQueue;
    }

    public FCPClient getClient() {
        return this.client;
    }

    protected boolean isRealTime(ObjectContainer container) {
        if (this.lowLevelClient != null) {
            container.activate((Object)this.lowLevelClient, Integer.MAX_VALUE);
            return this.lowLevelClient.realTimeFlag();
        }
        return false;
    }

    public abstract freenet.clients.fcp.ClientRequest migrate(PersistentRequestClient var1, ObjectContainer var2, NodeClientCore var3) throws IdentifierCollisionException, NotAllowedException, IOException, ResumeFailedException, MetadataUnresolvedException, TooManyFilesInsertException;
}

