/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import com.db4o.ext.Db4oIOException;
import com.db4o.io.IoAdapter;
import freenet.crypt.BlockCipher;
import freenet.crypt.UnsupportedCipherException;
import freenet.crypt.ciphers.Rijndael;
import freenet.node.MasterKeys;
import freenet.support.Fields;
import freenet.support.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Random;

public class EncryptingIoAdapter
extends IoAdapter {
    private final IoAdapter baseAdapter;
    private final Random random;
    private final byte[] key;
    private final BlockCipher cipher;
    private long position;
    private byte[] blockOutput;
    private long blockPosition;
    static final int BLOCK_SIZE_BYTES = 32;

    public EncryptingIoAdapter(IoAdapter baseAdapter2, byte[] databaseKey, Random random) {
        this.baseAdapter = baseAdapter2;
        this.key = (byte[])databaseKey.clone();
        this.random = random;
        this.position = 0L;
        this.blockPosition = -1L;
        this.blockOutput = new byte[32];
        try {
            this.cipher = new Rijndael(256, 256);
        }
        catch (UnsupportedCipherException e) {
            throw new Error(e);
        }
        this.cipher.initialize(databaseKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws Db4oIOException {
        this.baseAdapter.close();
        EncryptingIoAdapter encryptingIoAdapter = this;
        synchronized (encryptingIoAdapter) {
            MasterKeys.clear(this.key);
        }
    }

    public void delete(String arg0) {
        byte[] seed = new byte[32];
        this.random.nextBytes(seed);
        try {
            FileUtil.secureDelete(new File(arg0));
        }
        catch (IOException e) {
            System.err.println("Unable to secure delete " + arg0 + " for db4o, passing on to underlying adapter " + this.baseAdapter + " to attempt a normal deletion.");
            this.baseAdapter.delete(arg0);
        }
    }

    public boolean exists(String arg0) {
        return this.baseAdapter.exists(arg0);
    }

    public long getLength() throws Db4oIOException {
        return this.baseAdapter.getLength();
    }

    public IoAdapter open(String arg0, boolean arg1, long arg2, boolean arg3) throws Db4oIOException {
        EncryptingIoAdapter adapter = new EncryptingIoAdapter(this.baseAdapter.open(arg0, arg1, arg2, arg3), this.key, this.random);
        adapter.seek(0L);
        return adapter;
    }

    public synchronized int read(byte[] buffer, int length) throws Db4oIOException {
        int decrypt;
        int readBytes;
        try {
            readBytes = this.baseAdapter.read(buffer, length);
        }
        catch (Db4oIOException e) {
            System.err.println("Unable to read: " + (Object)((Object)e));
            e.printStackTrace();
            try {
                this.baseAdapter.seek(this.position);
            }
            catch (Db4oIOException e1) {
                System.err.println("Unable to seek, closing database file: " + (Object)((Object)e1));
                e1.printStackTrace();
                this.close();
            }
            throw e;
        }
        if (readBytes <= 0) {
            return readBytes;
        }
        int totalDecrypted = 0;
        int blockOffset = (int)(this.position % 32L);
        int blockRemaining = 32 - blockOffset;
        for (int toDecrypt = readBytes; toDecrypt > 0; toDecrypt -= decrypt) {
            decrypt = Math.min(toDecrypt, blockRemaining);
            long thisBlockPosition = this.position - (long)blockOffset;
            if (this.blockPosition != thisBlockPosition) {
                byte[] input = (byte[])this.key.clone();
                byte[] counter = Fields.longToBytes(thisBlockPosition);
                for (int i = 0; i < counter.length; ++i) {
                    int n = this.key.length - 8 + i;
                    input[n] = (byte)(input[n] ^ counter[i]);
                }
                this.cipher.encipher(input, this.blockOutput);
                this.blockPosition = thisBlockPosition;
            }
            for (int i = 0; i < decrypt; ++i) {
                int n = i + totalDecrypted;
                buffer[n] = (byte)(buffer[n] ^ this.blockOutput[i + blockOffset]);
            }
            this.position += (long)decrypt;
            totalDecrypted += decrypt;
            blockOffset = 0;
            blockRemaining = 32;
        }
        return readBytes;
    }

    public synchronized void seek(long arg0) throws Db4oIOException {
        if (arg0 < 0L) {
            throw new IllegalArgumentException();
        }
        this.baseAdapter.seek(arg0);
        this.position = arg0;
    }

    public void sync() throws Db4oIOException {
        this.baseAdapter.sync();
    }

    public synchronized void write(byte[] inputBuffer, int length) throws Db4oIOException {
        int decrypt;
        byte[] buffer = Arrays.copyOf(inputBuffer, length);
        int totalDecrypted = 0;
        int blockOffset = (int)(this.position % 32L);
        int blockRemaining = 32 - blockOffset;
        for (int toDecrypt = length; toDecrypt > 0; toDecrypt -= decrypt) {
            decrypt = Math.min(toDecrypt, blockRemaining);
            long thisBlockPosition = this.position - (long)blockOffset;
            if (this.blockPosition != thisBlockPosition) {
                byte[] input = (byte[])this.key.clone();
                byte[] counter = Fields.longToBytes(thisBlockPosition);
                for (int i = 0; i < counter.length; ++i) {
                    int n = this.key.length - 8 + i;
                    input[n] = (byte)(input[n] ^ counter[i]);
                }
                this.cipher.encipher(input, this.blockOutput);
                this.blockPosition = thisBlockPosition;
            }
            for (int i = 0; i < decrypt; ++i) {
                int n = i + totalDecrypted;
                buffer[n] = (byte)(buffer[n] ^ this.blockOutput[i + blockOffset]);
            }
            this.position += (long)decrypt;
            totalDecrypted += decrypt;
            blockOffset = 0;
            blockRemaining = 32;
        }
        try {
            this.baseAdapter.write(buffer, length);
        }
        catch (Db4oIOException e) {
            System.err.println("Unable to write: " + (Object)((Object)e));
            e.printStackTrace();
            try {
                this.baseAdapter.seek(this.position);
            }
            catch (Db4oIOException e1) {
                System.err.println("Unable to seek, closing database file: " + (Object)((Object)e1));
                e1.printStackTrace();
                this.close();
            }
            throw e;
        }
    }
}

