/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.node.Location;
import freenet.support.Logger;
import java.util.Arrays;

public class PeerLocation {
    private double currentLocation;
    private double[] currentPeersLocation;
    private long locSetTime;

    PeerLocation(String locationString) {
        this.currentLocation = Location.getLocation(locationString);
        this.locSetTime = System.currentTimeMillis();
    }

    public synchronized String toString() {
        return Double.toString(this.currentLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPeerLocations(String[] peerLocationsString) {
        if (peerLocationsString != null) {
            double[] peerLocations = new double[peerLocationsString.length];
            for (int i = 0; i < peerLocationsString.length; ++i) {
                peerLocations[i] = Location.getLocation(peerLocationsString[i]);
            }
            PeerLocation peerLocation = this;
            synchronized (peerLocation) {
                this.currentPeersLocation = peerLocations;
            }
        }
    }

    public synchronized double getLocation() {
        return this.currentLocation;
    }

    synchronized double[] getPeerLocations() {
        return this.currentPeersLocation;
    }

    public synchronized long getLocationSetTime() {
        return this.locSetTime;
    }

    public synchronized boolean isValidLocation() {
        return Location.isValid(this.currentLocation);
    }

    public synchronized int getDegree() {
        if (this.currentPeersLocation == null) {
            return 0;
        }
        return this.currentPeersLocation.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean updateLocation(double newLoc, double[] newLocs) {
        if (!Location.isValid(newLoc)) {
            Logger.error(this, "Invalid location update for " + this + " (" + newLoc + ')', (Throwable)new Exception("error"));
            return false;
        }
        for (double currentLoc : newLocs) {
            if (Location.isValid(currentLoc)) continue;
            Logger.error(this, "Invalid location update for " + this + " (" + currentLoc + ')', (Throwable)new Exception("error"));
            return false;
        }
        Arrays.sort(newLocs);
        boolean anythingChanged = false;
        PeerLocation peerLocation = this;
        synchronized (peerLocation) {
            if (!Location.equals(this.currentLocation, newLoc)) {
                anythingChanged = true;
            }
            this.currentLocation = newLoc;
            if (this.currentPeersLocation == null) {
                anythingChanged = true;
            } else if (this.currentPeersLocation != null && !anythingChanged) {
                if (this.currentPeersLocation.length != newLocs.length) {
                    anythingChanged = true;
                } else {
                    for (int i = 0; i < this.currentPeersLocation.length; ++i) {
                        if (Location.equals(this.currentPeersLocation[i], newLocs[i])) continue;
                        anythingChanged = true;
                        break;
                    }
                }
            }
            this.currentPeersLocation = newLocs;
            this.locSetTime = System.currentTimeMillis();
        }
        return anythingChanged;
    }

    synchronized double setLocation(double newLoc) {
        double oldLoc = this.currentLocation;
        if (!Location.equals(newLoc, this.currentLocation)) {
            this.currentLocation = newLoc;
            this.locSetTime = System.currentTimeMillis();
        }
        return oldLoc;
    }
}

