/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.client.async.ClientContext;
import freenet.client.async.ClientRequestScheduler;
import freenet.config.Config;
import freenet.config.EnumerableOptionCallback;
import freenet.config.InvalidConfigValueException;
import freenet.config.SubConfig;
import freenet.crypt.RandomSource;
import freenet.keys.Key;
import freenet.node.BaseRequestThrottle;
import freenet.node.Node;
import freenet.node.NodeClientCore;
import freenet.node.NodeStats;
import freenet.node.RequestStarter;
import freenet.node.ThrottleWindowManager;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import freenet.support.TimeUtil;
import freenet.support.api.StringCallback;
import freenet.support.math.BootstrappingDecayingRunningAverage;
import java.util.concurrent.TimeUnit;

public class RequestStarterGroup {
    private static volatile boolean logMINOR;
    private final ThrottleWindowManager throttleWindowBulk;
    private final ThrottleWindowManager throttleWindowRT;
    private final ThrottleWindowManager throttleWindowCHK;
    private final ThrottleWindowManager throttleWindowSSK;
    private final ThrottleWindowManager throttleWindowInsert;
    private final ThrottleWindowManager throttleWindowRequest;
    final MyRequestThrottle chkRequestThrottleBulk;
    final RequestStarter chkRequestStarterBulk;
    final MyRequestThrottle chkInsertThrottleBulk;
    final RequestStarter chkInsertStarterBulk;
    final MyRequestThrottle sskRequestThrottleBulk;
    final RequestStarter sskRequestStarterBulk;
    final MyRequestThrottle sskInsertThrottleBulk;
    final RequestStarter sskInsertStarterBulk;
    final MyRequestThrottle chkRequestThrottleRT;
    final RequestStarter chkRequestStarterRT;
    final MyRequestThrottle chkInsertThrottleRT;
    final RequestStarter chkInsertStarterRT;
    final MyRequestThrottle sskRequestThrottleRT;
    final RequestStarter sskRequestStarterRT;
    final MyRequestThrottle sskInsertThrottleRT;
    final RequestStarter sskInsertStarterRT;
    public final ClientRequestScheduler chkFetchSchedulerBulk;
    public final ClientRequestScheduler chkPutSchedulerBulk;
    public final ClientRequestScheduler sskFetchSchedulerBulk;
    public final ClientRequestScheduler sskPutSchedulerBulk;
    public final ClientRequestScheduler chkFetchSchedulerRT;
    public final ClientRequestScheduler chkPutSchedulerRT;
    public final ClientRequestScheduler sskFetchSchedulerRT;
    public final ClientRequestScheduler sskPutSchedulerRT;
    private final NodeStats stats;

    RequestStarterGroup(Node node, NodeClientCore core, int portNumber, RandomSource random, Config config, SimpleFieldSet fs, ClientContext ctx, long dbHandle) throws InvalidConfigValueException {
        SubConfig schedulerConfig = new SubConfig("node.scheduler", config);
        this.stats = core.nodeStats;
        this.throttleWindowBulk = new ThrottleWindowManager(2.0, fs == null ? null : fs.subset("ThrottleWindow"), node);
        this.throttleWindowRT = new ThrottleWindowManager(2.0, fs == null ? null : fs.subset("ThrottleWindowRT"), node);
        this.throttleWindowCHK = new ThrottleWindowManager(2.0, fs == null ? null : fs.subset("ThrottleWindowCHK"), node);
        this.throttleWindowSSK = new ThrottleWindowManager(2.0, fs == null ? null : fs.subset("ThrottleWindowSSK"), node);
        this.throttleWindowInsert = new ThrottleWindowManager(2.0, fs == null ? null : fs.subset("ThrottleWindowInsert"), node);
        this.throttleWindowRequest = new ThrottleWindowManager(2.0, fs == null ? null : fs.subset("ThrottleWindowRequest"), node);
        this.chkRequestThrottleBulk = new MyRequestThrottle(5000, "CHK Request", fs == null ? null : fs.subset("CHKRequestThrottle"), 32768, false);
        this.chkRequestThrottleRT = new MyRequestThrottle(5000, "CHK Request (RT)", fs == null ? null : fs.subset("CHKRequestThrottleRT"), 32768, true);
        this.chkRequestStarterBulk = new RequestStarter(core, this.chkRequestThrottleBulk, "CHK Request starter (" + portNumber + ')', this.stats.requestOutputThrottle, this.stats.requestInputThrottle, this.stats.localChkFetchBytesSentAverage, this.stats.localChkFetchBytesReceivedAverage, false, false, false);
        this.chkRequestStarterRT = new RequestStarter(core, this.chkRequestThrottleRT, "CHK Request starter (" + portNumber + ')', this.stats.requestOutputThrottle, this.stats.requestInputThrottle, this.stats.localChkFetchBytesSentAverage, this.stats.localChkFetchBytesReceivedAverage, false, false, true);
        this.chkFetchSchedulerBulk = new ClientRequestScheduler(false, false, false, random, this.chkRequestStarterBulk, node, core, "CHKrequester", ctx);
        this.chkFetchSchedulerRT = new ClientRequestScheduler(false, false, true, random, this.chkRequestStarterRT, node, core, "CHKrequester", ctx);
        this.chkRequestStarterBulk.setScheduler(this.chkFetchSchedulerBulk);
        this.chkRequestStarterRT.setScheduler(this.chkFetchSchedulerRT);
        this.registerSchedulerConfig(schedulerConfig, "CHKrequester", this.chkFetchSchedulerBulk, this.chkFetchSchedulerRT, false, false);
        this.chkInsertThrottleBulk = new MyRequestThrottle(20000, "CHK Insert", fs == null ? null : fs.subset("CHKInsertThrottle"), 32768, false);
        this.chkInsertThrottleRT = new MyRequestThrottle(20000, "CHK Insert (RT)", fs == null ? null : fs.subset("CHKInsertThrottleRT"), 32768, true);
        this.chkInsertStarterBulk = new RequestStarter(core, this.chkInsertThrottleBulk, "CHK Insert starter (" + portNumber + ')', this.stats.requestOutputThrottle, this.stats.requestInputThrottle, this.stats.localChkInsertBytesSentAverage, this.stats.localChkInsertBytesReceivedAverage, true, false, false);
        this.chkInsertStarterRT = new RequestStarter(core, this.chkInsertThrottleRT, "CHK Insert starter (" + portNumber + ')', this.stats.requestOutputThrottle, this.stats.requestInputThrottle, this.stats.localChkInsertBytesSentAverage, this.stats.localChkInsertBytesReceivedAverage, true, false, true);
        this.chkPutSchedulerBulk = new ClientRequestScheduler(true, false, false, random, this.chkInsertStarterBulk, node, core, "CHKinserter", ctx);
        this.chkPutSchedulerRT = new ClientRequestScheduler(true, false, true, random, this.chkInsertStarterRT, node, core, "CHKinserter", ctx);
        this.chkInsertStarterBulk.setScheduler(this.chkPutSchedulerBulk);
        this.chkInsertStarterRT.setScheduler(this.chkPutSchedulerRT);
        this.registerSchedulerConfig(schedulerConfig, "CHKinserter", this.chkPutSchedulerBulk, this.chkPutSchedulerRT, false, true);
        this.sskRequestThrottleBulk = new MyRequestThrottle(5000, "SSK Request", fs == null ? null : fs.subset("SSKRequestThrottle"), 1024, false);
        this.sskRequestThrottleRT = new MyRequestThrottle(5000, "SSK Request (RT)", fs == null ? null : fs.subset("SSKRequestThrottleRT"), 1024, true);
        this.sskRequestStarterBulk = new RequestStarter(core, this.sskRequestThrottleBulk, "SSK Request starter (" + portNumber + ')', this.stats.requestOutputThrottle, this.stats.requestInputThrottle, this.stats.localSskFetchBytesSentAverage, this.stats.localSskFetchBytesReceivedAverage, false, true, false);
        this.sskRequestStarterRT = new RequestStarter(core, this.sskRequestThrottleRT, "SSK Request starter (" + portNumber + ')', this.stats.requestOutputThrottle, this.stats.requestInputThrottle, this.stats.localSskFetchBytesSentAverage, this.stats.localSskFetchBytesReceivedAverage, false, true, true);
        this.sskFetchSchedulerBulk = new ClientRequestScheduler(false, true, false, random, this.sskRequestStarterBulk, node, core, "SSKrequester", ctx);
        this.sskFetchSchedulerRT = new ClientRequestScheduler(false, true, true, random, this.sskRequestStarterRT, node, core, "SSKrequester", ctx);
        this.sskRequestStarterBulk.setScheduler(this.sskFetchSchedulerBulk);
        this.sskRequestStarterRT.setScheduler(this.sskFetchSchedulerRT);
        this.registerSchedulerConfig(schedulerConfig, "SSKrequester", this.sskFetchSchedulerBulk, this.sskFetchSchedulerRT, true, false);
        this.sskInsertThrottleBulk = new MyRequestThrottle(20000, "SSK Insert", fs == null ? null : fs.subset("SSKInsertThrottle"), 1024, false);
        this.sskInsertThrottleRT = new MyRequestThrottle(20000, "SSK Insert", fs == null ? null : fs.subset("SSKInsertThrottleRT"), 1024, true);
        this.sskInsertStarterBulk = new RequestStarter(core, this.sskInsertThrottleBulk, "SSK Insert starter (" + portNumber + ')', this.stats.requestOutputThrottle, this.stats.requestInputThrottle, this.stats.localSskInsertBytesSentAverage, this.stats.localSskFetchBytesReceivedAverage, true, true, false);
        this.sskInsertStarterRT = new RequestStarter(core, this.sskInsertThrottleRT, "SSK Insert starter (" + portNumber + ')', this.stats.requestOutputThrottle, this.stats.requestInputThrottle, this.stats.localSskInsertBytesSentAverage, this.stats.localSskFetchBytesReceivedAverage, true, true, true);
        this.sskPutSchedulerBulk = new ClientRequestScheduler(true, true, false, random, this.sskInsertStarterBulk, node, core, "SSKinserter", ctx);
        this.sskPutSchedulerRT = new ClientRequestScheduler(true, true, true, random, this.sskInsertStarterRT, node, core, "SSKinserter", ctx);
        this.sskInsertStarterBulk.setScheduler(this.sskPutSchedulerBulk);
        this.sskInsertStarterRT.setScheduler(this.sskPutSchedulerRT);
        this.registerSchedulerConfig(schedulerConfig, "SSKinserter", this.sskPutSchedulerBulk, this.sskPutSchedulerRT, true, true);
        schedulerConfig.finishedInitialization();
    }

    private void registerSchedulerConfig(SubConfig schedulerConfig, String name, ClientRequestScheduler csBulk, ClientRequestScheduler csRT, boolean forSSKs, boolean forInserts) throws InvalidConfigValueException {
        PrioritySchedulerCallback callback = new PrioritySchedulerCallback();
        schedulerConfig.register(name + "_priority_policy", "SOFT", name.hashCode(), true, false, "RequestStarterGroup.scheduler" + (forSSKs ? "SSK" : "CHK") + (forInserts ? "Inserts" : "Requests"), "RequestStarterGroup.schedulerLong", callback);
        callback.init(csRT, csBulk, schedulerConfig.getString(name + "_priority_policy"));
    }

    public void start() {
        this.chkRequestStarterRT.start();
        this.chkInsertStarterRT.start();
        this.sskRequestStarterRT.start();
        this.sskInsertStarterRT.start();
        this.chkRequestStarterBulk.start();
        this.chkInsertStarterBulk.start();
        this.sskRequestStarterBulk.start();
        this.sskInsertStarterBulk.start();
    }

    public ThrottleWindowManager getThrottleWindow(boolean realTime) {
        if (realTime) {
            return this.throttleWindowRT;
        }
        return this.throttleWindowBulk;
    }

    public void requestCompleted(boolean isSSK, boolean isInsert, Key key, boolean realTime) {
        this.getThrottleWindow(realTime).requestCompleted();
        (isSSK ? this.throttleWindowSSK : this.throttleWindowCHK).requestCompleted();
        (isInsert ? this.throttleWindowInsert : this.throttleWindowRequest).requestCompleted();
        this.stats.reportOutgoingRequestLocation(key.toNormalizedDouble());
    }

    public void rejectedOverload(boolean isSSK, boolean isInsert, boolean realTime) {
        this.getThrottleWindow(realTime).rejectedOverload();
        (isSSK ? this.throttleWindowSSK : this.throttleWindowCHK).rejectedOverload();
        (isInsert ? this.throttleWindowInsert : this.throttleWindowRequest).rejectedOverload();
    }

    SimpleFieldSet persistToFieldSet() {
        SimpleFieldSet fs = new SimpleFieldSet(false);
        fs.put("ThrottleWindow", this.throttleWindowBulk.exportFieldSet(false));
        fs.put("ThrottleWindowRT", this.throttleWindowRT.exportFieldSet(false));
        fs.put("ThrottleWindowCHK", this.throttleWindowCHK.exportFieldSet(false));
        fs.put("ThrottleWindowSSK", this.throttleWindowCHK.exportFieldSet(false));
        fs.put("CHKRequestThrottle", this.chkRequestThrottleBulk.exportFieldSet());
        fs.put("SSKRequestThrottle", this.sskRequestThrottleBulk.exportFieldSet());
        fs.put("CHKInsertThrottle", this.chkInsertThrottleBulk.exportFieldSet());
        fs.put("SSKInsertThrottle", this.sskInsertThrottleBulk.exportFieldSet());
        fs.put("CHKRequestThrottleRT", this.chkRequestThrottleRT.exportFieldSet());
        fs.put("SSKRequestThrottleRT", this.sskRequestThrottleRT.exportFieldSet());
        fs.put("CHKInsertThrottleRT", this.chkInsertThrottleRT.exportFieldSet());
        fs.put("SSKInsertThrottleRT", this.sskInsertThrottleRT.exportFieldSet());
        return fs;
    }

    public double getWindow(boolean realTime) {
        return this.getThrottleWindow(realTime).currentValue(realTime);
    }

    public double getRTT(boolean isSSK, boolean isInsert, boolean realTime) {
        return this.getThrottle(isSSK, isInsert, realTime).getRTT();
    }

    public double getDelay(boolean isSSK, boolean isInsert, boolean realTime) {
        return this.getThrottle(isSSK, isInsert, realTime).getDelay();
    }

    MyRequestThrottle getThrottle(boolean isSSK, boolean isInsert, boolean realTime) {
        if (realTime) {
            if (isSSK) {
                if (isInsert) {
                    return this.sskInsertThrottleRT;
                }
                return this.sskRequestThrottleRT;
            }
            if (isInsert) {
                return this.chkInsertThrottleRT;
            }
            return this.chkRequestThrottleRT;
        }
        if (isSSK) {
            if (isInsert) {
                return this.sskInsertThrottleBulk;
            }
            return this.sskRequestThrottleBulk;
        }
        if (isInsert) {
            return this.chkInsertThrottleBulk;
        }
        return this.chkRequestThrottleBulk;
    }

    public String statsPageLine(boolean isSSK, boolean isInsert, boolean realTime) {
        StringBuilder sb = new StringBuilder(100);
        sb.append(isSSK ? "SSK" : "CHK");
        sb.append(' ');
        sb.append(isInsert ? "Insert" : "Request");
        sb.append(' ');
        sb.append(realTime ? "RealTime" : "Bulk");
        sb.append(" RTT=");
        MyRequestThrottle throttle = this.getThrottle(isSSK, isInsert, realTime);
        sb.append(TimeUtil.formatTime((long)throttle.getRTT(), 2, true));
        sb.append(" delay=");
        sb.append(TimeUtil.formatTime(throttle.getDelay(), 2, true));
        sb.append(" bw=");
        sb.append(throttle.getRate());
        sb.append("B/sec");
        return sb.toString();
    }

    public String diagnosticThrottlesLine(boolean mode) {
        StringBuilder sb = new StringBuilder();
        if (mode) {
            sb.append("Request window: ");
            sb.append(this.throttleWindowRequest.toString());
            sb.append(", Insert window: ");
            sb.append(this.throttleWindowInsert.toString());
        } else {
            sb.append("CHK window: ");
            sb.append(this.throttleWindowCHK.toString());
            sb.append(", SSK window: ");
            sb.append(this.throttleWindowSSK.toString());
        }
        return sb.toString();
    }

    public double getRealWindow(boolean realTime) {
        return this.getThrottleWindow(realTime).realCurrentValue();
    }

    public long countQueuedRequests() {
        return this.chkFetchSchedulerBulk.countQueuedRequests() + this.sskFetchSchedulerBulk.countQueuedRequests() + this.chkPutSchedulerBulk.countQueuedRequests() + this.sskPutSchedulerBulk.countQueuedRequests() + this.chkFetchSchedulerRT.countQueuedRequests() + this.sskFetchSchedulerRT.countQueuedRequests() + this.chkPutSchedulerRT.countQueuedRequests() + this.sskPutSchedulerRT.countQueuedRequests();
    }

    public ClientRequestScheduler getScheduler(boolean ssk, boolean insert, boolean realTime) {
        if (realTime) {
            if (insert) {
                return ssk ? this.sskPutSchedulerRT : this.chkPutSchedulerRT;
            }
            return ssk ? this.sskFetchSchedulerRT : this.chkFetchSchedulerRT;
        }
        if (insert) {
            return ssk ? this.sskPutSchedulerBulk : this.chkPutSchedulerBulk;
        }
        return ssk ? this.sskFetchSchedulerBulk : this.chkFetchSchedulerBulk;
    }

    public void setGlobalSalt(byte[] salt) {
        this.chkFetchSchedulerBulk.startCore(salt);
        this.sskFetchSchedulerBulk.startCore(salt);
        this.chkPutSchedulerBulk.startCore(salt);
        this.sskPutSchedulerBulk.startCore(salt);
        this.chkFetchSchedulerRT.startCore(salt);
        this.sskFetchSchedulerRT.startCore(salt);
        this.chkPutSchedulerRT.startCore(salt);
        this.sskPutSchedulerRT.startCore(salt);
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }

    public static class PrioritySchedulerCallback
    extends StringCallback
    implements EnumerableOptionCallback {
        ClientRequestScheduler csRT;
        ClientRequestScheduler csBulk;
        private final String[] possibleValues = new String[]{"HARD", "SOFT"};

        public void init(ClientRequestScheduler csRT, ClientRequestScheduler csBulk, String config) throws InvalidConfigValueException {
            this.csRT = csRT;
            this.csBulk = csBulk;
            this.set(config);
        }

        @Override
        public String get() {
            if (this.csBulk != null) {
                return this.csBulk.getChoosenPriorityScheduler();
            }
            return "SOFT";
        }

        @Override
        public void set(String val) throws InvalidConfigValueException {
            String value;
            if (val == null || val.equalsIgnoreCase(this.get())) {
                return;
            }
            if (val.equalsIgnoreCase("HARD")) {
                value = "HARD";
            } else if (val.equalsIgnoreCase("SOFT")) {
                value = "SOFT";
            } else {
                throw new InvalidConfigValueException("Invalid priority scheme");
            }
            this.csBulk.setPriorityScheduler(value);
            this.csRT.setPriorityScheduler(value);
        }

        @Override
        public String[] getPossibleValues() {
            return this.possibleValues;
        }
    }

    public class MyRequestThrottle
    implements BaseRequestThrottle {
        private final BootstrappingDecayingRunningAverage roundTripTime;
        private final int size;
        private final boolean realTime;

        public MyRequestThrottle(int rtt, String string, SimpleFieldSet fs, int size, boolean realTime) {
            this.roundTripTime = new BootstrappingDecayingRunningAverage(rtt, 10.0, TimeUnit.MINUTES.toMillis(5L), 10, fs == null ? null : fs.subset("RoundTripTime"));
            this.size = size;
            this.realTime = realTime;
        }

        @Override
        public synchronized long getDelay() {
            double rtt = this.roundTripTime.currentValue();
            double winSizeForMinPacketDelay = rtt / (double)MIN_DELAY;
            double _simulatedWindowSize = this.getThrottleWindow().currentValue(this.realTime);
            if (_simulatedWindowSize > winSizeForMinPacketDelay) {
                _simulatedWindowSize = winSizeForMinPacketDelay;
            }
            if (_simulatedWindowSize < 1.0) {
                _simulatedWindowSize = 1.0;
            }
            return Math.max(MIN_DELAY, Math.min((long)(rtt / _simulatedWindowSize), MAX_DELAY));
        }

        private ThrottleWindowManager getThrottleWindow() {
            return RequestStarterGroup.this.getThrottleWindow(this.realTime);
        }

        public synchronized void successfulCompletion(long rtt) {
            this.roundTripTime.report(Math.max(rtt, 10L));
            if (logMINOR) {
                Logger.minor(this, "Reported successful completion: " + rtt + " on " + this + " avg " + this.roundTripTime.currentValue());
            }
        }

        public String toString() {
            return "rtt: " + this.roundTripTime.currentValue() + " _s=" + this.getThrottleWindow().currentValue(this.realTime) + " RT=" + this.realTime;
        }

        public SimpleFieldSet exportFieldSet() {
            SimpleFieldSet fs = new SimpleFieldSet(false);
            fs.put("RoundTripTime", this.roundTripTime.exportFieldSet(false));
            return fs;
        }

        public double getRTT() {
            return this.roundTripTime.currentValue();
        }

        public long getRate() {
            return (long)(1000.0 / (double)this.getDelay() * (double)this.size);
        }
    }
}

