/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.fcp;

import com.db4o.ObjectContainer;
import freenet.client.FetchContext;
import freenet.client.FetchException;
import freenet.client.async.ClientContext;
import freenet.client.events.ExpectedFileSizeEvent;
import freenet.client.events.ExpectedHashesEvent;
import freenet.client.events.ExpectedMIMEEvent;
import freenet.client.events.SendingToNetworkEvent;
import freenet.client.events.SplitfileCompatibilityModeEvent;
import freenet.clients.fcp.ClientGet;
import freenet.clients.fcp.IdentifierCollisionException;
import freenet.clients.fcp.NotAllowedException;
import freenet.clients.fcp.PersistentRequestClient;
import freenet.node.NodeClientCore;
import freenet.node.fcp.AllDataMessage;
import freenet.node.fcp.ClientRequest;
import freenet.node.fcp.CompatibilityMode;
import freenet.node.fcp.ExpectedHashes;
import freenet.node.fcp.GetFailedMessage;
import freenet.node.fcp.ProtocolErrorMessage;
import freenet.support.api.Bucket;
import freenet.support.io.ResumeFailedException;
import java.io.File;
import java.io.IOException;

public class ClientGet
extends ClientRequest {
    private final FetchContext fctx;
    private final short returnType;
    private final File targetFile;
    private final File tempFile;
    private final boolean binaryBlob;
    private boolean succeeded;
    private long foundDataLength = -1L;
    private String foundDataMimeType;
    private GetFailedMessage getFailedMessage;
    private ProtocolErrorMessage postFetchProtocolErrorMessage;
    private AllDataMessage allDataPending;
    private boolean sentToNetwork;
    private CompatibilityMode compatMessage;
    private ExpectedHashes expectedHashes;
    static final short RETURN_TYPE_DIRECT = 0;
    static final short RETURN_TYPE_NONE = 1;
    static final short RETURN_TYPE_DISK = 2;
    static final short RETURN_TYPE_CHUNKED = 3;

    @Override
    public freenet.clients.fcp.ClientGet migrate(PersistentRequestClient newClient, ObjectContainer container, NodeClientCore core) throws IdentifierCollisionException, NotAllowedException, IOException, ResumeFailedException {
        container.activate((Object)this.fctx, Integer.MAX_VALUE);
        container.activate((Object)this.uri, Integer.MAX_VALUE);
        container.activate((Object)this.targetFile, Integer.MAX_VALUE);
        File f = this.targetFile;
        if (f != null) {
            f = new File(f.toString());
        }
        boolean realTime = this.isRealTime(container);
        freenet.clients.fcp.ClientGet ret = new freenet.clients.fcp.ClientGet(newClient, this.uri, this.fctx.localRequestOnly, this.fctx.ignoreStore, this.fctx.filterData, this.fctx.maxSplitfileBlockRetries, this.fctx.maxNonSplitfileRetries, this.fctx.maxOutputLength, ClientGet.ReturnType.getByCode(this.returnType), false, this.identifier, this.verbosity, this.priorityClass, f, this.charset, this.fctx.canWriteClientCache, realTime, this.binaryBlob, core);
        if (this.finished) {
            ClientContext context = core.clientContext;
            if (this.getFailedMessage != null) {
                container.activate((Object)this.getFailedMessage, Integer.MAX_VALUE);
                if (this.getFailedMessage.expectedMimeType != null) {
                    this.foundDataMimeType = this.getFailedMessage.expectedMimeType;
                }
            }
            if (this.foundDataLength >= 0L) {
                ret.receive(new ExpectedFileSizeEvent(this.foundDataLength), context);
            }
            if (this.foundDataMimeType != null) {
                ret.receive(new ExpectedMIMEEvent(this.foundDataMimeType), context);
            }
            if (this.sentToNetwork) {
                ret.receive(new SendingToNetworkEvent(), context);
            }
            if (this.expectedHashes != null) {
                container.activate((Object)this.expectedHashes, Integer.MAX_VALUE);
                if (this.expectedHashes.hashes != null) {
                    ret.receive(new ExpectedHashesEvent(this.expectedHashes.hashes), context);
                }
            }
            if (this.compatMessage != null) {
                container.activate((Object)this.compatMessage, Integer.MAX_VALUE);
                SplitfileCompatibilityModeEvent e = this.compatMessage.toEvent();
                ret.receive(e, context);
            }
            if (this.succeeded) {
                if (this.foundDataLength <= 0L) {
                    throw new ResumeFailedException("No data");
                }
                Bucket data = null;
                if (this.returnType == 0) {
                    container.activate((Object)this.allDataPending, Integer.MAX_VALUE);
                    data = this.allDataPending.bucket;
                    if (data == null) {
                        throw new ResumeFailedException("No data");
                    }
                    data.onResume(context);
                }
                ret.setSuccessForMigration(context, this.completionTime, data);
            } else if (this.getFailedMessage != null) {
                ret.onFailure(this.getFailedMessage.getFetchException(), null);
            } else if (this.postFetchProtocolErrorMessage != null) {
                this.tempFile.delete();
                ret.onFailure(new FetchException(FetchException.FetchExceptionMode.BUCKET_ERROR, "Failed to rename before migration. We have deleted the file."), null);
            }
        }
        return ret;
    }

    protected ClientGet() {
        throw new UnsupportedOperationException();
    }
}

