/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import freenet.client.async.ClientContext;
import freenet.support.Logger;
import freenet.support.api.LockableRandomAccessBuffer;
import freenet.support.io.FileUtil;
import freenet.support.io.ResumeFailedException;
import freenet.support.io.StorageFormatException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;

public class FileRandomAccessBuffer
implements LockableRandomAccessBuffer,
Serializable {
    private static final long serialVersionUID = 1L;
    transient RandomAccessFile raf;
    final File file;
    private boolean closed = false;
    private final long length;
    private final boolean readOnly;
    private boolean secureDelete;
    static final int MAGIC = -586200398;
    static final int VERSION = 1;

    public FileRandomAccessBuffer(RandomAccessFile raf, File filename, boolean readOnly) throws IOException {
        this.raf = raf;
        this.file = filename;
        this.length = raf.length();
        this.readOnly = readOnly;
    }

    public FileRandomAccessBuffer(File filename, long length, boolean readOnly) throws IOException {
        this.raf = new RandomAccessFile(filename, readOnly ? "r" : "rw");
        this.raf.setLength(length);
        this.length = length;
        this.file = filename;
        this.readOnly = readOnly;
    }

    public FileRandomAccessBuffer(File filename, boolean readOnly) throws IOException {
        this.raf = new RandomAccessFile(filename, readOnly ? "r" : "rw");
        this.length = this.raf.length();
        this.file = filename;
        this.readOnly = readOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pread(long fileOffset, byte[] buf, int bufOffset, int length) throws IOException {
        if (fileOffset < 0L) {
            throw new IllegalArgumentException();
        }
        if (fileOffset + (long)length > this.length) {
            throw new IOException("Length limit exceeded reading " + length + " bytes from " + fileOffset + " of " + this.length);
        }
        FileRandomAccessBuffer fileRandomAccessBuffer = this;
        synchronized (fileRandomAccessBuffer) {
            this.raf.seek(fileOffset);
            this.raf.readFully(buf, bufOffset, length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pwrite(long fileOffset, byte[] buf, int bufOffset, int length) throws IOException {
        if (fileOffset < 0L) {
            throw new IllegalArgumentException();
        }
        if (fileOffset + (long)length > this.length) {
            throw new IOException("Length limit exceeded writing " + length + " bytes from " + fileOffset + " of " + this.length);
        }
        if (this.readOnly) {
            throw new IOException("Read only");
        }
        FileRandomAccessBuffer fileRandomAccessBuffer = this;
        synchronized (fileRandomAccessBuffer) {
            this.raf.seek(fileOffset);
            this.raf.write(buf, bufOffset, length);
        }
    }

    @Override
    public long size() {
        return this.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        FileRandomAccessBuffer fileRandomAccessBuffer = this;
        synchronized (fileRandomAccessBuffer) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        try {
            this.raf.close();
        }
        catch (IOException e) {
            Logger.error(this, "Could not close " + this.raf + " : " + e + " for " + this, (Throwable)e);
        }
    }

    @Override
    public LockableRandomAccessBuffer.RAFLock lockOpen() {
        return new LockableRandomAccessBuffer.RAFLock(){

            @Override
            protected void innerUnlock() {
            }
        };
    }

    @Override
    public void free() {
        this.close();
        if (this.secureDelete) {
            try {
                FileUtil.secureDelete(this.file);
            }
            catch (IOException e) {
                Logger.error(this, "Unable to delete " + this.file + " : " + e, (Throwable)e);
                System.err.println("Unable to delete temporary file " + this.file);
            }
        } else {
            this.file.delete();
        }
    }

    public void setSecureDelete(boolean secureDelete) {
        this.secureDelete = secureDelete;
    }

    @Override
    public void onResume(ClientContext context) throws ResumeFailedException {
        if (!this.file.exists()) {
            throw new ResumeFailedException("File does not exist any more");
        }
        if (this.file.length() != this.length) {
            throw new ResumeFailedException("File is wrong length");
        }
        try {
            this.raf = new RandomAccessFile(this.file, this.readOnly ? "r" : "rw");
        }
        catch (FileNotFoundException e) {
            throw new ResumeFailedException("File does not exist any more");
        }
    }

    @Override
    public void storeTo(DataOutputStream dos) throws IOException {
        dos.writeInt(-586200398);
        dos.writeInt(1);
        dos.writeUTF(this.file.toString());
        dos.writeBoolean(this.readOnly);
        dos.writeLong(this.length);
        dos.writeBoolean(this.secureDelete);
    }

    public FileRandomAccessBuffer(DataInputStream dis) throws IOException, StorageFormatException, ResumeFailedException {
        int version = dis.readInt();
        if (version != 1) {
            throw new StorageFormatException("Bad version");
        }
        this.file = new File(dis.readUTF());
        this.readOnly = dis.readBoolean();
        this.length = dis.readLong();
        this.secureDelete = dis.readBoolean();
        if (this.length < 0L) {
            throw new StorageFormatException("Bad length");
        }
        if (!this.file.exists()) {
            throw new ResumeFailedException("File does not exist");
        }
        if (this.length > this.file.length()) {
            throw new ResumeFailedException("Bad length");
        }
        this.raf = new RandomAccessFile(this.file, this.readOnly ? "r" : "rw");
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
        result = 31 * result + (int)(this.length ^ this.length >>> 32);
        result = 31 * result + (this.readOnly ? 1231 : 1237);
        result = 31 * result + (this.secureDelete ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileRandomAccessBuffer other = (FileRandomAccessBuffer)obj;
        if (!this.file.equals(other.file)) {
            return false;
        }
        if (this.length != other.length) {
            return false;
        }
        if (this.readOnly != other.readOnly) {
            return false;
        }
        return this.secureDelete == other.secureDelete;
    }
}

