/*
 * Decompiled with CFR 0.152.
 */
package freenet.io;

import freenet.io.AddressTrackerItem;
import freenet.node.FSParseException;
import freenet.support.SimpleFieldSet;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class InetAddressAddressTrackerItem
extends AddressTrackerItem {
    public final InetAddress addr;

    public InetAddressAddressTrackerItem(long timeDefinitelyNoPacketsReceived, long timeDefinitelyNoPacketsSent, InetAddress addr) {
        super(timeDefinitelyNoPacketsReceived, timeDefinitelyNoPacketsSent);
        this.addr = addr;
    }

    @Override
    public SimpleFieldSet toFieldSet() {
        SimpleFieldSet fs = super.toFieldSet();
        fs.putOverwrite("Address", this.addr.getHostAddress());
        return fs;
    }

    public InetAddressAddressTrackerItem(SimpleFieldSet fs) throws FSParseException {
        super(fs);
        try {
            this.addr = InetAddress.getByName(fs.getString("Address"));
        }
        catch (UnknownHostException e) {
            throw (FSParseException)new FSParseException("Unknown domain name in Address: " + e).initCause(e);
        }
    }
}

