/*
 * Decompiled with CFR 0.152.
 */
package freenet.io.comm;

import freenet.io.comm.AsyncMessageFilterCallback;
import freenet.io.comm.ByteCounter;
import freenet.io.comm.IncorrectTypeException;
import freenet.io.comm.Message;
import freenet.io.comm.MessageType;
import freenet.io.comm.PeerContext;
import freenet.io.comm.SlowAsyncMessageFilterCallback;
import freenet.node.PrioRunnable;
import freenet.support.Executor;
import freenet.support.Logger;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public final class MessageFilter {
    private static volatile boolean logMINOR;
    public static final String VERSION = "$Id: MessageFilter.java,v 1.7 2005/08/25 17:28:19 amphibian Exp $";
    private boolean _matched;
    private PeerContext _droppedConnection;
    private MessageType _type;
    private final HashMap<String, Object> _fields = new HashMap();
    private final List<String> _fieldList = new LinkedList<String>();
    private PeerContext _source;
    private long _timeout;
    private boolean _timeoutFromWait = true;
    private long _initialTimeout;
    private MessageFilter _or;
    private Message _message;
    private long _oldBootID;
    private AsyncMessageFilterCallback _callback;
    private ByteCounter _ctr;
    private boolean _setTimeout = false;

    private MessageFilter() {
    }

    public static MessageFilter create() {
        return new MessageFilter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onStartWaiting(boolean waitFor) {
        MessageFilter messageFilter = this;
        synchronized (messageFilter) {
            if (waitFor && this._callback != null) {
                throw new IllegalStateException("Cannot wait on a MessageFilter with a callback!");
            }
            if (!this._setTimeout) {
                throw new IllegalStateException("No timeout set on filter " + this + "; cannot wait.");
            }
            if (this._initialTimeout > 0L && this._timeoutFromWait) {
                this._timeout = System.currentTimeMillis() + this._initialTimeout;
            }
        }
        if (this._or != null) {
            this._or.onStartWaiting(waitFor);
        }
    }

    public MessageFilter setTimeoutRelativeToCreation(boolean b) {
        this._timeoutFromWait = !b;
        return this;
    }

    public MessageFilter setTimeout(long timeout) {
        this._setTimeout = true;
        this._initialTimeout = timeout;
        this._timeout = System.currentTimeMillis() + timeout;
        return this;
    }

    public MessageFilter setNoTimeout() {
        this._setTimeout = true;
        this._timeout = Long.MAX_VALUE;
        this._initialTimeout = 0L;
        return this;
    }

    public MessageFilter setType(MessageType type) {
        this._type = type;
        return this;
    }

    public MessageFilter setSource(PeerContext source) {
        this._source = source;
        if (source != null) {
            this._oldBootID = source.getBootID();
        }
        return this;
    }

    public PeerContext getSource() {
        return this._source;
    }

    public MessageFilter setField(String fieldName, boolean value) {
        return this.setField(fieldName, (Object)value);
    }

    public MessageFilter setField(String fieldName, byte value) {
        return this.setField(fieldName, (Object)value);
    }

    public MessageFilter setField(String fieldName, short value) {
        return this.setField(fieldName, (Object)value);
    }

    public MessageFilter setField(String fieldName, int value) {
        return this.setField(fieldName, (Object)value);
    }

    public MessageFilter setField(String fieldName, long value) {
        return this.setField(fieldName, (Object)value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageFilter setField(String fieldName, Object fieldValue) {
        if (this._type != null && !this._type.checkType(fieldName, fieldValue)) {
            throw new IncorrectTypeException("Got " + fieldValue.getClass() + ", expected " + this._type.typeOf(fieldName) + " for " + this._type.getName());
        }
        HashMap<String, Object> hashMap = this._fields;
        synchronized (hashMap) {
            if (this._fields.put(fieldName, fieldValue) == null) {
                this._fieldList.add(fieldName);
            }
        }
        return this;
    }

    public MessageFilter or(MessageFilter or) {
        if (or != null && this._or != null && or != this._or) {
            throw new IllegalStateException("Setting a second .or() on the same filter will replace the existing one, not add another. " + this._or + " would be replaced by " + or + ".");
        }
        if (or._initialTimeout != this._initialTimeout) {
            Logger.error(this, "Message filters being or()ed have different timeouts! This is very dangerous! This is " + this + " or is " + or);
        }
        this._or = or;
        return this;
    }

    public MessageFilter setAsyncCallback(AsyncMessageFilterCallback cb, ByteCounter ctr) {
        this._callback = cb;
        this._ctr = ctr;
        return this;
    }

    public MATCHED match(Message m, long now) {
        return this.match(m, false, now);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MATCHED match(Message m, boolean noTimeout, long now) {
        MATCHED matched;
        if (this._or != null && (matched = this._or.match(m, noTimeout, now)) != MATCHED.NONE) {
            return matched;
        }
        if (this._type != null && !this._type.equals(m.getSpec())) {
            if (this._timeout < now) {
                return MATCHED.TIMED_OUT;
            }
            return MATCHED.NONE;
        }
        if (this._source != null && !this._source.equals(m.getSource())) {
            if (this._timeout < now) {
                return MATCHED.TIMED_OUT;
            }
            return MATCHED.NONE;
        }
        HashMap<String, Object> hashMap = this._fields;
        synchronized (hashMap) {
            for (String fieldName : this._fieldList) {
                if (!m.isSet(fieldName)) {
                    if (this._timeout < now) {
                        return MATCHED.TIMED_OUT;
                    }
                    return MATCHED.NONE;
                }
                if (this._fields.get(fieldName).equals(m.getFromPayload(fieldName))) continue;
                if (this._timeout < now) {
                    return MATCHED.TIMED_OUT;
                }
                return MATCHED.NONE;
            }
        }
        if (!noTimeout && this.reallyTimedOut(now)) {
            if (logMINOR) {
                Logger.minor(this, "Matched but timed out: " + this);
            }
            return MATCHED.TIMED_OUT_AND_MATCHED;
        }
        return MATCHED.MATCHED;
    }

    public boolean matched() {
        return this._matched;
    }

    public PeerContext droppedConnection() {
        return this._droppedConnection;
    }

    boolean reallyTimedOut(long time) {
        if (this._callback != null && this._callback.shouldTimeout()) {
            this._timeout = -1L;
        }
        return this._timeout < time;
    }

    boolean timedOut(long time) {
        if (this._matched) {
            Logger.error(this, "Impossible: filter already matched in timedOut(): " + this, (Throwable)new Exception("error"));
            return true;
        }
        return this.reallyTimedOut(time);
    }

    public Message getMessage() {
        return this._message;
    }

    public synchronized void setMessage(Message message) {
        this._message = message;
        this._matched = true;
        this.notifyAll();
    }

    public long getInitialTimeout() {
        return this._initialTimeout;
    }

    public long getTimeout() {
        return this._timeout;
    }

    public String toString() {
        return super.toString() + ":" + this._type.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearMatched() {
        MessageFilter or;
        MessageFilter messageFilter = this;
        synchronized (messageFilter) {
            this._matched = false;
            this._message = null;
            or = this._or;
        }
        if (or != null) {
            or.clearMatched();
        }
    }

    public void clearOr() {
        this._or = null;
    }

    public boolean matchesDroppedConnection(PeerContext ctx) {
        if (this._source == ctx) {
            return true;
        }
        if (this._or != null) {
            return this._or.matchesDroppedConnection(ctx);
        }
        return false;
    }

    public boolean matchesRestartedConnection(PeerContext ctx) {
        if (this._source == ctx) {
            return true;
        }
        if (this._or != null) {
            return this._or.matchesRestartedConnection(ctx);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDroppedConnection(final PeerContext ctx, Executor executor) {
        AsyncMessageFilterCallback cb;
        MessageFilter messageFilter = this;
        synchronized (messageFilter) {
            cb = this._callback;
            this._droppedConnection = ctx;
            this.notifyAll();
            this._ctr = null;
        }
        if (cb != null) {
            if (cb instanceof SlowAsyncMessageFilterCallback) {
                executor.execute(new PrioRunnable(){

                    @Override
                    public void run() {
                        cb.onDisconnect(ctx);
                    }

                    @Override
                    public int getPriority() {
                        return ((SlowAsyncMessageFilterCallback)cb).getPriority();
                    }
                });
            } else {
                cb.onDisconnect(ctx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRestartedConnection(final PeerContext ctx, Executor executor) {
        AsyncMessageFilterCallback cb;
        MessageFilter messageFilter = this;
        synchronized (messageFilter) {
            this._droppedConnection = ctx;
            cb = this._callback;
            this.notifyAll();
            this._ctr = null;
        }
        if (cb != null) {
            if (cb instanceof SlowAsyncMessageFilterCallback) {
                executor.execute(new PrioRunnable(){

                    @Override
                    public void run() {
                        cb.onRestarted(ctx);
                    }

                    @Override
                    public int getPriority() {
                        return ((SlowAsyncMessageFilterCallback)cb).getPriority();
                    }
                });
            } else {
                cb.onRestarted(ctx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMatched(Executor executor) {
        ByteCounter ctr;
        AsyncMessageFilterCallback cb;
        Message msg;
        MessageFilter messageFilter = this;
        synchronized (messageFilter) {
            msg = this._message;
            cb = this._callback;
            ctr = this._ctr;
            if (this._callback != null) {
                this.clearMatched();
            }
        }
        if (cb != null) {
            if (cb instanceof SlowAsyncMessageFilterCallback) {
                executor.execute(new PrioRunnable(){

                    @Override
                    public void run() {
                        cb.onMatched(msg);
                    }

                    @Override
                    public int getPriority() {
                        return ((SlowAsyncMessageFilterCallback)cb).getPriority();
                    }
                }, "Slow callback for " + cb);
            } else {
                cb.onMatched(msg);
            }
            if (ctr != null) {
                ctr.receivedBytes(msg._receivedByteCount);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTimedOut(Executor executor) {
        AsyncMessageFilterCallback cb;
        MessageFilter messageFilter = this;
        synchronized (messageFilter) {
            this.notifyAll();
            cb = this._callback;
        }
        if (cb != null) {
            if (cb instanceof SlowAsyncMessageFilterCallback) {
                executor.execute(new PrioRunnable(){

                    @Override
                    public void run() {
                        cb.onTimeout();
                    }

                    @Override
                    public int getPriority() {
                        return ((SlowAsyncMessageFilterCallback)cb).getPriority();
                    }
                });
            } else {
                cb.onTimeout();
            }
        }
    }

    public boolean anyConnectionsDropped() {
        if (this._matched) {
            return false;
        }
        if (this._source != null) {
            if (!this._source.isConnected()) {
                return true;
            }
            if (this._source.getBootID() != this._oldBootID) {
                return true;
            }
        }
        if (this._or != null) {
            return this._or.anyConnectionsDropped();
        }
        return false;
    }

    public synchronized boolean hasCallback() {
        return this._callback != null;
    }

    static {
        Logger.registerClass(MessageFilter.class);
    }

    static enum MATCHED {
        MATCHED,
        TIMED_OUT,
        TIMED_OUT_AND_MATCHED,
        NONE;

    }
}

