/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.crypt.HMAC;
import freenet.io.comm.ByteCounter;
import freenet.io.comm.DMT;
import freenet.io.comm.Dispatcher;
import freenet.io.comm.Message;
import freenet.io.comm.MessageType;
import freenet.io.comm.NotConnectedException;
import freenet.io.comm.Peer;
import freenet.keys.Key;
import freenet.keys.KeyBlock;
import freenet.keys.NodeCHK;
import freenet.keys.NodeSSK;
import freenet.node.AnnounceSender;
import freenet.node.AnnouncementCallback;
import freenet.node.CHKInsertHandler;
import freenet.node.DarknetPeerNode;
import freenet.node.InsertTag;
import freenet.node.Node;
import freenet.node.NodeStats;
import freenet.node.OfferReplyTag;
import freenet.node.OpennetManager;
import freenet.node.OpennetPeerNode;
import freenet.node.PeerNode;
import freenet.node.PrioRunnable;
import freenet.node.RequestHandler;
import freenet.node.RequestTag;
import freenet.node.RequestTracker;
import freenet.node.SSKInsertHandler;
import freenet.node.SeedClientPeerNode;
import freenet.node.probe.Probe;
import freenet.store.BlockMetadata;
import freenet.support.Fields;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.ShortBuffer;
import freenet.support.io.NativeThread;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.concurrent.ArrayBlockingQueue;

public class NodeDispatcher
implements Dispatcher,
Runnable {
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;
    final Node node;
    final RequestTracker tracker;
    private NodeStats nodeStats;
    private NodeDispatcherCallback callback;
    final Probe probe;
    private static final long STALE_CONTEXT = 20000L;
    private static final long STALE_CONTEXT_CHECK = 20000L;
    ByteCounter pingCounter = new ByteCounter(){

        @Override
        public void receivedBytes(int x) {
            NodeDispatcher.this.node.nodeStats.pingCounterReceived(x);
        }

        @Override
        public void sentBytes(int x) {
            NodeDispatcher.this.node.nodeStats.pingCounterSent(x);
        }

        @Override
        public void sentPayload(int x) {
        }
    };
    private final PrioRunnable queueRunner = new PrioRunnable(){

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Message msg;
                        boolean isSSK = (msg = (Message)NodeDispatcher.this.requestQueue.take()).getSpec() == DMT.FNPSSKDataRequest;
                        NodeDispatcher.this.innerHandleDataRequest(msg, (PeerNode)msg.getSource(), isSSK);
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        @Override
        public int getPriority() {
            return NativeThread.HIGH_PRIORITY - 1;
        }
    };
    private final ArrayBlockingQueue<Message> requestQueue = new ArrayBlockingQueue(100);
    final Hashtable<Long, RoutedContext> routedContexts = new Hashtable();

    NodeDispatcher(Node node) {
        this.node = node;
        this.tracker = node.tracker;
        this.nodeStats = node.nodeStats;
        node.getTicker().queueTimedJob(this, 20000L);
        this.probe = new Probe(node);
    }

    @Override
    public boolean handleMessage(Message m) {
        MessageType spec;
        PeerNode source = (PeerNode)m.getSource();
        if (source == null) {
            return true;
        }
        if (logMINOR) {
            Logger.minor(this, "Dispatching " + m + " from " + source);
        }
        if (this.callback != null) {
            try {
                this.callback.snoop(m, this.node);
            }
            catch (Throwable t) {
                Logger.error(this, "Callback threw " + t, t);
            }
        }
        if ((spec = m.getSpec()) == DMT.FNPPing) {
            block61: {
                Message reply = DMT.createFNPPong(m.getInt("pingSequenceNumber"));
                try {
                    source.sendAsync(reply, null, this.pingCounter);
                }
                catch (NotConnectedException e) {
                    if (!logMINOR) break block61;
                    Logger.minor(this, "Lost connection replying to " + m);
                }
            }
            return true;
        }
        if (spec == DMT.FNPDetectedIPAddress) {
            Peer p = (Peer)m.getObject("externalAddress");
            source.setRemoteDetectedPeer(p);
            this.node.ipDetector.redetectAddress();
            return true;
        }
        if (spec == DMT.FNPTime) {
            return this.handleTime(m, source);
        }
        if (spec == DMT.FNPUptime) {
            return this.handleUptime(m, source);
        }
        if (spec == DMT.FNPVisibility && source instanceof DarknetPeerNode) {
            ((DarknetPeerNode)source).handleVisibility(m);
            return true;
        }
        if (spec == DMT.FNPVoid) {
            return true;
        }
        if (spec == DMT.FNPDisconnect) {
            this.handleDisconnect(m, source);
            return true;
        }
        if (spec == DMT.nodeToNodeMessage) {
            this.node.receivedNodeToNodeMessage(m, source);
            return true;
        }
        if (spec == DMT.UOMAnnouncement && source.isRealConnection()) {
            return this.node.nodeUpdater.uom.handleAnnounce(m, source);
        }
        if (spec == DMT.UOMRequestRevocation && source.isRealConnection()) {
            return this.node.nodeUpdater.uom.handleRequestRevocation(m, source);
        }
        if (spec == DMT.UOMSendingRevocation && source.isRealConnection()) {
            return this.node.nodeUpdater.uom.handleSendingRevocation(m, source);
        }
        if (spec == DMT.UOMRequestMainJar && this.node.nodeUpdater.isEnabled() && source.isRealConnection()) {
            this.node.nodeUpdater.uom.handleRequestJar(m, source);
            return true;
        }
        if (spec == DMT.UOMSendingMainJar && this.node.nodeUpdater.isEnabled() && source.isRealConnection()) {
            return this.node.nodeUpdater.uom.handleSendingMain(m, source);
        }
        if (spec == DMT.UOMFetchDependency && this.node.nodeUpdater.isEnabled() && source.isRealConnection()) {
            this.node.nodeUpdater.uom.handleFetchDependency(m, source);
            return true;
        }
        if (spec == DMT.FNPOpennetAnnounceRequest) {
            return this.handleAnnounceRequest(m, source);
        }
        if (spec == DMT.FNPRoutingStatus) {
            if (source instanceof DarknetPeerNode) {
                boolean value = m.getBoolean("routingEnabled");
                if (logMINOR) {
                    Logger.minor(this, "The peer (" + source + ") asked us to set routing=" + value);
                }
                ((DarknetPeerNode)source).setRoutingStatus(value, false);
            }
            return true;
        }
        if (source.isRealConnection() && spec == DMT.FNPLocChangeNotificationNew) {
            double newLoc = m.getDouble("location");
            ShortBuffer buffer = (ShortBuffer)m.getObject("peerLocations");
            double[] locs = Fields.bytesToDoubles(buffer.getData());
            if (142 < locs.length && source.isOpennet()) {
                if (locs.length > 152) {
                    Logger.error(this, "We received " + locs.length + " locations from " + source.toString() + "! That should *NOT* happen! Possible attack!");
                    source.forceDisconnect();
                    return true;
                }
                Logger.normal(this, "Too many locations from " + source.toString() + " : " + locs.length + " could be an accident, using the first " + 142);
                locs = Arrays.copyOf(locs, 142);
            }
            source.updateLocation(newLoc, locs);
            return true;
        }
        if (spec == DMT.FNPPeerLoadStatusByte || spec == DMT.FNPPeerLoadStatusShort || spec == DMT.FNPPeerLoadStatusInt) {
            return this.handlePeerLoadStatus(m, source);
        }
        if (!source.isRoutable()) {
            if (logDEBUG) {
                Logger.debug(this, "Not routable");
            }
            if (spec == DMT.FNPCHKDataRequest) {
                this.rejectRequest(m, this.node.nodeStats.chkRequestCtr);
            } else if (spec == DMT.FNPSSKDataRequest) {
                this.rejectRequest(m, this.node.nodeStats.sskRequestCtr);
            } else if (spec == DMT.FNPInsertRequest) {
                this.rejectRequest(m, this.node.nodeStats.chkInsertCtr);
            } else if (spec == DMT.FNPSSKInsertRequest) {
                this.rejectRequest(m, this.node.nodeStats.sskInsertCtr);
            } else if (spec == DMT.FNPSSKInsertRequestNew) {
                this.rejectRequest(m, this.node.nodeStats.sskInsertCtr);
            } else if (spec == DMT.FNPGetOfferedKey) {
                this.rejectRequest(m, this.node.failureTable.senderCounter);
            } else {
                return false;
            }
            return true;
        }
        if (spec == DMT.FNPSwapRequest) {
            return this.node.lm.handleSwapRequest(m, source);
        }
        if (spec == DMT.FNPSwapReply) {
            return this.node.lm.handleSwapReply(m, source);
        }
        if (spec == DMT.FNPSwapRejected) {
            return this.node.lm.handleSwapRejected(m, source);
        }
        if (spec == DMT.FNPSwapCommit) {
            return this.node.lm.handleSwapCommit(m, source);
        }
        if (spec == DMT.FNPSwapComplete) {
            return this.node.lm.handleSwapComplete(m, source);
        }
        if (spec == DMT.FNPCHKDataRequest) {
            this.handleDataRequest(m, source, false);
            return true;
        }
        if (spec == DMT.FNPSSKDataRequest) {
            this.handleDataRequest(m, source, true);
            return true;
        }
        if (spec == DMT.FNPInsertRequest) {
            this.handleInsertRequest(m, source, false);
            return true;
        }
        if (spec == DMT.FNPSSKInsertRequest) {
            this.handleInsertRequest(m, source, true);
            return true;
        }
        if (spec == DMT.FNPSSKInsertRequestNew) {
            this.handleInsertRequest(m, source, true);
            return true;
        }
        if (spec == DMT.FNPRoutedPing) {
            return this.handleRouted(m, source);
        }
        if (spec == DMT.FNPRoutedPong) {
            return this.handleRoutedReply(m);
        }
        if (spec == DMT.FNPRoutedRejected) {
            return this.handleRoutedRejected(m);
        }
        if (spec == DMT.FNPOfferKey) {
            return this.handleOfferKey(m, source);
        }
        if (spec == DMT.FNPGetOfferedKey) {
            return this.handleGetOfferedKey(m, source);
        }
        if (spec == DMT.FNPGetYourFullNoderef && source instanceof DarknetPeerNode) {
            ((DarknetPeerNode)source).sendFullNoderef();
            return true;
        }
        if (spec == DMT.FNPMyFullNoderef && source instanceof DarknetPeerNode) {
            ((DarknetPeerNode)source).handleFullNoderef(m);
            return true;
        }
        if (spec == DMT.ProbeRequest) {
            this.probe.request(m, source);
            return true;
        }
        return false;
    }

    private void rejectRequest(Message m, ByteCounter ctr) {
        long uid = m.getLong("uid");
        Message msg = DMT.createFNPRejectedOverload(uid, true, false, false);
        msg.setNeedsLoadBulk();
        msg.setNeedsLoadRT();
        try {
            m.getSource().sendAsync(msg, null, ctr);
        }
        catch (NotConnectedException notConnectedException) {
            // empty catch block
        }
    }

    private boolean handlePeerLoadStatus(Message m, PeerNode source) {
        NodeStats.PeerLoadStats stat = this.node.nodeStats.parseLoadStats(source, m);
        source.reportLoadStatus(stat);
        return true;
    }

    private boolean handleUptime(Message m, PeerNode source) {
        byte uptime = m.getByte("uptimePercent48H");
        source.setUptime(uptime);
        return true;
    }

    private boolean handleOfferKey(Message m, PeerNode source) {
        Key key = (Key)m.getObject("key");
        byte[] authenticator = ((ShortBuffer)m.getObject("offerAuthenticator")).getData();
        this.node.failureTable.onOffer(key, source, authenticator);
        return true;
    }

    private boolean handleGetOfferedKey(Message m, PeerNode source) {
        boolean needPubKey;
        OfferReplyTag tag;
        boolean realTimeFlag;
        boolean isSSK;
        long uid;
        Key key;
        block17: {
            key = (Key)m.getObject("key");
            byte[] authenticator = ((ShortBuffer)m.getObject("offerAuthenticator")).getData();
            uid = m.getLong("uid");
            if (!HMAC.verifyWithSHA256(this.node.failureTable.offerAuthenticatorKey, key.getFullKey(), authenticator)) {
                Logger.error(this, "Invalid offer request from " + source + " : authenticator did not verify");
                try {
                    source.sendAsync(DMT.createFNPGetOfferedKeyInvalid(uid, (short)1), null, this.node.failureTable.senderCounter);
                }
                catch (NotConnectedException notConnectedException) {
                    // empty catch block
                }
                return true;
            }
            if (logMINOR) {
                Logger.minor(this, "Valid GetOfferedKey for " + key + " from " + source);
            }
            if (!this.tracker.lockUID(uid, isSSK = key instanceof NodeSSK, false, true, false, realTimeFlag = DMT.getRealTimeFlag(m), tag = new OfferReplyTag(isSSK, source, realTimeFlag, uid, this.node))) {
                if (logMINOR) {
                    Logger.minor(this, "Could not lock ID " + uid + " -> rejecting (already running)");
                }
                Message rejected = DMT.createFNPRejectedLoop(uid);
                try {
                    source.sendAsync(rejected, null, this.node.failureTable.senderCounter);
                }
                catch (NotConnectedException e) {
                    Logger.normal(this, "Rejecting request from " + source.getPeer() + ": " + e);
                }
                return true;
            }
            if (logMINOR) {
                Logger.minor(this, "Locked " + uid);
            }
            try {
                needPubKey = m.getBoolean("needPubKey");
                NodeStats.RejectReason reject = this.nodeStats.shouldRejectRequest(true, false, isSSK, false, true, source, false, false, realTimeFlag, tag);
                if (reject == null) break block17;
                Logger.normal(this, "Rejecting FNPGetOfferedKey from " + source + " for " + key + " : " + reject);
                Message rejected = DMT.createFNPRejectedOverload(uid, true, true, realTimeFlag);
                if (reject.soft) {
                    rejected.addSubMessage(DMT.createFNPRejectIsSoft());
                }
                try {
                    source.sendAsync(rejected, null, this.node.failureTable.senderCounter);
                }
                catch (NotConnectedException e) {
                    Logger.normal(this, "Rejecting (overload) data request from " + source.getPeer() + ": " + e);
                }
                tag.unlockHandler(reject.soft);
                return true;
            }
            catch (Error e) {
                tag.unlockHandler();
                throw e;
            }
            catch (RuntimeException e) {
                tag.unlockHandler();
                throw e;
            }
        }
        try {
            this.node.failureTable.sendOfferedKey(key, isSSK, needPubKey, uid, source, tag, realTimeFlag);
        }
        catch (NotConnectedException notConnectedException) {
            // empty catch block
        }
        return true;
    }

    private void handleDisconnect(final Message m, final PeerNode source) {
        this.node.getTicker().queueTimedJob(new Runnable(){

            @Override
            public void run() {
                NodeDispatcher.this.finishDisconnect(m, source);
            }
        }, 1000L);
    }

    private void finishDisconnect(Message m, PeerNode source) {
        OpennetManager om;
        boolean purge;
        source.disconnected(true, true);
        boolean remove = m.getBoolean("remove");
        if (remove) {
            this.node.peers.disconnectAndRemove(source, false, false, false);
            if (source instanceof DarknetPeerNode) {
                System.out.println("Disconnecting permanently from your friend \"" + ((DarknetPeerNode)source).getName() + "\" because they asked us to remove them.");
            }
        }
        if ((purge = m.getBoolean("purge")) && (om = this.node.getOpennet()) != null && source instanceof OpennetPeerNode) {
            om.purgeOldOpennetPeer((OpennetPeerNode)source);
        }
        int type = m.getInt("nodeToNodeMessageType");
        ShortBuffer messageData = (ShortBuffer)m.getObject("nodeToNodeMessageData");
        if (messageData.getLength() == 0) {
            return;
        }
        this.node.receivedNodeToNodeMessage(source, type, messageData, true);
    }

    private boolean handleTime(Message m, PeerNode source) {
        long delta = m.getLong("time") - System.currentTimeMillis();
        source.setTimeDelta(delta);
        return true;
    }

    private void handleDataRequest(Message m, PeerNode source, boolean isSSK) {
        if (!this.requestQueue.offer(m)) {
            this.rejectRequest(m, isSSK ? this.node.nodeStats.sskRequestCtr : this.node.nodeStats.chkRequestCtr);
        }
    }

    private void innerHandleDataRequest(Message m, PeerNode source, boolean isSSK) {
        NodeStats.RejectReason rejectReason;
        BlockMetadata meta;
        KeyBlock block;
        RequestTag tag;
        if (!source.isConnected()) {
            if (logMINOR) {
                Logger.minor(this, "Handling request off thread, source disconnected: " + source + " for " + m);
            }
            return;
        }
        if (!source.isRoutable()) {
            if (logMINOR) {
                Logger.minor(this, "Handling request off thread, source no longer routable: " + source + " for " + m);
            }
            this.rejectRequest(m, isSSK ? this.node.nodeStats.sskRequestCtr : this.node.nodeStats.chkRequestCtr);
            return;
        }
        long id = m.getLong("uid");
        ByteCounter ctr = isSSK ? this.node.nodeStats.sskRequestCtr : this.node.nodeStats.chkRequestCtr;
        short htl = m.getShort("hopsToLive");
        if (htl <= 0) {
            htl = 1;
        }
        Key key = (Key)m.getObject("freenetRoutingKey");
        boolean realTimeFlag = DMT.getRealTimeFlag(m);
        if (!this.tracker.lockUID(id, isSSK, false, false, false, realTimeFlag, tag = new RequestTag(isSSK, RequestTag.START.REMOTE, source, realTimeFlag, id, this.node))) {
            if (logMINOR) {
                Logger.minor(this, "Could not lock ID " + id + " -> rejecting (already running)");
            }
            Message rejected = DMT.createFNPRejectedLoop(id);
            try {
                source.sendAsync(rejected, null, ctr);
            }
            catch (NotConnectedException e) {
                Logger.normal(this, "Rejecting request from " + source.getPeer() + ": " + e);
            }
            this.node.failureTable.onFinalFailure(key, null, htl, htl, -1L, -1L, source);
            return;
        }
        if (logMINOR) {
            Logger.minor(this, "Locked " + id);
        }
        if ((block = this.node.fetch(key, false, false, false, false, meta = new BlockMetadata())) != null) {
            tag.setNotRoutedOnwards();
        }
        if ((rejectReason = this.nodeStats.shouldRejectRequest(!isSSK, false, isSSK, false, false, source, block != null, false, realTimeFlag, tag)) != null) {
            Logger.normal(this, "Rejecting " + (isSSK ? "SSK" : "CHK") + " request from " + source.getPeer() + " preemptively because " + rejectReason);
            Message rejected = DMT.createFNPRejectedOverload(id, true, true, realTimeFlag);
            if (rejectReason.soft) {
                rejected.addSubMessage(DMT.createFNPRejectIsSoft());
            }
            try {
                source.sendAsync(rejected, null, ctr);
            }
            catch (NotConnectedException e) {
                Logger.normal(this, "Rejecting (overload) data request from " + source.getPeer() + ": " + e);
            }
            tag.setRejected();
            tag.unlockHandler(rejectReason.soft);
            return;
        }
        this.nodeStats.reportIncomingRequestLocation(key.toNormalizedDouble());
        boolean needsPubKey = false;
        if (key instanceof NodeSSK) {
            needsPubKey = m.getBoolean("needPubKey");
        }
        RequestHandler rh = new RequestHandler(source, id, this.node, htl, key, tag, block, realTimeFlag, needsPubKey);
        rh.receivedBytes(m.receivedByteCount());
        this.node.executor.execute(rh, "RequestHandler for UID " + id + " on " + this.node.getDarknetPortNumber());
    }

    private void handleInsertRequest(Message m, PeerNode source, boolean isSSK) {
        NodeStats.RejectReason rejectReason;
        Message preference;
        Message lowBackoff;
        InsertTag tag;
        boolean realTimeFlag;
        ByteCounter ctr = isSSK ? this.node.nodeStats.sskInsertCtr : this.node.nodeStats.chkInsertCtr;
        long id = m.getLong("uid");
        if (!this.tracker.lockUID(id, isSSK, true, false, false, realTimeFlag = DMT.getRealTimeFlag(m), tag = new InsertTag(isSSK, InsertTag.START.REMOTE, source, realTimeFlag, id, this.node))) {
            if (logMINOR) {
                Logger.minor(this, "Could not lock ID " + id + " -> rejecting (already running)");
            }
            Message rejected = DMT.createFNPRejectedLoop(id);
            try {
                source.sendAsync(rejected, null, ctr);
            }
            catch (NotConnectedException e) {
                Logger.normal(this, "Rejecting insert request from " + source.getPeer() + ": " + e);
            }
            return;
        }
        boolean preferInsert = false;
        boolean ignoreLowBackoff = false;
        boolean forkOnCacheable = true;
        Message forkControl = m.getSubMessage(DMT.FNPSubInsertForkControl);
        if (forkControl != null) {
            forkOnCacheable = forkControl.getBoolean("enableInsertForkWhenCacheable");
        }
        if ((lowBackoff = m.getSubMessage(DMT.FNPSubInsertIgnoreLowBackoff)) != null) {
            ignoreLowBackoff = lowBackoff.getBoolean("ignoreLowBackoff");
        }
        if ((preference = m.getSubMessage(DMT.FNPSubInsertPreferInsert)) != null) {
            preferInsert = preference.getBoolean("preferInsert");
        }
        if ((rejectReason = this.nodeStats.shouldRejectRequest(!isSSK, true, isSSK, false, false, source, false, preferInsert, realTimeFlag, tag)) != null) {
            Logger.normal(this, "Rejecting insert from " + source.getPeer() + " preemptively because " + rejectReason);
            Message rejected = DMT.createFNPRejectedOverload(id, true, true, realTimeFlag);
            if (rejectReason.soft) {
                rejected.addSubMessage(DMT.createFNPRejectIsSoft());
            }
            try {
                source.sendAsync(rejected, null, ctr);
            }
            catch (NotConnectedException e) {
                Logger.normal(this, "Rejecting (overload) insert request from " + source.getPeer() + ": " + e);
            }
            tag.unlockHandler(rejectReason.soft);
            return;
        }
        long now = System.currentTimeMillis();
        if (m.getSpec().equals(DMT.FNPSSKInsertRequest)) {
            NodeSSK key = (NodeSSK)m.getObject("freenetRoutingKey");
            byte[] data = ((ShortBuffer)m.getObject("data")).getData();
            byte[] headers = ((ShortBuffer)m.getObject("blockHeaders")).getData();
            short htl = m.getShort("hopsToLive");
            if (htl <= 0) {
                htl = 1;
            }
            SSKInsertHandler rh = new SSKInsertHandler(key, data, headers, htl, source, id, this.node, now, tag, this.node.canWriteDatastoreInsert(htl), forkOnCacheable, preferInsert, ignoreLowBackoff, realTimeFlag);
            rh.receivedBytes(m.receivedByteCount());
            this.node.executor.execute(rh, "SSKInsertHandler for " + id + " on " + this.node.getDarknetPortNumber());
        } else if (m.getSpec().equals(DMT.FNPSSKInsertRequestNew)) {
            NodeSSK key = (NodeSSK)m.getObject("freenetRoutingKey");
            short htl = m.getShort("hopsToLive");
            if (htl <= 0) {
                htl = 1;
            }
            SSKInsertHandler rh = new SSKInsertHandler(key, null, null, htl, source, id, this.node, now, tag, this.node.canWriteDatastoreInsert(htl), forkOnCacheable, preferInsert, ignoreLowBackoff, realTimeFlag);
            rh.receivedBytes(m.receivedByteCount());
            this.node.executor.execute(rh, "SSKInsertHandler for " + id + " on " + this.node.getDarknetPortNumber());
        } else {
            NodeCHK key = (NodeCHK)m.getObject("freenetRoutingKey");
            short htl = m.getShort("hopsToLive");
            if (htl <= 0) {
                htl = 1;
            }
            CHKInsertHandler rh = new CHKInsertHandler(key, htl, source, id, this.node, now, tag, forkOnCacheable, preferInsert, ignoreLowBackoff, realTimeFlag);
            rh.receivedBytes(m.receivedByteCount());
            this.node.executor.execute(rh, "CHKInsertHandler for " + id + " on " + this.node.getDarknetPortNumber());
        }
        if (logMINOR) {
            Logger.minor(this, "Started InsertHandler for " + id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleAnnounceRequest(Message m, PeerNode source) {
        long uid = m.getLong("uid");
        double target = m.getDouble("targetLocation");
        short htl = (short)Math.min(m.getShort("hopsToLive"), this.node.maxHTL());
        long xferUID = m.getLong("transferUID");
        int noderefLength = m.getInt("noderefLength");
        int paddedLength = m.getInt("paddedLength");
        if (target < 0.0 || target >= 1.0 || htl <= 0 || paddedLength < 0 || paddedLength > 32768 || noderefLength > paddedLength) {
            Message msg = DMT.createFNPRejectedOverload(uid, true, false, false);
            try {
                source.sendAsync(msg, null, this.node.nodeStats.announceByteCounter);
            }
            catch (NotConnectedException notConnectedException) {
                // empty catch block
            }
            if (logMINOR) {
                Logger.minor(this, "Got bogus announcement message from " + source);
            }
            return true;
        }
        OpennetManager om = this.node.getOpennet();
        if (om == null || !source.canAcceptAnnouncements()) {
            if (om != null && source instanceof SeedClientPeerNode) {
                om.seedTracker.rejectedAnnounce((SeedClientPeerNode)source);
            }
            Message msg = DMT.createFNPOpennetDisabled(uid);
            try {
                source.sendAsync(msg, null, this.node.nodeStats.announceByteCounter);
            }
            catch (NotConnectedException notConnectedException) {
                // empty catch block
            }
            if (logMINOR) {
                Logger.minor(this, "Rejected announcement (opennet or announcement disabled) from " + source);
            }
            return true;
        }
        boolean success = false;
        try {
            short maxHTL;
            if (!this.node.nodeStats.shouldAcceptAnnouncement(uid)) {
                if (om != null && source instanceof SeedClientPeerNode) {
                    om.seedTracker.rejectedAnnounce((SeedClientPeerNode)source);
                }
                Message msg = DMT.createFNPRejectedOverload(uid, true, false, false);
                try {
                    source.sendAsync(msg, null, this.node.nodeStats.announceByteCounter);
                }
                catch (NotConnectedException notConnectedException) {
                    // empty catch block
                }
                if (logMINOR) {
                    Logger.minor(this, "Rejected announcement (overall overload) from " + source);
                }
                boolean bl = true;
                return bl;
            }
            if (!source.shouldAcceptAnnounce(uid)) {
                if (om != null && source instanceof SeedClientPeerNode) {
                    om.seedTracker.rejectedAnnounce((SeedClientPeerNode)source);
                }
                this.node.nodeStats.endAnnouncement(uid);
                Message msg = DMT.createFNPRejectedOverload(uid, true, false, false);
                try {
                    source.sendAsync(msg, null, this.node.nodeStats.announceByteCounter);
                }
                catch (NotConnectedException notConnectedException) {
                    // empty catch block
                }
                if (logMINOR) {
                    Logger.minor(this, "Rejected announcement (peer limit) from " + source);
                }
                boolean bl = true;
                return bl;
            }
            if (om != null && source instanceof SeedClientPeerNode && !om.seedTracker.acceptAnnounce((SeedClientPeerNode)source, this.node.fastWeakRandom)) {
                this.node.nodeStats.endAnnouncement(uid);
                Message msg = DMT.createFNPRejectedOverload(uid, true, false, false);
                try {
                    source.sendAsync(msg, null, this.node.nodeStats.announceByteCounter);
                }
                catch (NotConnectedException notConnectedException) {
                    // empty catch block
                }
                if (logMINOR) {
                    Logger.minor(this, "Rejected announcement (seednode limit) from " + source);
                }
                boolean bl = true;
                return bl;
            }
            if (source instanceof SeedClientPeerNode && htl < (maxHTL = this.node.maxHTL()) - 1) {
                Logger.error(this, "Announcement from seed client not at max HTL: " + htl + " for " + source);
                htl = maxHTL;
            }
            AnnouncementCallback cb = null;
            if (logMINOR) {
                final String origin = source.toString() + " (htl " + htl + ")";
                cb = new AnnouncementCallback(){
                    private int totalAdded;
                    private int totalNotWanted;
                    private boolean acceptedSomewhere;

                    @Override
                    public synchronized void acceptedSomewhere() {
                        this.acceptedSomewhere = true;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void addedNode(PeerNode pn) {
                        5 var2_2 = this;
                        synchronized (var2_2) {
                            ++this.totalAdded;
                        }
                        Logger.minor(this, "Announcement from " + origin + " added node " + pn + (pn instanceof SeedClientPeerNode ? " (seed server added the peer directly)" : ""));
                    }

                    @Override
                    public void bogusNoderef(String reason) {
                        Logger.minor(this, "Announcement from " + origin + " got bogus noderef: " + reason, (Throwable)new Exception("debug"));
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void completed() {
                        5 var1_1 = this;
                        synchronized (var1_1) {
                            Logger.minor(this, "Announcement from " + origin + " completed");
                        }
                        int shallow = NodeDispatcher.this.node.maxHTL() - (this.totalAdded + this.totalNotWanted);
                        if (this.acceptedSomewhere) {
                            Logger.minor(this, "Announcement from " + origin + " completed (" + this.totalAdded + " added, " + this.totalNotWanted + " not wanted, " + shallow + " shallow)");
                        } else {
                            Logger.minor(this, "Announcement from " + origin + " not accepted anywhere.");
                        }
                    }

                    @Override
                    public void nodeFailed(PeerNode pn, String reason) {
                        Logger.minor(this, "Announcement from " + origin + " failed: " + reason);
                    }

                    @Override
                    public void noMoreNodes() {
                        Logger.minor(this, "Announcement from " + origin + " ran out of nodes (route not found)");
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void nodeNotWanted() {
                        5 var1_1 = this;
                        synchronized (var1_1) {
                            ++this.totalNotWanted;
                        }
                        Logger.minor(this, "Announcement from " + origin + " returned node not wanted for a total of " + this.totalNotWanted + " from this announcement)");
                    }

                    @Override
                    public void nodeNotAdded() {
                        Logger.minor(this, "Announcement from " + origin + " : node not wanted (maybe already have it, opennet just turned off, etc)");
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void relayedNoderef() {
                        5 var1_1 = this;
                        synchronized (var1_1) {
                            ++this.totalAdded;
                            Logger.minor(this, "Announcement from " + origin + " accepted by a downstream node, relaying noderef for a total of " + this.totalAdded + " from this announcement)");
                        }
                    }
                };
            }
            AnnounceSender sender = new AnnounceSender(target, htl, uid, source, om, this.node, xferUID, noderefLength, paddedLength, cb);
            this.node.executor.execute(sender, "Announcement sender for " + uid);
            success = true;
            if (logMINOR) {
                Logger.minor(this, "Accepted announcement from " + source);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (!success) {
                source.completedAnnounce(uid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long now = System.currentTimeMillis();
        Hashtable<Long, RoutedContext> hashtable = this.routedContexts;
        synchronized (hashtable) {
            Iterator<RoutedContext> i = this.routedContexts.values().iterator();
            while (i.hasNext()) {
                RoutedContext rc = i.next();
                if (now - rc.createdTime <= 20000L) continue;
                i.remove();
            }
        }
        this.node.getTicker().queueTimedJob(this, 20000L);
    }

    private boolean handleRoutedRejected(Message m) {
        short ohtl;
        if (!this.node.enableRoutedPing()) {
            return true;
        }
        long id = m.getLong("uid");
        Long lid = id;
        RoutedContext rc = this.routedContexts.get(lid);
        if (rc == null) {
            Logger.error(this, "Unrecognized FNPRoutedRejected");
            return false;
        }
        short htl = rc.lastHtl;
        if (rc.source != null) {
            htl = rc.source.decrementHTL(htl);
        }
        if ((ohtl = m.getShort("hopsToLive")) < htl) {
            htl = ohtl;
        }
        if (htl == 0) {
            if (rc.source != null) {
                try {
                    rc.source.sendAsync(DMT.createFNPRoutedRejected(id, (short)0), null, this.nodeStats.routedMessageCtr);
                }
                catch (NotConnectedException e) {
                    Logger.error(this, "Unable to relay probe DNF: peer disconnected: " + rc.source);
                }
            }
        } else {
            this.forward(rc.msg, id, rc.source, htl, rc.msg.getDouble("targetLocation"), rc, rc.identity);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean handleRouted(Message m, PeerNode source) {
        RoutedContext ctx;
        if (!this.node.enableRoutedPing()) {
            return true;
        }
        if (logMINOR) {
            Logger.minor(this, "handleRouted(" + m + ')');
        }
        long id = m.getLong("uid");
        Long lid = id;
        short htl = m.getShort("hopsToLive");
        byte[] identity = ((ShortBuffer)m.getObject("nodeIdentity")).getData();
        if (source != null) {
            htl = source.decrementHTL(htl);
        }
        if ((ctx = this.routedContexts.get(lid)) != null) {
            block16: {
                try {
                    source.sendAsync(DMT.createFNPRoutedRejected(id, htl), null, this.nodeStats.routedMessageCtr);
                }
                catch (NotConnectedException e) {
                    if (!logMINOR) break block16;
                    Logger.minor(this, "Lost connection rejecting " + m);
                }
            }
            return true;
        }
        ctx = new RoutedContext(m, source, identity);
        Hashtable<Long, RoutedContext> e = this.routedContexts;
        synchronized (e) {
            this.routedContexts.put(lid, ctx);
        }
        double target = m.getDouble("targetLocation");
        if (logMINOR) {
            Logger.minor(this, "id " + id + " from " + source + " htl " + htl + " target " + target);
        }
        if (Math.abs(this.node.lm.getLocation() - target) <= Double.MIN_VALUE) {
            if (logMINOR) {
                Logger.minor(this, "Dispatching " + m.getSpec() + " on " + this.node.getDarknetPortNumber());
            }
            this.dispatchRoutedMessage(m, source, id);
            return true;
        }
        if (htl == 0) {
            block17: {
                Message reject = DMT.createFNPRoutedRejected(id, (short)0);
                if (source != null) {
                    try {
                        source.sendAsync(reject, null, this.nodeStats.routedMessageCtr);
                    }
                    catch (NotConnectedException e2) {
                        if (!logMINOR) break block17;
                        Logger.minor(this, "Lost connection rejecting " + m);
                    }
                }
            }
            return true;
        }
        return this.forward(m, id, source, htl, target, ctx, identity);
    }

    boolean handleRoutedReply(Message m) {
        block6: {
            Long lid;
            RoutedContext ctx;
            if (!this.node.enableRoutedPing()) {
                return true;
            }
            long id = m.getLong("uid");
            if (logMINOR) {
                Logger.minor(this, "Got reply: " + m);
            }
            if ((ctx = this.routedContexts.get(lid = Long.valueOf(id))) == null) {
                Logger.error(this, "Unrecognized routed reply: " + m);
                return false;
            }
            PeerNode pn = ctx.source;
            if (pn == null) {
                return false;
            }
            try {
                pn.sendAsync(m.cloneAndDropSubMessages(), null, this.nodeStats.routedMessageCtr);
            }
            catch (NotConnectedException e) {
                if (!logMINOR) break block6;
                Logger.minor(this, "Lost connection forwarding " + m + " to " + pn);
            }
        }
        return true;
    }

    private boolean forward(Message m, long id, PeerNode pn, short htl, double target, RoutedContext ctx, byte[] targetIdentity) {
        block12: {
            if (logMINOR) {
                Logger.minor(this, "Should forward");
            }
            m = this.preForward(m, htl);
            while (true) {
                PeerNode next;
                if ((next = this.node.peers.getByPubKeyHash(targetIdentity)) != null && !next.isConnected()) {
                    Logger.error(this, "Found target but disconnected!: " + next);
                    next = null;
                }
                if (next == null) {
                    next = this.node.peers.closerPeer(pn, ctx.routedTo, target, true, this.node.isAdvancedModeEnabled(), -1, null, null, htl, 0L, pn == null, false, false);
                }
                if (logMINOR) {
                    Logger.minor(this, "Next: " + next + " message: " + m);
                }
                if (next == null) break;
                if (logMINOR) {
                    Logger.minor(this, "Forwarding " + m.getSpec() + " to " + next.getPeer().getPort());
                }
                ctx.addSent(next);
                try {
                    next.sendAsync(m, null, this.nodeStats.routedMessageCtr);
                    break block12;
                }
                catch (NotConnectedException e) {
                    continue;
                }
                break;
            }
            if (logMINOR) {
                Logger.minor(this, "Reached dead end for " + m.getSpec() + " on " + this.node.getDarknetPortNumber());
            }
            Message reject = DMT.createFNPRoutedRejected(id, htl);
            if (pn != null) {
                try {
                    pn.sendAsync(reject, null, this.nodeStats.routedMessageCtr);
                }
                catch (NotConnectedException e) {
                    Logger.error(this, "Cannot send reject message back to source " + pn);
                    return true;
                }
            }
        }
        return true;
    }

    private Message preForward(Message m, short newHTL) {
        m = m.cloneAndDropSubMessages();
        m.set("hopsToLive", newHTL);
        if (m.getSpec() == DMT.FNPRoutedPing) {
            int x = m.getInt("counter");
            m.set("counter", ++x);
        }
        return m;
    }

    private boolean dispatchRoutedMessage(Message m, PeerNode src, long id) {
        if (m.getSpec() == DMT.FNPRoutedPing) {
            block5: {
                if (logMINOR) {
                    Logger.minor(this, "RoutedPing reached other side! (" + id + ")");
                }
                int x = m.getInt("counter");
                Message reply = DMT.createFNPRoutedPong(id, x);
                if (logMINOR) {
                    Logger.minor(this, "Replying - counter = " + x + " for " + id);
                }
                try {
                    src.sendAsync(reply, null, this.nodeStats.routedMessageCtr);
                }
                catch (NotConnectedException e) {
                    if (!logMINOR) break block5;
                    Logger.minor(this, "Lost connection replying to " + m + " in dispatchRoutedMessage");
                }
            }
            return true;
        }
        return false;
    }

    void start(NodeStats stats) {
        this.nodeStats = stats;
        this.node.executor.execute(this.queueRunner);
    }

    public static String peersUIDsToString(long[] peerUIDs, double[] peerLocs) {
        StringBuilder sb;
        block4: {
            int i;
            int min;
            block3: {
                sb = new StringBuilder(peerUIDs.length * 23 + peerLocs.length * 26);
                min = Math.min(peerUIDs.length, peerLocs.length);
                for (i = 0; i < min; ++i) {
                    double loc = peerLocs[i];
                    long uid = peerUIDs[i];
                    sb.append(loc);
                    sb.append('=');
                    sb.append(uid);
                    if (i == min - 1) continue;
                    sb.append('|');
                }
                if (peerUIDs.length <= min) break block3;
                for (i = min; i < peerUIDs.length; ++i) {
                    sb.append("|U:");
                    sb.append(peerUIDs[i]);
                }
                break block4;
            }
            if (peerLocs.length <= min) break block4;
            for (i = min; i < peerLocs.length; ++i) {
                sb.append("|L:");
                sb.append(peerLocs[i]);
            }
        }
        return sb.toString();
    }

    public void setHook(NodeDispatcherCallback cb) {
        this.callback = cb;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
                logDEBUG = Logger.shouldLog(Logger.LogLevel.DEBUG, (Object)this);
            }
        });
    }

    static class RoutedContext {
        long createdTime;
        long accessTime;
        PeerNode source;
        final HashSet<PeerNode> routedTo;
        Message msg;
        short lastHtl;
        final byte[] identity;

        RoutedContext(Message msg, PeerNode source, byte[] identity) {
            this.createdTime = this.accessTime = System.currentTimeMillis();
            this.source = source;
            this.routedTo = new HashSet();
            this.msg = msg;
            this.lastHtl = msg.getShort("hopsToLive");
            this.identity = identity;
        }

        void addSent(PeerNode n) {
            this.routedTo.add(n);
        }
    }

    public static interface NodeDispatcherCallback {
        public void snoop(Message var1, Node var2);
    }
}

