/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.node.FastRunnable;
import freenet.support.Executor;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.Ticker;
import freenet.support.io.NativeThread;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.TreeMap;

public class PrioritizedTicker
implements Ticker,
Runnable {
    private static volatile boolean logMINOR;
    private final TreeMap<Long, Object> timedJobsByTime;
    private final HashMap<Job, Long> timedJobsQueued;
    final NativeThread myThread;
    final Executor executor;
    static final int MAX_SLEEP_TIME = 200;

    public PrioritizedTicker(Executor executor, int portNumber) {
        this.executor = executor;
        this.timedJobsByTime = new TreeMap();
        this.timedJobsQueued = new HashMap();
        this.myThread = new NativeThread(this, "Ticker thread for " + portNumber, NativeThread.MAX_PRIORITY, false);
        this.myThread.setDaemon(true);
    }

    public void start() {
        Logger.normal(this, "Starting Ticker");
        System.out.println("Starting Ticker");
        this.myThread.start();
    }

    @Override
    public void run() {
        if (logMINOR) {
            Logger.minor(this, "In Ticker.run()");
        }
        Logger.OSThread.logPID(this);
        while (true) {
            try {
                while (true) {
                    this.realRun();
                }
            }
            catch (Throwable t) {
                Logger.error(this, "Caught in PacketSender: " + t, t);
                System.err.println("Caught in PacketSender: " + t);
                t.printStackTrace();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void realRun() {
        long now = System.currentTimeMillis();
        ArrayList<Job> jobsToRun = null;
        long sleepTime = 200L;
        Object object = this.timedJobsByTime;
        synchronized (object) {
            while (!this.timedJobsByTime.isEmpty()) {
                Long tRun = this.timedJobsByTime.firstKey();
                if (tRun <= now) {
                    Object o;
                    if (jobsToRun == null) {
                        jobsToRun = new ArrayList<Job>();
                    }
                    if ((o = this.timedJobsByTime.remove(tRun)) instanceof Job[]) {
                        for (Job r : (Job[])o) {
                            jobsToRun.add(r);
                            this.timedJobsQueued.remove(r);
                        }
                        continue;
                    }
                    Job r = (Job)o;
                    jobsToRun.add(r);
                    this.timedJobsQueued.remove(r);
                    continue;
                }
                sleepTime = Math.min(sleepTime, tRun - now);
                break;
            }
        }
        if (jobsToRun != null) {
            for (Job r : jobsToRun) {
                if (logMINOR) {
                    Logger.minor(this, "Running " + r);
                }
                if (r.job instanceof FastRunnable) {
                    try {
                        r.job.run();
                    }
                    catch (Throwable t) {
                        Logger.error(this, "Caught " + t + " running " + r, t);
                    }
                    continue;
                }
                try {
                    this.executor.execute(r.job, r.name, true);
                }
                catch (Throwable t) {
                    Logger.error(this, "Caught in PacketSender: " + t, t);
                    System.err.println("Caught in PacketSender: " + t);
                    t.printStackTrace();
                    System.err.println("Will retry above failed operation...");
                    this.queueTimedJob(r.job, r.name, 200L, true, false);
                }
            }
        }
        if (sleepTime > 0L) {
            try {
                if (logMINOR) {
                    Logger.minor(this, "Sleeping for " + sleepTime);
                }
                object = this;
                synchronized (object) {
                    this.wait(sleepTime);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public void queueTimedJob(Runnable job, long offset) {
        this.queueTimedJob(job, "Scheduled job: " + job, offset, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void queueTimedJob(Runnable runner, String name, long offset, boolean runOnTickerAnyway, boolean noDupes) {
        if (offset <= 0L && !runOnTickerAnyway) {
            if (logMINOR) {
                Logger.minor(this, "Running directly: " + runner);
            }
            this.executor.execute(runner, name);
            return;
        }
        Job job = new Job(name, runner);
        if (offset < 0L) {
            offset = 0L;
        }
        long now = System.currentTimeMillis();
        Long l = offset + now;
        TreeMap<Long, Object> treeMap = this.timedJobsByTime;
        synchronized (treeMap) {
            Object o;
            Job[] jobs;
            Long t;
            if (noDupes && (t = this.timedJobsQueued.get(job)) != null) {
                if (t <= l) {
                    Logger.normal(this, "Not re-running as already queued: " + runner + " for " + name);
                    return;
                }
                Object o2 = this.timedJobsByTime.get(t);
                if (o2 instanceof Job) {
                    this.timedJobsQueued.remove(job);
                    assert (o2.equals(job));
                    this.timedJobsByTime.remove(t);
                } else {
                    jobs = (Job[])o2;
                    if (jobs.length == 1) {
                        this.timedJobsQueued.remove(job);
                        assert (jobs[0].equals(job));
                        this.timedJobsByTime.remove(t);
                    } else {
                        Job[] newJobs = new Job[jobs.length - 1];
                        int x = 0;
                        for (Job oldjob : jobs) {
                            if (oldjob.equals(job)) {
                                this.timedJobsQueued.remove(oldjob);
                                continue;
                            }
                            newJobs[x++] = oldjob;
                            if (x != jobs.length) continue;
                            assert (false);
                            newJobs = jobs;
                        }
                        if (x == 0) {
                            assert (false);
                            this.timedJobsByTime.remove(t);
                        } else if (x == 1) {
                            this.timedJobsByTime.put(t, newJobs[0]);
                        } else {
                            if (x != newJobs.length) {
                                newJobs = Arrays.copyOf(newJobs, x);
                            }
                            this.timedJobsByTime.put(t, newJobs);
                            assert (x == jobs.length - 1);
                        }
                    }
                }
            }
            if ((o = this.timedJobsByTime.get(l)) == null) {
                this.timedJobsByTime.put(l, job);
            } else if (o instanceof Job) {
                this.timedJobsByTime.put(l, new Job[]{(Job)o, job});
            } else if (o instanceof Job[]) {
                Job[] r = (Job[])o;
                jobs = Arrays.copyOf(r, r.length + 1);
                jobs[jobs.length - 1] = job;
                this.timedJobsByTime.put(l, jobs);
            }
            this.timedJobsQueued.put(job, l);
        }
        if (offset < 200L) {
            this.wakeUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void wakeUp() {
        PrioritizedTicker prioritizedTicker = this;
        synchronized (prioritizedTicker) {
            this.notifyAll();
        }
    }

    @Override
    public Executor getExecutor() {
        return this.executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int queuedJobs() {
        TreeMap<Long, Object> treeMap = this.timedJobsByTime;
        synchronized (treeMap) {
            return this.timedJobsByTime.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeQueuedJob(Runnable runnable) {
        Job job = new Job(null, runnable);
        TreeMap<Long, Object> treeMap = this.timedJobsByTime;
        synchronized (treeMap) {
            Long t = this.timedJobsQueued.remove(job);
            if (t != null) {
                Object o = this.timedJobsByTime.get(t);
                if (o == null) {
                    return;
                }
                if (o instanceof Job) {
                    assert (o.equals(job));
                    this.timedJobsByTime.remove(t);
                } else {
                    Job[] jobs = (Job[])o;
                    if (jobs.length == 1) {
                        assert (jobs[0].equals(job));
                        this.timedJobsByTime.remove(t);
                    } else {
                        Job[] newJobs = new Job[jobs.length - 1];
                        int x = 0;
                        for (Job oldjob : jobs) {
                            if (oldjob.equals(job)) continue;
                            newJobs[x++] = oldjob;
                            if (x != jobs.length) continue;
                            assert (false);
                            newJobs = jobs;
                        }
                        if (x == 0) {
                            assert (false);
                            this.timedJobsByTime.remove(t);
                        } else if (x == 1) {
                            this.timedJobsByTime.put(t, newJobs[0]);
                        } else {
                            if (x != newJobs.length) {
                                newJobs = Arrays.copyOf(newJobs, x);
                            }
                            this.timedJobsByTime.put(t, newJobs);
                            assert (x == jobs.length - 1);
                        }
                    }
                }
            }
        }
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }

    private static final class Job {
        final String name;
        final Runnable job;

        Job(String name, Runnable job) {
            this.name = name;
            this.job = job;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Job)) {
                return false;
            }
            return ((Job)o).job == this.job;
        }

        public int hashCode() {
            return this.job.hashCode();
        }
    }
}

