/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import freenet.client.FetchContext;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientGetState;
import freenet.client.async.PersistenceDisabledException;
import freenet.client.async.PersistentJob;
import freenet.client.async.USKFetcher;
import freenet.client.async.USKFetcherCallback;
import freenet.client.async.USKFetcherTagCallback;
import freenet.client.async.USKFetcherWrapper;
import freenet.client.async.USKManager;
import freenet.keys.USK;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.io.NativeThread;
import java.io.Serializable;

class USKFetcherTag
implements ClientGetState,
USKFetcherCallback,
Serializable {
    private static final long serialVersionUID = 1L;
    public final USKFetcherCallback callback;
    public final USK origUSK;
    protected long edition;
    public final boolean persistent;
    public final FetchContext ctx;
    public final boolean keepLastData;
    private short priority;
    private long token;
    private transient USKFetcher fetcher;
    private short pollingPriorityNormal;
    private short pollingPriorityProgress;
    private boolean finished;
    private final boolean ownFetchContext;
    private final boolean checkStoreOnly;
    private final int hashCode;
    private final boolean realTimeFlag;
    private static volatile boolean logMINOR;

    private USKFetcherTag(USK origUSK, USKFetcherCallback callback, boolean persistent, boolean realTime, FetchContext ctx, boolean keepLastData, long token, boolean hasOwnFetchContext, boolean checkStoreOnly) {
        this.callback = callback;
        this.origUSK = origUSK;
        this.edition = origUSK.suggestedEdition;
        this.persistent = persistent;
        this.ctx = ctx;
        this.keepLastData = keepLastData;
        this.token = token;
        this.ownFetchContext = hasOwnFetchContext;
        this.realTimeFlag = realTime;
        this.pollingPriorityNormal = callback.getPollingPriorityNormal();
        this.pollingPriorityProgress = callback.getPollingPriorityProgress();
        this.priority = this.pollingPriorityNormal;
        this.checkStoreOnly = checkStoreOnly;
        this.hashCode = super.hashCode();
        if (logMINOR) {
            Logger.minor(this, "Created tag for " + origUSK + " and " + callback + " : " + this);
        }
    }

    public int hashCode() {
        return this.hashCode;
    }

    public static USKFetcherTag create(USK usk, USKFetcherCallback callback, boolean persistent, boolean realTime, FetchContext ctx, boolean keepLast, int token, boolean hasOwnFetchContext, boolean checkStoreOnly) {
        USKFetcherTag tag = new USKFetcherTag(usk, callback, persistent, realTime, ctx, keepLast, token, hasOwnFetchContext, checkStoreOnly);
        return tag;
    }

    synchronized void updatedEdition(long ed) {
        if (this.edition < ed) {
            this.edition = ed;
        }
    }

    public void start(USKManager manager, ClientContext context) {
        USK usk = this.origUSK;
        if (usk.suggestedEdition < this.edition) {
            usk = usk.copy(this.edition);
        } else if (this.persistent) {
            usk = usk.copy();
        }
        this.fetcher = manager.getFetcher(usk, this.ctx, new USKFetcherWrapper(usk, this.priority, this.realTimeFlag ? USKManager.rcRT : USKManager.rcBulk), this.keepLastData, this.checkStoreOnly);
        this.fetcher.addCallback(this);
        this.fetcher.schedule(context);
        if (logMINOR) {
            Logger.minor(this, "Starting " + this.fetcher + " for " + this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel(ClientContext context) {
        USKFetcher f = this.fetcher;
        if (f != null) {
            this.fetcher.cancel(context);
        }
        USKFetcherTag uSKFetcherTag = this;
        synchronized (uSKFetcherTag) {
            if (this.finished) {
                if (logMINOR) {
                    Logger.minor(this, "Already cancelled " + this);
                }
                return;
            }
            this.finished = true;
        }
        if (f != null) {
            Logger.error(this, "cancel() for " + this.fetcher + " did not set finished on " + this + " ???");
        }
    }

    @Override
    public long getToken() {
        return this.token;
    }

    @Override
    public void schedule(ClientContext context) {
        this.start(context.uskManager, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCancelled(ClientContext context) {
        if (logMINOR) {
            Logger.minor(this, "Cancelled on " + this);
        }
        USKFetcherTag uSKFetcherTag = this;
        synchronized (uSKFetcherTag) {
            this.finished = true;
        }
        if (this.persistent) {
            try {
                context.jobRunner.queue(new PersistentJob(){

                    @Override
                    public boolean run(ClientContext context) {
                        if (USKFetcherTag.this.callback instanceof USKFetcherTagCallback) {
                            ((USKFetcherTagCallback)USKFetcherTag.this.callback).setTag(USKFetcherTag.this, context);
                        }
                        USKFetcherTag.this.callback.onCancelled(context);
                        return false;
                    }
                }, NativeThread.HIGH_PRIORITY);
            }
            catch (PersistenceDisabledException persistenceDisabledException) {}
        } else {
            if (this.callback instanceof USKFetcherTagCallback) {
                ((USKFetcherTagCallback)this.callback).setTag(this, context);
            }
            this.callback.onCancelled(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFailure(ClientContext context) {
        if (logMINOR) {
            Logger.minor(this, "Failed on " + this);
        }
        USKFetcherTag uSKFetcherTag = this;
        synchronized (uSKFetcherTag) {
            if (this.finished) {
                Logger.error(this, "onFailure called after finish on " + this, (Throwable)new Exception("error"));
                return;
            }
            this.finished = true;
        }
        if (this.persistent) {
            try {
                context.jobRunner.queue(new PersistentJob(){

                    @Override
                    public boolean run(ClientContext context) {
                        if (USKFetcherTag.this.callback instanceof USKFetcherTagCallback) {
                            ((USKFetcherTagCallback)USKFetcherTag.this.callback).setTag(USKFetcherTag.this, context);
                        }
                        USKFetcherTag.this.callback.onFailure(context);
                        return true;
                    }
                }, NativeThread.HIGH_PRIORITY);
            }
            catch (PersistenceDisabledException persistenceDisabledException) {}
        } else {
            if (this.callback instanceof USKFetcherTagCallback) {
                ((USKFetcherTagCallback)this.callback).setTag(this, context);
            }
            this.callback.onFailure(context);
        }
    }

    @Override
    public short getPollingPriorityNormal() {
        return this.pollingPriorityNormal;
    }

    @Override
    public short getPollingPriorityProgress() {
        return this.pollingPriorityProgress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFoundEdition(final long l, final USK key, ClientContext context, final boolean metadata, final short codec, final byte[] data, final boolean newKnownGood, final boolean newSlotToo) {
        if (logMINOR) {
            Logger.minor(this, "Found edition " + l + " on " + this);
        }
        USKFetcherTag uSKFetcherTag = this;
        synchronized (uSKFetcherTag) {
            if (this.fetcher == null) {
                Logger.error(this, "onFoundEdition but fetcher is null - isn't onFoundEdition() terminal for USKFetcherCallback's??", (Throwable)new Exception("debug"));
            }
            if (this.finished) {
                Logger.error(this, "onFoundEdition called after finish on " + this, (Throwable)new Exception("error"));
                return;
            }
            this.finished = true;
            this.fetcher = null;
        }
        if (this.persistent) {
            try {
                context.jobRunner.queue(new PersistentJob(){

                    @Override
                    public boolean run(ClientContext context) {
                        if (USKFetcherTag.this.callback instanceof USKFetcherTagCallback) {
                            ((USKFetcherTagCallback)USKFetcherTag.this.callback).setTag(USKFetcherTag.this, context);
                        }
                        USKFetcherTag.this.callback.onFoundEdition(l, key, context, metadata, codec, data, newKnownGood, newSlotToo);
                        return false;
                    }
                }, NativeThread.HIGH_PRIORITY);
            }
            catch (PersistenceDisabledException e) {}
        } else {
            if (this.callback instanceof USKFetcherTagCallback) {
                ((USKFetcherTagCallback)this.callback).setTag(this, context);
            }
            this.callback.onFoundEdition(l, key, context, metadata, codec, data, newKnownGood, newSlotToo);
        }
    }

    public final boolean isFinished() {
        return this.finished;
    }

    @Override
    public void onResume(ClientContext context) {
        if (this.finished) {
            return;
        }
        this.start(context.uskManager, context);
    }

    @Override
    public void onShutdown(ClientContext context) {
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

