/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.filter;

import freenet.client.filter.ContentDataFilter;
import freenet.client.filter.DataFilterException;
import freenet.client.filter.FilterCallback;
import freenet.l10n.NodeL10n;
import freenet.support.io.FileUtil;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;

public class GIFFilter
implements ContentDataFilter {
    static final int HEADER_SIZE = 6;
    static final byte[] gif87aHeader = new byte[]{71, 73, 70, 56, 55, 97};
    static final byte[] gif89aHeader = new byte[]{71, 73, 70, 56, 57, 97};

    @Override
    public void readFilter(InputStream input, OutputStream output, String charset, HashMap<String, String> otherParams, FilterCallback cb) throws DataFilterException, IOException {
        DataInputStream dis = new DataInputStream(input);
        byte[] headerCheck = new byte[6];
        dis.readFully(headerCheck);
        if (!Arrays.equals(headerCheck, gif87aHeader) && !Arrays.equals(headerCheck, gif89aHeader)) {
            this.throwHeaderError(GIFFilter.l10n("invalidHeaderTitle"), GIFFilter.l10n("invalidHeader"));
        }
        output.write(headerCheck);
        FileUtil.copy(dis, output, -1L);
        output.flush();
    }

    private static String l10n(String key) {
        return NodeL10n.getBase().getString("GIFFilter." + key);
    }

    private void throwHeaderError(String shortReason, String reason) throws DataFilterException {
        String message = GIFFilter.l10n("notGif");
        if (reason != null) {
            message = message + ' ' + reason;
        }
        if (shortReason != null) {
            message = message + " - (" + shortReason + ')';
        }
        throw new DataFilterException(shortReason, shortReason, message);
    }

    @Override
    public void writeFilter(InputStream input, OutputStream output, String charset, HashMap<String, String> otherParams, FilterCallback cb) throws DataFilterException, IOException {
        output.write(input.read());
    }
}

