/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http;

import freenet.clients.http.ToadletContext;
import freenet.support.Fields;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.MultiValueTable;
import freenet.support.SimpleReadOnlyArrayBucket;
import freenet.support.URLEncoder;
import freenet.support.api.Bucket;
import freenet.support.api.BucketFactory;
import freenet.support.api.HTTPRequest;
import freenet.support.api.HTTPUploadedFile;
import freenet.support.api.RandomAccessBucket;
import freenet.support.io.BucketTools;
import freenet.support.io.Closer;
import freenet.support.io.LineReadingInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.naming.SizeLimitExceededException;

public class HTTPRequestImpl
implements HTTPRequest {
    private final Map<String, List<String>> parameterNameValuesMap = new HashMap<String, List<String>>();
    private URI uri;
    private MultiValueTable<String, String> headers;
    private Bucket data;
    private HashMap<String, RandomAccessBucket> parts;
    private boolean freedParts;
    private Map<String, HTTPUploadedFileImpl> uploadedFiles = new HashMap<String, HTTPUploadedFileImpl>();
    private final BucketFactory bucketfactory;
    private final String method;
    private static volatile boolean logMINOR;

    public HTTPRequestImpl(URI uri, String method) {
        this.uri = uri;
        this.parseRequestParameters(uri.getRawQuery(), true, false);
        this.data = null;
        this.parts = null;
        this.bucketfactory = null;
        this.method = method;
    }

    public HTTPRequestImpl(String path, String encodedQueryString, String method) throws URISyntaxException {
        this.data = null;
        this.parts = null;
        this.bucketfactory = null;
        this.uri = encodedQueryString != null && encodedQueryString.length() > 0 ? new URI(path + '?' + encodedQueryString) : new URI(path);
        this.method = method;
        this.parseRequestParameters(this.uri.getRawQuery(), true, false);
    }

    public HTTPRequestImpl(URI uri, Bucket d, ToadletContext ctx, String method) {
        this.uri = uri;
        this.headers = ctx.getHeaders();
        this.parseRequestParameters(uri.getRawQuery(), true, false);
        this.data = d;
        this.parts = new HashMap();
        this.bucketfactory = ctx.getBucketFactory();
        this.method = method;
        if (this.data != null) {
            try {
                this.parseMultiPartData();
            }
            catch (IOException ioe) {
                Logger.error(this, "Temporary files error ? Could not parse: " + ioe, (Throwable)ioe);
            }
        }
    }

    @Override
    public String getPath() {
        return this.uri.getPath();
    }

    @Override
    public boolean hasParameters() {
        return !this.parameterNameValuesMap.isEmpty();
    }

    @Override
    public Collection<String> getParameterNames() {
        return this.parameterNameValuesMap.keySet();
    }

    private void parseRequestParameters(String queryString, boolean doUrlDecoding, boolean asParts) {
        if (logMINOR) {
            Logger.minor(this, "queryString is " + queryString + ", doUrlDecoding=" + doUrlDecoding);
        }
        Map<String, List<String>> parameters = HTTPRequestImpl.parseUriParameters(queryString, doUrlDecoding);
        if (asParts) {
            for (Map.Entry<String, List<String>> parameterValues : parameters.entrySet()) {
                byte[] buf;
                List<String> values = parameterValues.getValue();
                String value = values.get(values.size() - 1);
                try {
                    buf = value.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new Error("Impossible: JVM doesn't support UTF-8: " + e, e);
                }
                SimpleReadOnlyArrayBucket b = new SimpleReadOnlyArrayBucket(buf);
                this.parts.put(parameterValues.getKey(), b);
                if (!logMINOR) continue;
                Logger.minor(this, "Added as part: name=" + parameterValues.getKey() + " value=" + value);
            }
        } else {
            this.parameterNameValuesMap.clear();
            this.parameterNameValuesMap.putAll(parameters);
        }
    }

    private String getParameterValue(String name) {
        if (!this.isParameterSet(name)) {
            return null;
        }
        List<String> allValues = this.getParameterValueList(name);
        return allValues.get(0);
    }

    private List<String> getParameterValueList(String name) {
        List<String> values = this.parameterNameValuesMap.get(name);
        if (values == null) {
            values = new LinkedList<String>();
            this.parameterNameValuesMap.put(name, values);
        }
        return values;
    }

    public static Map<String, List<String>> parseUriParameters(String queryString, boolean doUrlDecoding) {
        if (logMINOR) {
            Logger.minor(HTTPRequestImpl.class, "queryString is " + queryString + ", doUrlDecoding=" + doUrlDecoding);
        }
        HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
        if (queryString == null || queryString.length() == 0) {
            return parameters;
        }
        StringTokenizer tokenizer = new StringTokenizer(queryString, "&");
        while (tokenizer.hasMoreTokens()) {
            ArrayList<String> values;
            String nameValueToken = tokenizer.nextToken();
            if (logMINOR) {
                Logger.minor(HTTPRequestImpl.class, "Token: " + nameValueToken);
            }
            String name = null;
            String value = "";
            int indexOfEqualsChar = nameValueToken.indexOf(61);
            if (indexOfEqualsChar < 0) {
                name = nameValueToken;
                if (logMINOR) {
                    Logger.minor(HTTPRequestImpl.class, "Name: " + name);
                }
            } else if (indexOfEqualsChar == nameValueToken.length() - 1) {
                name = nameValueToken.substring(0, indexOfEqualsChar);
                if (logMINOR) {
                    Logger.minor(HTTPRequestImpl.class, "Name: " + name);
                }
            } else {
                name = nameValueToken.substring(0, indexOfEqualsChar);
                value = nameValueToken.substring(indexOfEqualsChar + 1);
                if (logMINOR) {
                    Logger.minor(HTTPRequestImpl.class, "Name: " + name + " Value: " + value);
                }
            }
            if (doUrlDecoding) {
                try {
                    name = URLDecoder.decode(name, "UTF-8");
                    value = URLDecoder.decode(value, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new Error("Impossible: JVM doesn't support UTF-8: " + e, e);
                }
                if (logMINOR) {
                    Logger.minor(HTTPRequestImpl.class, "Decoded name: " + name);
                    Logger.minor(HTTPRequestImpl.class, "Decoded value: " + value);
                }
            }
            if ((values = (ArrayList<String>)parameters.get(name)) == null) {
                values = new ArrayList<String>();
                parameters.put(name, values);
            }
            values.add(value);
        }
        return parameters;
    }

    public static String createQueryString(Map<String, List<String>> parameterValues, boolean doUrlEncoding) {
        StringBuilder queryString = new StringBuilder();
        for (Map.Entry<String, List<String>> parameter : parameterValues.entrySet()) {
            for (String value : parameter.getValue()) {
                if (queryString.length() > 0) {
                    queryString.append('&');
                }
                queryString.append(URLEncoder.encode(parameter.getKey(), doUrlEncoding));
                queryString.append('=');
                queryString.append(URLEncoder.encode(value, doUrlEncoding));
            }
        }
        return queryString.toString();
    }

    @Override
    public boolean isParameterSet(String name) {
        return this.parameterNameValuesMap.containsKey(name);
    }

    @Override
    public String getParam(String name) {
        return this.getParam(name, "");
    }

    @Override
    public String getParam(String name, String defaultValue) {
        String value = this.getParameterValue(name);
        if (value == null || value.isEmpty()) {
            return defaultValue;
        }
        return value;
    }

    @Override
    public int getIntParam(String name) {
        return this.getIntParam(name, 0);
    }

    @Override
    public int getIntParam(String name, int defaultValue) {
        if (!this.isParameterSet(name)) {
            return defaultValue;
        }
        String value = this.getParameterValue(name);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @Override
    public int getIntPart(String name, int defaultValue) {
        if (!this.isPartSet(name)) {
            return defaultValue;
        }
        String value = this.getPartAsString(name, 32);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @Override
    public String[] getMultipleParam(String name) {
        List<String> valueList = this.getParameterValueList(name);
        String[] values = new String[valueList.size()];
        valueList.toArray(values);
        return values;
    }

    @Override
    public int[] getMultipleIntParam(String name) {
        List<String> valueList = this.getParameterValueList(name);
        ArrayList<Integer> intValueList = new ArrayList<Integer>();
        for (int i = 0; i < valueList.size(); ++i) {
            try {
                intValueList.add(Integer.valueOf(valueList.get(i)));
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        int[] values = new int[intValueList.size()];
        for (int i = 0; i < intValueList.size(); ++i) {
            values[i] = (Integer)intValueList.get(i);
        }
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseMultiPartData() throws IOException {
        String boundary;
        OutputStream bucketos;
        LineReadingInputStream lis;
        InputStream is;
        block28: {
            String[] ctypeparts;
            block27: {
                String ctype;
                block26: {
                    block25: {
                        is = null;
                        lis = null;
                        bucketos = null;
                        if (this.data != null) break block25;
                        Closer.close(bucketos);
                        Closer.close(lis);
                        Closer.close(is);
                        Closer.close(is);
                        return;
                    }
                    ctype = this.headers.get("content-type");
                    if (ctype != null) break block26;
                    Closer.close(bucketos);
                    Closer.close(lis);
                    Closer.close(is);
                    Closer.close(is);
                    return;
                }
                if (logMINOR) {
                    Logger.minor(this, "Uploaded content-type: " + ctype);
                }
                if ((ctypeparts = ctype.split(";"))[0].equalsIgnoreCase("application/x-www-form-urlencoded")) {
                    if (this.data.size() > 0x100000L) {
                        throw new IOException("Too big");
                    }
                    byte[] buf = BucketTools.toByteArray(this.data);
                    String s = new String(buf, "us-ascii");
                    this.parseRequestParameters(s, true, true);
                }
                if (ctypeparts[0].trim().equalsIgnoreCase("multipart/form-data") && ctypeparts.length >= 2) break block27;
                Closer.close(bucketos);
                Closer.close(lis);
                Closer.close(is);
                Closer.close(is);
                return;
            }
            boundary = null;
            for (String ctypepart : ctypeparts) {
                String[] subparts = ctypepart.split("=");
                if (subparts.length != 2 || !subparts[0].trim().equalsIgnoreCase("boundary")) continue;
                boundary = subparts[1];
            }
            if (boundary != null && boundary.length() != 0) break block28;
            Closer.close(bucketos);
            Closer.close(lis);
            Closer.close(is);
            Closer.close(is);
            return;
        }
        try {
            if (boundary.charAt(0) == '\"') {
                boundary = boundary.substring(1);
            }
            if (boundary.charAt(boundary.length() - 1) == '\"') {
                boundary = boundary.substring(0, boundary.length() - 1);
            }
            boundary = "--" + boundary;
            if (logMINOR) {
                Logger.minor(this, "Boundary is: " + boundary);
            }
            is = this.data.getInputStream();
            lis = new LineReadingInputStream(is);
            String line = lis.readLine(100, 100, false);
            while (is.available() > 0 && !line.equals(boundary)) {
                line = lis.readLine(100, 100, false);
            }
            boundary = "\r\n" + boundary;
            RandomAccessBucket filedata = null;
            String name = null;
            String filename = null;
            String contentType = null;
            while (is.available() > 0) {
                name = null;
                filename = null;
                contentType = null;
                while ((line = lis.readLine(200, 200, true)) != null && line.length() != 0) {
                    String[] lineparts = line.split(":");
                    if (lineparts == null || lineparts.length == 0) continue;
                    String hdrname = lineparts[0].trim();
                    if (hdrname.equalsIgnoreCase("Content-Disposition")) {
                        if (lineparts.length < 2) continue;
                        String[] valueparts = lineparts[1].split(";");
                        for (int i = 0; i < valueparts.length; ++i) {
                            String[] subparts = valueparts[i].split("=");
                            if (subparts.length != 2) continue;
                            String fieldname = subparts[0].trim();
                            String value = subparts[1].trim();
                            if (value.startsWith("\"") && value.endsWith("\"")) {
                                value = value.substring(1, value.length() - 1);
                            }
                            if (fieldname.equalsIgnoreCase("name")) {
                                name = value;
                                continue;
                            }
                            if (!fieldname.equalsIgnoreCase("filename")) continue;
                            filename = value;
                        }
                        continue;
                    }
                    if (!hdrname.equalsIgnoreCase("Content-Type")) continue;
                    contentType = lineparts[1].trim();
                    if (!logMINOR) continue;
                    Logger.minor(this, "Parsed type: " + contentType);
                }
                if (name == null) continue;
                filedata = this.bucketfactory.makeBucket(is.available());
                bucketos = filedata.getOutputStream();
                byte[] bbound = boundary.getBytes("UTF-8");
                int offset = 0;
                while (is.available() > 0 && offset < bbound.length) {
                    byte b = (byte)is.read();
                    if (b == bbound[offset]) {
                        ++offset;
                        continue;
                    }
                    if (b != bbound[offset] && offset > 0) {
                        bucketos.write(bbound, 0, offset);
                        offset = 0;
                        if (b == bbound[0]) {
                            offset = 1;
                            continue;
                        }
                        bucketos.write(b);
                        continue;
                    }
                    bucketos.write(b);
                }
                bucketos.close();
                bucketos = null;
                this.parts.put(name, filedata);
                if (logMINOR) {
                    Logger.minor(this, "Name = " + name + " length = " + filedata.size() + " filename = " + filename);
                }
                if (filename == null) continue;
                this.uploadedFiles.put(name, new HTTPUploadedFileImpl(filename, contentType, filedata));
            }
        }
        catch (Throwable throwable) {
            Closer.close(bucketos);
            Closer.close(lis);
            Closer.close(is);
            Closer.close(is);
            throw throwable;
        }
        Closer.close(bucketos);
        Closer.close(lis);
        Closer.close(is);
        Closer.close(is);
    }

    @Override
    public HTTPUploadedFile getUploadedFile(String name) {
        return this.uploadedFiles.get(name);
    }

    @Override
    public RandomAccessBucket getPart(String name) {
        if (this.freedParts) {
            throw new IllegalStateException("Already freed");
        }
        return this.parts.get(name);
    }

    @Override
    public boolean isPartSet(String name) {
        if (this.freedParts) {
            throw new IllegalStateException("Already freed");
        }
        if (this.parts == null) {
            return false;
        }
        return this.parts.containsKey(name);
    }

    @Override
    @Deprecated
    public String getPartAsString(String name, int maxlength) {
        try {
            return new String(this.getPartAsBytes(name, maxlength), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("Impossible: JVM doesn't support UTF-8: " + e, e);
        }
    }

    @Override
    public String getPartAsStringThrowing(String name, int maxLength) throws NoSuchElementException, SizeLimitExceededException {
        if (this.freedParts) {
            throw new IllegalStateException("Already freed");
        }
        Bucket part = this.parts.get(name);
        if (part == null) {
            throw new NoSuchElementException(name);
        }
        if (part.size() > (long)maxLength) {
            throw new SizeLimitExceededException();
        }
        return this.getPartAsLimitedString(part, maxLength);
    }

    @Override
    public String getPartAsStringFailsafe(String name, int maxLength) {
        if (this.freedParts) {
            throw new IllegalStateException("Already freed");
        }
        Bucket part = this.parts.get(name);
        return part == null ? "" : this.getPartAsLimitedString(part, maxLength);
    }

    private String getPartAsLimitedString(Bucket part, int maxLength) {
        try {
            return new String(this.getPartAsLimitedBytes(part, maxLength), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("Impossible: JVM doesn't support UTF-8: " + e, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Deprecated
    public byte[] getPartAsBytes(String name, int maxlength) {
        byte[] byArray;
        if (this.freedParts) {
            throw new IllegalStateException("Already freed");
        }
        Bucket part = this.parts.get(name);
        if (part == null) {
            return new byte[0];
        }
        if (part.size() > (long)maxlength) {
            return new byte[0];
        }
        InputStream is = null;
        DataInputStream dis = null;
        try {
            is = part.getInputStream();
            dis = new DataInputStream(is);
            byte[] buf = new byte[(int)Math.min(part.size(), (long)maxlength)];
            dis.readFully(buf);
            byArray = buf;
        }
        catch (IOException ioe) {
            try {
                Logger.error(this, "Caught IOE:" + ioe.getMessage());
            }
            catch (Throwable throwable) {
                Closer.close(dis);
                if (dis != null) throw throwable;
                Closer.close(is);
                throw throwable;
            }
            Closer.close(dis);
            if (dis != null) return new byte[0];
            Closer.close(is);
            return new byte[0];
        }
        Closer.close(dis);
        if (dis != null) return byArray;
        Closer.close(is);
        return byArray;
    }

    @Override
    public byte[] getPartAsBytesThrowing(String name, int maxLength) throws NoSuchElementException, SizeLimitExceededException {
        if (this.freedParts) {
            throw new IllegalStateException("Already freed");
        }
        Bucket part = this.parts.get(name);
        if (part == null) {
            throw new NoSuchElementException(name);
        }
        if (part.size() > (long)maxLength) {
            throw new SizeLimitExceededException();
        }
        return this.getPartAsLimitedBytes(part, maxLength);
    }

    @Override
    public byte[] getPartAsBytesFailsafe(String name, int maxLength) {
        if (this.freedParts) {
            throw new IllegalStateException("Already freed");
        }
        Bucket part = this.parts.get(name);
        return part == null ? new byte[]{} : this.getPartAsLimitedBytes(part, maxLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getPartAsLimitedBytes(Bucket part, int maxLength) {
        byte[] byArray;
        InputStream is = null;
        DataInputStream dis = null;
        try {
            is = part.getInputStream();
            dis = new DataInputStream(is);
            byte[] buf = new byte[(int)Math.min(part.size(), (long)maxLength)];
            dis.readFully(buf, 0, buf.length);
            byArray = buf;
        }
        catch (IOException ioe) {
            byte[] byArray2;
            try {
                Logger.error(this, "Caught IOE:" + ioe.getMessage());
                byArray2 = new byte[]{};
            }
            catch (Throwable throwable) {
                Closer.close(dis);
                if (dis == null) {
                    Closer.close(is);
                }
                throw throwable;
            }
            Closer.close(dis);
            if (dis == null) {
                Closer.close(is);
            }
            return byArray2;
        }
        Closer.close(dis);
        if (dis == null) {
            Closer.close(is);
        }
        return byArray;
    }

    @Override
    public void freeParts() {
        if (this.parts == null) {
            return;
        }
        for (Bucket bucket : this.parts.values()) {
            bucket.free();
        }
        this.parts.clear();
        this.freedParts = true;
    }

    @Override
    public long getLongParam(String name, long defaultValue) {
        if (!this.isParameterSet(name)) {
            return defaultValue;
        }
        String value = this.getParameterValue(name);
        try {
            return Fields.parseLong(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public Bucket getRawData() {
        return this.data;
    }

    @Override
    public String getHeader(String name) {
        assert (name.equals(name.toLowerCase()));
        return this.headers.get(name.toLowerCase());
    }

    @Override
    public int getContentLength() {
        String slen = this.headers.get("content-length");
        if (slen == null) {
            return -1;
        }
        return Integer.parseInt(slen);
    }

    @Override
    public String[] getParts() {
        if (this.freedParts) {
            throw new IllegalStateException("Already freed");
        }
        return this.parts.keySet().toArray(new String[this.parts.size()]);
    }

    @Override
    public boolean isIncognito() {
        if (this.isParameterSet("incognito")) {
            return Boolean.valueOf(this.getParam("incognito"));
        }
        return false;
    }

    @Override
    public boolean isChrome() {
        String ua = this.getHeader("user-agent");
        return ua != null && ua.contains("Chrome");
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }

    public static class HTTPUploadedFileImpl
    implements HTTPUploadedFile {
        private final String filename;
        private final String contentType;
        private final Bucket data;

        public HTTPUploadedFileImpl(String filename, String contentType, Bucket data) {
            this.filename = filename;
            this.contentType = contentType;
            this.data = data;
        }

        @Override
        public String getContentType() {
            return this.contentType;
        }

        @Override
        public Bucket getData() {
            return this.data;
        }

        @Override
        public String getFilename() {
            return this.filename;
        }
    }
}

