/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.io.comm.AsyncMessageCallback;
import freenet.io.comm.ByteCounter;
import freenet.io.comm.DMT;
import freenet.io.comm.DisconnectedException;
import freenet.io.comm.Message;
import freenet.io.comm.MessageFilter;
import freenet.io.comm.NotConnectedException;
import freenet.io.comm.PeerContext;
import freenet.io.comm.SlowAsyncMessageFilterCallback;
import freenet.io.xfer.AbortedException;
import freenet.io.xfer.BlockTransmitter;
import freenet.io.xfer.PartiallyReceivedBlock;
import freenet.keys.CHKBlock;
import freenet.keys.CHKVerifyException;
import freenet.keys.NodeCHK;
import freenet.node.AnyInsertSender;
import freenet.node.BaseSender;
import freenet.node.InsertTag;
import freenet.node.Node;
import freenet.node.PeerNode;
import freenet.node.PrioRunnable;
import freenet.node.SyncSendWaitedTooLongException;
import freenet.node.UIDTag;
import freenet.support.Logger;
import freenet.support.io.NativeThread;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class CHKInsertSender
extends BaseSender
implements PrioRunnable,
AnyInsertSender,
ByteCounter {
    static boolean logMINOR;
    static boolean logDEBUG;
    static final long ACCEPTED_TIMEOUT;
    static final long TRANSFER_COMPLETION_ACK_TIMEOUT_REALTIME;
    static final long TRANSFER_COMPLETION_ACK_TIMEOUT_BULK;
    final long transferCompletionTimeout;
    final long origUID;
    final InsertTag origTag;
    private InsertTag forkedRequestTag;
    final byte[] headers;
    final PartiallyReceivedBlock prb;
    final boolean fromStore;
    private boolean receiveFailed;
    final long startTime;
    private final boolean forkOnCacheable;
    private final boolean preferInsert;
    private final boolean ignoreLowBackoff;
    private List<BackgroundTransfer> backgroundTransfers;
    private boolean allTransfersCompleted;
    private volatile boolean transferTimedOut;
    private int status = -1;
    static final int NOT_FINISHED = -1;
    static final int SUCCESS = 0;
    static final int ROUTE_NOT_FOUND = 1;
    static final int INTERNAL_ERROR = 3;
    static final int TIMED_OUT = 4;
    static final int GENERATED_REJECTED_OVERLOAD = 5;
    static final int ROUTE_REALLY_NOT_FOUND = 6;
    static final int RECEIVE_FAILED = 7;
    static final int MAX_HIGH_HTL_FAILURES = 5;
    private static final long TIMEOUT_AFTER_ACCEPTEDREJECTED_TIMEOUT;
    private boolean hasForwardedRejectedOverload;
    private final Object totalBytesSync = new Object();
    private int totalBytesSent;
    private int totalBytesReceived;

    CHKInsertSender(NodeCHK myKey, long uid, InsertTag tag, byte[] headers, short htl, PeerNode source, Node node, PartiallyReceivedBlock prb, boolean fromStore, boolean canWriteClientCache, boolean forkOnCacheable, boolean preferInsert, boolean ignoreLowBackoff, boolean realTimeFlag) {
        super(myKey, realTimeFlag, source, node, htl, uid);
        this.origUID = uid;
        this.origTag = tag;
        this.headers = headers;
        this.prb = prb;
        this.fromStore = fromStore;
        this.startTime = System.currentTimeMillis();
        this.backgroundTransfers = new ArrayList<BackgroundTransfer>();
        this.forkOnCacheable = forkOnCacheable;
        this.preferInsert = preferInsert;
        this.ignoreLowBackoff = ignoreLowBackoff;
        this.transferCompletionTimeout = realTimeFlag ? TRANSFER_COMPLETION_ACK_TIMEOUT_REALTIME : TRANSFER_COMPLETION_ACK_TIMEOUT_BULK;
    }

    void start() {
        this.node.executor.execute(this, "CHKInsertSender for UID " + this.uid + " on " + this.node.getDarknetPortNumber() + " at " + System.currentTimeMillis());
    }

    public String toString() {
        return super.toString() + " for " + this.uid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Logger.OSThread.logPID(this);
        this.origTag.startedSender();
        try {
            this.routeRequests();
        }
        catch (Throwable t) {
            Logger.error(this, "Caught " + t, t);
        }
        finally {
            int myStatus;
            CHKInsertSender cHKInsertSender = this;
            synchronized (cHKInsertSender) {
                myStatus = this.status;
            }
            if (myStatus == -1) {
                this.finish(3, null);
            }
            this.origTag.finishedSender();
            if (this.forkedRequestTag != null) {
                this.forkedRequestTag.finishedSender();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void routeRequests() {
        PeerNode next = null;
        int highHTLFailureCount = 0;
        boolean starting = true;
        if (this.failIfReceiveFailed(null, null)) {
            return;
        }
        if (this.origTag.shouldStop()) {
            this.finish(0, null);
            return;
        }
        boolean canWriteStorePrev = this.node.canWriteDatastoreInsert(this.htl);
        if (!starting && !canWriteStorePrev) {
            if (highHTLFailureCount++ >= 5) {
                if (logMINOR) {
                    Logger.minor(this, "Too many failures at non-cacheable HTL");
                }
                this.finish(1, null);
                return;
            }
            if (logMINOR) {
                Logger.minor(this, "Allowing failure " + highHTLFailureCount + " htl is still " + this.htl);
            }
        } else {
            this.htl = this.node.decrementHTL(this.hasForwarded ? next : this.source, this.htl);
            if (logMINOR) {
                Logger.minor(this, "Decremented HTL to " + this.htl);
            }
        }
        starting = false;
        boolean successNow = false;
        boolean noRequest = false;
        CHKInsertSender cHKInsertSender = this;
        synchronized (cHKInsertSender) {
            if (this.htl <= 0) {
                successNow = true;
                noRequest = !this.hasForwarded;
            }
        }
        if (successNow) {
            if (noRequest) {
                this.origTag.setNotRoutedOnwards();
            }
            this.finish(0, null);
            return;
        }
        if (this.node.canWriteDatastoreInsert(this.htl) && !canWriteStorePrev && this.forkOnCacheable && this.forkedRequestTag == null) {
            this.uid = this.node.clientCore.makeUID();
            this.forkedRequestTag = new InsertTag(false, InsertTag.START.REMOTE, this.source, this.realTimeFlag, this.uid, this.node);
            this.forkedRequestTag.reassignToSelf();
            this.forkedRequestTag.startedSender();
            this.forkedRequestTag.unlockHandler();
            this.forkedRequestTag.setAccepted();
            Logger.normal(this, "FORKING CHK INSERT " + this.origUID + " to " + this.uid);
            this.nodesRoutedTo.clear();
            this.node.tracker.lockUID(this.forkedRequestTag);
        }
        if ((next = this.node.peers.closerPeer(this.forkedRequestTag == null ? this.source : null, this.nodesRoutedTo, this.target, true, this.node.isAdvancedModeEnabled(), -1, null, null, this.htl, this.ignoreLowBackoff ? Node.LOW_BACKOFF : 0L, this.source == null, this.realTimeFlag, this.newLoadManagement)) == null) {
            if (!this.hasForwarded) {
                this.origTag.setNotRoutedOnwards();
            }
            this.finish(1, null);
            return;
        }
        if (logMINOR) {
            Logger.minor(this, "Routing insert to " + next);
        }
        this.nodesRoutedTo.add(next);
        InsertTag thisTag = this.forkedRequestTag;
        if (this.forkedRequestTag == null) {
            thisTag = this.origTag;
        }
        if (this.failIfReceiveFailed(thisTag, next)) {
            try {
                next.sendAsync(DMT.createFNPDataInsertRejected(this.uid, (short)2), null, this);
            }
            catch (NotConnectedException e) {
                // empty catch block
            }
            return;
        }
        this.innerRouteRequests(next, thisTag);
    }

    private void handleRejectedTimeout(Message msg, PeerNode next) {
        Logger.warning(this, "Node timed out waiting for our DataInsert (" + msg + " from " + next + ") after Accepted in insert - treating as fatal timeout");
        next.localRejectedOverload("AfterInsertAcceptedRejectedTimeout", this.realTimeFlag);
        this.finish(4, next);
    }

    private boolean handleRejectedOverload(Message msg, PeerNode next, InsertTag thisTag) {
        if (msg.getBoolean("isLocal")) {
            next.localRejectedOverload("ForwardRejectedOverload6", this.realTimeFlag);
            if (logMINOR) {
                Logger.minor(this, "Local RejectedOverload, moving on to next peer");
            }
            return true;
        }
        this.forwardRejectedOverload();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRNF(Message msg, PeerNode next, InsertTag thisTag) {
        short newHtl;
        if (logMINOR) {
            Logger.minor(this, "Rejected: RNF");
        }
        if ((newHtl = msg.getShort("hopsToLive")) < 0) {
            newHtl = 0;
        }
        CHKInsertSender cHKInsertSender = this;
        synchronized (cHKInsertSender) {
            if (this.htl > newHtl) {
                this.htl = newHtl;
            }
        }
        next.successNotOverload(this.realTimeFlag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDataInsertRejected(Message msg, PeerNode next, InsertTag thisTag) {
        short reason;
        block22: {
            next.successNotOverload(this.realTimeFlag);
            reason = msg.getShort("dataInsertRejectedReason");
            if (logMINOR) {
                Logger.minor(this, "DataInsertRejected: " + reason);
            }
            if (reason == 1) {
                if (this.fromStore) {
                    Logger.error(this, "Verify failed on next node " + next + " for DataInsert but we were sending from the store!");
                } else {
                    try {
                        if (!this.prb.allReceived()) {
                            Logger.error(this, "Did not receive all packets but next node says invalid anyway!");
                            break block22;
                        }
                        new CHKBlock(this.prb.getBlock(), this.headers, (NodeCHK)this.key);
                        Logger.error(this, "Verify failed on " + next + " but data was valid!");
                    }
                    catch (CHKVerifyException e) {
                        Logger.normal(this, "Verify failed because data was invalid");
                    }
                    catch (AbortedException e) {
                        this.onReceiveFailed();
                    }
                }
            } else if (reason == 2) {
                boolean recvFailed;
                List<BackgroundTransfer> list = this.backgroundTransfers;
                synchronized (list) {
                    recvFailed = this.receiveFailed;
                }
                if (recvFailed) {
                    if (logMINOR) {
                        Logger.minor(this, "Failed to receive data, so failed to send data");
                    }
                } else {
                    try {
                        if (this.prb.allReceived()) {
                            Logger.warning(this, "Received all data but send failed to " + next);
                        } else if (this.prb.isAborted()) {
                            Logger.normal(this, "Send failed: aborted: " + this.prb.getAbortReason() + ": " + this.prb.getAbortDescription());
                        } else {
                            Logger.normal(this, "Send failed; have not yet received all data but not aborted: " + next);
                        }
                    }
                    catch (AbortedException e) {
                        this.onReceiveFailed();
                    }
                }
            }
        }
        Logger.error(this, "DataInsert rejected! Reason=" + DMT.getDataInsertRejectedReason(reason));
    }

    @Override
    protected MessageFilter makeAcceptedRejectedFilter(PeerNode next, long acceptedTimeout, UIDTag tag) {
        long uid = tag.uid;
        MessageFilter mfAccepted = MessageFilter.create().setSource(next).setField("uid", uid).setTimeout(acceptedTimeout).setType(DMT.FNPAccepted);
        MessageFilter mfRejectedLoop = MessageFilter.create().setSource(next).setField("uid", uid).setTimeout(acceptedTimeout).setType(DMT.FNPRejectedLoop);
        MessageFilter mfRejectedOverload = MessageFilter.create().setSource(next).setField("uid", uid).setTimeout(acceptedTimeout).setType(DMT.FNPRejectedOverload);
        mfRejectedOverload.clearOr();
        return mfAccepted.or(mfRejectedLoop.or(mfRejectedOverload));
    }

    @Override
    protected void handleAcceptedRejectedTimeout(final PeerNode next, final UIDTag tag) {
        Logger.warning(this, "Timeout awaiting Accepted/Rejected " + this + " to " + next);
        final long uid = tag.uid;
        tag.handlingTimeout(next);
        MessageFilter mf = this.makeAcceptedRejectedFilter(next, TIMEOUT_AFTER_ACCEPTEDREJECTED_TIMEOUT, tag);
        try {
            this.node.usm.addAsyncFilter(mf, new SlowAsyncMessageFilterCallback(){

                @Override
                public void onMatched(Message m) {
                    if (m.getSpec() == DMT.FNPRejectedLoop || m.getSpec() == DMT.FNPRejectedOverload) {
                        next.noLongerRoutingTo(tag, false);
                    } else {
                        assert (m.getSpec() == DMT.FNPAccepted);
                        if (logMINOR) {
                            Logger.minor(this, "Accepted after timeout on " + CHKInsertSender.this + " - will not send DataInsert, waiting for RejectedTimeout");
                        }
                        try {
                            next.sendAsync(DMT.createFNPDataInsertRejected(uid, (short)4), new AsyncMessageCallback(){

                                @Override
                                public void sent() {
                                    if (logDEBUG) {
                                        Logger.debug(this, "DataInsertRejected sent after accepted timeout on " + CHKInsertSender.this);
                                    }
                                }

                                @Override
                                public void acknowledged() {
                                    if (logDEBUG) {
                                        Logger.debug(this, "DataInsertRejected acknowledged after accepted timeout on " + CHKInsertSender.this);
                                    }
                                    next.noLongerRoutingTo(tag, false);
                                }

                                @Override
                                public void disconnected() {
                                    if (logDEBUG) {
                                        Logger.debug(this, "DataInsertRejected peer disconnected after accepted timeout on " + CHKInsertSender.this);
                                    }
                                    next.noLongerRoutingTo(tag, false);
                                }

                                @Override
                                public void fatalError() {
                                    if (logDEBUG) {
                                        Logger.debug(this, "DataInsertRejected fatal error after accepted timeout on " + CHKInsertSender.this);
                                    }
                                    next.noLongerRoutingTo(tag, false);
                                }
                            }, CHKInsertSender.this);
                        }
                        catch (NotConnectedException e) {
                            next.noLongerRoutingTo(tag, false);
                        }
                    }
                }

                @Override
                public boolean shouldTimeout() {
                    return false;
                }

                @Override
                public void onTimeout() {
                    Logger.error(this, "Fatal: No Accepted/Rejected for " + CHKInsertSender.this);
                    next.fatalTimeout(tag, false);
                }

                @Override
                public void onDisconnect(PeerContext ctx) {
                    next.noLongerRoutingTo(tag, false);
                }

                @Override
                public void onRestarted(PeerContext ctx) {
                    next.noLongerRoutingTo(tag, false);
                }

                @Override
                public int getPriority() {
                    return NativeThread.NORM_PRIORITY;
                }
            }, this);
        }
        catch (DisconnectedException e) {
            next.noLongerRoutingTo(tag, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BackgroundTransfer startBackgroundTransfer(PeerNode node, PartiallyReceivedBlock prb, InsertTag tag) {
        BackgroundTransfer ac = new BackgroundTransfer(node, prb, tag);
        List<BackgroundTransfer> list = this.backgroundTransfers;
        synchronized (list) {
            this.backgroundTransfers.add(ac);
            this.backgroundTransfers.notifyAll();
        }
        ac.start();
        return ac;
    }

    synchronized boolean receivedRejectedOverload() {
        return this.hasForwardedRejectedOverload;
    }

    @Override
    protected synchronized void forwardRejectedOverload() {
        if (this.hasForwardedRejectedOverload) {
            return;
        }
        this.hasForwardedRejectedOverload = true;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTransferTimedOut() {
        CHKInsertSender cHKInsertSender = this;
        synchronized (cHKInsertSender) {
            if (!this.transferTimedOut) {
                this.transferTimedOut = true;
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finish(int code, PeerNode next) {
        if (logMINOR) {
            Logger.minor(this, "Finished: " + code + " on " + this, (Throwable)new Exception("debug"));
        }
        CHKInsertSender cHKInsertSender = this;
        synchronized (cHKInsertSender) {
            if (this.allTransfersCompleted) {
                return;
            }
            if (code == 1 && !this.hasForwarded) {
                code = 6;
            }
            if (this.status != -1) {
                if (this.status == 7) {
                    if (code == 0) {
                        Logger.error(this, "Request succeeded despite receive failed?! on " + this);
                    }
                } else if (this.status != 4) {
                    throw new IllegalStateException("finish() called with " + code + " when was already " + this.status);
                }
            } else {
                this.status = code;
            }
            this.notifyAll();
            if (logMINOR) {
                Logger.minor(this, "Set status code: " + this.getStatusString() + " on " + this.uid);
            }
        }
        boolean failedRecv = false;
        boolean mustWait = false;
        List<BackgroundTransfer> list = this.backgroundTransfers;
        synchronized (list) {
            if (this.backgroundTransfers.isEmpty()) {
                if (logMINOR) {
                    Logger.minor(this, "No background transfers");
                }
                failedRecv = this.receiveFailed;
            } else {
                mustWait = true;
            }
        }
        if (mustWait) {
            this.waitForBackgroundTransferCompletions();
            list = this.backgroundTransfers;
            synchronized (list) {
                failedRecv = this.receiveFailed;
            }
        }
        list = this;
        synchronized (list) {
            if (!this.allTransfersCompleted) {
                if (failedRecv) {
                    this.status = 7;
                }
                this.allTransfersCompleted = true;
                this.notifyAll();
            }
        }
        if (this.status == 0 && next != null) {
            next.onSuccess(true, false);
        }
        if (logMINOR) {
            Logger.minor(this, "Returning from finish()");
        }
    }

    @Override
    public synchronized int getStatus() {
        return this.status;
    }

    @Override
    public synchronized short getHTL() {
        return this.htl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean failIfReceiveFailed(InsertTag tag, PeerNode next) {
        List<BackgroundTransfer> list = this.backgroundTransfers;
        synchronized (list) {
            if (!this.receiveFailed) {
                return false;
            }
        }
        if (logMINOR) {
            Logger.minor(this, "Failing because receive failed on " + this);
        }
        if (tag != null && next != null) {
            next.noLongerRoutingTo(tag, false);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onReceiveFailed() {
        if (logMINOR) {
            Logger.minor(this, "Receive failed on " + this);
        }
        Object object = this.backgroundTransfers;
        synchronized (object) {
            this.receiveFailed = true;
            this.backgroundTransfers.notifyAll();
            for (BackgroundTransfer t : this.backgroundTransfers) {
                t.thisTag.handlingTimeout(t.pn);
            }
        }
        object = this;
        synchronized (object) {
            this.status = 7;
            this.allTransfersCompleted = true;
            this.notifyAll();
        }
    }

    @Override
    public synchronized String getStatusString() {
        if (this.status == 0) {
            return "SUCCESS";
        }
        if (this.status == 1) {
            return "ROUTE NOT FOUND";
        }
        if (this.status == -1) {
            return "NOT FINISHED";
        }
        if (this.status == 3) {
            return "INTERNAL ERROR";
        }
        if (this.status == 4) {
            return "TIMED OUT";
        }
        if (this.status == 5) {
            return "GENERATED REJECTED OVERLOAD";
        }
        if (this.status == 6) {
            return "ROUTE REALLY NOT FOUND";
        }
        return "UNKNOWN STATUS CODE: " + this.status;
    }

    @Override
    public synchronized boolean sentRequest() {
        return this.hasForwarded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForBackgroundTransferCompletions() {
        Object object;
        try {
            BackgroundTransfer[] transfers;
            Logger.OSThread.logPID(this);
            if (logMINOR) {
                Logger.minor(this, "Waiting for background transfer completions: " + this);
            }
            object = this.backgroundTransfers;
            synchronized (object) {
                transfers = new BackgroundTransfer[this.backgroundTransfers.size()];
                transfers = this.backgroundTransfers.toArray(transfers);
            }
            if (!this.waitForBackgroundTransfers(transfers)) {
                this.setTransferTimedOut();
                return;
            }
        }
        finally {
            object = this;
            synchronized (object) {
                this.allTransfersCompleted = true;
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForBackgroundTransfers(BackgroundTransfer[] transfers) {
        long start = System.currentTimeMillis();
        long deadline = start + this.transferCompletionTimeout * 3L;
        while (true) {
            if (System.currentTimeMillis() > deadline) {
                Logger.normal(this, "Timed out waiting for background transfers! Probably caused by async filter not getting a timeout notification! DEBUG ME!");
                return false;
            }
            List<BackgroundTransfer> list = this.backgroundTransfers;
            synchronized (list) {
                if (this.receiveFailed) {
                    return false;
                }
                boolean noneRouteable = true;
                boolean completedTransfers = true;
                boolean completedNotifications = true;
                boolean someFailed = false;
                for (BackgroundTransfer transfer : transfers) {
                    if (!transfer.pn.isRoutable()) {
                        if (!logMINOR) continue;
                        Logger.minor(this, "Ignoring transfer to " + transfer.pn + " for " + this + " as not routable");
                        continue;
                    }
                    noneRouteable = false;
                    if (!transfer.completedTransfer) {
                        if (logMINOR) {
                            Logger.minor(this, "Waiting for transfer completion to " + transfer.pn + " : " + transfer);
                        }
                        completedTransfers = false;
                        break;
                    }
                    if (!transfer.receivedCompletionNotice) {
                        if (logMINOR) {
                            Logger.minor(this, "Waiting for completion notice from " + transfer.pn + " : " + transfer);
                        }
                        completedNotifications = false;
                        break;
                    }
                    if (transfer.completionSucceeded) continue;
                    someFailed = true;
                }
                if (noneRouteable) {
                    return false;
                }
                if (completedTransfers && completedNotifications) {
                    return !someFailed;
                }
                if (logMINOR) {
                    Logger.minor(this, "Waiting: transfer completion=" + completedTransfers + " notification=" + completedNotifications);
                }
                try {
                    this.backgroundTransfers.wait(TimeUnit.SECONDS.toMillis(100L));
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
    }

    public synchronized boolean completed() {
        return this.allTransfersCompleted;
    }

    public synchronized void waitForStatus() {
        while (this.status == -1) {
            try {
                this.wait(TimeUnit.SECONDS.toMillis(100L));
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public boolean anyTransfersFailed() {
        return this.transferTimedOut;
    }

    public byte[] getPubkeyHash() {
        return this.headers;
    }

    public byte[] getHeaders() {
        return this.headers;
    }

    @Override
    public long getUID() {
        return this.uid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sentBytes(int x) {
        Object object = this.totalBytesSync;
        synchronized (object) {
            this.totalBytesSent += x;
        }
        this.node.nodeStats.insertSentBytes(false, x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalSentBytes() {
        Object object = this.totalBytesSync;
        synchronized (object) {
            return this.totalBytesSent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receivedBytes(int x) {
        Object object = this.totalBytesSync;
        synchronized (object) {
            this.totalBytesReceived += x;
        }
        this.node.nodeStats.insertReceivedBytes(false, x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalReceivedBytes() {
        Object object = this.totalBytesSync;
        synchronized (object) {
            return this.totalBytesReceived;
        }
    }

    @Override
    public void sentPayload(int x) {
        this.node.sentPayload(x);
        this.node.nodeStats.insertSentBytes(false, -x);
    }

    public boolean failedReceive() {
        return this.receiveFailed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startedSendingData() {
        List<BackgroundTransfer> list = this.backgroundTransfers;
        synchronized (list) {
            return !this.backgroundTransfers.isEmpty();
        }
    }

    @Override
    public int getPriority() {
        return NativeThread.HIGH_PRIORITY;
    }

    public PeerNode[] getRoutedTo() {
        return this.nodesRoutedTo.toArray(new PeerNode[this.nodesRoutedTo.size()]);
    }

    @Override
    protected Message createDataRequest() {
        Message req = DMT.createFNPInsertRequest(this.uid, this.htl, this.key);
        if (!this.forkOnCacheable) {
            req.addSubMessage(DMT.createFNPSubInsertForkControl(this.forkOnCacheable));
        }
        if (this.ignoreLowBackoff) {
            req.addSubMessage(DMT.createFNPSubInsertIgnoreLowBackoff(this.ignoreLowBackoff));
        }
        if (this.preferInsert) {
            req.addSubMessage(DMT.createFNPSubInsertPreferInsert(this.preferInsert));
        }
        req.addSubMessage(DMT.createFNPRealTimeFlag(this.realTimeFlag));
        return req;
    }

    @Override
    protected long getAcceptedTimeout() {
        return ACCEPTED_TIMEOUT;
    }

    @Override
    protected void timedOutWhileWaiting(double load) {
        this.htl = (short)(this.htl - (short)Math.max(0, this.hopsForFatalTimeoutWaitingForPeer()));
        if (this.htl < 0) {
            this.htl = 0;
        }
        if (!this.hasForwarded) {
            this.origTag.setNotRoutedOnwards();
        }
        this.finish(1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onAccepted(PeerNode next) {
        block22: {
            Message msg;
            BackgroundTransfer transfer;
            InsertTag thisTag;
            block23: {
                Message dataInsert = DMT.createFNPDataInsert(this.uid, this.headers);
                int searchTimeout = this.calculateTimeout(this.htl);
                MessageFilter mfInsertReply = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(searchTimeout).setType(DMT.FNPInsertReply);
                MessageFilter mfRejectedOverload = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(searchTimeout).setType(DMT.FNPRejectedOverload);
                MessageFilter mfRouteNotFound = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(searchTimeout).setType(DMT.FNPRouteNotFound);
                MessageFilter mfDataInsertRejected = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(searchTimeout).setType(DMT.FNPDataInsertRejected);
                MessageFilter mfTimeout = MessageFilter.create().setSource(next).setField("uid", this.uid).setTimeout(searchTimeout).setType(DMT.FNPRejectedTimeout);
                MessageFilter mf = mfInsertReply.or(mfRouteNotFound.or(mfDataInsertRejected.or(mfTimeout.or(mfRejectedOverload))));
                thisTag = this.forkedRequestTag;
                if (this.forkedRequestTag == null) {
                    thisTag = this.origTag;
                }
                if (logMINOR) {
                    Logger.minor(this, "Sending DataInsert");
                }
                try {
                    next.sendSync(dataInsert, this, this.realTimeFlag);
                }
                catch (NotConnectedException e1) {
                    if (logMINOR) {
                        Logger.minor(this, "Not connected sending DataInsert: " + next + " for " + this.uid);
                    }
                    next.noLongerRoutingTo(thisTag, false);
                    this.routeRequests();
                    return;
                }
                catch (SyncSendWaitedTooLongException e) {
                    Logger.error(this, "Unable to send " + dataInsert + " to " + next + " in a reasonable time");
                    next.noLongerRoutingTo(thisTag, false);
                    this.routeRequests();
                    return;
                }
                if (logMINOR) {
                    Logger.minor(this, "Sending data");
                }
                transfer = this.startBackgroundTransfer(next, this.prb, thisTag);
                do {
                    if (this.failIfReceiveFailed(thisTag, next)) {
                        transfer.onCompleted();
                        return;
                    }
                    try {
                        msg = this.node.usm.waitFor(mf, this);
                    }
                    catch (DisconnectedException e) {
                        Logger.normal(this, "Disconnected from " + next + " while waiting for InsertReply on " + this);
                        transfer.onDisconnect(next);
                        break block22;
                    }
                    if (this.failIfReceiveFailed(thisTag, next)) {
                        transfer.onCompleted();
                        return;
                    }
                    if (msg == null) {
                        Logger.warning(this, "Timeout on insert " + this + " to " + next);
                        next.localRejectedOverload("AfterInsertAcceptedTimeout2", this.realTimeFlag);
                        this.forwardRejectedOverload();
                        CHKInsertSender e = this;
                        synchronized (e) {
                            this.status = 4;
                            this.notifyAll();
                        }
                        final InsertTag tag = thisTag;
                        final PeerNode waitingFor = next;
                        final short htl = this.htl;
                        Runnable r = new Runnable(){

                            @Override
                            public void run() {
                                Message msg;
                                block10: {
                                    int searchTimeout = CHKInsertSender.this.calculateTimeout(htl);
                                    MessageFilter mfInsertReply = MessageFilter.create().setSource(waitingFor).setField("uid", CHKInsertSender.this.uid).setTimeout(searchTimeout).setType(DMT.FNPInsertReply);
                                    MessageFilter mfRejectedOverload = MessageFilter.create().setSource(waitingFor).setField("uid", CHKInsertSender.this.uid).setTimeout(searchTimeout).setType(DMT.FNPRejectedOverload);
                                    MessageFilter mfRouteNotFound = MessageFilter.create().setSource(waitingFor).setField("uid", CHKInsertSender.this.uid).setTimeout(searchTimeout).setType(DMT.FNPRouteNotFound);
                                    MessageFilter mfDataInsertRejected = MessageFilter.create().setSource(waitingFor).setField("uid", CHKInsertSender.this.uid).setTimeout(searchTimeout).setType(DMT.FNPDataInsertRejected);
                                    MessageFilter mfTimeout = MessageFilter.create().setSource(waitingFor).setField("uid", CHKInsertSender.this.uid).setTimeout(searchTimeout).setType(DMT.FNPRejectedTimeout);
                                    MessageFilter mf = mfInsertReply.or(mfRouteNotFound.or(mfDataInsertRejected.or(mfTimeout.or(mfRejectedOverload))));
                                    do {
                                        if (CHKInsertSender.this.failIfReceiveFailed(tag, waitingFor)) {
                                            transfer.onCompleted();
                                            return;
                                        }
                                        try {
                                            msg = CHKInsertSender.this.node.usm.waitFor(mf, CHKInsertSender.this);
                                        }
                                        catch (DisconnectedException e) {
                                            Logger.normal(this, "Disconnected from " + waitingFor + " while waiting for InsertReply on " + CHKInsertSender.this);
                                            transfer.onDisconnect(waitingFor);
                                            return;
                                        }
                                        if (CHKInsertSender.this.failIfReceiveFailed(tag, waitingFor)) {
                                            transfer.onCompleted();
                                            return;
                                        }
                                        if (msg == null) {
                                            Logger.error(this, "Got second (local) timeout on " + CHKInsertSender.this + " from " + waitingFor);
                                            transfer.onCompleted();
                                            waitingFor.fatalTimeout();
                                            return;
                                        }
                                        if (msg.getSpec() == DMT.FNPRejectedTimeout) {
                                            CHKInsertSender.this.handleRejectedTimeout(msg, waitingFor);
                                            transfer.kill();
                                            return;
                                        }
                                        if (msg.getSpec() != DMT.FNPRejectedOverload) break block10;
                                    } while (!CHKInsertSender.this.handleRejectedOverload(msg, waitingFor, tag));
                                    transfer.onCompleted();
                                    return;
                                }
                                if (msg.getSpec() == DMT.FNPRouteNotFound) {
                                    transfer.onCompleted();
                                    return;
                                }
                                if (msg.getSpec() == DMT.FNPDataInsertRejected) {
                                    CHKInsertSender.this.handleDataInsertRejected(msg, waitingFor, tag);
                                    transfer.kill();
                                    return;
                                }
                                if (msg.getSpec() != DMT.FNPInsertReply) {
                                    Logger.error(this, "Unknown reply: " + msg);
                                    transfer.onCompleted();
                                    return;
                                }
                                transfer.onCompleted();
                            }
                        };
                        this.node.executor.execute(r);
                        this.finish(4, next);
                        return;
                    }
                    if (msg.getSpec() == DMT.FNPRejectedTimeout) {
                        transfer.kill();
                        this.handleRejectedTimeout(msg, next);
                        return;
                    }
                    if (msg.getSpec() != DMT.FNPRejectedOverload) break block23;
                } while (!this.handleRejectedOverload(msg, next, thisTag));
                transfer.onCompleted();
                break block22;
            }
            if (msg.getSpec() == DMT.FNPRouteNotFound) {
                this.handleRNF(msg, next, thisTag);
                transfer.onCompleted();
            } else if (msg.getSpec() == DMT.FNPDataInsertRejected) {
                this.handleDataInsertRejected(msg, next, thisTag);
                transfer.kill();
            } else {
                if (msg.getSpec() != DMT.FNPInsertReply) {
                    Logger.error(this, "Unknown reply: " + msg);
                    transfer.onCompleted();
                    this.finish(3, next);
                    return;
                }
                transfer.onCompleted();
                this.finish(0, next);
                return;
            }
        }
        this.routeRequests();
    }

    @Override
    protected boolean isInsert() {
        return true;
    }

    @Override
    protected PeerNode sourceForRouting() {
        if (this.forkedRequestTag != null) {
            return null;
        }
        return this.source;
    }

    @Override
    protected long ignoreLowBackoff() {
        return this.ignoreLowBackoff ? Node.LOW_BACKOFF : 0L;
    }

    static {
        Logger.registerClass(CHKInsertSender.class);
        ACCEPTED_TIMEOUT = TimeUnit.SECONDS.toMillis(10L);
        TRANSFER_COMPLETION_ACK_TIMEOUT_REALTIME = TimeUnit.MINUTES.toMillis(1L);
        TRANSFER_COMPLETION_ACK_TIMEOUT_BULK = TimeUnit.MINUTES.toMillis(5L);
        TIMEOUT_AFTER_ACCEPTEDREJECTED_TIMEOUT = TimeUnit.MINUTES.toMillis(1L);
    }

    private class BackgroundTransfer
    implements PrioRunnable,
    SlowAsyncMessageFilterCallback {
        private final long uid;
        final PeerNode pn;
        BlockTransmitter bt;
        boolean receivedCompletionNotice;
        boolean finishedWaiting;
        boolean completionSucceeded;
        boolean completedTransfer;
        boolean gotInsertReply;
        private boolean startedWait;
        private boolean killed;
        private final InsertTag thisTag;

        BackgroundTransfer(final PeerNode pn, PartiallyReceivedBlock prb, InsertTag thisTag) {
            this.pn = pn;
            this.uid = CHKInsertSender.this.uid;
            this.thisTag = thisTag;
            this.bt = new BlockTransmitter(CHKInsertSender.this.node.usm, CHKInsertSender.this.node.getTicker(), pn, this.uid, prb, CHKInsertSender.this, BlockTransmitter.NEVER_CASCADE, new BlockTransmitter.BlockTransmitterCompletion(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void blockTransferFinished(boolean success) {
                    if (logMINOR) {
                        Logger.minor(this, "Transfer completed: " + success + " for " + this);
                    }
                    BackgroundTransfer.this.completedTransfer(success);
                    if (pn.isConnected() && success) {
                        List list = CHKInsertSender.this.backgroundTransfers;
                        synchronized (list) {
                            if (!BackgroundTransfer.this.gotInsertReply) {
                                return;
                            }
                            if (BackgroundTransfer.this.startedWait) {
                                return;
                            }
                            BackgroundTransfer.this.startedWait = true;
                        }
                        BackgroundTransfer.this.startWait();
                    } else {
                        BackgroundTransfer.this.receivedNotice(false, false, false);
                        pn.localRejectedOverload("TransferFailedInsert", CHKInsertSender.this.realTimeFlag);
                    }
                }
            }, CHKInsertSender.this.realTimeFlag, CHKInsertSender.this.node.nodeStats);
        }

        private void startWait() {
            if (logMINOR) {
                Logger.minor(this, "Waiting for completion notification from " + this);
            }
            try {
                CHKInsertSender.this.node.usm.addAsyncFilter(this.getNotificationMessageFilter(false), this, null);
            }
            catch (DisconnectedException e) {
                if (logMINOR) {
                    Logger.minor(this, "Disconnected while adding filter");
                }
                this.completedTransfer(false);
                this.receivedNotice(false, false, true);
            }
        }

        void start() {
            CHKInsertSender.this.node.executor.execute(this, "CHKInsert-BackgroundTransfer for " + this.uid + " to " + this.pn.getPeer());
        }

        @Override
        public void run() {
            Logger.OSThread.logPID(this);
            try {
                this.realRun();
            }
            catch (Throwable t) {
                this.completedTransfer(false);
                this.receivedNotice(false, false, true);
                Logger.error(this, "Caught " + t, t);
            }
        }

        private void realRun() {
            this.bt.sendAsync();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void completedTransfer(boolean success) {
            List list = CHKInsertSender.this.backgroundTransfers;
            synchronized (list) {
                this.completedTransfer = true;
                CHKInsertSender.this.backgroundTransfers.notifyAll();
            }
            if (!success) {
                CHKInsertSender.this.setTransferTimedOut();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean receivedNotice(boolean success, boolean timeout, boolean kill) {
            if (logMINOR) {
                Logger.minor(this, "Received notice: " + success + (timeout ? " (timeout)" : "") + " on " + this);
            }
            boolean noUnlockPeer = false;
            boolean gotFatalTimeout = false;
            List list = CHKInsertSender.this.backgroundTransfers;
            synchronized (list) {
                if (this.finishedWaiting) {
                    if (!this.killed && !kill) {
                        Logger.error(this, "Finished waiting already yet receivedNotice(" + success + "," + timeout + "," + kill + ")", (Throwable)new Exception("error"));
                    }
                    return false;
                }
                if (!this.killed) {
                    if (kill) {
                        this.killed = true;
                        this.finishedWaiting = true;
                        this.receivedCompletionNotice = true;
                        this.completionSucceeded = false;
                    } else if (this.receivedCompletionNotice) {
                        if (logMINOR) {
                            Logger.minor(this, "receivedNotice(" + success + "), already had receivedNotice(" + this.completionSucceeded + ")");
                        }
                        if (timeout) {
                            this.finishedWaiting = true;
                            gotFatalTimeout = true;
                        }
                    } else {
                        this.completionSucceeded = success;
                        this.receivedCompletionNotice = true;
                        if (!timeout) {
                            this.finishedWaiting = true;
                        } else {
                            this.thisTag.handlingTimeout(this.pn);
                            noUnlockPeer = true;
                        }
                    }
                }
                if (!noUnlockPeer) {
                    this.startedWait = true;
                }
            }
            if (!gotFatalTimeout && !success) {
                CHKInsertSender.this.setTransferTimedOut();
            }
            if (!noUnlockPeer) {
                this.pn.noLongerRoutingTo(this.thisTag, false);
            }
            list = CHKInsertSender.this.backgroundTransfers;
            synchronized (list) {
                if (!gotFatalTimeout) {
                    CHKInsertSender.this.backgroundTransfers.notifyAll();
                }
            }
            if (timeout && gotFatalTimeout) {
                Logger.error(this, "Second timeout waiting for final ack from " + this.pn + " on " + this);
                this.pn.fatalTimeout(this.thisTag, false);
                return false;
            }
            return true;
        }

        @Override
        public void onMatched(Message m) {
            this.pn.successNotOverload(CHKInsertSender.this.realTimeFlag);
            PeerNode pn = (PeerNode)m.getSource();
            if (this.pn.equals(pn)) {
                boolean anyTimedOut = m.getBoolean("anyTimedOut");
                if (anyTimedOut) {
                    CHKInsertSender.this.setTransferTimedOut();
                }
                this.receivedNotice(!anyTimedOut, false, false);
            } else {
                Logger.error(this, "received completion notice for wrong node: " + pn + " != " + this.pn);
            }
        }

        @Override
        public boolean shouldTimeout() {
            return this.finishedWaiting;
        }

        private MessageFilter getNotificationMessageFilter(boolean longTimeoutAnyway) {
            return MessageFilter.create().setField("uid", this.uid).setType(DMT.FNPInsertTransfersCompleted).setSource(this.pn).setTimeout(longTimeoutAnyway ? TRANSFER_COMPLETION_ACK_TIMEOUT_BULK : CHKInsertSender.this.transferCompletionTimeout);
        }

        @Override
        public void onTimeout() {
            Logger.normal(this, "Timed out waiting for a final ack from: " + this.pn + " on " + this, (Throwable)new Exception("debug"));
            if (this.receivedNotice(false, true, false)) {
                this.pn.localRejectedOverload("InsertTimeoutNoFinalAck", CHKInsertSender.this.realTimeFlag);
                try {
                    CHKInsertSender.this.node.usm.addAsyncFilter(this.getNotificationMessageFilter(true), this, CHKInsertSender.this);
                }
                catch (DisconnectedException e) {
                    if (logMINOR) {
                        Logger.minor(this, "Disconnected while adding filter after first timeout");
                    }
                    this.pn.noLongerRoutingTo(this.thisTag, false);
                }
            }
        }

        @Override
        public void onDisconnect(PeerContext ctx) {
            Logger.normal(this, "Disconnected " + ctx + " for " + this);
            this.receivedNotice(true, false, true);
            this.pn.noLongerRoutingTo(this.thisTag, false);
        }

        @Override
        public void onRestarted(PeerContext ctx) {
            Logger.normal(this, "Restarted " + ctx + " for " + this);
            this.receivedNotice(true, false, true);
            this.pn.noLongerRoutingTo(this.thisTag, false);
        }

        @Override
        public int getPriority() {
            return NativeThread.HIGH_PRIORITY;
        }

        public String toString() {
            return super.toString() + ":" + this.uid + ":" + this.pn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCompleted() {
            List list = CHKInsertSender.this.backgroundTransfers;
            synchronized (list) {
                if (this.finishedWaiting) {
                    return;
                }
                if (this.gotInsertReply) {
                    return;
                }
                this.gotInsertReply = true;
                if (!this.completedTransfer) {
                    return;
                }
                if (this.startedWait) {
                    return;
                }
                this.startedWait = true;
            }
            this.startWait();
        }

        public void kill() {
            Logger.normal(this, "Killed " + this);
            this.receivedNotice(false, false, true);
            this.pn.noLongerRoutingTo(this.thisTag, false);
        }
    }
}

