/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.simulator;

import freenet.client.ClientMetadata;
import freenet.client.FetchException;
import freenet.client.HighLevelSimpleClient;
import freenet.client.InsertBlock;
import freenet.client.InsertException;
import freenet.crypt.RandomSource;
import freenet.keys.FreenetURI;
import freenet.node.Node;
import freenet.node.NodeStarter;
import freenet.node.Version;
import freenet.node.simulator.LongTermTest;
import freenet.node.simulator.TestUtil;
import freenet.support.Logger;
import freenet.support.PooledExecutor;
import freenet.support.api.RandomAccessBucket;
import freenet.support.io.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;

public class LongTermPushRepullTest
extends LongTermTest {
    private static final int TEST_SIZE = 65536;
    private static final int DARKNET_PORT1 = 5010;
    private static final int OPENNET_PORT1 = 5011;
    private static final int DARKNET_PORT2 = 5012;
    private static final int OPENNET_PORT2 = 5013;
    private static final int MAX_N = 8;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("Usage: java freenet.node.simulator.LongTermPushPullTest <unique identifier>");
            System.exit(1);
        }
        String uid = args[0];
        ArrayList<String> csvLine = new ArrayList<String>(19);
        System.out.println("DATE:" + dateFormat.format(today.getTime()));
        csvLine.add(dateFormat.format(today.getTime()));
        System.out.println("Version:" + Version.buildNumber());
        csvLine.add(String.valueOf(Version.buildNumber()));
        int exitCode = 0;
        Node node = null;
        Node node2 = null;
        try {
            File dir = new File("longterm-push-pull-test-" + uid);
            FileUtil.removeAll(dir);
            RandomSource random = NodeStarter.globalTestInit(dir.getPath(), false, Logger.LogLevel.ERROR, "", false);
            File seednodes = new File("seednodes.fref");
            if (!seednodes.exists() || seednodes.length() == 0L || !seednodes.canRead()) {
                System.err.println("Unable to read seednodes.fref, it doesn't exist, or is empty");
                System.exit(257);
            }
            File innerDir = new File(dir, Integer.toString(5010));
            innerDir.mkdir();
            FileInputStream fis = new FileInputStream(seednodes);
            FileUtil.writeTo(fis, new File(innerDir, "seednodes.fref"));
            fis.close();
            node = NodeStarter.createTestNode(5010, 5011, dir.getPath(), false, (short)18, 0, random, new PooledExecutor(), 1000, 0x400000L, true, true, true, true, true, true, true, 12288, true, true, false, false, null);
            Logger.getChain().setThreshold(Logger.LogLevel.ERROR);
            node.start(true);
            long t1 = System.currentTimeMillis();
            if (!TestUtil.waitForNodes(node)) {
                exitCode = 258;
                return;
            }
            long t2 = System.currentTimeMillis();
            System.out.println("SEED-TIME:" + (t2 - t1));
            csvLine.add(String.valueOf(t2 - t1));
            RandomAccessBucket data = LongTermPushRepullTest.randomData(node);
            HighLevelSimpleClient client = node.clientCore.makeClient((short)0, false, false);
            FreenetURI uri = new FreenetURI("KSK@" + uid + "-" + dateFormat.format(today.getTime()));
            System.out.println("PUSHING " + uri);
            try {
                InsertBlock block = new InsertBlock(data, new ClientMetadata(), uri);
                t1 = System.currentTimeMillis();
                client.insert(block, false, null);
                t2 = System.currentTimeMillis();
                System.out.println("PUSH-TIME-:" + (t2 - t1));
                csvLine.add(String.valueOf(t2 - t1));
            }
            catch (InsertException e) {
                e.printStackTrace();
                csvLine.add("N/A");
            }
            data.free();
            node.park();
            File innerDir2 = new File(dir, Integer.toString(5012));
            innerDir2.mkdir();
            fis = new FileInputStream(seednodes);
            FileUtil.writeTo(fis, new File(innerDir2, "seednodes.fref"));
            fis.close();
            node2 = NodeStarter.createTestNode(5012, 5013, dir.getPath(), false, (short)18, 0, random, new PooledExecutor(), 1000, 0x500000L, true, true, true, true, true, true, true, 12288, false, true, false, false, null);
            node2.start(true);
            t1 = System.currentTimeMillis();
            if (!TestUtil.waitForNodes(node2)) {
                exitCode = 258;
                return;
            }
            t2 = System.currentTimeMillis();
            System.out.println("SEED-TIME:" + (t2 - t1));
            csvLine.add(String.valueOf(t2 - t1));
            for (int i = 0; i <= 8; ++i) {
                client = node2.clientCore.makeClient((short)0, false, false);
                Calendar targetDate = (Calendar)today.clone();
                targetDate.add(5, -((1 << i) - 1));
                uri = new FreenetURI("KSK@" + uid + "-" + dateFormat.format(targetDate.getTime()));
                System.out.println("PULLING " + uri);
                try {
                    t1 = System.currentTimeMillis();
                    client.fetch(uri);
                    t2 = System.currentTimeMillis();
                    System.out.println("PULL-TIME-" + i + ":" + (t2 - t1));
                    csvLine.add(String.valueOf(t2 - t1));
                    continue;
                }
                catch (FetchException e) {
                    if (e.getMode() != FetchException.FetchExceptionMode.ALL_DATA_NOT_FOUND && e.getMode() != FetchException.FetchExceptionMode.DATA_NOT_FOUND) {
                        e.printStackTrace();
                    }
                    csvLine.add(FetchException.getShortMessage(e.getMode()));
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            exitCode = 261;
        }
        finally {
            try {
                if (node != null) {
                    node.park();
                }
            }
            catch (Throwable t1) {}
            try {
                if (node2 != null) {
                    node2.park();
                }
            }
            catch (Throwable t1) {}
            File file = new File(uid + ".csv");
            LongTermPushRepullTest.writeToStatusLog(file, csvLine);
            System.exit(exitCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RandomAccessBucket randomData(Node node) throws IOException {
        RandomAccessBucket data = node.clientCore.tempBucketFactory.makeBucket(65536L);
        try (OutputStream os = data.getOutputStream();){
            int toWrite;
            byte[] buf = new byte[4096];
            for (long written = 0L; written < 65536L; written += (long)toWrite) {
                node.fastWeakRandom.nextBytes(buf);
                toWrite = (int)Math.min(65536L - written, (long)buf.length);
                os.write(buf, 0, toWrite);
            }
        }
        return data;
    }
}

