/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.support.Logger;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;

public class SortedIntSet
extends AbstractCollection<Integer>
implements SortedSet<Integer> {
    private int[] data;
    private int length;
    private static final int MIN_SIZE = 32;

    public SortedIntSet() {
        this.data = new int[32];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = Integer.MAX_VALUE;
        }
        this.length = 0;
    }

    public SortedIntSet(int[] input) {
        this.data = input;
        this.length = input.length;
        this.verify();
    }

    @Override
    public int size() {
        return this.length;
    }

    @Override
    public synchronized int getFirst() {
        if (this.length == 0) {
            return -1;
        }
        return this.data[0];
    }

    @Override
    public synchronized int getLast() {
        if (this.length == 0) {
            return -1;
        }
        return this.data[this.length - 1];
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.length == 0;
    }

    public synchronized boolean contains(int num) {
        int x = this.binarySearch(num);
        return x >= 0;
    }

    public synchronized boolean remove(int item) {
        boolean ret = false;
        int x = this.binarySearch(item);
        if (x >= 0) {
            if (x < this.length - 1) {
                System.arraycopy(this.data, x + 1, this.data, x, this.length - x - 1);
            }
            this.data[--this.length] = Integer.MAX_VALUE;
            ret = true;
        }
        if (this.length * 4 < this.data.length && this.length > 32) {
            int[] newData = new int[Math.max(this.data.length / 2, 32)];
            System.arraycopy(this.data, 0, newData, 0, this.length);
            for (int i = this.length; i < newData.length; ++i) {
                newData[i] = Integer.MAX_VALUE;
            }
            this.data = newData;
        }
        assert (this.verify());
        return ret;
    }

    private synchronized boolean verify() {
        int i;
        int lastItem = -1;
        for (i = 0; i < this.length; ++i) {
            int item = this.data[i];
            if (i > 0 && item <= lastItem) {
                throw new IllegalStateException("Verify failed!");
            }
            lastItem = item;
        }
        for (i = this.length; i < this.data.length; ++i) {
            if (this.data[i] == Integer.MAX_VALUE) continue;
            throw new IllegalStateException("length=" + this.length + ", data.length=" + this.data.length + " but [" + i + "] != Integer.MAX_VALUE");
        }
        return true;
    }

    public synchronized boolean push(int num) {
        int x = this.binarySearch(num);
        if (x >= 0) {
            return false;
        }
        x = -x - 1;
        this.push(num, x);
        return true;
    }

    public synchronized void add(int num) {
        int x = this.binarySearch(num);
        if (x >= 0) {
            throw new IllegalArgumentException();
        }
        x = -x - 1;
        this.push(num, x);
    }

    private synchronized void push(int num, int x) {
        boolean logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
        if (logMINOR) {
            Logger.minor(this, "Insertion point: " + x + " length " + this.length + " data.length " + this.data.length);
        }
        if (this.length == this.data.length) {
            int[] newData = Arrays.copyOf(this.data, Math.max(this.length * 2, 4));
            if (logMINOR) {
                Logger.minor(this, "Expanding from " + this.length + " to " + newData.length);
            }
            for (int i = this.length; i < newData.length; ++i) {
                newData[i] = Integer.MAX_VALUE;
            }
            this.data = newData;
        }
        if (x < this.length) {
            System.arraycopy(this.data, x, this.data, x + 1, this.length - x);
        }
        this.data[x] = num;
        ++this.length;
        assert (this.verify());
    }

    @Override
    public int removeFirst() {
        int val = this.getFirst();
        this.remove(val);
        return val;
    }

    @Override
    public synchronized void clear() {
        this.data = new int[32];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = Integer.MAX_VALUE;
        }
        this.length = 0;
    }

    public synchronized int[] toIntArray() {
        return Arrays.copyOf(this.data, this.length);
    }

    public synchronized int[] toArrayRaw() {
        if (this.length == this.data.length) {
            return this.data;
        }
        return this.toIntArray();
    }

    private int binarySearch(int key) {
        return Arrays.binarySearch(this.data, 0, this.length, key);
    }

    @Override
    public Comparator<? super Integer> comparator() {
        return null;
    }

    @Override
    public Integer first() {
        return this.getFirst();
    }

    @Override
    public SortedSet<Integer> headSet(Integer arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Integer last() {
        return this.getLast();
    }

    @Override
    public SortedSet<Integer> subSet(Integer arg0, Integer arg1) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SortedSet<Integer> tailSet(Integer arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(Integer arg0) {
        return this.push(arg0);
    }

    @Override
    public boolean contains(Object arg0) {
        if (arg0 instanceof Integer) {
            int x = (Integer)arg0;
            return this.contains(x);
        }
        return false;
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            int x = 0;
            int last = -1;
            boolean hasLast = false;

            @Override
            public boolean hasNext() {
                return this.x < SortedIntSet.this.length;
            }

            @Override
            public Integer next() {
                if (this.x >= SortedIntSet.this.length) {
                    throw new NoSuchElementException();
                }
                this.hasLast = true;
                this.last = SortedIntSet.this.data[this.x++];
                return this.last;
            }

            @Override
            public void remove() {
                if (!this.hasLast) {
                    throw new IllegalStateException();
                }
                SortedIntSet.this.remove(this.last);
                --this.x;
            }
        };
    }

    @Override
    public boolean remove(Object arg0) {
        if (arg0 instanceof Integer) {
            return this.remove((Integer)arg0);
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        throw new UnsupportedOperationException();
    }
}

