/*
 * Decompiled with CFR 0.152.
 */
package freenet.io;

import freenet.crypt.SSL;
import freenet.io.NetworkInterface;
import freenet.support.Executor;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.Arrays;
import javax.net.ssl.SSLServerSocket;

public class SSLNetworkInterface
extends NetworkInterface {
    public static NetworkInterface create(int port, String bindTo, String allowedHosts, Executor executor, boolean ignoreUnbindableIP6) throws IOException {
        SSLNetworkInterface iface = new SSLNetworkInterface(port, allowedHosts, executor);
        Object[] failedBind = iface.setBindTo(bindTo, ignoreUnbindableIP6);
        if (failedBind != null) {
            System.err.println("Could not bind to some of the interfaces specified for port " + port + " : " + Arrays.toString(failedBind));
        }
        return iface;
    }

    protected SSLNetworkInterface(int port, String allowedHosts, Executor executor) throws IOException {
        super(port, allowedHosts, executor);
    }

    @Override
    protected ServerSocket createServerSocket() throws IOException {
        SSLServerSocket serverSocket = (SSLServerSocket)SSL.createServerSocket();
        serverSocket.setNeedClientAuth(false);
        serverSocket.setUseClientMode(false);
        serverSocket.setWantClientAuth(false);
        serverSocket.setEnabledCipherSuites(new String[]{"TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256"});
        return serverSocket;
    }
}

